/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.scheme;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.scheme.AssessSchemeApplicationService;
import kd.opmc.epa.business.application.service.scheme.ExecuteSchemeApplicationService;
import kd.opmc.epa.business.application.service.scheme.ObjectScopeApplicationService;
import kd.opmc.epa.formplugin.web.utils.SchemeStatusValidateUtils;
import kd.opmc.epa.formplugin.web.utils.TimeTagUtil;
import kd.opmc.pbs.business.application.service.timetag.TimeTagApplicationService;

public class ExecuteSchemeDynamicPlugin
extends HRDataBaseEdit
implements SearchEnterListener {
    private static final TimeTagApplicationService TIME_TAG_APPLICATION_SERVICE = TimeTagApplicationService.getInstance();
    private static final ObjectScopeApplicationService OBJECT_SCOPE_APPLICATION_SERVICE = ObjectScopeApplicationService.getInstance();
    private static final ExecuteSchemeApplicationService EXECUTE_SCHEME_APPLICATION_SERVICE = ExecuteSchemeApplicationService.getInstance();
    private static final AssessSchemeApplicationService ASSESS_SCHEME_APPLICATION_SERVICE = AssessSchemeApplicationService.getInstance();
    private final Map<String, String> TAG_MAP = ImmutableBiMap.builder().put((Object)"1010_S", (Object)"Y").put((Object)"1020_S", (Object)"H").put((Object)"1030_S", (Object)"Q").put((Object)"1040_S", (Object)"M").build();

    public void registerListener(EventObject e) {
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
    }

    public void search(SearchEnterEvent event) {
        String text = event.getText();
        this.getView().getPageCache().put("searchText", text);
        this.initData(text);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String searchText = this.getView().getPageCache().get("searchText");
        this.initData(searchText);
        this.setTipsContent();
        this.setVisible();
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey = args.getProperty().getName();
        if ("combovalue".equals(fieldKey)) {
            String searchText = this.getView().getPageCache().get("searchText");
            String combo = (String)this.getModel().getValue("combovalue");
            this.getView().getPageCache().put("combovalue", combo);
            this.initData(searchText);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Long schemeId;
        Object[] executeScheme;
        super.beforeDoOperation(args);
        SchemeStatusValidateUtils.checkSchemeStatusValidate(args, this.getView());
        FormOperate source = (FormOperate)args.getSource();
        if (HRStringUtils.equals((String)source.getOperateKey(), (String)"permissionbatch") && ObjectUtils.isEmpty((Object[])(executeScheme = EXECUTE_SCHEME_APPLICATION_SERVICE.queryListBySchemeId(schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId"), "")))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8003\u6838\u5468\u671f\u4e0e\u6267\u884c\u8ba1\u5212\u8fd8\u672a\u751f\u6210\uff0c\u8bf7\u5148\u65b0\u589e\u8003\u6838\u5468\u671f\u4e0e\u6267\u884c\u8ba1\u5212\u540e\u518d\u6279\u91cf\u8bbe\u7f6e\u6743\u9650", (String)"ExecuteSchemeDynamicPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        Long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId");
        switch (args.getOperateKey()) {
            case "addscheme": {
                this.addShowForm("epa_executescheme", OperationStatus.ADDNEW);
                break;
            }
            case "addbatch": {
                this.batchAdd(schemeId);
                break;
            }
            case "permissionbatch": {
                Object[] executeScheme = EXECUTE_SCHEME_APPLICATION_SERVICE.queryListBySchemeId(schemeId, null);
                if (ObjectUtils.isEmpty((Object[])executeScheme)) {
                    return;
                }
                Map<String, List<DynamicObject>> map = Arrays.stream(executeScheme).collect(Collectors.groupingBy(scheme -> scheme.getLong("assessform.id") + "-" + scheme.getLong("perfworkflow.id")));
                if (ObjectUtils.isEmpty(map)) {
                    return;
                }
                if (map.size() == 1 && executeScheme.length == 1) {
                    HashMap returnDate = Maps.newHashMap();
                    returnDate.put("executeschemeId", executeScheme[0].getString("id"));
                    returnDate.put("BATCH_SETTING", false);
                    returnDate.put("exeIdsNNames", this.getPageCache().get("currentSelectMap"));
                    this.showPermissionBatch(returnDate);
                    break;
                }
                this.permissionBatch(schemeId);
                break;
            }
            default: {
                this.initData("");
            }
        }
    }

    private void permissionBatch(Long schemeId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("epa_permissionbatch");
        showParameter.setCustomParam("schemeId", (Object)schemeId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "permissionbatch"));
        this.getView().showForm(showParameter);
    }

    private void batchAdd(Long schemeId) {
        int allSize;
        boolean allDatas;
        DynamicObject scheme = ASSESS_SCHEME_APPLICATION_SERVICE.queryOne("cycletype,cycletype.number,periodconfentity,periodconfentity.pcycletype,periodconfentity.pcycletype.name", schemeId);
        DynamicObjectCollection periodconfentity = scheme.getDynamicObjectCollection("periodconfentity");
        if (periodconfentity.size() == 0) {
            periodconfentity = new DynamicObjectCollection();
            DynamicObject periodconf = ASSESS_SCHEME_APPLICATION_SERVICE.generateEmptyEntryDynamicObject("periodconfentity");
            periodconf.set("pcycletype", scheme.get("cycletype"));
            periodconfentity.add((Object)periodconf);
        }
        int timeTagCount = 0;
        for (DynamicObject data : periodconfentity) {
            String cycle;
            switch (cycle = this.TAG_MAP.get(data.getString("pcycletype.number"))) {
                case "Y": {
                    ++timeTagCount;
                    break;
                }
                case "H": {
                    timeTagCount += 2;
                    break;
                }
                case "Q": {
                    timeTagCount += 4;
                    break;
                }
                case "M": {
                    timeTagCount += 12;
                    break;
                }
            }
        }
        DynamicObject[] objectScopes = OBJECT_SCOPE_APPLICATION_SERVICE.queryListBySchemeId(schemeId);
        DynamicObject[] datas = EXECUTE_SCHEME_APPLICATION_SERVICE.queryListBySchemeId(schemeId, null);
        boolean bl = allDatas = datas.length >= (allSize = timeTagCount * objectScopes.length);
        if (allDatas) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61\u8303\u56f4\u7684\u8003\u6838\u6267\u884c\u8ba1\u5212\u5df2\u5168\u90e8\u751f\u6210\uff0c\u65e0\u9700\u518d\u6b21\u65b0\u589e", (String)"ExecuteSchemeDynamicPlugin_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        } else {
            this.addShowForm("epa_executescheme_add", OperationStatus.EDIT);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData != null) {
            switch (actionId) {
                case "epa_executescheme": 
                case "epa_executescheme_add": {
                    String searchText = this.getView().getPageCache().get("searchText");
                    this.initData(searchText);
                    if (returnData instanceof Map) {
                        Integer success = (Integer)((Map)returnData).get("success");
                        Integer all = (Integer)((Map)returnData).get("all");
                        String message = MessageFormat.format(ResManager.loadKDString((String)"\u6210\u529f\u65b0\u589e{0}\u4e2a\u8003\u6838\u6267\u884c\u8ba1\u5212\u3002", (String)"ExecuteSchemeDynamicPlugin_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]), success + "");
                        this.getView().showSuccessNotification(message);
                    }
                    this.setTipsContent();
                    break;
                }
                case "permissionbatch": {
                    this.showPermissionBatch(returnData);
                    return;
                }
            }
            this.initData("");
        }
    }

    private void showPermissionBatch(Object returnData) {
        Map returnDataMap = (Map)returnData;
        String executeschemeId = (String)returnDataMap.get("executeschemeId");
        FormShowParameter baseShowParameter = new FormShowParameter();
        baseShowParameter.setFormId("epa_batch_permissionset");
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setPageId(String.valueOf(executeschemeId));
        baseShowParameter.setCustomParam("executeschemeId", (Object)executeschemeId);
        Boolean isBatch = (Boolean)returnDataMap.get("BATCH_SETTING");
        baseShowParameter.setCustomParam("BATCH_SETTING", (Object)isBatch);
        if (!isBatch.booleanValue()) {
            DynamicObject executescheme = EXECUTE_SCHEME_APPLICATION_SERVICE.queryBySchemeId(Long.valueOf(executeschemeId));
            QFilter excutescheme = new QFilter("excutescheme", "=", (Object)Long.valueOf(executeschemeId));
            QFilter assessform = new QFilter("assessform", "=", (Object)executescheme.getLong("assessform.id"));
            QFilter perfworkflow = new QFilter("perfworkflow", "=", (Object)executescheme.getLong("perfworkflow.id"));
            QFilter bindtype = new QFilter("bindtype", "=", (Object)"1");
            DynamicObject permissionObj = BusinessDataServiceHelper.loadSingle((String)"epa_dynamicpermission", (String)"id", (QFilter[])new QFilter[]{excutescheme, assessform, perfworkflow, bindtype});
            baseShowParameter.setCustomParam("processpermsetting", (Object)permissionObj.getLong("id"));
            baseShowParameter.setCustomParam("locknumber", (Object)executescheme.getString("name"));
        } else {
            baseShowParameter.setCustomParam("currentSelectMap", returnDataMap.get("exeIdsNNames"));
            baseShowParameter.setCustomParam("schemeCardName", returnDataMap.get("schemeCardName"));
        }
        this.getView().showForm(baseShowParameter);
    }

    private void initData(String searchText) {
        Map<String, List<DynamicObject>> map;
        DynamicObject[] dys;
        String combo;
        Long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId");
        DynamicObject[] datas = EXECUTE_SCHEME_APPLICATION_SERVICE.queryListBySchemeId(schemeId, searchText);
        String comboCache = this.getView().getPageCache().get("combovalue");
        if (comboCache == null) {
            combo = (String)this.getModel().getValue("combovalue");
        } else {
            combo = comboCache;
            this.getModel().setValue("combovalue", (Object)combo);
            this.getView().updateView("combovalue");
        }
        this.getView().getPageCache().put("combovalue", combo);
        if ("1".equals(combo)) {
            Long cycleType = (Long)this.getView().getFormShowParameter().getCustomParam("cycletype");
            List<DynamicObject> timeTagRange = TimeTagUtil.getTimeTagRange(schemeId, cycleType);
            dys = timeTagRange.toArray(new DynamicObject[0]);
            map = Arrays.stream(datas).collect(Collectors.groupingBy(obj -> obj.getDynamicObject("timetag").getString("name")));
        } else {
            dys = OBJECT_SCOPE_APPLICATION_SERVICE.queryListBySchemeId(schemeId);
            map = Arrays.stream(datas).collect(Collectors.groupingBy(obj -> obj.getDynamicObject("assessscope").getString("name")));
        }
        this.addCardPanel(map, dys, combo, searchText);
    }

    private void addCardPanel(Map<String, List<DynamicObject>> map, DynamicObject[] dys, String combo, String searchText) {
        Long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId");
        DynamicObject scheme = ASSESS_SCHEME_APPLICATION_SERVICE.queryOne("cycletype,cycletype.number,periodconfentity,periodconfentity.pcycletype,periodconfentity.pcycletype.name", schemeId);
        DynamicObjectCollection periodconfentity = scheme.getDynamicObjectCollection("periodconfentity");
        int rows = this.getRows(scheme, periodconfentity);
        FlexPanelAp contentap = new HRFlexPanelAp.Builder("schemepanel").setDirection("column").setAlignItems("stretch").setJustifyContent("flex-start").setWrap(false).setGrow(1).setShrink(1).setOverflow("visible").build();
        ArrayList<FlexPanelAp> controls = new ArrayList<FlexPanelAp>(10);
        DynamicObject orgDyn = (DynamicObject)this.getView().getParentView().getModel().getValue("org");
        DynamicObject adminOrgDyn = (DynamicObject)this.getView().getParentView().getModel().getValue("adminorg");
        if ("1".equals(combo)) {
            DynamicObject[] objects = OBJECT_SCOPE_APPLICATION_SERVICE.queryListBySchemeId(schemeId);
            List assess = Arrays.stream(objects).map(data -> data.getLong("id")).collect(Collectors.toList());
            QFilter[] filters = new QFilter[]{new QFilter("assessscope.id", "in", assess)};
            int count = EXECUTE_SCHEME_APPLICATION_SERVICE.count(filters);
            int gridHeight = 38 * (count + 3);
            FlexPanelAp cardAp = new HRFlexPanelAp.Builder("").setGrow(1).setHeight(gridHeight + "px").setShrink(1).build();
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("epa_excutescheme_time");
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.getOpenStyle().setTargetKey(cardAp.getKey());
            showParameter.setCustomParam("schemeId", (Object)schemeId);
            showParameter.setCustomParam("org", (Object)orgDyn.getLong("id"));
            showParameter.setCustomParam("adminorg", (Object)adminOrgDyn.getLong("id"));
            showParameter.setCustomParam("searchtext", (Object)searchText);
            this.getView().showForm(showParameter);
            controls.add(cardAp);
        } else {
            for (int i = 0; i < dys.length; ++i) {
                QFilter[] filters = new QFilter[]{new QFilter("assessscope.id", "=", (Object)dys[i].getLong("id"))};
                int count = EXECUTE_SCHEME_APPLICATION_SERVICE.count(filters);
                FlexPanelAp cardAp = new HRFlexPanelAp.Builder("cardap" + dys[i].getLong("id")).build();
                if (count > 0) {
                    int height = 39;
                    cardAp = new HRFlexPanelAp.Builder("cardap" + dys[i].getLong("id")).setHeight(height * (rows + 3) + "px").build();
                }
                controls.add(cardAp);
                String name = dys[i].getString("name");
                List<DynamicObject> datas = map.get(name);
                ArrayList ids = ObjectUtils.isEmpty(datas) ? new ArrayList(10) : datas.stream().sorted(Comparator.comparing(dy -> dy.getDynamicObject("timetag").getString("number"))).map(dy -> dy.getLong("id")).collect(Collectors.toList());
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("epa_excutescheme_entry");
                showParameter.setStatus(OperationStatus.EDIT);
                showParameter.getOpenStyle().setShowType(ShowType.InContainer);
                showParameter.getOpenStyle().setTargetKey(cardAp.getKey());
                showParameter.setCustomParam("schemeId", (Object)schemeId);
                showParameter.setCustomParam("objectscope", (Object)dys[i].getLong("id"));
                showParameter.setCustomParam("org", (Object)orgDyn.getLong("id"));
                showParameter.setCustomParam("adminorg", (Object)adminOrgDyn.getLong("id"));
                showParameter.setCustomParam("ids", ids);
                showParameter.setCustomParam("name", (Object)name);
                showParameter.setCustomParam("searchtext", (Object)searchText);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_executescheme"));
                this.getView().showForm(showParameter);
            }
        }
        contentap.getItems().addAll(controls);
        this.getView().updateControlMetadata(contentap.getKey(), contentap.createControl());
    }

    private int getRows(DynamicObject scheme, DynamicObjectCollection periodconfentity) {
        int rows = 0;
        ImmutableBiMap tag_map = ImmutableBiMap.builder().put((Object)"1010_S", (Object)"Y").put((Object)"1020_S", (Object)"H").put((Object)"1030_S", (Object)"Q").put((Object)"1040_S", (Object)"M").build();
        if (periodconfentity.size() == 0) {
            String number;
            switch (number = (String)tag_map.get(scheme.getString("cycletype.number"))) {
                case "Y": {
                    rows = 1;
                    break;
                }
                case "H": {
                    rows = 2;
                    break;
                }
                case "Q": {
                    rows = 4;
                    break;
                }
                case "M": {
                    rows = 12;
                }
            }
        } else {
            for (DynamicObject dyn : periodconfentity) {
                String number;
                switch (number = (String)tag_map.get(dyn.getString("pcycletype.number"))) {
                    case "Y": {
                        ++rows;
                        break;
                    }
                    case "H": {
                        rows += 2;
                        break;
                    }
                    case "Q": {
                        rows += 4;
                        break;
                    }
                    case "M": {
                        rows += 12;
                    }
                }
            }
        }
        return rows;
    }

    private void addShowForm(String formId, OperationStatus status) {
        Long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId");
        Long cycleType = (Long)this.getView().getFormShowParameter().getCustomParam("cycletype");
        BaseShowParameter showParameter = "epa_executescheme".equals(formId) ? new BaseShowParameter() : new FormShowParameter();
        DynamicObject orgDyn = (DynamicObject)this.getView().getParentView().getModel().getValue("org");
        DynamicObject adminOrgDyn = (DynamicObject)this.getView().getParentView().getModel().getValue("adminorg");
        showParameter.setFormId(formId);
        showParameter.setStatus(status);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("schemeId", (Object)schemeId);
        showParameter.setCustomParam("org", (Object)orgDyn.getLong("id"));
        showParameter.setCustomParam("adminorg", (Object)adminOrgDyn.getLong("id"));
        showParameter.setCustomParam("cycletype", (Object)cycleType);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_executescheme"));
        String subViewId = this.getView().getPageCache().get("currentOperationSubview");
        if (!StringUtils.isEmpty((CharSequence)subViewId)) {
            IFormView view = this.getView().getView(subViewId);
            showParameter.setCustomParam("cardShowTag", view.getFormShowParameter().getCustomParam("cardShowTag"));
            showParameter.setCustomParam("cardShowTagId", view.getFormShowParameter().getCustomParam("cardShowTagId"));
            this.getView().getPageCache().remove("currentOperationSubview");
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void setTipsContent() {
        Long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId");
        DynamicObject scheme = ASSESS_SCHEME_APPLICATION_SERVICE.queryOne("cycletype,cycletype.number,periodconfentity,periodconfentity.pcycletype,periodconfentity.pcycletype.name", schemeId);
        DynamicObjectCollection periodconfentity = scheme.getDynamicObjectCollection("periodconfentity");
        if (periodconfentity.size() == 0) {
            periodconfentity = new DynamicObjectCollection();
            DynamicObject periodconf = ASSESS_SCHEME_APPLICATION_SERVICE.generateEmptyEntryDynamicObject("periodconfentity");
            periodconf.set("pcycletype", scheme.get("cycletype"));
            periodconfentity.add((Object)periodconf);
        }
        int timeTagCount = 0;
        for (DynamicObject data : periodconfentity) {
            String cycle;
            switch (cycle = this.TAG_MAP.get(data.getString("pcycletype.number"))) {
                case "Y": {
                    ++timeTagCount;
                    break;
                }
                case "H": {
                    timeTagCount += 2;
                    break;
                }
                case "Q": {
                    timeTagCount += 4;
                    break;
                }
                case "M": {
                    timeTagCount += 12;
                    break;
                }
            }
        }
        DynamicObject[] objectScopes = OBJECT_SCOPE_APPLICATION_SERVICE.queryListBySchemeId(schemeId);
        Object[] datas = EXECUTE_SCHEME_APPLICATION_SERVICE.queryListBySchemeId(schemeId, null);
        int allSize = timeTagCount * objectScopes.length;
        int initSize = 0;
        String message = "";
        if (!ObjectUtils.isEmpty((Object[])datas) && datas.length > 0) {
            boolean allDatas = datas.length >= allSize;
            initSize = datas.length;
            if (allDatas) {
                message = MessageFormat.format(ResManager.loadKDString((String)"\u660e\u7ec6\u8ba1\u5212\u5168\u90e8\u65b0\u589e\u5b8c\u6210 ({0}/{1})", (String)"ExecuteSchemeDynamicPlugin_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]), initSize, allSize + "");
                this.getView().setEnable(Boolean.FALSE, new String[]{"addbatch"});
                HashMap<String, String> bcstyle = new HashMap<String, String>(16);
                bcstyle.put("bc", "#DCFAE4");
                this.getView().updateControlMetadata("flexpanelap41", bcstyle);
            } else {
                message = MessageFormat.format(ResManager.loadKDString((String)"\u660e\u7ec6\u8ba1\u5212\u5f85\u65b0\u589e ({0}/{1})", (String)"ExecuteSchemeDynamicPlugin_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]), initSize, allSize + "");
                this.getView().setEnable(Boolean.TRUE, new String[]{"addbatch"});
                HashMap<String, String> bcstyle = new HashMap<String, String>(16);
                bcstyle.put("bc", "#FFF1D4");
                this.getView().updateControlMetadata("flexpanelap41", bcstyle);
            }
        } else {
            message = MessageFormat.format(ResManager.loadKDString((String)"\u660e\u7ec6\u8ba1\u5212\u5f85\u65b0\u589e ({0}/{1})", (String)"ExecuteSchemeDynamicPlugin_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]), initSize, allSize + "");
            this.getView().setEnable(Boolean.TRUE, new String[]{"addbatch"});
            HashMap<String, String> bcstyle = new HashMap<String, String>(16);
            bcstyle.put("bc", "#FFF1D4");
            this.getView().updateControlMetadata("flexpanelap41", bcstyle);
        }
        Label resultLab = (Label)this.getControl("content");
        resultLab.setText(message);
        this.getView().updateView("flexpanelap41");
        this.getView().updateView("content");
    }

    private void setVisible() {
        long currUserId = RequestContext.get().getCurrUserId();
        boolean hasModeifyPermission = PermissionServiceHelper.checkPermission((Long)currUserId, (String)"epa", (String)"epa_scheme", (String)"4715a0df000000ac");
        if (!hasModeifyPermission) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"permissionbatch"});
        }
    }
}

