/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.scheme;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.scheme.AssessSchemeApplicationService;
import kd.opmc.epa.business.application.service.scheme.ExecuteSchemeApplicationService;
import kd.opmc.epa.business.domain.indicator.imp.helper.DataValidateServiceHelper;

public class ExecuteSchemeEditPlugin
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final ExecuteSchemeApplicationService EXECUTE_SCHEME_APPLICATION_SERVICE = ExecuteSchemeApplicationService.getInstance();
    private static final AssessSchemeApplicationService ASSESS_SCHEME_APPLICATION_SERVICE = AssessSchemeApplicationService.getInstance();
    public static final String EVAL_DATA = "10";
    public static final String SUM_DATA = "20";
    private static Long EVA_NODE = 4L;
    private static Long SUM_NODE = 5L;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit scopeEdit = (BasedataEdit)this.getView().getControl("assessscope");
        scopeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit timeEdit = (BasedataEdit)this.getView().getControl("timetag");
        timeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit assessformEdit = (BasedataEdit)this.getView().getControl("assessform");
        assessformEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit perfworkformEdit = (BasedataEdit)this.getView().getControl("perfworkflow");
        perfworkformEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object schemeId = this.getView().getFormShowParameter().getCustomParam("schemeId");
        this.getModel().setValue("scheme", schemeId);
        String cardShowTag = (String)this.getView().getFormShowParameter().getCustomParam("cardShowTag");
        if (StringUtils.equals((CharSequence)cardShowTag, (CharSequence)"hbss_timestamp")) {
            Long timeTagId = (Long)this.getView().getFormShowParameter().getCustomParam("cardShowTagId");
            this.getModel().setValue("timetag", (Object)timeTagId);
        }
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        this.getView().getPageCache().put("assessform", String.valueOf(this.getView().getModel().getDataEntity().getLong("assessform.id")));
        this.getView().getPageCache().put("perfworkflow", String.valueOf(this.getView().getModel().getDataEntity().getLong("perfworkflow.id")));
        this.getView().getPageCache().put("againClick", "0");
        if (pkValue != 0L) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number", "timetag", "assessscope"});
        }
        this.setFormMustInput();
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey = args.getProperty().getName();
        if ("timetag".equals(fieldKey)) {
            this.getModel().setValue("assessscope", null);
        }
        this.setFormMustInput();
    }

    private void setFormMustInput() {
        IDataEntityProperty property = this.getModel().getProperty("assessform");
        DynamicObject perfworkflow = (DynamicObject)this.getModel().getValue("perfworkflow");
        if (perfworkflow != null) {
            DynamicObjectCollection entryentity = perfworkflow.getDynamicObjectCollection("entryentity");
            List entryList = entryentity.stream().filter(data -> data.getBoolean("isshow") && data.getLong("node.id") == 1L).collect(Collectors.toList());
            Boolean mustInput = entryList.size() > 0;
            if (property instanceof FieldProp) {
                ((FieldProp)property).setMustInput(mustInput.booleanValue());
            } else if (property instanceof BasedataProp) {
                ((BasedataProp)property).setMustInput(mustInput.booleanValue());
            }
            BasedataEdit edit = (BasedataEdit)this.getControl("assessform");
            edit.setMustInput(mustInput.booleanValue());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("save".equals(key)) {
            Boolean isupdate = Boolean.FALSE;
            Boolean isnewUpdate = Boolean.FALSE;
            int updatePermissType = 1;
            long executeschemeId = this.getView().getModel().getDataEntity().getLong("id");
            String oldassessformId = this.getView().getPageCache().get("assessform");
            String oldperfworkflowId = this.getView().getPageCache().get("perfworkflow");
            DynamicObject[] permissionObj = BusinessDataServiceHelper.load((String)"epa_processpermsetting", (String)"id", (QFilter[])new QFilter[]{new QFilter("excutescheme", "=", (Object)executeschemeId).and(new QFilter("assessform", "=", (Object)Long.valueOf(oldassessformId))).and(new QFilter("perfworkflow", "=", (Object)Long.valueOf(oldperfworkflowId)))});
            Object[] newpermissionObj = BusinessDataServiceHelper.load((String)"epa_dynamicpermission", (String)"id,createtime,modifytime", (QFilter[])new QFilter[]{new QFilter("excutescheme", "=", (Object)executeschemeId).and(new QFilter("assessform", "=", (Object)Long.valueOf(oldassessformId))).and(new QFilter("perfworkflow", "=", (Object)Long.valueOf(oldperfworkflowId))).and(new QFilter("bindtype", "=", (Object)"1"))}, (String)"createtime desc");
            if (!ObjectUtils.isEmpty((Object[])newpermissionObj)) {
                Date createtime = newpermissionObj[0].getDate("createtime");
                Date modifytime = newpermissionObj[0].getDate("modifytime");
                if (createtime.getTime() != modifytime.getTime()) {
                    isnewUpdate = true;
                    updatePermissType = 2;
                }
            }
            if (permissionObj != null) {
                this.getView().getPageCache().put("updatecount", String.valueOf(permissionObj.length));
                if (permissionObj.length > 2) {
                    isupdate = true;
                    updatePermissType = 1;
                }
            }
            if (updatePermissType == 1) {
                this.updatePermissByFormOrFlow(args, isupdate, updatePermissType);
            } else if (updatePermissType == 2) {
                this.updatePermissByFormOrFlow(args, isnewUpdate, updatePermissType);
            }
        }
    }

    private void updatePermissByFormOrFlow(BeforeDoOperationEventArgs args, Boolean ismodify, int updatePermissType) {
        if (ismodify.booleanValue()) {
            this.getView().getParentView().getPageCache().put("updatePermissType", String.valueOf(updatePermissType));
            if ("0".equals(this.getView().getPageCache().get("againClick"))) {
                Long assessformId = this.getView().getModel().getDataEntity().getLong("assessform.id");
                Long perfworkflowId = this.getView().getModel().getDataEntity().getLong("perfworkflow.id");
                if (!String.valueOf(assessformId).equals(this.getView().getPageCache().get("assessform")) || !String.valueOf(perfworkflowId).equals(this.getView().getPageCache().get("perfworkflow"))) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u8003\u6838\u5468\u671f\u7684\u8bc4\u4f30\u8868\u5355\u6216\u6d41\u7a0b\u5df2\u8c03\u6574\uff0c\u5bf9\u5e94\u6743\u9650\u8bbe\u7f6e\u5c06\u53d1\u751f\u53d8\u5316\u3002\u662f\u5426\u91cd\u65b0\u8c03\u6574\u6743\u9650\uff1f", (String)"ExecuteSchemeEditPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("SaveConfirmAction", (IFormPlugin)this));
                    args.setCancel(Boolean.TRUE.booleanValue());
                    this.getView().getParentView().getPageCache().put("isSameSettings", "0");
                } else {
                    this.getView().getParentView().getPageCache().put("isSameSettings", "1");
                }
            }
        } else {
            Long assessformId = this.getView().getModel().getDataEntity().getLong("assessform.id");
            Long perfworkflowId = this.getView().getModel().getDataEntity().getLong("perfworkflow.id");
            if (!String.valueOf(assessformId).equals(this.getView().getPageCache().get("assessform")) || !String.valueOf(perfworkflowId).equals(this.getView().getPageCache().get("perfworkflow"))) {
                this.getView().getParentView().getPageCache().put("isSameSettings", "0");
            } else {
                this.getView().getParentView().getPageCache().put("isSameSettings", "1");
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if ("save".equals(key)) {
            this.getView().returnDataToParent(this.getModel().getDataEntity().getPkValue());
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = ((Control)beforeF7SelectEvent.getSource()).getKey();
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("scheme");
        Long schemeId = scheme.getLong("id");
        switch (fieldKey) {
            case "assessscope": {
                DynamicObject timeTag = (DynamicObject)this.getModel().getValue("timetag");
                QFilter schemeFilter = new QFilter("scheme", "=", (Object)schemeId);
                QFilter timeTagFilter = new QFilter("timetag", "=", (Object)timeTag.getLong("id"));
                DynamicObject[] scopeList = EXECUTE_SCHEME_APPLICATION_SERVICE.queryScopeList(new QFilter[]{schemeFilter, timeTagFilter});
                List scopeIds = Arrays.stream(scopeList).map(obj -> obj.getDynamicObject("assessscope").getLong("id")).collect(Collectors.toList());
                QFilter scopeFilter = new QFilter("id", "not in", scopeIds);
                List<QFilter> filters = Arrays.asList(schemeFilter, scopeFilter);
                beforeF7SelectEvent.getCustomQFilters().addAll(filters);
                break;
            }
            case "assessrule": {
                Object[] baseInfo = ASSESS_SCHEME_APPLICATION_SERVICE.queryListBySchemeId(schemeId);
                List ruleIds = null;
                if (!ObjectUtils.isEmpty((Object[])baseInfo)) {
                    DynamicObjectCollection rules = baseInfo[0].getDynamicObjectCollection("ruleentryentity");
                    ruleIds = rules.stream().map(obj -> obj.getDynamicObject("ruledatabase").getLong("id")).collect(Collectors.toList());
                }
                QFilter ruleFilter = new QFilter("id", "in", ruleIds);
                beforeF7SelectEvent.getCustomQFilters().add(ruleFilter);
                break;
            }
            case "assessform": {
                String caption = ResManager.loadKDString((String)"\u8bc4\u4f30\u8868\u5355", (String)"ExecuteSchemeEditPlugin_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
                String appId = DataValidateServiceHelper.getBizAppId((String)"epa_assessform");
                HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"epa_assessform", (String)"47150e89000000ac");
                QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)"epa_assessform", (List)result.getHasPermOrgs(), (boolean)true);
                QFilter qFilter = new QFilter("activity", "is null", null).or(new QFilter("activity", "=", (Object)0));
                beforeF7SelectEvent.getCustomQFilters().add(qFilter);
                beforeF7SelectEvent.getCustomQFilters().add(filter);
                beforeF7SelectEvent.getFormShowParameter().setCaption(caption);
                break;
            }
            case "perfworkflow": {
                String appId1 = DataValidateServiceHelper.getBizAppId((String)"epa_perfworkflow");
                HasPermOrgResult result1 = PermissionServiceHelper.getAllPermOrgs((Long)RequestContext.get().getCurrUserId(), (String)appId1, (String)"epa_perfworkflow", (String)"47150e89000000ac");
                QFilter filter1 = BaseDataServiceHelper.getBaseDataFilter((String)"epa_perfworkflow", (List)result1.getHasPermOrgs(), (boolean)true);
                QFilter qFilter1 = new QFilter("activityid", "is null", null).or(new QFilter("activityid", "=", (Object)0));
                beforeF7SelectEvent.getCustomQFilters().add(filter1);
                beforeF7SelectEvent.getCustomQFilters().add(qFilter1);
                QFilter evalFilter = this.getFilter(this.getModel().getDataEntity());
                evalFilter.and(new QFilter("entryentity.isshow", "=", (Object)"1"));
                evalFilter.and(new QFilter("epaworkflowtype", "!=", (Object)SUM_DATA));
                beforeF7SelectEvent.getCustomQFilters().add(evalFilter);
                break;
            }
        }
    }

    private QFilter getFilter(DynamicObject data) {
        QFilter ruleFilter = new QFilter("entryentity.isshow", "=", (Object)"1");
        return ruleFilter;
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if ("SaveConfirmAction".equals(event.getCallBackId())) {
            if (MessageBoxResult.Cancel.equals((Object)event.getResult())) {
                this.getView().getParentView().getPageCache().put("isToPermission", "0");
            } else {
                this.getView().getParentView().getPageCache().put("isToPermission", "1");
            }
            this.getView().getPageCache().put("againClick", "1");
            this.getView().invokeOperation("save");
        }
    }
}

