/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.scheme;

import com.google.common.collect.ImmutableBiMap;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.extplugin.PluginFilter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.dynpermission.DynPermissionConfigService;
import kd.opmc.epa.business.application.service.dynpermission.presetpermission.PresetPermissionUtils;
import kd.opmc.epa.business.application.service.scheme.AssessSchemeApplicationService;
import kd.opmc.epa.business.application.service.scheme.ExecuteSchemeApplicationService;
import kd.opmc.epa.business.application.service.scheme.ObjectScopeApplicationService;
import kd.opmc.epa.business.domain.activitymanage.extpoint.IDynPermissionExtProcessService;
import kd.opmc.epa.business.domain.activitymanage.extpoint.IUpdatePermissionSettingService;
import kd.opmc.epa.common.vo.dynpermission.DynamicPermissionConfigVO;
import kd.opmc.epa.formplugin.web.utils.SchemeStatusValidateUtils;
import kd.opmc.epa.formplugin.web.utils.permission.ExcuterSchemePermissionUtils;

public class ExecuterSchemeTimeViewPlugin
extends AbstractFormPlugin {
    private static final ExecuteSchemeApplicationService EXECUTE_SCHEME_APPLICATION_SERVICE = ExecuteSchemeApplicationService.getInstance();
    private static final AssessSchemeApplicationService ASSESS_SCHEME_APPLICATION_SERVICE = AssessSchemeApplicationService.getInstance();
    private static final ObjectScopeApplicationService OBJECT_SCOPE_APPLICATION_SERVICE = ObjectScopeApplicationService.getInstance();
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final IUpdatePermissionSettingService UPDATE_PERMISSION_SETTING_SERVICE = IUpdatePermissionSettingService.getInstance();
    private static final IDynPermissionExtProcessService DYN_PERMISSION_EXT_PROCESS_SERVICE = IDynPermissionExtProcessService.getInstance();
    private static final String TREEENTRYENTITY = "treeentryentity";
    private static final String PCYCLETYPE_NUMBER = "pcycletype.number";
    private static final String EXECUTESCHEME_ID = "executescheme.id";
    private static final String[] TIME_TAG_H = new String[]{"H1", "H2"};
    private static final String[] TIME_TAG_Q = new String[]{"Q1", "Q2", "Q3", "Q4"};
    private static final String[] TIME_TAG_M = new String[]{"M1", "M2", "M3", "M4", "M5", "M6", "M7", "M8", "M9", "M10", "M11", "M12"};
    private static final String[] TIME_TAG_ALL = new String[]{"Y", "H1", "Q1", "M1", "M2", "M3", "Q2", "M4", "M5", "M6", "H2", "Q3", "M7", "M8", "M9", "Q4", "M10", "M11", "M12"};
    private final Map<String, String> TAG_MAP = ImmutableBiMap.builder().put((Object)"1010_S", (Object)"Y").put((Object)"1020_S", (Object)"H").put((Object)"1030_S", (Object)"Q").put((Object)"1040_S", (Object)"M").build();
    private final Long ZERO = 0L;

    public void initialize() {
        super.initialize();
        Long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId");
        EntryGrid entryGrid = (EntryGrid)this.getControl(TREEENTRYENTITY);
        ExcuterSchemePermissionUtils.setOperatorVisble(entryGrid, schemeId);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId");
        DynamicObject[] datas = EXECUTE_SCHEME_APPLICATION_SERVICE.queryListBySchemeId(schemeId, "");
        if (datas.length > 0) {
            this.getTreeEntryEntityData();
        }
    }

    private void getTreeEntryEntityData() {
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
        treeEntryGrid.setCollapse(true);
        IDataModel gridModel = treeEntryGrid.getModel();
        gridModel.deleteEntryData(TREEENTRYENTITY);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getView().getModel();
        model.beginInit();
        List<TreeNode> bulidSalaryTypeTree = this.bulidSalaryTypeTree();
        for (TreeNode treeNode : bulidSalaryTypeTree) {
            this.createTopNode(treeNode, gridModel);
        }
        model.endInit();
        this.getView().updateView(TREEENTRYENTITY);
    }

    private void createTopNode(TreeNode treeNode, IDataModel gridModel) {
        DynamicObject dynamicObject = (DynamicObject)treeNode.getData();
        int createNewEntryRow = gridModel.createNewEntryRow(TREEENTRYENTITY);
        DynamicObject entryRowEntity = gridModel.getEntryRowEntity(TREEENTRYENTITY, createNewEntryRow);
        entryRowEntity.set("executescheme", (Object)dynamicObject);
        if (dynamicObject == null) {
            entryRowEntity.set("number", (Object)treeNode.getLongNumber());
            entryRowEntity.set("name", (Object)treeNode.getText());
        } else {
            entryRowEntity.set("number", (Object)dynamicObject.getString("timetag.name"));
            entryRowEntity.set("name", (Object)dynamicObject.getString("assessscope.name"));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String message;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        IDataModel entryOperate = this.getView().getModel();
        Long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId");
        SchemeStatusValidateUtils.checkSchemeStatusValidate(args, this.getView());
        DynamicObject[] datas = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryActivityBySchemeId(schemeId);
        Map activities = Arrays.stream(datas).collect(Collectors.toMap(DynamicObject2 -> DynamicObject2.getString(EXECUTESCHEME_ID), Function.identity(), (key1, key2) -> key2));
        int selectRow = entryOperate.getEntryCurrentRowIndex(TREEENTRYENTITY);
        DynamicObject currentRowEntity = entryOperate.getEntryRowEntity(TREEENTRYENTITY, selectRow);
        if (HRStringUtils.equals((String)"donothing_modify", (String)source.getOperateKey()) && !args.isCancel()) {
            if (activities.get(currentRowEntity.getString(EXECUTESCHEME_ID)) != null) {
                message = MessageFormat.format(ResManager.loadKDString((String)"{0}\u8003\u6838\u6d3b\u52a8\u5df2\u751f\u6210\uff0c\u65e0\u6cd5\u7f16\u8f91\u3002", (String)"ExecuterSchemeTimeViewPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]), currentRowEntity.getString("executescheme.name"));
                this.getView().showErrorNotification(message);
                args.setCancel(true);
            } else {
                this.addShowForm(currentRowEntity.getLong(EXECUTESCHEME_ID));
            }
        }
        if (HRStringUtils.equals((String)"donothing_delete", (String)source.getOperateKey()) && !args.isCancel()) {
            if (activities.get(currentRowEntity.getString(EXECUTESCHEME_ID)) != null) {
                message = MessageFormat.format(ResManager.loadKDString((String)"{0}\u8003\u6838\u6d3b\u52a8\u5df2\u751f\u6210\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"ExecuterSchemeTimeViewPlugin_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]), currentRowEntity.getString("executescheme.name"));
                this.getView().showErrorNotification(message);
                args.setCancel(true);
            } else {
                message = ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684{0}\u6761\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"ExecuterSchemeTimeViewPlugin_2", (String)"opmc-epa-formplugin", (Object[])new Object[]{1});
                ConfirmCallBackListener closeCallBack = new ConfirmCallBackListener("listoperation", (IFormPlugin)this);
                this.getView().showConfirm(message, MessageBoxOptions.OKCancel, ConfirmTypes.Default, closeCallBack);
            }
        }
        if (HRStringUtils.equals((String)"setpermission", (String)source.getOperateKey()) && !args.isCancel()) {
            this.showSettingPermissionPage(currentRowEntity.getString(EXECUTESCHEME_ID));
        }
        if (HRStringUtils.equals((String)"permissionset", (String)source.getOperateKey()) && !args.isCancel()) {
            this.showPermissionSetting(currentRowEntity.getString(EXECUTESCHEME_ID));
        }
    }

    private void showPermissionSetting(String executeschemeId) {
        FormShowParameter baseShowParameter = new FormShowParameter();
        baseShowParameter.setFormId("epa_permissionsetting");
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setPageId("epa_permissionsetting" + executeschemeId);
        baseShowParameter.setCustomParam("executeschemeId", (Object)executeschemeId);
        DynamicObject executescheme = EXECUTE_SCHEME_APPLICATION_SERVICE.queryOne("id,name,assessform,perfworkflow,perfworkflow.flowentry", Long.valueOf(executeschemeId));
        DynamicObject[] permissionObj = BusinessDataServiceHelper.load((String)"epa_dynamicpermission", (String)"id", (QFilter[])new QFilter[]{new QFilter("excutescheme", "=", (Object)Long.valueOf(executeschemeId)).and(new QFilter("assessform", "=", (Object)executescheme.getLong("assessform.id"))).and(new QFilter("perfworkflow", "=", (Object)executescheme.getLong("perfworkflow.id"))).and(new QFilter("bindtype", "=", (Object)"1"))}, (String)"createtime desc");
        baseShowParameter.setCustomParam("BATCH_SETTING", (Object)false);
        baseShowParameter.setCustomParam("processpermsetting", (Object)permissionObj[0].getLong("id"));
        long currUserId = RequestContext.get().getCurrUserId();
        boolean hasModfyPermission = PermissionServiceHelper.checkPermission((Long)currUserId, (String)"epa", (String)"epa_scheme", (String)"4715a0df000000ac");
        boolean hasViewPermission = PermissionServiceHelper.checkPermission((Long)currUserId, (String)"epa", (String)"epa_scheme", (String)"47150e89000000ac");
        if (hasModfyPermission) {
            baseShowParameter.setCustomParam("status", (Object)OperationStatus.EDIT.toString());
        } else if (hasViewPermission) {
            baseShowParameter.setCustomParam("status", (Object)OperationStatus.VIEW.toString());
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u8003\u6838\u8ba1\u5212\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ExecuterSchemeViewPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showForm(baseShowParameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (!HRStringUtils.equals((String)"donothing_delete", (String)args.getOperateKey()) && !HRStringUtils.equals((String)"confirmdelete", (String)args.getOperateKey())) {
            this.getTreeEntryEntityData();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData != null && ("editscheme".equals(actionId) || "epa_executescheme".equals(actionId))) {
            DynamicObjectCollection treeentryentity;
            Optional<DynamicObject> entityWithId;
            if (returnData instanceof Map) {
                Integer success = (Integer)((Map)returnData).get("success");
                String message = MessageFormat.format(ResManager.loadKDString((String)"\u6210\u529f\u65b0\u589e{0}\u4e2a\u8003\u6838\u6267\u884c\u8ba1\u5212\u3002", (String)"ExecuterSchemeTimeViewPlugin_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]), success + "");
                this.getView().showSuccessNotification(message);
            }
            this.getTreeEntryEntityData();
            String isSameSettings = this.getView().getPageCache().get("isSameSettings");
            if (returnData instanceof Long && "0".equals(isSameSettings) && (entityWithId = (treeentryentity = this.getView().getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection(TREEENTRYENTITY)).stream().filter(entry -> entry.getLong(EXECUTESCHEME_ID) == ((Long)returnData).longValue()).findFirst()).isPresent()) {
                this.savePermissionSettings(entityWithId);
                if ("1".equals(this.getView().getPageCache().get("isToPermission"))) {
                    this.showPermissionSetting(String.valueOf(returnData));
                }
            }
            this.getView().getPageCache().remove("isToPermission");
            this.getView().getPageCache().remove("isSameSettings");
            this.getView().getPageCache().remove("updatePermissType");
        }
    }

    private void addShowForm(Long executescheme) {
        Long scheme = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId");
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("epa_executescheme");
        showParameter.setPkId((Object)executescheme);
        showParameter.setHasRight(true);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("schemeId", (Object)scheme);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_executescheme"));
        Long orgId = Long.parseLong(this.getView().getFormShowParameter().getCustomParam("org") + "");
        Long adminId = Long.parseLong(this.getView().getFormShowParameter().getCustomParam("adminorg") + "");
        showParameter.setCustomParam("org", (Object)orgId);
        showParameter.setCustomParam("adminorg", (Object)adminId);
        String subViewId = this.getView().getPageCache().get("currentOperationSubview");
        if (!StringUtils.isEmpty((CharSequence)subViewId)) {
            IFormView view = this.getView().getView(subViewId);
            showParameter.setCustomParam("cardShowTag", view.getFormShowParameter().getCustomParam("cardShowTag"));
            showParameter.setCustomParam("cardShowTagId", view.getFormShowParameter().getCustomParam("cardShowTagId"));
            this.getView().getPageCache().remove("currentOperationSubview");
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private List<TreeNode> bulidSalaryTypeTree() {
        Long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId");
        DynamicObject scheme = ASSESS_SCHEME_APPLICATION_SERVICE.queryOne("cycletype,cycletype.number,periodconfentity,periodconfentity.pcycletype,periodconfentity.pcycletype.name", schemeId);
        DynamicObjectCollection periodconfentity = scheme.getDynamicObjectCollection("periodconfentity");
        DynamicObject[] objecScopes = OBJECT_SCOPE_APPLICATION_SERVICE.queryListBySchemeId(schemeId);
        if (periodconfentity.size() == 0) {
            periodconfentity = new DynamicObjectCollection();
            DynamicObject periodconf = ASSESS_SCHEME_APPLICATION_SERVICE.generateEmptyEntryDynamicObject("periodconfentity");
            periodconf.set("pcycletype", scheme.get("cycletype"));
            periodconfentity.add((Object)periodconf);
        }
        TreeMap<String, String> parentMap = new TreeMap<String, String>();
        ArrayList<TreeNode> allTreeNodes = new ArrayList<TreeNode>();
        this.buildParentMap(periodconfentity, parentMap);
        String searchtext = (String)this.getView().getFormShowParameter().getCustomParam("searchtext");
        for (DynamicObject objecScope : objecScopes) {
            QFilter[] qFilters = new QFilter[]{new QFilter("scheme.id", "=", (Object)schemeId), new QFilter("assessscope.id", "=", (Object)objecScope.getLong("ID"))};
            if (!HRStringUtils.isEmpty((String)searchtext)) {
                qFilters[0].and(new QFilter("name", "like", (Object)("%" + searchtext + "%")));
            }
            DynamicObject[] excuteSchemes = EXECUTE_SCHEME_APPLICATION_SERVICE.query("scheme,timetag.name,objectscope,assessscope.name,assesssumtype,name,number,assessform,perfworkflow,sumperiod", qFilters, "timetag.number desc");
            Map<String, List<DynamicObject>> map = Arrays.stream(excuteSchemes).collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getString("timetag.name")));
            if (excuteSchemes.length <= 0) continue;
            this.buildAllTreeNode(parentMap, allTreeNodes, map, objecScope.getString("name"));
        }
        List<TreeNode> treeNodeList = this.sort(allTreeNodes);
        return treeNodeList;
    }

    private List<TreeNode> sort(List<TreeNode> topTreeNodes) {
        Map<String, List<TreeNode>> map = topTreeNodes.stream().collect(Collectors.groupingBy(TreeNode::getLongNumber));
        ArrayList<TreeNode> treeNodeList = new ArrayList<TreeNode>();
        for (int i = 0; i < TIME_TAG_ALL.length; ++i) {
            List<TreeNode> treeNodes = map.get(TIME_TAG_ALL[i]);
            if (CollectionUtils.isEmpty(treeNodes)) continue;
            treeNodeList.addAll(treeNodes);
        }
        return treeNodeList;
    }

    private void buildParentMap(DynamicObjectCollection periodconfentity, Map<String, String> parentMap) {
        for (int i = 0; i < periodconfentity.size(); ++i) {
            DynamicObject entryentity = (DynamicObject)periodconfentity.get(i);
            String tag = entryentity.getString(PCYCLETYPE_NUMBER);
            if (i > 0) {
                parentMap.put(this.TAG_MAP.get(tag), this.TAG_MAP.get(((DynamicObject)periodconfentity.get(i - 1)).getString(PCYCLETYPE_NUMBER)));
                continue;
            }
            parentMap.put(this.TAG_MAP.get(tag), "top0");
        }
    }

    private void buildAllTreeNode(Map<String, String> parentMap, List<TreeNode> allTreeNodes, Map<String, List<DynamicObject>> map, String name) {
        parentMap.forEach((key, value) -> {
            switch (key) {
                case "Y": {
                    this.buildYTreeNode(allTreeNodes, map, name);
                    break;
                }
                case "H": {
                    this.buildHTreeNode(allTreeNodes, map, name);
                    break;
                }
                case "Q": {
                    this.buildQTreeNode(allTreeNodes, map, name);
                    break;
                }
                case "M": {
                    this.buildMTreeNode(allTreeNodes, map, name);
                    break;
                }
            }
        });
    }

    private void buildYTreeNode(List<TreeNode> allTreeNodes, Map<String, List<DynamicObject>> map, String name) {
        block5: {
            block4: {
                String searchtext = (String)this.getView().getFormShowParameter().getCustomParam("searchtext");
                if (!HRStringUtils.isEmpty((String)searchtext)) break block4;
                if (map.get("Y") != null) {
                    List<DynamicObject> datas = map.get("Y");
                    for (DynamicObject data : datas) {
                        TreeNode treeNode = new TreeNode();
                        treeNode.setIsOpened(Boolean.TRUE.booleanValue());
                        treeNode.setData((Object)data);
                        treeNode.setId(data.getString("id"));
                        treeNode.setLongNumber("Y");
                        treeNode.setText(name);
                        allTreeNodes.add(treeNode);
                    }
                } else {
                    TreeNode treeNode = new TreeNode();
                    treeNode.setId("Y");
                    treeNode.setLongNumber("Y");
                    treeNode.setText(name);
                    allTreeNodes.add(treeNode);
                }
                break block5;
            }
            if (map.get("Y") == null) break block5;
            List<DynamicObject> datas = map.get("Y");
            for (DynamicObject data : datas) {
                TreeNode treeNode = new TreeNode();
                treeNode.setIsOpened(Boolean.TRUE.booleanValue());
                treeNode.setData((Object)data);
                treeNode.setId(data.getString("id"));
                treeNode.setLongNumber("Y");
                treeNode.setText(name);
                allTreeNodes.add(treeNode);
            }
        }
    }

    private void buildHTreeNode(List<TreeNode> allTreeNodes, Map<String, List<DynamicObject>> map, String name) {
        String searchtext = (String)this.getView().getFormShowParameter().getCustomParam("searchtext");
        if (HRStringUtils.isEmpty((String)searchtext)) {
            for (int i = 0; i < TIME_TAG_H.length; ++i) {
                TreeNode treeNode;
                if (map.get(TIME_TAG_H[i]) != null) {
                    List<DynamicObject> datas = map.get(TIME_TAG_H[i]);
                    for (DynamicObject data : datas) {
                        treeNode = new TreeNode();
                        treeNode.setIsOpened(Boolean.TRUE.booleanValue());
                        treeNode.setData((Object)data);
                        treeNode.setId(data.getString("id"));
                        treeNode.setLongNumber(TIME_TAG_H[i]);
                        treeNode.setText(name);
                        allTreeNodes.add(treeNode);
                    }
                    continue;
                }
                treeNode = new TreeNode();
                treeNode.setIsOpened(Boolean.TRUE.booleanValue());
                treeNode.setId(TIME_TAG_H[i]);
                treeNode.setLongNumber(TIME_TAG_H[i]);
                treeNode.setText(name);
                allTreeNodes.add(treeNode);
            }
        } else {
            for (int i = 0; i < TIME_TAG_H.length; ++i) {
                if (map.get(TIME_TAG_H[i]) == null) continue;
                List<DynamicObject> datas = map.get(TIME_TAG_H[i]);
                for (DynamicObject data : datas) {
                    TreeNode treeNode = new TreeNode();
                    treeNode.setIsOpened(Boolean.TRUE.booleanValue());
                    treeNode.setData((Object)data);
                    treeNode.setId(data.getString("id"));
                    treeNode.setLongNumber(TIME_TAG_H[i]);
                    treeNode.setText(name);
                    allTreeNodes.add(treeNode);
                }
            }
        }
    }

    private void buildQTreeNode(List<TreeNode> allTreeNodes, Map<String, List<DynamicObject>> map, String name) {
        String searchtext = (String)this.getView().getFormShowParameter().getCustomParam("searchtext");
        if (HRStringUtils.isEmpty((String)searchtext)) {
            for (int i = 0; i < TIME_TAG_Q.length; ++i) {
                TreeNode treeNode = new TreeNode();
                if (map.get(TIME_TAG_Q[i]) != null) {
                    List<DynamicObject> datas = map.get(TIME_TAG_Q[i]);
                    for (DynamicObject data : datas) {
                        treeNode = new TreeNode();
                        treeNode.setIsOpened(Boolean.TRUE.booleanValue());
                        treeNode.setData((Object)data);
                        treeNode.setId(data.getString("id"));
                        treeNode.setLongNumber(TIME_TAG_Q[i]);
                        treeNode.setText(name);
                        allTreeNodes.add(treeNode);
                    }
                    continue;
                }
                treeNode.setId(TIME_TAG_Q[i]);
                treeNode.setIsOpened(Boolean.TRUE.booleanValue());
                treeNode.setLongNumber(TIME_TAG_Q[i]);
                treeNode.setText(name);
                allTreeNodes.add(treeNode);
            }
        } else {
            for (int i = 0; i < TIME_TAG_Q.length; ++i) {
                TreeNode treeNode = new TreeNode();
                if (map.get(TIME_TAG_Q[i]) == null) continue;
                List<DynamicObject> datas = map.get(TIME_TAG_Q[i]);
                for (DynamicObject data : datas) {
                    treeNode = new TreeNode();
                    treeNode.setIsOpened(Boolean.TRUE.booleanValue());
                    treeNode.setData((Object)data);
                    treeNode.setId(data.getString("id"));
                    treeNode.setLongNumber(TIME_TAG_Q[i]);
                    treeNode.setText(name);
                    allTreeNodes.add(treeNode);
                }
            }
        }
    }

    private void buildMTreeNode(List<TreeNode> allTreeNodes, Map<String, List<DynamicObject>> map, String name) {
        String searchtext = (String)this.getView().getFormShowParameter().getCustomParam("searchtext");
        if (HRStringUtils.isEmpty((String)searchtext)) {
            for (int i = 0; i < TIME_TAG_M.length; ++i) {
                TreeNode treeNode;
                if (map.get(TIME_TAG_M[i]) != null) {
                    List<DynamicObject> datas = map.get(TIME_TAG_M[i]);
                    for (DynamicObject data : datas) {
                        treeNode = new TreeNode();
                        treeNode.setIsOpened(Boolean.TRUE.booleanValue());
                        treeNode.setData((Object)data);
                        treeNode.setLongNumber(TIME_TAG_M[i]);
                        treeNode.setId(data.getString("id"));
                        treeNode.setText(name);
                        allTreeNodes.add(treeNode);
                    }
                    continue;
                }
                treeNode = new TreeNode();
                treeNode.setIsOpened(Boolean.TRUE.booleanValue());
                treeNode.setParentid("top0");
                treeNode.setLongNumber(TIME_TAG_M[i]);
                treeNode.setId(TIME_TAG_M[i]);
                treeNode.setText(name);
                allTreeNodes.add(treeNode);
            }
        } else {
            for (int i = 0; i < TIME_TAG_M.length; ++i) {
                if (map.get(TIME_TAG_M[i]) == null) continue;
                List<DynamicObject> datas = map.get(TIME_TAG_M[i]);
                for (DynamicObject data : datas) {
                    TreeNode treeNode = new TreeNode();
                    treeNode.setIsOpened(Boolean.TRUE.booleanValue());
                    treeNode.setData((Object)data);
                    treeNode.setLongNumber(TIME_TAG_M[i]);
                    treeNode.setId(data.getString("id"));
                    treeNode.setText(name);
                    allTreeNodes.add(treeNode);
                }
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        boolean hasPermission = PermissionServiceHelper.hasPermission((Long)RequestContext.get().getCurrUserId(), (String)"epa_excutescheme_time", (String)"4715e1f1000000ac");
        if (hasPermission) {
            if ("listoperation".equals(e.getCallBackId()) && e.getResult().equals((Object)MessageBoxResult.Yes)) {
                Long schemeId;
                DynamicObject[] datas;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("systeminvoke", "true");
                this.getView().invokeOperation("confirmdelete", operateOption);
                IDataModel entryOperate = this.getView().getModel();
                int selectRow = entryOperate.getEntryCurrentRowIndex(TREEENTRYENTITY);
                DynamicObject currentRowEntity = entryOperate.getEntryRowEntity(TREEENTRYENTITY, selectRow);
                Long excuteId = currentRowEntity.getLong(EXECUTESCHEME_ID);
                if (excuteId != null && Long.compare(excuteId, this.ZERO) != 0) {
                    EXECUTE_SCHEME_APPLICATION_SERVICE.deleteById(excuteId);
                }
                if ((datas = EXECUTE_SCHEME_APPLICATION_SERVICE.queryListBySchemeId(schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId"), "")).length > 0) {
                    this.getTreeEntryEntityData();
                } else {
                    TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
                    IDataModel gridModel = treeEntryGrid.getModel();
                    gridModel.deleteEntryData(TREEENTRYENTITY);
                }
                this.getView().getParentView().updateView();
                this.getView().sendFormAction(this.getView().getParentView());
            }
        } else {
            String str = ResManager.loadKDString((String)"\u65e0\u201c\u8003\u6838\u8ba1\u5212\u6267\u884c\u65b9\u6848\u201d\u7684\u201c\u5220\u9664\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ExecuterSchemeTimeViewPlugin_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(str);
        }
    }

    private void showSettingPermissionPage(String executeschemeId) {
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("epa_processpermsetting");
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setPageId("epa_processpermsetting" + executeschemeId);
        baseShowParameter.setCustomParam("executeschemeId", (Object)executeschemeId);
        DynamicObject executescheme = EXECUTE_SCHEME_APPLICATION_SERVICE.queryOne("id,name,assessform,perfworkflow,perfworkflow.flowentry", Long.valueOf(executeschemeId));
        DynamicObject permissionObj = BusinessDataServiceHelper.loadSingle((String)"epa_processpermsetting", (String)"id", (QFilter[])new QFilter[]{new QFilter("excutescheme", "=", (Object)Long.valueOf(executeschemeId)).and(new QFilter("assessform", "=", (Object)executescheme.getLong("assessform.id"))).and(new QFilter("perfworkflow", "=", (Object)executescheme.getLong("perfworkflow.id")).and(new QFilter("iscurrentversion", "=", (Object)"1")))});
        if (permissionObj == null) {
            baseShowParameter.setStatus(OperationStatus.ADDNEW);
        } else {
            baseShowParameter.setPkId(permissionObj.getPkValue());
            baseShowParameter.setStatus(OperationStatus.EDIT);
            baseShowParameter.setBillStatus(BillOperationStatus.VIEW);
        }
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    private void savePermissionSettings(Optional<DynamicObject> entityWithId) {
        DynamicPermissionConfigVO dynamicPermissionConfigVO = PresetPermissionUtils.setDynamicPermissionConfigVO((DynamicObject)entityWithId.get().getDynamicObject("executescheme"));
        HRPluginProxy proxy = new HRPluginProxy((Object)DYN_PERMISSION_EXT_PROCESS_SERVICE, IDynPermissionExtProcessService.class, "kd.opmc.epa.business.domain.activitymanage.extpoint.impl.DynPermissionExtProcessService#updatePermissionSetting", (PluginFilter)null);
        proxy.callReplaceIfPresent(p -> p.updatePermissionSetting(dynamicPermissionConfigVO));
        DynPermissionConfigService dynamicObjectCollection = new DynPermissionConfigService();
        dynamicObjectCollection.insertDynamicPermission(dynamicPermissionConfigVO);
    }
}

