/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.scheme;

import com.google.common.collect.ImmutableBiMap;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.extplugin.PluginFilter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mutex.DataMutex;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.dynpermission.DynPermissionConfigService;
import kd.opmc.epa.business.application.service.dynpermission.presetpermission.PresetPermissionUtils;
import kd.opmc.epa.business.application.service.scheme.AssessSchemeApplicationService;
import kd.opmc.epa.business.application.service.scheme.ExecuteSchemeApplicationService;
import kd.opmc.epa.business.application.service.scheme.ObjectScopeApplicationService;
import kd.opmc.epa.business.domain.activitymanage.extpoint.IDynPermissionExtProcessService;
import kd.opmc.epa.business.domain.activitymanage.extpoint.IUpdatePermissionSettingService;
import kd.opmc.epa.common.vo.dynpermission.DynamicPermissionConfigVO;
import kd.opmc.epa.formplugin.web.utils.SchemeStatusValidateUtils;
import kd.opmc.epa.formplugin.web.utils.permission.ExcuterSchemePermissionUtils;

public class ExecuterSchemeViewPlugin
extends AbstractFormPlugin {
    private static final ExecuteSchemeApplicationService EXECUTE_SCHEME_APPLICATION_SERVICE = ExecuteSchemeApplicationService.getInstance();
    private static final AssessSchemeApplicationService ASSESS_SCHEME_APPLICATION_SERVICE = AssessSchemeApplicationService.getInstance();
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final IUpdatePermissionSettingService UPDATE_PERMISSION_SETTING_SERVICE = IUpdatePermissionSettingService.getInstance();
    private static final ObjectScopeApplicationService OBJECT_SCOPE_APPLICATION_SERVICE = ObjectScopeApplicationService.getInstance();
    private static final String TREEENTRYENTITY = "treeentryentity";
    private static final String FLEX_PANELAP = "flexpanelap";
    private static final String ADVCONAP = "advconap";
    private static final String EMPTY_ADVCONAP = "advconap1";
    private static final String[] TIME_TAG_H = new String[]{"H1", "H2"};
    private static final String[] TIME_TAG_Q = new String[]{"Q1", "Q2", "Q3", "Q4"};
    private static final String[] TIME_TAG_M = new String[]{"M1", "M2", "M3", "M4", "M5", "M6", "M7", "M8", "M9", "M10", "M11", "M12"};
    private static final String[] TIME_TAG_ALL = new String[]{"Y", "H1", "Q1", "M1", "M2", "M3", "Q2", "M4", "M5", "M6", "H2", "Q3", "M7", "M8", "M9", "Q4", "M10", "M11", "M12"};
    private static final String PCYCLETYPE_NUMBER = "pcycletype.number";
    private static final String TIMETAG_NAME = "timetag.name";
    public static final String EXECUTESCHEME_ID = "executescheme.id";
    public static final String ASSESSSCOPE_ID = "assessscope.id";
    private final Map<String, String> TAG_MAP = ImmutableBiMap.builder().put((Object)"1010_S", (Object)"Y").put((Object)"1020_S", (Object)"H").put((Object)"1030_S", (Object)"Q").put((Object)"1040_S", (Object)"M").build();
    private final Long ZERO = 0L;
    private static final IDynPermissionExtProcessService DYN_PERMISSION_EXT_PROCESS_SERVICE = IDynPermissionExtProcessService.getInstance();

    public void initialize() {
        super.initialize();
        Long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId");
        EntryGrid entryGrid = (EntryGrid)this.getControl(TREEENTRYENTITY);
        ExcuterSchemePermissionUtils.setOperatorVisble(entryGrid, schemeId);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.showEmptyOrHasData();
        this.setTipsContent();
    }

    private void showEmptyOrHasData() {
        Long assessScope = (Long)this.getView().getFormShowParameter().getCustomParam("objectscope");
        QFilter[] filters = new QFilter[]{new QFilter(ASSESSSCOPE_ID, "=", (Object)assessScope)};
        int count = EXECUTE_SCHEME_APPLICATION_SERVICE.count(filters);
        if (count > 0) {
            this.getTreeEntryEntityData();
            this.getView().setVisible(Boolean.valueOf(false), new String[]{EMPTY_ADVCONAP});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{ADVCONAP});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{EMPTY_ADVCONAP});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ADVCONAP});
        }
        String name = (String)this.getView().getFormShowParameter().getCustomParam("name");
        HashMap<String, LocaleString> props = new HashMap<String, LocaleString>(16);
        props.put("text", new LocaleString(name));
        this.getView().updateControlMetadata(ADVCONAP, props);
        this.getView().updateControlMetadata(EMPTY_ADVCONAP, props);
    }

    private void getTreeEntryEntityData() {
        Long scheme = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId");
        Long assessScope = (Long)this.getView().getFormShowParameter().getCustomParam("objectscope");
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
        treeEntryGrid.setCollapse(false);
        IDataModel gridModel = treeEntryGrid.getModel();
        gridModel.deleteEntryData(TREEENTRYENTITY);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getView().getModel();
        model.beginInit();
        List<TreeNode> bulidSalaryTypeTree = this.bulidSalaryTypeTree(new QFilter[]{new QFilter("scheme.id", "=", (Object)scheme), new QFilter(ASSESSSCOPE_ID, "=", (Object)assessScope)});
        for (TreeNode treeNode : bulidSalaryTypeTree) {
            this.createTopNode(treeNode, gridModel);
        }
        model.endInit();
        this.getView().updateView(TREEENTRYENTITY);
    }

    private List<TreeNode> bulidSalaryTypeTree(QFilter[] queryFilters) {
        Long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId");
        List<TreeNode> topTreeNodes = new ArrayList<TreeNode>();
        String searchtext = (String)this.getView().getFormShowParameter().getCustomParam("searchtext");
        if (!HRStringUtils.isEmpty((String)searchtext)) {
            DynamicObject[] excuteSchemes;
            queryFilters[0].and(new QFilter("name", "like", (Object)("%" + searchtext + "%")));
            for (DynamicObject data : excuteSchemes = EXECUTE_SCHEME_APPLICATION_SERVICE.query("scheme,timetag.name,objectscope,assesssumtype,name,number,assessform,perfworkflow,sumperiod", queryFilters, "timetag.number desc")) {
                TreeNode treeNode = new TreeNode();
                treeNode.setData((Object)data);
                treeNode.setId(data.getString(TIMETAG_NAME));
                topTreeNodes.add(treeNode);
            }
            topTreeNodes = this.sort(topTreeNodes);
            return topTreeNodes;
        }
        DynamicObject[] excuteSchemes = EXECUTE_SCHEME_APPLICATION_SERVICE.query("scheme,timetag.name,objectscope,assesssumtype,name,number,assessform,perfworkflow,sumperiod", queryFilters, "timetag.number desc");
        DynamicObject scheme = ASSESS_SCHEME_APPLICATION_SERVICE.queryOne("cycletype,cycletype.number,periodconfentity,periodconfentity.pcycletype,periodconfentity.pcycletype.name", schemeId);
        DynamicObjectCollection periodconfentity = scheme.getDynamicObjectCollection("periodconfentity");
        if (periodconfentity.size() == 0) {
            periodconfentity = new DynamicObjectCollection();
            DynamicObject periodconf = ASSESS_SCHEME_APPLICATION_SERVICE.generateEmptyEntryDynamicObject("periodconfentity");
            periodconf.set("pcycletype", scheme.get("cycletype"));
            periodconfentity.add((Object)periodconf);
        }
        HashMap<String, String> parentMap = new HashMap<String, String>();
        ArrayList<TreeNode> allTreeNodes = new ArrayList<TreeNode>();
        this.buildParentMap(periodconfentity, parentMap);
        this.buildAllTreeNode(parentMap, allTreeNodes);
        Map map = Arrays.stream(excuteSchemes).collect(Collectors.toMap(DynamicObject2 -> DynamicObject2.getString(TIMETAG_NAME), Function.identity(), (key1, key2) -> key2));
        Map tempTreeNodeMap = allTreeNodes.stream().collect(Collectors.toMap(TreeNode::getId, Function.identity(), (key1, key2) -> key2));
        for (TreeNode value : allTreeNodes) {
            String parentid = value.getParentid();
            value.setData(map.get(value.getId()));
            if ("top0".equals(parentid)) {
                topTreeNodes.add(value);
                continue;
            }
            TreeNode parentNode = (TreeNode)tempTreeNodeMap.get(parentid);
            if (null == parentNode) {
                topTreeNodes.add(value);
                continue;
            }
            parentNode.addChild(value);
        }
        return topTreeNodes;
    }

    private List<TreeNode> sort(List<TreeNode> topTreeNodes) {
        Map<String, List<TreeNode>> map = topTreeNodes.stream().collect(Collectors.groupingBy(TreeNode::getId));
        ArrayList<TreeNode> treeNodeList = new ArrayList<TreeNode>();
        for (int i = 0; i < TIME_TAG_ALL.length; ++i) {
            List<TreeNode> treeNodes = map.get(TIME_TAG_ALL[i]);
            if (CollectionUtils.isEmpty(treeNodes)) continue;
            treeNodeList.addAll(treeNodes);
        }
        return treeNodeList;
    }

    private void buildParentMap(DynamicObjectCollection periodconfentity, Map<String, String> parentMap) {
        for (int i = 0; i < periodconfentity.size(); ++i) {
            DynamicObject entryentity = (DynamicObject)periodconfentity.get(i);
            String tag = entryentity.getString(PCYCLETYPE_NUMBER);
            if (i > 0) {
                parentMap.put(this.TAG_MAP.get(tag), this.TAG_MAP.get(((DynamicObject)periodconfentity.get(i - 1)).getString(PCYCLETYPE_NUMBER)));
                continue;
            }
            parentMap.put(this.TAG_MAP.get(tag), "top0");
        }
    }

    private void buildAllTreeNode(Map<String, String> parentMap, List<TreeNode> allTreeNodes) {
        parentMap.forEach((key, value) -> {
            Object treeNode = null;
            switch (key) {
                case "Y": {
                    this.buildYTreeNode(allTreeNodes, (String)value);
                    break;
                }
                case "H": {
                    this.buildHTreeNode(allTreeNodes, (String)value);
                    break;
                }
                case "Q": {
                    this.buildQTreeNode(allTreeNodes, (String)value);
                    break;
                }
                case "M": {
                    this.buildMTreeNode(allTreeNodes, (String)value);
                    break;
                }
            }
        });
    }

    private void buildQTreeNode(List<TreeNode> allTreeNodes, String value) {
        for (int i = 0; i < TIME_TAG_Q.length; ++i) {
            TreeNode treeNode = new TreeNode();
            treeNode.setIsOpened(Boolean.TRUE.booleanValue());
            treeNode.setParentid("top0");
            treeNode.setId(TIME_TAG_Q[i]);
            if ("Y".equals(value)) {
                treeNode.setParentid(value);
            } else if ("H".equals(value)) {
                if (i < 2) {
                    treeNode.setParentid(TIME_TAG_H[0]);
                } else {
                    treeNode.setParentid(TIME_TAG_H[1]);
                }
            }
            allTreeNodes.add(treeNode);
        }
    }

    private void buildHTreeNode(List<TreeNode> allTreeNodes, String value) {
        for (int i = 0; i < TIME_TAG_H.length; ++i) {
            TreeNode treeNode = new TreeNode();
            treeNode.setIsOpened(Boolean.TRUE.booleanValue());
            treeNode.setId(TIME_TAG_H[i]);
            treeNode.setParentid(value);
            allTreeNodes.add(treeNode);
        }
    }

    private void buildYTreeNode(List<TreeNode> allTreeNodes, String value) {
        TreeNode treeNode = new TreeNode();
        treeNode.setId("Y");
        treeNode.setParentid(value);
        treeNode.setIsOpened(Boolean.TRUE.booleanValue());
        allTreeNodes.add(treeNode);
    }

    private void buildMTreeNode(List<TreeNode> allTreeNodes, String value) {
        for (int i = 0; i < TIME_TAG_M.length; ++i) {
            TreeNode treeNode = new TreeNode();
            treeNode.setIsOpened(Boolean.TRUE.booleanValue());
            treeNode.setParentid("top0");
            treeNode.setId(TIME_TAG_M[i]);
            if ("Y".equals(value)) {
                treeNode.setParentid(value);
            } else if ("H".equals(value)) {
                if (i < TIME_TAG_M.length / 2) {
                    treeNode.setParentid(TIME_TAG_H[0]);
                } else {
                    treeNode.setParentid(TIME_TAG_H[1]);
                }
            } else if ("Q".equals(value)) {
                if (i <= 2) {
                    treeNode.setParentid(TIME_TAG_Q[0]);
                } else if (i <= 5) {
                    treeNode.setParentid(TIME_TAG_Q[1]);
                } else if (i <= 8) {
                    treeNode.setParentid(TIME_TAG_Q[2]);
                } else {
                    treeNode.setParentid(TIME_TAG_Q[3]);
                }
            }
            allTreeNodes.add(treeNode);
        }
    }

    private void createTopNode(TreeNode treeNode, IDataModel gridModel) {
        DynamicObject dynamicObject = (DynamicObject)treeNode.getData();
        int createNewEntryRow = gridModel.createNewEntryRow(TREEENTRYENTITY);
        DynamicObject entryRowEntity = gridModel.getEntryRowEntity(TREEENTRYENTITY, createNewEntryRow);
        entryRowEntity.set("executescheme", (Object)dynamicObject);
        entryRowEntity.set("number", (Object)treeNode.getId());
        List children = treeNode.getChildren();
        if (CollectionUtils.isEmpty((Collection)children)) {
            return;
        }
        for (TreeNode childrenNode : children) {
            this.createChildNode(childrenNode, createNewEntryRow, gridModel);
        }
    }

    private void createChildNode(TreeNode childrenNode, int position, IDataModel gridModel) {
        DynamicObject child = (DynamicObject)childrenNode.getData();
        int insertEntryRow = gridModel.insertEntryRow(TREEENTRYENTITY, position);
        DynamicObject childRowEntity = gridModel.getEntryRowEntity(TREEENTRYENTITY, insertEntryRow);
        childRowEntity.set("executescheme", (Object)child);
        childRowEntity.set("number", (Object)childrenNode.getId());
        List children = childrenNode.getChildren();
        if (CollectionUtils.isEmpty((Collection)children)) {
            return;
        }
        for (TreeNode treeNode : children) {
            this.createChildNode(treeNode, insertEntryRow, gridModel);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operName;
        String executeSchemeName;
        String message;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        IDataModel entryOperate = this.getView().getModel();
        Long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId");
        SchemeStatusValidateUtils.checkSchemeStatusValidate(args, this.getView());
        DynamicObject[] datas = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryActivityBySchemeId(schemeId);
        Map activities = Arrays.stream(datas).collect(Collectors.toMap(DynamicObject2 -> DynamicObject2.getString(EXECUTESCHEME_ID), Function.identity(), (key1, key2) -> key2));
        int selectRow = entryOperate.getEntryCurrentRowIndex(TREEENTRYENTITY);
        DynamicObject currentRowEntity = entryOperate.getEntryRowEntity(TREEENTRYENTITY, selectRow);
        if (HRStringUtils.equals((String)"donothing_modify", (String)source.getOperateKey()) && !args.isCancel()) {
            if (activities.get(currentRowEntity.getString(EXECUTESCHEME_ID)) != null) {
                message = MessageFormat.format(ResManager.loadKDString((String)"{0}\u8003\u6838\u6d3b\u52a8\u5df2\u751f\u6210\uff0c\u65e0\u6cd5\u7f16\u8f91\u3002", (String)"ExecuterSchemeViewPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]), currentRowEntity.getString("executescheme.name"));
                this.getView().showErrorNotification(message);
                args.setCancel(true);
            } else {
                long executeSchemeId = currentRowEntity.getLong(EXECUTESCHEME_ID);
                if (this.checkMutex(executeSchemeId, executeSchemeName = currentRowEntity.getDynamicObject("executescheme").getString("name"), operName = ResManager.loadKDString((String)"\u7f16\u8f91", (String)"ExecuterSchemeViewPlugin_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]))) {
                    args.setCancel(true);
                    return;
                }
                this.addShowForm(executeSchemeId);
            }
        }
        if (HRStringUtils.equals((String)"donothing_delete", (String)source.getOperateKey()) && !args.isCancel()) {
            if (activities.get(currentRowEntity.getString(EXECUTESCHEME_ID)) != null) {
                message = MessageFormat.format(ResManager.loadKDString((String)"{0}\u8003\u6838\u6d3b\u52a8\u5df2\u751f\u6210\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"ExecuterSchemeViewPlugin_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]), currentRowEntity.getString("executescheme.name"));
                this.getView().showErrorNotification(message);
                args.setCancel(true);
            } else {
                long executeSchemeId = currentRowEntity.getLong(EXECUTESCHEME_ID);
                if (this.checkMutex(executeSchemeId, executeSchemeName = currentRowEntity.getDynamicObject("executescheme").getString("name"), operName = ResManager.loadKDString((String)"\u5220\u9664", (String)"ExecuterSchemeViewPlugin_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]))) {
                    args.setCancel(true);
                    return;
                }
                String message2 = ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684{0}\u6761\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"ExecuterSchemeViewPlugin_4", (String)"opmc-epa-formplugin", (Object[])new Object[]{1});
                ConfirmCallBackListener closeCallBack = new ConfirmCallBackListener("listoperation", (IFormPlugin)this);
                this.getView().showConfirm(message2, MessageBoxOptions.OKCancel, ConfirmTypes.Default, closeCallBack);
            }
        }
        if (HRStringUtils.equals((String)"donothing_add", (String)source.getOperateKey()) && !args.isCancel()) {
            this.batchAdd(schemeId);
        }
        if (HRStringUtils.equals((String)"setpermission", (String)source.getOperateKey()) && !args.isCancel()) {
            this.showSettingPermissionPage(currentRowEntity.getString(EXECUTESCHEME_ID));
        }
        if (HRStringUtils.equals((String)"permissionset", (String)source.getOperateKey()) && !args.isCancel()) {
            this.showPermissionSetting(currentRowEntity.getString(EXECUTESCHEME_ID));
        }
    }

    private void batchAdd(Long schemeId) {
        boolean allDatas;
        DynamicObject scheme = ASSESS_SCHEME_APPLICATION_SERVICE.queryOne("cycletype,cycletype.number,periodconfentity,periodconfentity.pcycletype,periodconfentity.pcycletype.name", schemeId);
        DynamicObjectCollection periodconfentity = scheme.getDynamicObjectCollection("periodconfentity");
        if (periodconfentity.size() == 0) {
            periodconfentity = new DynamicObjectCollection();
            DynamicObject periodconf = ASSESS_SCHEME_APPLICATION_SERVICE.generateEmptyEntryDynamicObject("periodconfentity");
            periodconf.set("pcycletype", scheme.get("cycletype"));
            periodconfentity.add((Object)periodconf);
        }
        int timeTagCount = 0;
        for (DynamicObject data : periodconfentity) {
            String cycle;
            switch (cycle = this.TAG_MAP.get(data.getString(PCYCLETYPE_NUMBER))) {
                case "Y": {
                    ++timeTagCount;
                    break;
                }
                case "H": {
                    timeTagCount += 2;
                    break;
                }
                case "Q": {
                    timeTagCount += 4;
                    break;
                }
                case "M": {
                    timeTagCount += 12;
                    break;
                }
            }
        }
        Long assessScope = (Long)this.getView().getFormShowParameter().getCustomParam("objectscope");
        QFilter[] filters = new QFilter[]{new QFilter(ASSESSSCOPE_ID, "=", (Object)assessScope)};
        int count = EXECUTE_SCHEME_APPLICATION_SERVICE.count(filters);
        boolean bl = allDatas = timeTagCount <= count;
        if (allDatas) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61\u8303\u56f4\u7684\u8003\u6838\u6267\u884c\u8ba1\u5212\u5df2\u5168\u90e8\u751f\u6210\uff0c\u65e0\u9700\u518d\u6b21\u65b0\u589e", (String)"ExecuterSchemeViewPlugin_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        } else {
            this.addShowForm("epa_executescheme_add", OperationStatus.EDIT);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        boolean hasPermission = PermissionServiceHelper.hasPermission((Long)RequestContext.get().getCurrUserId(), (String)"epa_excutescheme_entry", (String)"4715e1f1000000ac");
        if (hasPermission) {
            if ("listoperation".equals(e.getCallBackId()) && e.getResult().equals((Object)MessageBoxResult.Yes)) {
                Long schemeId;
                DynamicObject[] datas;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("systeminvoke", "true");
                this.getView().invokeOperation("confirmdelete", operateOption);
                IDataModel entryOperate = this.getView().getModel();
                int selectRow = entryOperate.getEntryCurrentRowIndex(TREEENTRYENTITY);
                DynamicObject currentRowEntity = entryOperate.getEntryRowEntity(TREEENTRYENTITY, selectRow);
                Long excuteId = currentRowEntity.getLong(EXECUTESCHEME_ID);
                if (excuteId != null && Long.compare(excuteId, this.ZERO) != 0) {
                    EXECUTE_SCHEME_APPLICATION_SERVICE.deleteById(excuteId);
                }
                if ((datas = EXECUTE_SCHEME_APPLICATION_SERVICE.queryListBySchemeId(schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId"), "")).length > 0) {
                    this.getTreeEntryEntityData();
                } else {
                    TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
                    IDataModel gridModel = treeEntryGrid.getModel();
                    gridModel.deleteEntryData(TREEENTRYENTITY);
                }
                this.getView().getParentView().updateView();
                this.getView().sendFormAction(this.getView().getParentView());
            }
        } else {
            String str = ResManager.loadKDString((String)"\u65e0\u201c\u8003\u6838\u8ba1\u5212\u6267\u884c\u65b9\u6848\u201d\u7684\u201c\u5220\u9664\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ExecuterSchemeViewPlugin_7", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(str);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (!HRStringUtils.equals((String)"donothing_delete", (String)args.getOperateKey()) && !HRStringUtils.equals((String)"confirmdelete", (String)args.getOperateKey())) {
            this.getTreeEntryEntityData();
        }
    }

    private void addShowForm(Long executescheme) {
        Long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId");
        Long orgId = Long.parseLong(this.getView().getFormShowParameter().getCustomParam("org") + "");
        Long adminId = Long.parseLong(this.getView().getFormShowParameter().getCustomParam("adminorg") + "");
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("epa_executescheme");
        showParameter.setPkId((Object)executescheme);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("schemeId", (Object)schemeId);
        showParameter.setCustomParam("org", (Object)orgId);
        showParameter.setCustomParam("adminorg", (Object)adminId);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_executescheme"));
        String subViewId = this.getView().getPageCache().get("currentOperationSubview");
        if (!StringUtils.isEmpty((CharSequence)subViewId)) {
            IFormView view = this.getView().getView(subViewId);
            showParameter.setCustomParam("cardShowTag", view.getFormShowParameter().getCustomParam("cardShowTag"));
            showParameter.setCustomParam("cardShowTagId", view.getFormShowParameter().getCustomParam("cardShowTagId"));
            this.getView().getPageCache().remove("currentOperationSubview");
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void addShowForm(String formId, OperationStatus status) {
        Long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId");
        Long scope = (Long)this.getView().getFormShowParameter().getCustomParam("objectscope");
        Long orgId = Long.parseLong(this.getView().getFormShowParameter().getCustomParam("org") + "");
        Long adminId = Long.parseLong(this.getView().getFormShowParameter().getCustomParam("adminorg") + "");
        Long cycleType = (Long)this.getView().getFormShowParameter().getCustomParam("cycletype");
        BaseShowParameter showParameter = "epa_executescheme".equals(formId) ? new BaseShowParameter() : new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.setStatus(status);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("schemeId", (Object)schemeId);
        showParameter.setCustomParam("cycletype", (Object)cycleType);
        showParameter.setCustomParam("objectscope", (Object)scope);
        showParameter.setCustomParam("org", (Object)orgId);
        showParameter.setCustomParam("adminorg", (Object)adminId);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_executescheme"));
        String subViewId = this.getView().getPageCache().get("currentOperationSubview");
        if (!StringUtils.isEmpty((CharSequence)subViewId)) {
            IFormView view = this.getView().getView(subViewId);
            showParameter.setCustomParam("cardShowTag", view.getFormShowParameter().getCustomParam("cardShowTag"));
            showParameter.setCustomParam("cardShowTagId", view.getFormShowParameter().getCustomParam("cardShowTagId"));
            this.getView().getPageCache().remove("currentOperationSubview");
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData != null) {
            switch (actionId) {
                case "epa_executescheme": 
                case "epa_executescheme_add": {
                    DynamicObjectCollection treeentryentity;
                    Optional<DynamicObject> entityWithId;
                    if (returnData instanceof Map) {
                        Integer success = (Integer)((Map)returnData).get("success");
                        String message = MessageFormat.format(ResManager.loadKDString((String)"\u6210\u529f\u65b0\u589e{0}\u4e2a\u8003\u6838\u6267\u884c\u8ba1\u5212\u3002", (String)"ExecuterSchemeViewPlugin_8", (String)"opmc-epa-formplugin", (Object[])new Object[0]), success + "");
                        this.getView().getParentView().showSuccessNotification(message);
                        this.setTipsContent();
                    }
                    String searchText = this.getView().getPageCache().get("searchText");
                    this.showEmptyOrHasData();
                    String isSameSettings = this.getView().getPageCache().get("isSameSettings");
                    if (returnData instanceof Long && "0".equals(isSameSettings) && (entityWithId = (treeentryentity = this.getView().getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection(TREEENTRYENTITY)).stream().filter(entry -> entry.getLong(EXECUTESCHEME_ID) == ((Long)returnData).longValue()).findFirst()).isPresent()) {
                        this.savePermissionSettings(entityWithId);
                        if ("1".equals(this.getView().getPageCache().get("isToPermission"))) {
                            this.showPermissionSetting(String.valueOf(returnData));
                        }
                    }
                    this.getView().getPageCache().remove("isToPermission");
                    this.getView().getPageCache().remove("isSameSettings");
                    this.getView().getPageCache().remove("updatePermissType");
                    this.getView().getParentView().invokeOperation("refresh");
                    this.getView().sendFormAction(this.getView().getParentView());
                    break;
                }
            }
        }
    }

    private void savePermissionSettings(Optional<DynamicObject> entityWithId) {
        DynamicPermissionConfigVO dynamicPermissionConfigVO = PresetPermissionUtils.setDynamicPermissionConfigVO((DynamicObject)entityWithId.get().getDynamicObject("executescheme"));
        HRPluginProxy proxy = new HRPluginProxy((Object)DYN_PERMISSION_EXT_PROCESS_SERVICE, IDynPermissionExtProcessService.class, "kd.opmc.epa.business.domain.activitymanage.extpoint.impl.DynPermissionExtProcessService#updatePermissionSetting", (PluginFilter)null);
        proxy.callReplaceIfPresent(p -> p.updatePermissionSetting(dynamicPermissionConfigVO));
        DynPermissionConfigService dynamicObjectCollection = new DynPermissionConfigService();
        dynamicObjectCollection.insertDynamicPermission(dynamicPermissionConfigVO);
    }

    private void showSettingPermissionPage(String executeschemeId) {
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("epa_processpermsetting");
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setPageId("epa_processpermsetting" + executeschemeId);
        baseShowParameter.setCustomParam("executeschemeId", (Object)executeschemeId);
        DynamicObject executescheme = EXECUTE_SCHEME_APPLICATION_SERVICE.queryOne("id,name,assessform,perfworkflow,perfworkflow.flowentry", Long.valueOf(executeschemeId));
        DynamicObject permissionObj = BusinessDataServiceHelper.loadSingle((String)"epa_processpermsetting", (String)"id", (QFilter[])new QFilter[]{new QFilter("excutescheme", "=", (Object)Long.valueOf(executeschemeId)).and(new QFilter("assessform", "=", (Object)executescheme.getLong("assessform.id"))).and(new QFilter("perfworkflow", "=", (Object)executescheme.getLong("perfworkflow.id")).and(new QFilter("iscurrentversion", "=", (Object)"1")))});
        if (permissionObj == null) {
            baseShowParameter.setStatus(OperationStatus.ADDNEW);
        } else {
            baseShowParameter.setPkId(permissionObj.getPkValue());
            baseShowParameter.setStatus(OperationStatus.EDIT);
            baseShowParameter.setBillStatus(BillOperationStatus.VIEW);
        }
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    private void setTipsContent() {
        Long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId");
        DynamicObject scheme = ASSESS_SCHEME_APPLICATION_SERVICE.queryOne("cycletype,cycletype.number,periodconfentity,periodconfentity.pcycletype,periodconfentity.pcycletype.name", schemeId);
        DynamicObjectCollection periodconfentity = scheme.getDynamicObjectCollection("periodconfentity");
        if (periodconfentity.size() == 0) {
            periodconfentity = new DynamicObjectCollection();
            DynamicObject periodconf = ASSESS_SCHEME_APPLICATION_SERVICE.generateEmptyEntryDynamicObject("periodconfentity");
            periodconf.set("pcycletype", scheme.get("cycletype"));
            periodconfentity.add((Object)periodconf);
        }
        int timeTagCount = 0;
        for (DynamicObject data : periodconfentity) {
            String cycle;
            switch (cycle = this.TAG_MAP.get(data.getString(PCYCLETYPE_NUMBER))) {
                case "Y": {
                    ++timeTagCount;
                    break;
                }
                case "H": {
                    timeTagCount += 2;
                    break;
                }
                case "Q": {
                    timeTagCount += 4;
                    break;
                }
                case "M": {
                    timeTagCount += 12;
                    break;
                }
            }
        }
        DynamicObject[] objectScopes = OBJECT_SCOPE_APPLICATION_SERVICE.queryListBySchemeId(schemeId);
        Object[] datas = EXECUTE_SCHEME_APPLICATION_SERVICE.queryListBySchemeId(schemeId, null);
        int allSize = timeTagCount * objectScopes.length;
        int initSize = 0;
        String message = "";
        if (!ObjectUtils.isEmpty((Object[])datas) && datas.length > 0) {
            boolean allDatas = datas.length >= allSize;
            initSize = datas.length;
            if (allDatas) {
                message = MessageFormat.format(ResManager.loadKDString((String)"\u660e\u7ec6\u8ba1\u5212\u5168\u90e8\u65b0\u589e\u5b8c\u6210 ({0}/{1})", (String)"ExecuterSchemeViewPlugin_10", (String)"opmc-epa-formplugin", (Object[])new Object[0]), initSize, allSize + "");
                this.getView().getParentView().setEnable(Boolean.FALSE, new String[]{"addbatch"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"add"});
                HashMap<String, String> bcstyle = new HashMap<String, String>(16);
                bcstyle.put("bc", "#DCFAE4");
                HashMap<String, String> fcstyle = new HashMap<String, String>(16);
                fcstyle.put("fc", "#cccccc");
                this.getView().getParentView().updateControlMetadata("flexpanelap41", bcstyle);
                this.getView().updateControlMetadata("add", fcstyle);
            } else {
                message = MessageFormat.format(ResManager.loadKDString((String)"\u660e\u7ec6\u8ba1\u5212\u5f85\u65b0\u589e ({0}/{1})", (String)"ExecuterSchemeViewPlugin_11", (String)"opmc-epa-formplugin", (Object[])new Object[0]), initSize, allSize + "");
                this.getView().getParentView().setEnable(Boolean.TRUE, new String[]{"addbatch"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"add"});
                HashMap<String, String> bcstyle = new HashMap<String, String>(16);
                bcstyle.put("bc", "#FFF1D4");
                this.getView().getParentView().updateControlMetadata("flexpanelap41", bcstyle);
            }
        } else {
            message = MessageFormat.format(ResManager.loadKDString((String)"\u660e\u7ec6\u8ba1\u5212\u5f85\u65b0\u589e ({0}/{1})", (String)"ExecuterSchemeViewPlugin_11", (String)"opmc-epa-formplugin", (Object[])new Object[0]), initSize, allSize + "");
        }
        Label resultLab = (Label)this.getView().getParentView().getControl("content");
        resultLab.setText(message);
        this.getView().getParentView().updateView("flexpanelap41");
        this.getView().getParentView().updateView("content");
        this.getView().updateView("advcontoolbarap");
        this.getView().updateView("add");
    }

    private void showPermissionSetting(String executeschemeId) {
        Long executeSchemeId = Long.valueOf(executeschemeId);
        DynamicObject executescheme = EXECUTE_SCHEME_APPLICATION_SERVICE.queryOne("id,name,assessform,perfworkflow,perfworkflow.flowentry,number", executeSchemeId);
        IFormView rightListView = this.getView().getView(executeschemeId);
        if (rightListView == null) {
            String operName = ResManager.loadKDString((String)"\u91cd\u590d\u8bbe\u7f6e", (String)"ExecuterSchemeViewPlugin_12", (String)"opmc-epa-formplugin", (Object[])new Object[0]);
            if (this.checkMutex(executeSchemeId, executescheme.getString("name"), operName)) {
                return;
            }
        }
        FormShowParameter baseShowParameter = new FormShowParameter();
        baseShowParameter.setFormId("epa_permissionsetting");
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setPageId("epa_permissionsetting" + executeschemeId);
        baseShowParameter.setCustomParam("executeschemeId", (Object)executeschemeId);
        DynamicObject[] permissionObj = BusinessDataServiceHelper.load((String)"epa_dynamicpermission", (String)"id", (QFilter[])new QFilter[]{new QFilter("excutescheme", "=", (Object)executeSchemeId).and(new QFilter("assessform", "=", (Object)executescheme.getLong("assessform.id"))).and(new QFilter("perfworkflow", "=", (Object)executescheme.getLong("perfworkflow.id"))).and(new QFilter("bindtype", "=", (Object)"1"))}, (String)"createtime desc");
        baseShowParameter.setCustomParam("BATCH_SETTING", (Object)false);
        baseShowParameter.setCustomParam("processpermsetting", (Object)permissionObj[0].getLong("id"));
        baseShowParameter.setCustomParam("locknumber", (Object)executescheme.getString("name"));
        long currUserId = RequestContext.get().getCurrUserId();
        boolean hasModfyPermission = PermissionServiceHelper.checkPermission((Long)currUserId, (String)"epa", (String)"epa_scheme", (String)"4715a0df000000ac");
        boolean hasViewPermission = PermissionServiceHelper.checkPermission((Long)currUserId, (String)"epa", (String)"epa_scheme", (String)"47150e89000000ac");
        if (hasModfyPermission) {
            baseShowParameter.setCustomParam("status", (Object)OperationStatus.EDIT.toString());
        } else if (hasViewPermission) {
            baseShowParameter.setCustomParam("status", (Object)OperationStatus.VIEW.toString());
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u8003\u6838\u8ba1\u5212\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ExecuterSchemeViewPlugin_13", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showForm(baseShowParameter);
    }

    private Map<String, String> requiredPermissionMutex(Long executeSchemeId, String executeSchemeName, String operName) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        result.put("result", "true");
        DataMutex dataMutex = DataMutex.create();
        String lockId = executeSchemeId + "";
        Map lockInfo = dataMutex.getLockInfo(lockId, "permission_netctrl", "epa_permissionsetting");
        if (lockInfo != null && lockInfo.size() > 0) {
            result.put("result", "false");
            result.put("errmsg", ResManager.loadKDString((String)"\u8003\u6838\u6267\u884c\u8ba1\u5212-{0}\u6b63\u5728\u8fdb\u884c\u6743\u9650\u8bbe\u7f6e\uff0c\u8bf7\u52ff{1}!", (String)"ExecuterSchemeViewPlugin_14", (String)"opmc-epa-formplugin", (Object[])new Object[]{executeSchemeName, operName}));
        }
        return result;
    }

    private boolean checkMutex(long executeSchemeId, String executeSchemeName, String operName) {
        Map<String, String> lockResult = this.requiredPermissionMutex(executeSchemeId, executeSchemeName, operName);
        if (!"true".equals(lockResult.get("result"))) {
            this.getView().showErrorNotification(lockResult.get("errmsg"));
            return true;
        }
        return false;
    }
}

