/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.scheme;

import com.google.common.collect.ImmutableBiMap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssessSchemeApplicationService;
import kd.opmc.epa.business.domain.scheme.entity.MpRuleSetEntryVO;
import kd.opmc.epa.business.domain.scheme.entity.MpRuleSetVO;
import kd.opmc.epa.formplugin.web.utils.MpRuleUtils;

public class MpRuleSetEditPlugin
extends HRDataBaseEdit {
    private static final AssessSchemeApplicationService ASSESS_SCHEME_APPLICATION_SERVICE = AssessSchemeApplicationService.getInstance();
    private final AssessActivityApplicationService service = AssessActivityApplicationService.getInstance();
    private static final String DEAL_RULE = "erdealrule";
    private static final String WEIGHTSET = "weightset";
    private static final String MP_FORMULA = "mpformula";
    private static final String PCYCLETYPE_NUMBER = "pcycletype.number";
    private static final String RADIO_1 = "textfield";
    private static final String RADIO_2 = "textfield1";
    private static final String RADIO_3 = "textfield2";
    private static final List<String> RADIOS = Arrays.asList("dealrule", "weightset", "mpformula", "erdealrule");
    public static final String BTNOK = "btnok";
    private static final String ER_DEALRULE = "erdealrule";
    private final Map<String, String> TAG_MAP = ImmutableBiMap.builder().put((Object)"1010_S", (Object)"Y").put((Object)"1020_S", (Object)"H").put((Object)"1030_S", (Object)"Q").put((Object)"1040_S", (Object)"M").build();
    private static final List<String> TIME_TAG_ALL = Arrays.asList("M1", "M2", "M3", "Q1", "M4", "M5", "M6", "Q2", "H1", "M7", "M8", "M9", "Q3", "M10", "M11", "M12", "Q4", "H2", "Y");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "weightset": {
                boolean visible = Integer.parseInt((String)this.getModel().getValue(WEIGHTSET)) == 2;
                this.getView().setVisible(Boolean.valueOf(visible), new String[]{"flexpanelap3"});
                this.refleshFurmula();
                this.getView().updateView("flexpanelap3");
                break;
            }
        }
        if (!RADIOS.contains(name) && !name.contains("weight")) {
            boolean visible = (Boolean)this.getModel().getValue(name);
            String key = name + "weight";
            this.getModel().setValue(key, (Object)0);
            this.getView().setVisible(Boolean.valueOf(visible), new String[]{key});
            this.getView().setVisible(Boolean.valueOf(visible), new String[]{"labelap" + name});
            this.refleshFurmula();
            this.getView().updateView(key);
        }
        if (name.contains("weight")) {
            this.refleshFurmula();
        }
    }

    private void refleshFurmula() {
        MpRuleSetVO ppRuleSetVO = this.getRuleSetVO();
        this.getModel().setValue(MP_FORMULA, (Object)ppRuleSetVO.getMpformula());
        this.getView().updateView(MP_FORMULA);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        MpRuleSetVO ppRuleSetVO = this.getMpRuleSetVOFromScheme();
        this.getModel().setValue(WEIGHTSET, (Object)ppRuleSetVO.getMpmode());
        this.getModel().setValue("erdealrule", (Object)ppRuleSetVO.getErdealrule());
        this.getModel().setValue(MP_FORMULA, (Object)ppRuleSetVO.getMpformula());
        this.getModel().setValue("erdealrule", (Object)ppRuleSetVO.getErdealrule());
        boolean visible = Integer.parseInt((String)this.getModel().getValue(WEIGHTSET)) == 2;
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"flexpanelap3"});
        List entryentities = ppRuleSetVO.getEntryentities();
        ArrayList<String> showTags = new ArrayList<String>(10);
        ArrayList<String> visibleshowTags = new ArrayList<String>(10);
        for (MpRuleSetEntryVO vo : entryentities) {
            this.getModel().setValue(vo.getTimetag().toLowerCase(Locale.ROOT), (Object)true);
            this.getModel().setValue(vo.getTimetag().toLowerCase(Locale.ROOT) + "weight", (Object)vo.getWeight());
            showTags.add(vo.getTimetag());
            visibleshowTags.add(vo.getTimetag());
        }
        DynamicObjectCollection periodconfentity = this.getPeriodDynamicObjects();
        for (DynamicObject entryentity : periodconfentity) {
            String tag = entryentity.getString(PCYCLETYPE_NUMBER);
            String timeTag = this.TAG_MAP.get(tag);
            showTags.addAll(TIME_TAG_ALL.stream().filter(v -> v.contains(timeTag)).collect(Collectors.toList()));
        }
        for (String timeTag : TIME_TAG_ALL) {
            this.getView().setVisible(Boolean.valueOf(showTags.contains(timeTag)), new String[]{timeTag.toLowerCase(Locale.ROOT) + "flexpanelap"});
            this.getView().setVisible(Boolean.valueOf(visibleshowTags.contains(timeTag)), new String[]{timeTag.toLowerCase(Locale.ROOT) + "weight"});
            this.getView().setVisible(Boolean.valueOf(visibleshowTags.contains(timeTag)), new String[]{"labelap" + timeTag.toLowerCase(Locale.ROOT)});
        }
        this.getView().updateView(WEIGHTSET);
        this.getView().updateView(MP_FORMULA);
        this.getView().updateView("erdealrule");
        this.getView().updateView("flexpanelap3");
        this.initTips();
    }

    private void initTips() {
        this.setTips(RADIO_1);
        this.setTips(RADIO_2);
        this.setTips(RADIO_3);
    }

    private void setTips(String key) {
        DynamicObject dy = this.getModel().getDataEntity();
        String tipContent = this.service.getTips("epa_mpruleset", key, dy);
        if (StringUtils.isNotBlank((CharSequence)tipContent)) {
            HashMap<String, Tips> props = new HashMap<String, Tips>(16);
            Tips tips = new Tips();
            tips.setType("text");
            tips.setContent(new LocaleString(tipContent));
            tips.setTriggerType("hover");
            tips.setPlace("right");
            props.put("tips", tips);
            this.getView().updateControlMetadata(key, props);
        }
    }

    private DynamicObjectCollection getPeriodDynamicObjects() {
        Long schemeId = 0L;
        if (this.getView().getFormShowParameter().getCustomParam("scheme") instanceof Long) {
            schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("scheme");
        }
        DynamicObject schemeDyn = null;
        DynamicObjectCollection periodconfentity = new DynamicObjectCollection();
        if ("epa_scheme".equals(this.getView().getParentView().getModel().getDataEntityType().getName())) {
            schemeDyn = this.getView().getParentView().getModel().getDataEntity();
            periodconfentity = this.getView().getParentView().getModel().getEntryEntity("periodconfentity");
        } else {
            schemeDyn = this.getSchemeDyn(schemeId);
            periodconfentity = schemeDyn.getDynamicObjectCollection("periodconfentity");
        }
        if (periodconfentity.size() == 0) {
            periodconfentity = new DynamicObjectCollection();
            DynamicObject periodconf = ASSESS_SCHEME_APPLICATION_SERVICE.generateEmptyEntryDynamicObject("periodconfentity");
            periodconf.set("pcycletype", schemeDyn.get("cycletype"));
            periodconfentity.add((Object)periodconf);
        }
        return periodconfentity;
    }

    private MpRuleSetVO getMpRuleSetVOFromScheme() {
        MpRuleSetVO mpRuleSetVO = new MpRuleSetVO();
        ArrayList<MpRuleSetEntryVO> entryentities = new ArrayList<MpRuleSetEntryVO>(10);
        if (!StringUtils.isEmpty((CharSequence)((CharSequence)this.getView().getFormShowParameter().getCustomParam("tempvo")))) {
            mpRuleSetVO = (MpRuleSetVO)SerializationUtils.fromJsonString((String)((String)this.getView().getFormShowParameter().getCustomParam("tempvo")), MpRuleSetVO.class);
            return mpRuleSetVO;
        }
        Long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("scheme");
        DynamicObject schemeDyn = null;
        if (schemeId == 0L) {
            if ("epa_scheme".equals(this.getView().getParentView().getModel().getDataEntityType().getName())) {
                schemeDyn = this.getView().getParentView().getModel().getDataEntity();
            }
        } else {
            schemeDyn = this.getSchemeDyn(schemeId);
        }
        if (schemeDyn != null) {
            if (schemeDyn.getDynamicObject("mprule") == null) {
                MpRuleUtils.buildMpRuleFromScheme(mpRuleSetVO, entryentities, schemeDyn);
            } else {
                MpRuleUtils.buildVoByMpRule(schemeDyn.getDynamicObject("mprule"), mpRuleSetVO, entryentities);
            }
            mpRuleSetVO.setEntryentities(entryentities);
        }
        return mpRuleSetVO;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (HRStringUtils.equalsIgnoreCase((String)BTNOK, (String)source.getKey())) {
            this.buildReturnVO();
        }
    }

    private void buildReturnVO() {
        MpRuleSetVO mpRuleSetVO = this.getRuleSetVO();
        if (this.valideVOWeight(mpRuleSetVO)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6743\u91cd\u4e4b\u548c\u987b=100", (String)"MpRuleSetEditPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().returnDataToParent((Object)mpRuleSetVO);
        this.getView().close();
    }

    private boolean valideVOWeight(MpRuleSetVO mpRuleSetVO) {
        boolean result = false;
        if (mpRuleSetVO.getMpmode() == 1) {
            return result;
        }
        List entryentities = mpRuleSetVO.getEntryentities();
        BigDecimal total = new BigDecimal("0");
        BigDecimal validWeight = new BigDecimal("100");
        for (MpRuleSetEntryVO vo : entryentities) {
            total = total.add(vo.getWeight());
        }
        return validWeight.compareTo(total) != 0;
    }

    private MpRuleSetVO getRuleSetVO() {
        MpRuleSetVO mpRuleSetVO = new MpRuleSetVO();
        ArrayList<MpRuleSetEntryVO> entryentities = new ArrayList<MpRuleSetEntryVO>(10);
        mpRuleSetVO.setMpmode(Integer.parseInt((String)this.getModel().getValue(WEIGHTSET)));
        mpRuleSetVO.setErdealrule(Integer.parseInt((String)this.getModel().getValue("erdealrule")));
        if (mpRuleSetVO.getMpmode() == 2) {
            for (String tag : TIME_TAG_ALL) {
                MpRuleSetEntryVO vo = new MpRuleSetEntryVO();
                if (!((Boolean)this.getModel().getValue(tag)).booleanValue()) continue;
                vo.setTimetag(tag.toUpperCase(Locale.ROOT));
                vo.setTimetag(tag);
                entryentities.add(vo);
                if (this.getModel().getValue(tag.toLowerCase(Locale.ROOT) + "weight") == null) continue;
                vo.setWeight((BigDecimal)this.getModel().getValue(tag.toLowerCase(Locale.ROOT) + "weight"));
            }
        } else {
            MpRuleUtils.buildEntryVO(entryentities, this.getPeriodDynamicObjects());
        }
        mpRuleSetVO.setEntryentities(entryentities);
        return mpRuleSetVO;
    }

    private DynamicObject getSchemeDyn(Long schemeId) {
        return ASSESS_SCHEME_APPLICATION_SERVICE.queryOne("mprule,mprule.entryentity,cycletype,cycletype.number,periodconfentity,periodconfentity.pcycletype,periodconfentity.pcycletype.name", schemeId);
    }
}

