/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.scheme;

import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.basedataref.BaseDataRefenceKey;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.scheme.AssessGroupApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssessSchemeApplicationService;
import kd.opmc.epa.business.application.service.scheme.ObjectScopeApplicationService;
import kd.opmc.epa.common.constants.ObjectScopeConstants;
import kd.opmc.epa.formplugin.web.utils.SchemeStatusValidateUtils;

public class ObjectScopeCardEditPlugin
extends AbstractFormPlugin
implements ObjectScopeConstants {
    private static final ObjectScopeApplicationService OBJECT_SCOPE_APPLICATION_SERVICE = ObjectScopeApplicationService.getInstance();
    private static final AssessGroupApplicationService ASSESS_GROUP_APPLICATION_SERVICE = AssessGroupApplicationService.getInstance();
    private static final AssessSchemeApplicationService ASSESS_SCHEME_APPLICATION_SERVICE = AssessSchemeApplicationService.getInstance();

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        this.initCardList(pkValue);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        SchemeStatusValidateUtils.checkSchemeStatusValidate(args, this.getView());
        if (args.isCancel()) {
            return;
        }
        switch (key) {
            case "deleteentry": {
                this.deleteGroupEntry(args);
                break;
            }
            case "setdefault": {
                Long schemePkId = this.getSchemeIdByParam();
                DynamicObject group = this.getSelectAssessGroup();
                ASSESS_GROUP_APPLICATION_SERVICE.changeDefaultGroup(Long.valueOf(group.getLong("id")), schemePkId);
                this.getModel().setDataChanged(false);
                this.getView().returnDataToParent((Object)"setdefault");
                this.getView().close();
                break;
            }
            case "deletescope": {
                String systemInvoke = op.getOption().getVariableValue("systeminvoke", "false");
                if (HRStringUtils.equals((String)systemInvoke, (String)"true")) break;
                this.checkBeforeDelete(args);
                args.setCancel(true);
                break;
            }
        }
    }

    private void checkBeforeDelete(BeforeDoOperationEventArgs args) {
        Long schemeId = this.getSchemeIdByParam();
        int count = OBJECT_SCOPE_APPLICATION_SERVICE.queryCountBySchemeId(schemeId);
        if (count == 1) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u4fdd\u7559\u4e00\u4e2a\u8bc4\u4f30\u5bf9\u8c61\u8303\u56f4\u3002", (String)"ObjectScopeCardEditPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection groups = this.getModel().getEntryEntity("groupcard");
        boolean haveDefault = groups.stream().anyMatch(obj -> obj.getDynamicObject("assessgroup").getBoolean("isdefault"));
        if (haveDefault) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u5176\u4ed6\u8003\u6838\u7ec4\u4e3a\u9ed8\u8ba4\u8003\u6838\u7ec4\uff0c\u518d\u6267\u884c\u5220\u9664\u3002", (String)"ObjectScopeCardEditPlugin_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject scope = this.getModel().getDataEntity();
        BasedataEntityType entityType = (BasedataEntityType)scope.getDataEntityType();
        BaseDataCheckRefrence checker = new BaseDataCheckRefrence();
        checker.setDraftValidReference(true);
        List allRefs = checker.getAllRefs(entityType, (Object)scope.getLong("id"));
        BaseDataRefenceKey refKey = allRefs.stream().filter(ref -> !ref.getRefEntityKey().equals("epa_assessgroup")).findFirst().orElse(null);
        if (ObjectUtils.isEmpty((Object)refKey)) {
            if (groups.size() > 0) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u8bc4\u4f30\u5bf9\u8c61\u8303\u56f4\u65f6\u8003\u6838\u7ec4\u5c06\u4e00\u5e76\u5220\u9664\uff0c\u786e\u5b9a\u5220\u9664\uff1f", (String)"ObjectScopeCardEditPlugin_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("epa_objectscope_card", (IFormPlugin)this));
            } else {
                this.getView().invokeOperation("delete");
            }
        } else {
            MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)refKey.getRefEntityKey());
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c{0}\u201d\u5b57\u6bb5\u7684\u201c\u8bc4\u4f30\u5bf9\u8c61\u8303\u56f4\u201d\u5f15\u7528\u4e86\u6b64\u6570\u636e\uff0c\u4e0d\u652f\u6301\u5220\u9664\u3002", (String)"ObjectScopeCardEditPlugin_3", (String)"opmc-epa-formplugin", (Object[])new Object[]{refMainType.getDisplayName()}));
        }
    }

    private void deleteGroupEntry(BeforeDoOperationEventArgs args) {
        OperateOption option;
        Long scopeId;
        DynamicObject assessGroup = this.getSelectAssessGroup();
        boolean isDefault = assessGroup.getBoolean("isdefault");
        if (isDefault) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9ed8\u8ba4\u8003\u6838\u7ec4\u4e0d\u53ef\u5220\u9664\u3002", (String)"ObjectScopeCardEditPlugin_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        Long id = assessGroup.getLong("id");
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "!=", (Object)id), new QFilter("objectscope", "=", (Object)(scopeId = (Long)this.getModel().getDataEntity().getPkValue()))};
        int count = ASSESS_GROUP_APPLICATION_SERVICE.count(qFilters);
        if (count == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u81f3\u5c11\u4fdd\u7559\u4e00\u4e2a\u201c\u8003\u6838\u7ec4\u201d\u3002", (String)"ObjectScopeCardEditPlugin_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        DynamicObject group = ASSESS_GROUP_APPLICATION_SERVICE.queryById(id);
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)"epa_assessgroup", (DynamicObject[])new DynamicObject[]{group}, (OperateOption)(option = OperateOption.create()));
        if (operationResult.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"ObjectScopeCardEditPlugin_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
        } else {
            String message = operationResult.getMessage();
            List validateErrors = operationResult.getValidateResult().getValidateErrors();
            if (!ObjectUtils.isEmpty((Object)validateErrors)) {
                List allErrorInfo = ((ValidateResult)validateErrors.get(0)).getAllErrorInfo();
                message = ObjectUtils.isEmpty((Object)allErrorInfo) ? message : ((OperateErrorInfo)allErrorInfo.get(0)).getMessage();
            }
            this.getView().showTipNotification(message);
            args.setCancel(true);
        }
    }

    private Long getSchemeIdByParam() {
        Object schemeIdObj = this.getView().getFormShowParameter().getCustomParam("schemeId");
        return schemeIdObj != null ? Long.valueOf(Long.parseLong(String.valueOf(schemeIdObj))) : null;
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String actionId = event.getCallBackId();
        if ("epa_objectscope_card".contains(actionId) && event.getResult() == MessageBoxResult.Yes) {
            Long scopeId = (Long)this.getModel().getDataEntity().getPkValue();
            DynamicObject[] objects = ASSESS_GROUP_APPLICATION_SERVICE.queryListByScopeId(false, scopeId);
            BasedataEntityType entityType = (BasedataEntityType)objects[0].getDataEntityType();
            BaseDataCheckRefrence checker = new BaseDataCheckRefrence();
            checker.setDraftValidReference(true);
            String message = null;
            for (DynamicObject dy : objects) {
                long id = dy.getLong("id");
                BaseDataCheckRefrenceResult checkResult = checker.checkRef(entityType, (Object)id);
                if (!checkResult.isRefence()) continue;
                MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)checkResult.getRefenceKey().getRefEntityKey());
                String ref = String.valueOf(refMainType.getDisplayName());
                message = ResManager.loadKDString((String)"\u201c{0}\u201d\u5b57\u6bb5\u7684\u201c\u8003\u6838\u7ec4\u201d\u5f15\u7528\u4e86\u6b64\u6570\u636e\uff1a{1}\uff0c\u4e0d\u652f\u6301\u5220\u9664\u3002", (String)"ObjectScopeCardEditPlugin_7", (String)"opmc-epa-formplugin", (Object[])new Object[]{ref, dy.getString("name")});
                break;
            }
            if (ObjectUtils.isEmpty(message)) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("systeminvoke", "true");
                option.setVariableValue("OP_SOURCE", "formulate");
                this.getView().invokeOperation("deletescope", option);
                OBJECT_SCOPE_APPLICATION_SERVICE.deleteById(scopeId);
                ASSESS_GROUP_APPLICATION_SERVICE.deleteByScopeId(scopeId);
                this.getModel().setDataChanged(false);
                this.getView().returnDataToParent((Object)"deletescope");
                this.getView().close();
            } else {
                this.getView().showTipNotification(message);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        super.afterDoOperation(args);
        switch (key = args.getOperateKey()) {
            case "addgroup": {
                this.openShowForm("epa_assessgroup", OperationStatus.ADDNEW);
                break;
            }
            case "groupedit": {
                this.openShowForm("epa_assessgroup", OperationStatus.EDIT);
                break;
            }
            case "scopeedit": {
                this.openShowForm("epa_objectscope", OperationStatus.EDIT);
                break;
            }
            case "delete": {
                this.getView().returnDataToParent((Object)"deletescope");
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData != null) {
            switch (actionId) {
                case "addgroup": {
                    Long id = (Long)returnData;
                    List<Long> list = Collections.singletonList(id);
                    this.addGroupCard(list);
                    break;
                }
                case "groupedit": {
                    this.getView().updateView("groupcard");
                    break;
                }
                case "scopeedit": {
                    this.getView().invokeOperation("refresh");
                    this.getView().updateView("epa_objectscope_card");
                    break;
                }
            }
        }
    }

    private DynamicObject getSelectAssessGroup() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("groupcard");
        int[] rows = entryGrid.getSelectRows();
        return this.getModel().getEntryRowEntity("groupcard", rows[0]).getDynamicObject("assessgroup");
    }

    private void initCardList(Long scopeId) {
        DynamicObject[] cols = ASSESS_GROUP_APPLICATION_SERVICE.queryListByScopeId(true, scopeId);
        List<Long> ids = Arrays.stream(cols).map(obj -> obj.getLong("id")).collect(Collectors.toList());
        this.addGroupCard(ids);
    }

    private void openShowForm(String formId, OperationStatus status) {
        Long scopeId = (Long)this.getModel().getDataEntity().getPkValue();
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId(formId);
        showParameter.setStatus(status);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        if ("epa_assessgroup".equals(formId)) {
            Long schemeId = this.getSchemeIdByParam();
            showParameter.setCustomParam("schemeId", (Object)schemeId);
            showParameter.setCustomParam("scopeId", (Object)scopeId);
            if (status == OperationStatus.ADDNEW) {
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addgroup"));
            } else {
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "groupedit"));
                DynamicObject group = this.getSelectAssessGroup();
                showParameter.setPkId((Object)group.getLong("id"));
            }
        }
        if ("epa_objectscope".equals(formId)) {
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "scopeedit"));
            showParameter.setPkId((Object)scopeId);
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void addGroupCard(List<Long> ids) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("assessgroup", new Object[0]);
        for (Long id : ids) {
            setter.addRow(new Object[]{id});
        }
        model.batchCreateNewEntryRow("groupcard", setter);
        model.endInit();
        this.getView().updateView("groupcard");
    }
}

