/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.scheme;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.scheme.AssessSchemeApplicationService;
import kd.opmc.epa.business.application.service.scheme.ObjectScopeApplicationService;
import kd.opmc.epa.common.constants.ObjectScopeConstants;
import kd.opmc.epa.formplugin.web.utils.SchemeStatusValidateUtils;

public class ObjectScopeDynamicPlugin
extends AbstractFormPlugin
implements ObjectScopeConstants {
    private static final ObjectScopeApplicationService OBJECT_SCOPE_APPLICATION_SERVICE = ObjectScopeApplicationService.getInstance();
    private static final AssessSchemeApplicationService ASSESS_SCHEME_APPLICATION_SERVICE = AssessSchemeApplicationService.getInstance();
    private static final String[] TAB_AP_ARRAY = new String[]{"objscopeap", "joinap", "notjoinap"};

    public void initialize() {
        super.initialize();
        this.addClickListeners(TAB_AP_ARRAY);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initData(true);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        boolean isTabSelect = Arrays.stream(TAB_AP_ARRAY).anyMatch(tabAp -> tabAp.equals(source.getKey()));
        if (!isTabSelect) {
            return;
        }
        for (String tabAp2 : TAB_AP_ARRAY) {
            boolean isSelected = HRStringUtils.equals((String)tabAp2, (String)source.getKey());
            HashMap<String, String> tabApMap = new HashMap<String, String>(16);
            tabApMap.put("bc", isSelected ? "themeColor|10" : "");
            tabApMap.put("fc", isSelected ? "themeColor" : "");
            this.getView().updateControlMetadata(tabAp2, tabApMap);
        }
        Tab dataTab = (Tab)this.getControl("datatabap");
        dataTab.activeTab(source.getKey().substring(0, source.getKey().length() - 2) + "tab");
    }

    private void initData(boolean ref) {
        Long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId");
        Object[] dys = OBJECT_SCOPE_APPLICATION_SERVICE.queryListBySchemeId(schemeId);
        if (ObjectUtils.isEmpty((Object[])dys)) {
            return;
        }
        List<Long> ids = Arrays.stream(dys).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        this.addScopeCardPanel(ids, ref);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        SchemeStatusValidateUtils.checkSchemeStatusValidate(args, this.getView());
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("addscope".equals(args.getOperateKey())) {
            this.addShowForm("epa_objectscope", null, OperationStatus.ADDNEW, ShowType.Modal, null);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData != null && "epa_objectscope".equals(actionId)) {
            String data;
            switch (data = String.valueOf(returnData)) {
                case "setdefault": {
                    this.initData(false);
                    break;
                }
                case "deletescope": {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"ObjectScopeDynamicPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    break;
                }
                default: {
                    Long id = (Long)returnData;
                    List<Long> list = Collections.singletonList(id);
                    this.addScopeCardPanel(list, true);
                }
            }
        }
    }

    private void addScopeCardPanel(List<Long> ids, boolean ref) {
        Container contentap = (Container)this.getControl("objscopepanel");
        ArrayList<Map> controls = new ArrayList<Map>(10);
        for (long id : ids) {
            FlexPanelAp cardAp = new HRFlexPanelAp.Builder("cardap" + id).setShrink(1).build();
            Map control = cardAp.createControl();
            controls.add(control);
            this.addShowForm("epa_objectscope_card", id, OperationStatus.VIEW, ShowType.InContainer, cardAp.getKey());
        }
        if (ref) {
            contentap.addControls(controls);
        }
    }

    private void addShowForm(String FormId, Long pkId, OperationStatus status, ShowType showType, String targetKey) {
        Long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId");
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId(FormId);
        showParameter.setPkId((Object)pkId);
        showParameter.setStatus(status);
        showParameter.getOpenStyle().setShowType(showType);
        showParameter.getOpenStyle().setTargetKey(targetKey);
        showParameter.setCustomParam("schemeId", (Object)schemeId);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epa_objectscope"));
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

