/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.scheme;

import com.alibaba.fastjson.JSON;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssessObjectApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssessSchemeApplicationService;
import kd.opmc.epa.business.application.service.scheme.ExecuteSchemeApplicationService;
import kd.opmc.epa.business.domain.mp.entityservice.MpRuleEntityService;
import kd.opmc.epa.business.domain.scheme.entity.MpRuleSetEntryVO;
import kd.opmc.epa.business.domain.scheme.entity.MpRuleSetVO;
import kd.opmc.epa.business.domain.scheme.enums.CycleTypeFilterEnum;
import kd.opmc.epa.business.domain.timetag.enums.TimeStampEnums;
import kd.opmc.epa.formplugin.web.utils.MpRuleUtils;
import kd.opmc.epa.formplugin.web.utils.SchemeStatusValidateUtils;
import kd.opmc.epa.formplugin.web.utils.permission.AssessSchemePermissionUtils;
import kd.opmc.pbs.business.application.service.PerfParamConfigApplicationService;
import kd.opmc.pbs.business.domain.timetag.entityservice.TimeTagEntityService;

public class SchemeBaseInfoEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener,
AfterF7SelectListener,
ItemClickListener {
    private static final Log LOGGER = LogFactory.getLog(SchemeBaseInfoEdit.class);
    private static final AssessSchemeApplicationService SCHEME_APPLICATION_SERVICE = AssessSchemeApplicationService.getInstance();
    private static final ExecuteSchemeApplicationService EXECUTE_SCHEME_APPLICATION_SERVICE = ExecuteSchemeApplicationService.getInstance();
    private static final AssessObjectApplicationService ASSESS_OBJECT_APPLICATION_SERVICE = AssessObjectApplicationService.getInstance();
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final TimeTagEntityService TIME_TAG_ENTITY_SERVICE = TimeTagEntityService.getInstance();
    private static final MpRuleEntityService MP_RULE_ENTITY_SERVICE = MpRuleEntityService.getInstance();
    private static final PerfParamConfigApplicationService PERF_PARAM_CONFIG_APPLICATION_SERVICE = PerfParamConfigApplicationService.getInstance();
    private static final String[] CYCLE_INFO = new String[5];
    private static final String PRO_NOT_CHANGE = "PRO_NOT_CHANGE";
    private static final String DELETE_ORG_ENTRY = "deleteorgentry";
    private static final String DELETE_PERIOD_CONF_LAB = "deleteperiodconflab";
    private static final String CYCLE_TYPE_F_7 = "cycletypef7";
    private static final String P_CYCLE_SCHEME = "pcyclescheme";
    private static final String ORG_F_7 = "orgf7";
    private static final String ADMIN_ORG = "adminorg";
    private static final Long CYCLE_MONTH = 1363180276724933632L;
    public static final Long CYCLE_YEAR = 1363179570613844992L;
    private static final String IS_NEEDMPGENWAY = "isneedmpgenway";
    private static final String MP_GENWAY = "mpgenway";
    private static final String MP_RULE = "mp_rule";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        if (!e.getFormShowParameter().getStatus().equals((Object)OperationStatus.ADDNEW)) {
            e.getFormShowParameter().setStatus(OperationStatus.EDIT);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        if ("bar_save".equals(evt.getItemKey())) {
            if (!this.validateTimeTag()) {
                evt.setCancel(true);
                return;
            }
            DynamicObjectCollection orgEntity = this.getModel().getEntryEntity("orgentryentity");
            if (CollectionUtils.isEmpty((Collection)orgEntity)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9002\u7528\u7ec4\u7ec7\u81f3\u5c11\u4fdd\u7559\u4e00\u6761\u3002", (String)"SchemeBaseInfoEdit_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    private void setMpRuleDefault() {
        DynamicObject cycleType = this.getModel().getDataEntity().getDynamicObject("cycletype");
        if (cycleType == null) {
            return;
        }
        if (this.getModel().getDataEntity().getBoolean(IS_NEEDMPGENWAY)) {
            DynamicObject[] timeTags;
            MpRuleSetVO mpRuleSetVO = null;
            if (!StringUtils.isEmpty((CharSequence)this.getView().getPageCache().get("tempvo"))) {
                mpRuleSetVO = (MpRuleSetVO)JSON.parseObject((String)this.getView().getPageCache().get("tempvo"), MpRuleSetVO.class);
            }
            if (mpRuleSetVO == null) {
                mpRuleSetVO = new MpRuleSetVO();
                ArrayList<MpRuleSetEntryVO> entryentities = new ArrayList<MpRuleSetEntryVO>(10);
                mpRuleSetVO.setEntryentities(entryentities);
                MpRuleUtils.buildMpRuleFromScheme(mpRuleSetVO, entryentities, (AbstractFormDataModel)this.getModel());
            }
            if (CYCLE_YEAR.longValue() == cycleType.getLong("id") && !((Boolean)this.getModel().getValue("isperiodassess")).booleanValue()) {
                this.getModel().setValue(IS_NEEDMPGENWAY, (Object)false);
                this.getModel().setValue("mprule", null);
            } else if (CYCLE_YEAR.longValue() == cycleType.getLong("id") && ((Boolean)this.getModel().getValue("isperiodassess")).booleanValue()) {
                this.getModel().setValue("mpsopcategory", (Object)"Y");
                timeTags = TIME_TAG_ENTITY_SERVICE.queryListByCycleType(Long.valueOf(cycleType.getLong("ID")));
                this.getModel().setValue("mpsoptimetag", (Object)timeTags[timeTags.length - 1]);
                this.getModel().setValue("isgenextmpsop", (Object)false);
                DynamicObject rule = MP_RULE_ENTITY_SERVICE.saveByVo(mpRuleSetVO, Long.valueOf(this.getModel().getValue("mprule") == null ? 0L : ((DynamicObject)this.getModel().getValue("mprule")).getLong("id")));
                this.getModel().setValue("mprule", (Object)rule);
            } else {
                this.getModel().setValue("isgenextmpsop", (Object)true);
                this.getModel().setValue("mpsopcategory", (Object)"Y");
                timeTags = TIME_TAG_ENTITY_SERVICE.queryListByCycleType(Long.valueOf(cycleType.getLong("ID")));
                this.getModel().setValue("mpsoptimetag", (Object)timeTags[timeTags.length - 1]);
                DynamicObject rule = MP_RULE_ENTITY_SERVICE.saveByVo(mpRuleSetVO, Long.valueOf(this.getModel().getValue("mprule") == null ? 0L : ((DynamicObject)this.getModel().getValue("mprule")).getLong("id")));
                this.getModel().setValue("mprule", (Object)rule);
            }
        } else {
            this.getModel().setValue("isgenextmpsop", (Object)false);
            this.getModel().setValue("mpsopcategory", (Object)" ");
            this.getModel().setValue("mpsoptimetag", null);
            this.getModel().setValue("mprule", null);
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl("cyclescheme");
        BasedataEdit assessOrgF7 = (BasedataEdit)this.getView().getControl("orgbasedata");
        BasedataEdit startTime = (BasedataEdit)this.getView().getControl("starttimetag");
        BasedataEdit endTime = (BasedataEdit)this.getView().getControl("endtimetag");
        BasedataEdit adminOrg = (BasedataEdit)this.getView().getControl(ADMIN_ORG);
        startTime.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        endTime.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        assessOrgF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit cycleTypeF7 = (BasedataEdit)this.getView().getControl(CYCLE_TYPE_F_7);
        cycleTypeF7.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit pCycleSchemeEdit = (BasedataEdit)this.getView().getControl(P_CYCLE_SCHEME);
        pCycleSchemeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit orgF7 = (BasedataEdit)this.getView().getControl(ORG_F_7);
        orgF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        orgF7.addAfterF7SelectListener((AfterF7SelectListener)this);
        adminOrg.addAfterF7SelectListener((AfterF7SelectListener)this);
    }

    private QFilter buildFilter() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject cycleType = dataEntity.getDynamicObject("cycletype");
        if (HRObjectUtils.isEmpty((Object)cycleType)) {
            return null;
        }
        return new QFilter("cycletype", "=", (Object)cycleType.getLong("id"));
    }

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        if (this.getModel().getValue("createOrg") == null) {
            String createOrgId = Long.toString(RequestContext.getOrCreate().getOrgId());
            this.getModel().setValue("createOrg", (Object)createOrgId);
        }
        this.setCycleInfoEnableByCycleType();
        if (!PERF_PARAM_CONFIG_APPLICATION_SERVICE.isOpenPerfSum()) {
            this.getModel().setValue(IS_NEEDMPGENWAY, (Object)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void propertyChanged(PropertyChangedArgs changedArgs) {
        super.propertyChanged(changedArgs);
        try {
            String fieldKey;
            switch (fieldKey = changedArgs.getProperty().getName()) {
                case "cycletype": {
                    this.changeCycleType(changedArgs);
                    return;
                }
                case "isperiodassess": {
                    if (this.notChangeYearNTag(fieldKey, changedArgs)) {
                        return;
                    }
                    this.processPeriodConf();
                    return;
                }
                case "endyear": 
                case "startyear": {
                    if (this.notChangeYearNTag(fieldKey, changedArgs)) {
                        return;
                    }
                    if (ObjectUtils.isEmpty((Object)changedArgs.getChangeSet()[0].getNewValue())) return;
                    this.setTimeControl();
                    return;
                }
                case "pcyclescheme": {
                    if (this.notChangeYearNTag(fieldKey, changedArgs)) {
                        return;
                    }
                    if (this.getPeriodConfSelectRow() != 0) return;
                    this.getModel().setValue("cyclescheme", this.getModel().getValue(P_CYCLE_SCHEME, this.getPeriodConfSelectRow()));
                    return;
                }
                case "iscontainlower": {
                    this.setDefaultValidateOrg(changedArgs);
                    return;
                }
                case "isneedmpgenway": 
                case "mpgenway": {
                    if (changedArgs.getChangeSet()[0].getNewValue() != null && !"".equals(changedArgs.getChangeSet()[0].getNewValue())) {
                        this.setMpRuleVisible();
                        if (this.getModel().getValue("mprule") != null) return;
                        this.getModel().setValue("mpruleformula", null);
                        this.getView().updateView("mpruleformula");
                        return;
                    }
                    this.getModel().setValue(MP_GENWAY, changedArgs.getChangeSet()[0].getOldValue());
                    return;
                }
            }
            return;
        }
        finally {
            this.getView().getPageCache().put(PRO_NOT_CHANGE, "N");
        }
    }

    private void setMpRuleVisible() {
        if (!PERF_PARAM_CONFIG_APPLICATION_SERVICE.isOpenPerfSum()) {
            Boolean isNeedMpGenWay = (Boolean)this.getModel().getValue(IS_NEEDMPGENWAY);
            if (isNeedMpGenWay.booleanValue()) {
                this.initFormula();
            }
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap6"});
            return;
        }
        Boolean visible = (Boolean)this.getModel().getValue(IS_NEEDMPGENWAY);
        DynamicObject cycleType = this.getModel().getDataEntity().getDynamicObject("cycletype");
        if (cycleType != null) {
            if (CYCLE_YEAR.longValue() == cycleType.getLong("id") && !((Boolean)this.getModel().getValue("isperiodassess")).booleanValue()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap6"});
            } else if (CYCLE_YEAR.longValue() == cycleType.getLong("id") && ((Boolean)this.getModel().getValue("isperiodassess")).booleanValue()) {
                this.lableSetText("labelap3", ResManager.loadKDString((String)"\u5e74\u5ea6\u9700\u6c47\u603b", (String)"SchemeBaseInfoEdit_1", (String)"opmc-pmd-formplugin", (Object[])new Object[0]));
                this.lableSetText("labelap4", ResManager.loadKDString((String)"\uff08\u5f00\u542f\u540e\uff0c\u5e74\u5ea6\u7ed3\u679c\u53ef\u7531\u5404\u8003\u6838\u5468\u671f\u7ed3\u679c\u4e0e\u5e74\u5ea6\u8bc4\u4f30\u7ed3\u679c\u6c47\u603b\u751f\u6210\u3002\uff09", (String)"SchemeBaseInfoEdit_2", (String)"opmc-pmd-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(MP_GENWAY, (Object)1);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{MP_GENWAY});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap6"});
            } else {
                this.lableSetText("labelap3", ResManager.loadKDString((String)"\u751f\u6210\u5e74\u5ea6\u7ed3\u679c", (String)"SchemeBaseInfoEdit_3", (String)"opmc-pmd-formplugin", (Object[])new Object[0]));
                this.lableSetText("labelap4", ResManager.loadKDString((String)"\uff08\u5f00\u542f\u540e\uff0c\u9ed8\u8ba4\u8003\u6838\u8ba1\u5212\u5185\u6700\u540e\u4e00\u4e2a\u8003\u6838\u5468\u671f\u5c06\u8fdb\u884c\u5e74\u5ea6\u7ed3\u679c\u751f\u6210\u3002\uff09", (String)"SchemeBaseInfoEdit_4", (String)"opmc-pmd-formplugin", (Object[])new Object[0]));
                this.getView().setVisible(Boolean.valueOf(true), new String[]{MP_GENWAY});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap6"});
            }
            if (visible.booleanValue()) {
                this.initFormula();
            }
            this.getView().setVisible(visible, new String[]{"flexpanelap51"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap6"});
        }
        IDataEntityProperty property = this.getModel().getProperty("mpruleformula");
        Boolean mustInput = false;
        if (!"".equals(this.getModel().getValue(MP_GENWAY)) && this.getModel().getValue(MP_GENWAY) != null) {
            mustInput = Integer.parseInt((String)this.getModel().getValue(MP_GENWAY)) != 2;
        }
        if (property instanceof FieldProp) {
            ((FieldProp)property).setMustInput(visible != false && mustInput != false);
        } else if (property instanceof BasedataProp) {
            ((BasedataProp)property).setMustInput(visible != false && mustInput != false);
        }
        this.getView().setVisible(mustInput, new String[]{"flexpanelap7"});
    }

    private void initFormula() {
        MpRuleSetVO mpRuleSetVO = new MpRuleSetVO();
        ArrayList<MpRuleSetEntryVO> entryentities = new ArrayList<MpRuleSetEntryVO>(10);
        mpRuleSetVO.setEntryentities(entryentities);
        if (!StringUtils.isEmpty((CharSequence)this.getView().getPageCache().get("tempvo"))) {
            mpRuleSetVO = (MpRuleSetVO)JSON.parseObject((String)this.getView().getPageCache().get("tempvo"), MpRuleSetVO.class);
        } else if (this.getModel().getValue("mprule") == null) {
            MpRuleUtils.buildMpRuleFromScheme(mpRuleSetVO, entryentities, (AbstractFormDataModel)this.getModel());
        } else {
            MpRuleUtils.buildVoByMpRule((DynamicObject)this.getModel().getValue("mprule"), mpRuleSetVO, entryentities);
            this.getModel().setValue("mpruleformula", (Object)mpRuleSetVO.getMpformula());
            this.getView().updateView("mpruleformula");
        }
        this.getView().updateView("mpruleformula");
        this.getView().getPageCache().put("tempvo", JSON.toJSONString((Object)mpRuleSetVO));
    }

    private Boolean setMustInputValue() {
        Boolean visible = (Boolean)this.getModel().getValue(IS_NEEDMPGENWAY);
        IDataEntityProperty property = this.getModel().getProperty("mpruleformula");
        Boolean mustInput = false;
        if (!"".equals(this.getModel().getValue(MP_GENWAY)) && this.getModel().getValue(MP_GENWAY) != null) {
            mustInput = Integer.parseInt((String)this.getModel().getValue(MP_GENWAY)) != 2;
        }
        if (property instanceof FieldProp) {
            ((FieldProp)property).setMustInput(visible != false && mustInput != false);
        } else if (property instanceof BasedataProp) {
            ((BasedataProp)property).setMustInput(visible != false && mustInput != false);
        }
        return visible;
    }

    private void processPeriodConf() {
        Boolean isPeriodAssess = (Boolean)this.getModel().getValue("isperiodassess");
        if (isPeriodAssess.booleanValue()) {
            if (((DynamicObject)this.getModel().getValue("cycletype")).getLong("id") == CYCLE_MONTH.longValue()) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u53ef\u9009\u7684\u671f\u95f4\u5468\u671f\u7c7b\u578b\u3002", (String)"SchemeBaseInfoEdit_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]), new Object[0]));
                this.getModel().setValue("isperiodassess", (Object)false);
                return;
            }
            this.getModel().createNewEntryRow("periodconfentity");
            this.getModel().setValue("pcycletype", this.getModel().getValue("cycletype"), 0);
            this.getModel().setValue(P_CYCLE_SCHEME, this.getModel().getValue("cyclescheme"), 0);
            BasedataEdit baseData = (BasedataEdit)this.getView().getControl(CYCLE_TYPE_F_7);
            DynamicObject cycleType = (DynamicObject)this.getModel().getValue("pcycletype", 0);
            baseData.setQFilter(CycleTypeFilterEnum.getFilterById((Long)cycleType.getLong("id")));
            baseData.addBeforeF7SelectListener(this::beforeF7Select);
            baseData.click();
        } else {
            DynamicObjectCollection periodConfEntity = this.getModel().getEntryEntity("periodconfentity");
            int[] deleteRows = new int[periodConfEntity.size()];
            for (int i = 0; i < periodConfEntity.size(); ++i) {
                deleteRows[i] = i;
            }
            this.getModel().deleteEntryRows("periodconfentity", deleteRows);
        }
        DynamicObject cycleType = (DynamicObject)this.getModel().getValue("cycletype");
        this.getView().setEnable(Boolean.valueOf(cycleType != null && isPeriodAssess == false), new String[]{"cyclescheme"});
    }

    private void setDefaultValidateOrg(PropertyChangedArgs changedArgs) {
        ChangeData[] changeSet = changedArgs.getChangeSet();
        Boolean notContainLower = (Boolean)changeSet[0].getNewValue();
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("orgentryentity");
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("orgentryentity", entryCurrentRowIndex);
        if (!notContainLower.booleanValue() && entryRowEntity.getLong("id") != 0L) {
            ConfirmCallBackListener confirmListener = new ConfirmCallBackListener("iscontainlower", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u7acb\u5373\u5220\u9664\u8be5\u7ec4\u7ec7\u4e0b\u5df2\u52a0\u5165\u7ee9\u6548\u8003\u6838\u65b9\u6848\u7684\u8bc4\u4f30\u5bf9\u8c61\uff0c\u786e\u8ba4\u5173\u95ed\u5417\uff1f", (String)"SchemeBaseInfoEdit_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmListener);
        }
    }

    private boolean notChangeYearNTag(String fieldKey, PropertyChangedArgs changedArgs) {
        String proNotChange = this.getView().getPageCache().get(PRO_NOT_CHANGE);
        if (HRStringUtils.isNotEmpty((String)proNotChange) && proNotChange.equals("Y")) {
            return true;
        }
        if (this.generateExecuteScheme() || this.generateAssessActivity() || this.generateAssessObject()) {
            this.cancelTimeChange(fieldKey, changedArgs);
            IDataEntityProperty property = (IDataEntityProperty)this.getModel().getDataEntity().getDataEntityType().getProperties().get((Object)fieldKey);
            String localeValue = property == null ? ResManager.loadKDString((String)"\u8003\u6838\u5468\u671f\u4fe1\u606f", (String)"SchemeBaseInfoEdit_7", (String)"opmc-epa-formplugin", (Object[])new Object[0]) : property.getDisplayName().getLocaleValue();
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8003\u6838\u8ba1\u5212\u4e2d\u5b58\u5728\u8bc4\u4f30\u5bf9\u8c61/\u8003\u6838\u6267\u884c\u8ba1\u5212\uff0c%s\u4e0d\u53ef\u4fee\u6539", (String)"SchemeBaseInfoEdit_8", (String)"opmc-epa-formplugin", (Object[])new Object[0]), localeValue));
            return true;
        }
        return false;
    }

    private void cancelTimeChange(String key, PropertyChangedArgs changedArgs) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        this.getView().getPageCache().put(PRO_NOT_CHANGE, "Y");
        Object oldValue = changedArgs.getChangeSet()[0].getOldValue();
        this.getModel().setValue(key, oldValue);
        this.getView().getPageCache().put(PRO_NOT_CHANGE, "N");
    }

    private void changeCycleType(PropertyChangedArgs changedArgs) {
        this.clearCycleInfo(changedArgs);
    }

    private void setTimeTagControl() {
        DynamicObject cycleType = this.getModel().getDataEntity().getDynamicObject("cycletype");
        if (!HRObjectUtils.isEmpty((Object)cycleType)) {
            this.setTimeStampDefault(cycleType.getLong("id"));
        }
        this.validateTimeTag();
        this.setMpRuleVisible();
    }

    private boolean validateTimeTag() {
        DynamicObject startTimeTag = this.getModel().getDataEntity().getDynamicObject("starttimetag");
        DynamicObject endTimeTag = this.getModel().getDataEntity().getDynamicObject("endtimetag");
        Date startYear = this.getModel().getDataEntity().getDate("startyear");
        Date endYear = this.getModel().getDataEntity().getDate("endyear");
        if (!HRObjectUtils.isEmpty((Object)startTimeTag) && !HRObjectUtils.isEmpty((Object)endTimeTag) && endTimeTag.getString("name").substring(0, 1).equals(startTimeTag.getString("name").substring(0, 1)) && startYear.equals(endYear) && startTimeTag.getLong("id") > endTimeTag.getLong("id")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"[\u8d77\u59cb\u5e74\u4efd]\u5e94\u5c0f\u4e8e\u6216\u7b49\u4e8e[\u7ec8\u6b62\u5e74\u4efd]", (String)"SchemeBaseInfoEdit_9", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void setTimeControl() {
        String cycleType = this.getModel().getDataEntity().getString("cycletype");
        if (HRStringUtils.isNotEmpty((String)cycleType)) {
            Date startYear = this.getModel().getDataEntity().getDate("startyear");
            if (HRObjectUtils.isEmpty((Object)startYear)) {
                try {
                    Date curYear = HRDateTimeUtils.parseDate((String)HRDateTimeUtils.formatDate((Date)new Date()), (String)"yyyy");
                    this.getModel().setValue("startyear", (Object)curYear);
                }
                catch (ParseException e) {
                    LOGGER.error("assess scheme base info format error !", (Throwable)e);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7ee9\u6548\u8003\u6838\u65b9\u6848\u57fa\u672c\u4fe1\u606f\u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"SchemeBaseInfoEdit_10", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                }
            } else {
                DateEdit dateEdit = (DateEdit)this.getControl("endyear");
                dateEdit.setMinDate(startYear);
            }
            Date endYear = this.getModel().getDataEntity().getDate("endyear");
            if (!HRObjectUtils.isEmpty((Object)endYear)) {
                DateEdit dateEdit = (DateEdit)this.getControl("startyear");
                dateEdit.setMaxDate(endYear);
            }
        }
        this.validateTimeTag();
    }

    private boolean generateExecuteScheme() {
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        if (pkValue != 0L) {
            DynamicObject[] executeSchemes = EXECUTE_SCHEME_APPLICATION_SERVICE.queryListBySchemeId(pkValue, "");
            return executeSchemes.length != 0;
        }
        return false;
    }

    private boolean generateAssessObject() {
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        if (pkValue != 0L) {
            DynamicObject[] assessObject = ASSESS_OBJECT_APPLICATION_SERVICE.queryPerffileBySchemeId(pkValue);
            return assessObject.length != 0;
        }
        return false;
    }

    private boolean generateAssessActivity() {
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        if (pkValue != 0L) {
            DynamicObject[] activities = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryActivityBySchemeId(pkValue);
            return activities.length != 0;
        }
        return false;
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId;
        super.confirmCallBack(event);
        switch (callBackId = event.getCallBackId()) {
            case "cycletype": {
                this.changeCycleTypeCallBack(event);
                break;
            }
            case "iscontainlower": {
                this.changeOrgIsContainLowerCallBack(event);
                break;
            }
            case "deleteorgentry": {
                this.deleteOrgEntryCallBack(event);
                break;
            }
            case "mp_rule": {
                this.changeMpRuleCallBack(event);
            }
        }
    }

    private void changeMpRuleCallBack(MessageBoxClosedEvent event) {
        if (MessageBoxResult.Yes == event.getResult()) {
            this.clearMpRule();
        } else if (MessageBoxResult.Cancel == event.getResult()) {
            this.cycleTypeCancelChange();
        }
    }

    private void clearMpRule() {
        for (int i = 0; i < 5; ++i) {
            this.getModel().setValue(CYCLE_INFO[i], null);
        }
        this.setTimeControl();
        this.setTimeTagControl();
        this.setCycleInfoEnableByCycleType();
        this.resetPeriodAssessInfo();
        this.updateVoCache();
        this.setMpRuleVisible();
        this.getModel().setValue("mpruleformula", null);
        this.getView().updateView("mpruleformula");
    }

    private void deleteOrgEntryCallBack(MessageBoxClosedEvent event) {
        if (MessageBoxResult.Yes == event.getResult()) {
            long schemeId = this.getModel().getDataEntity().getLong("id");
            DynamicObject savedSchemes = SCHEME_APPLICATION_SERVICE.queryOrgEntryById(Long.valueOf(schemeId));
            DynamicObjectCollection orgEntryEntity = savedSchemes.getDynamicObjectCollection("orgentryentity");
            Set savedOrgEntryId = orgEntryEntity.stream().map(org -> org.getLong("id")).collect(Collectors.toSet());
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("orgentryentity");
            int[] selectRows = entryGrid.getSelectRows();
            ArrayList<Integer> delRows = new ArrayList<Integer>(selectRows.length);
            int successCount = 0;
            int failCount = 0;
            ArrayList<String> failMsg = new ArrayList<String>(selectRows.length);
            HashMap<Long, Boolean> deleteOrgMap = new HashMap<Long, Boolean>(selectRows.length);
            for (int selectRow : selectRows) {
                if (savedOrgEntryId.contains(this.getModel().getEntryRowEntity("orgentryentity", selectRow).getLong("id"))) {
                    DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("orgentryentity", selectRow);
                    long orgId = entryRowEntity.getDynamicObject("orgbasedata").getLong("id");
                    boolean isContainLower = entryRowEntity.getBoolean("iscontainlower");
                    boolean exist = SCHEME_APPLICATION_SERVICE.queryOrgIsExistEvalObjInAct(Long.valueOf(schemeId), Long.valueOf(orgId), true, isContainLower);
                    if (exist) {
                        failMsg.add(ResManager.loadKDString((String)"{0}\uff1a\u8be5\u7ec4\u7ec7\u6216\u5176\u4e0b\u7ea7\u7ec4\u7ec7\u5b58\u5728\u8bc4\u4f30\u5bf9\u8c61\u5df2\u52a0\u5165\u8003\u6838\u6d3b\u52a8\uff0c\u4e0d\u53ef\u5220\u9664", (String)"SchemeBaseInfoEdit_11", (String)"opmc-epa-formplugin", (Object[])new Object[]{entryRowEntity.getDynamicObject("orgbasedata").getString("name")}));
                        ++failCount;
                        continue;
                    }
                    deleteOrgMap.put(orgId, isContainLower);
                    delRows.add(selectRow);
                    ++successCount;
                    continue;
                }
                delRows.add(selectRow);
                ++successCount;
            }
            ASSESS_OBJECT_APPLICATION_SERVICE.deleteAssObjByOrgNSchemeId(schemeId, deleteOrgMap);
            String title = MessageFormat.format(ResManager.loadKDString((String)"\u5171{0}\u6761\u6570\u636e\uff0c\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761", (String)"SchemeBaseInfoEdit_12", (String)"opmc-epa-business", (Object[])new Object[0]), selectRows.length, successCount, failCount);
            int[] deleteRows = new int[delRows.size()];
            for (int i = 0; i < deleteRows.length; ++i) {
                deleteRows[i] = (Integer)delRows.get(i);
            }
            this.getModel().deleteEntryRows("orgentryentity", deleteRows);
            this.getView().showMessage(title, String.join((CharSequence)"\n", failMsg), MessageTypes.Default);
        }
    }

    private void changeOrgIsContainLowerCallBack(MessageBoxClosedEvent event) {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("orgentryentity");
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("orgentryentity", entryCurrentRowIndex);
        if (MessageBoxResult.Yes == event.getResult()) {
            long orgId = entryRowEntity.getDynamicObject("orgbasedata").getLong("id");
            Object pkValue = this.getModel().getDataEntity().getPkValue();
            boolean isExistEvalObj = SCHEME_APPLICATION_SERVICE.queryOrgIsExistEvalObjInAct((Long)pkValue, Long.valueOf(orgId), false, true);
            if (isExistEvalObj) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"{0}\u7684\u4e0b\u7ea7\u7ec4\u7ec7\u4e2d\u5b58\u5728\u8bc4\u4f30\u5bf9\u8c61\u5df2\u52a0\u5165\u8003\u6838\u6d3b\u52a8\uff0c\u4e0d\u53ef\u5173\u95ed", (String)"SchemeBaseInfoEdit_13", (String)"opmc-epa-formplugin", (Object[])new Object[]{entryRowEntity.getDynamicObject("orgbasedata").getString("name")}));
                this.getModel().setValue("iscontainlower", (Object)Boolean.TRUE, entryCurrentRowIndex);
            } else {
                DynamicObjectCollection orgEntryEntity = this.getModel().getEntryEntity("orgentryentity");
                Map<Long, Boolean> orgIdMap = orgEntryEntity.stream().filter(org -> (Long)org.getPkValue() != 0L).collect(Collectors.toMap(org -> org.getDynamicObject("orgbasedata").getLong("id"), org -> org.getBoolean("iscontainlower"), (x1, x2) -> x1));
                ASSESS_OBJECT_APPLICATION_SERVICE.deleteOrgLowerAssObjByOrgNSchemeId((Long)pkValue, orgIdMap);
            }
        } else if (MessageBoxResult.Cancel == event.getResult()) {
            this.getModel().setValue("iscontainlower", (Object)Boolean.TRUE, entryCurrentRowIndex);
        }
    }

    private void changeCycleTypeCallBack(MessageBoxClosedEvent event) {
        if (MessageBoxResult.Yes == event.getResult()) {
            if (this.generateExecuteScheme() || this.generateAssessActivity() || this.generateAssessObject()) {
                String localeValue = ((IDataEntityProperty)this.getModel().getDataEntity().getDataEntityType().getProperties().get((Object)"cycletype")).getDisplayName().getLocaleValue();
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8003\u6838\u8ba1\u5212\u4e2d\u5b58\u5728\u8bc4\u4f30\u5bf9\u8c61/\u8003\u6838\u6267\u884c\u8ba1\u5212\uff0c%s\u4e0d\u53ef\u4fee\u6539", (String)"SchemeBaseInfoEdit_8", (String)"opmc-epa-formplugin", (Object[])new Object[0]), localeValue));
                this.cycleTypeCancelChange();
                return;
            }
            if (PERF_PARAM_CONFIG_APPLICATION_SERVICE.isOpenPerfSum()) {
                ConfirmCallBackListener confirmListener = new ConfirmCallBackListener(MP_RULE, (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u540e\u7ed3\u679c\u6c47\u603b\u8ba1\u7b97\u89c4\u5219\u5c06\u6e05\u7a7a\uff0c\u786e\u5b9a\u7ee7\u7eed\u5417\uff1f", (String)"SchemeBaseInfoEdit_14", (String)"opmc-epa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmListener);
            } else {
                this.clearMpRule();
                this.getModel().setValue(IS_NEEDMPGENWAY, (Object)false);
            }
        } else if (MessageBoxResult.Cancel == event.getResult()) {
            this.cycleTypeCancelChange();
        }
    }

    private void resetPeriodAssessInfo() {
        this.getModel().setValue("isperiodassess", (Object)Boolean.FALSE);
    }

    private void cycleTypeCancelChange() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        Long cycleTypeId = Long.valueOf(this.getPageCache().get("cycletype"));
        this.getModel().setValue("cycletype", (Object)cycleTypeId);
        this.getView().updateView("cycletype");
        model.endInit();
    }

    private void clearCycleInfo(PropertyChangedArgs changedArgs) {
        if (this.hasAssessCycleInfo()) {
            long cycleTypeId = ((DynamicObject)changedArgs.getChangeSet()[0].getOldValue()).getLong("id");
            this.getView().getPageCache().put("cycletype", String.valueOf(cycleTypeId));
            ConfirmCallBackListener confirmListener = new ConfirmCallBackListener("cycletype", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u82e5\u5207\u6362\u5468\u671f\u7c7b\u578b\uff0c\u5df2\u7f16\u8f91\u7684\u5176\u4ed6\u8003\u6838\u5468\u671f\u4fe1\u606f\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u8981\u5207\u6362\u5417\uff1f", (String)"SchemeBaseInfoEdit_15", (String)"opmc-epa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmListener);
        } else {
            this.resetPeriodAssessInfo();
            this.setCycleInfoEnableByCycleType();
        }
        if (changedArgs.getChangeSet()[0].getOldValue() == null) {
            this.updateVoCache();
            this.setMpRuleVisible();
        } else if (changedArgs.getChangeSet()[0].getNewValue() == null) {
            this.updateVoCache();
        }
    }

    private boolean hasAssessCycleInfo() {
        for (int i = 0; i < 5; ++i) {
            if (HRObjectUtils.isEmpty((Object)this.getModel().getValue(CYCLE_INFO[i]))) continue;
            return true;
        }
        return false;
    }

    private void setCycleInfoEnableByCycleType() {
        DynamicObject cycleType = this.getModel().getDataEntity().getDynamicObject("cycletype");
        if (HRObjectUtils.isEmpty((Object)cycleType)) {
            this.setCycleInfoEnable(null, Boolean.FALSE);
        } else {
            this.setCycleInfoEnable(cycleType.getLong("id"), Boolean.TRUE);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        this.getView().getFormShowParameter().setCustomParam("schemeId", (Object)((Long)this.getModel().getDataEntity().getPkValue()));
        SchemeStatusValidateUtils.checkSchemeStatusValidate(args, this.getView());
        if (DELETE_ORG_ENTRY.equals(source.getOperateKey())) {
            this.checkOrgEntryForDel(args);
        } else if ((HRStringUtils.equals((String)"deleteperiodconf", (String)source.getOperateKey()) || HRStringUtils.equals((String)"newperiodconf", (String)source.getOperateKey())) && (this.generateExecuteScheme() || this.generateAssessActivity() || this.generateAssessObject())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8003\u6838\u8ba1\u5212\u4e2d\u5b58\u5728\u8bc4\u4f30\u5bf9\u8c61/\u8003\u6838\u6267\u884c\u8ba1\u5212\uff0c\u8003\u6838\u5468\u671f\u4fe1\u606f\u4e0d\u53ef\u4fee\u6539", (String)"SchemeBaseInfoEdit_16", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
        if ("mpruleset".equals(source.getOperateKey())) {
            args.setCancel(true);
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("epa_mpruleset");
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "mpruleset"));
            formShowParameter.setCustomParam("scheme", this.getModel().getValue("id"));
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            if (StringUtils.isEmpty((CharSequence)this.getView().getPageCache().get("tempvo"))) {
                if (this.getModel().getValue("mprule") != null) {
                    MpRuleSetVO mpRuleSetVO = new MpRuleSetVO();
                    ArrayList<MpRuleSetEntryVO> entryentities = new ArrayList<MpRuleSetEntryVO>(10);
                    MpRuleUtils.buildVoByMpRule((DynamicObject)this.getModel().getValue("mprule"), mpRuleSetVO, entryentities);
                    formShowParameter.setCustomParam("tempvo", JSON.toJSON((Object)mpRuleSetVO));
                }
            } else {
                formShowParameter.setCustomParam("tempvo", (Object)this.getView().getPageCache().get("tempvo"));
            }
            this.getView().showForm(formShowParameter);
        } else if ("save".equals(source.getOperateKey())) {
            this.setMustInputValue();
            this.setMpRuleDefault();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        if ("save".equals(source.getOperateKey()) && args.getOperationResult().isSuccess()) {
            DynamicObjectCollection orgEntryEntity = this.getModel().getEntryEntity("orgentryentity");
            Object pkValue = this.getModel().getDataEntity().getPkValue();
            Map<Long, Boolean> orgIdMap = orgEntryEntity.stream().collect(Collectors.toMap(org -> org.getDynamicObject("orgbasedata").getLong("id"), org -> org.getBoolean("iscontainlower"), (x1, x2) -> x1));
            ASSESS_OBJECT_APPLICATION_SERVICE.deleteOrgLowerAssObjByOrgNSchemeId((Long)pkValue, orgIdMap);
            this.getView().getFormShowParameter().setStatus(OperationStatus.EDIT);
        } else if (HRStringUtils.equals((String)source.getOperateKey(), (String)"newperiodconf")) {
            this.getModel().setValue(CYCLE_TYPE_F_7, null);
            BasedataEdit cycleTypeF7 = (BasedataEdit)this.getControl(CYCLE_TYPE_F_7);
            DynamicObject cycleType = (DynamicObject)this.getModel().getValue("pcycletype", this.getPeriodConfSelectRow());
            cycleTypeF7.setQFilter(CycleTypeFilterEnum.getFilterById((Long)cycleType.getLong("id")));
            cycleTypeF7.click();
        } else if (HRStringUtils.equals((String)source.getOperateKey(), (String)"neworgentry")) {
            this.getModel().setValue(ORG_F_7, null);
            BasedataEdit orgF7 = (BasedataEdit)this.getControl(ORG_F_7);
            orgF7.click();
        }
    }

    private void checkOrgEntryForDel(BeforeDoOperationEventArgs args) {
        long schemeId = this.getModel().getDataEntity().getLong("id");
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("orgentryentity");
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("orgentryentity", entryCurrentRowIndex);
        if (schemeId != 0L && entryRowEntity.getLong("id") != 0L) {
            ConfirmCallBackListener confirmListener = new ConfirmCallBackListener(DELETE_ORG_ENTRY, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u7acb\u5373\u5220\u9664\u8be5\u7ec4\u7ec7\u4e0b\u5df2\u52a0\u5165\u7ee9\u6548\u8003\u6838\u65b9\u6848\u7684\u8bc4\u4f30\u5bf9\u8c61\uff0c\u786e\u8ba4\u5220\u9664\u5417\uff1f", (String)"SchemeBaseInfoEdit_17", (String)"opmc-epa-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmListener);
            args.setCancel(true);
        }
    }

    private void setCycleInfoEnable(Long CycleTypeId, Boolean enable) {
        if (enable.booleanValue()) {
            this.setTimeControl();
            this.setTimeStampDefault(CycleTypeId);
        }
        this.getView().setEnable(enable, new String[]{"cyclescheme", "startyear", "starttimetag", "endyear", "endtimetag", "isperiodassess"});
    }

    private void setTimeStampDefault(Long CycleTypeId) {
        if (HRObjectUtils.isEmpty((Object)this.getModel().getValue("starttimetag"))) {
            TimeStampEnums startTimeStamp = TimeStampEnums.getStartTimeStampByType((Long)CycleTypeId);
            this.getModel().setValue("starttimetag", (Object)(startTimeStamp == null ? null : startTimeStamp.getId()));
        }
        if (HRObjectUtils.isEmpty((Object)this.getModel().getValue("endtimetag"))) {
            TimeStampEnums endTimeStamp = TimeStampEnums.getEndTimeStampByType((Long)CycleTypeId);
            this.getModel().setValue("endtimetag", (Object)(endTimeStamp == null ? null : endTimeStamp.getId()));
        }
    }

    public void beforeBindData(EventObject event) {
        String schStatus;
        boolean modifyDataPermission;
        super.beforeBindData(event);
        long schemeId = (Long)this.getModel().getDataEntity().getPkValue();
        if (schemeId != 0L && !(modifyDataPermission = AssessSchemePermissionUtils.checkModifyDataPermission(schemeId))) {
            this.getView().setStatus(OperationStatus.VIEW);
        }
        if ((schStatus = this.getModel().getDataEntity().getString("schstatus")).equals("20")) {
            this.getView().setStatus(OperationStatus.VIEW);
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.initTips();
        CardEntry periodConfCard = (CardEntry)this.getView().getControl("periodconfentity");
        periodConfCard.setChildVisible(false, 0, new String[]{DELETE_PERIOD_CONF_LAB});
        periodConfCard.setChildEnable(false, 0, new String[]{"pcycletype"});
        if (this.getModel().getValue(MP_GENWAY) == null || "".equals(this.getModel().getValue(MP_GENWAY))) {
            this.getModel().setValue(MP_GENWAY, (Object)1);
            this.getView().updateView(MP_GENWAY);
        }
        this.setMpRuleVisible();
        this.processNewPeriodConfEnable();
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String name = e.getEntryProp().getName();
        if (HRStringUtils.equals((String)name, (String)"periodconfentity")) {
            this.processNewPeriodConfEnable();
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String name = e.getEntryProp().getName();
        if (HRStringUtils.equals((String)name, (String)"periodconfentity")) {
            this.processNewPeriodConfEnable();
            this.updateVoCache();
            this.setMpRuleVisible();
            this.getModel().setValue("mpruleformula", null);
            this.getView().updateView("mpruleformula");
        }
    }

    private void processNewPeriodConfEnable() {
        CardEntry periodConfCard = (CardEntry)this.getView().getControl("periodconfentity");
        periodConfCard.setChildVisible(false, 0, new String[]{DELETE_PERIOD_CONF_LAB});
        int endIndex = periodConfCard.getEntryData().getEndIndex();
        for (int i = 0; i < endIndex; ++i) {
            boolean isShowNewPeriodConfAp = i == endIndex - 1;
            periodConfCard.setChildVisible(!isShowNewPeriodConfAp, i, new String[]{"connectlab"});
            if (endIndex == 5) {
                isShowNewPeriodConfAp = false;
            }
            periodConfCard.setChildVisible(isShowNewPeriodConfAp, i, new String[]{"newperiodconfap"});
        }
        DynamicObject cycleType = this.getModel().getDataEntity().getDynamicObject("cycletype");
        Boolean isPeriodAssess = (Boolean)this.getModel().getValue("isperiodassess");
        this.getView().setEnable(Boolean.valueOf(cycleType != null && isPeriodAssess == false), new String[]{"cyclescheme"});
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey;
        switch (fieldKey = evt.getProperty().getName()) {
            case "cyclescheme": 
            case "starttimetag": 
            case "endtimetag": {
                QFilter qFilter = this.buildFilter();
                if (HRObjectUtils.isEmpty((Object)qFilter)) break;
                ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
            case "orgf7": {
                ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                DynamicObjectCollection filteredNullObject = this.getModel().getEntryEntity("orgentryentity").stream().filter(org -> !HRObjectUtils.isEmpty((Object)org.getDynamicObject("orgbasedata"))).collect(Collectors.toCollection(DynamicObjectCollection::new));
                List ids = filteredNullObject.stream().map(org -> org.getDynamicObject("orgbasedata").getLong("id")).collect(Collectors.toList());
                if (!CollectionUtils.isNotEmpty(ids)) break;
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "not in", ids));
                break;
            }
            case "pcyclescheme": {
                this.addCycleSchemeFilter(evt);
                break;
            }
            case "cycletypef7": {
                evt.getFormShowParameter().setCloseCallBack(new CloseCallBack((IFormPlugin)this, CYCLE_TYPE_F_7));
                break;
            }
        }
    }

    private void addCycleSchemeFilter(BeforeF7SelectEvent evt) {
        int row = evt.getRow();
        DynamicObject pCycleType = (DynamicObject)this.getModel().getValue("pcycletype", row);
        QFilter qFilter = new QFilter("cycletype", "=", (Object)pCycleType.getLong("id"));
        if (!HRObjectUtils.isEmpty((Object)qFilter)) {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    public void afterF7Select(AfterF7SelectEvent evt) {
        String fieldKey = ((Control)evt.getSource()).getKey();
        if (HRStringUtils.equals((String)CYCLE_TYPE_F_7, (String)fieldKey)) {
            int newRow = this.getModel().getEntryEntity("periodconfentity").size();
            this.getModel().createNewEntryRow("periodconfentity");
            if (newRow >= 0) {
                this.getModel().setValue("pcycletype", this.getModel().getValue(CYCLE_TYPE_F_7), newRow);
            }
            this.updateVoCache();
            this.setMpRuleVisible();
            this.getModel().setValue("mpruleformula", null);
            this.getView().updateView("mpruleformula");
        } else if (HRStringUtils.equals((String)ORG_F_7, (String)fieldKey)) {
            DynamicObjectCollection orgDyColl = (DynamicObjectCollection)this.getModel().getValue(ORG_F_7);
            this.addOrgEntry(ORG_F_7, orgDyColl);
        } else if (HRStringUtils.equals((String)ADMIN_ORG, (String)fieldKey) && this.getView().getModel().getEntryEntity("orgentryentity").size() == 0) {
            DynamicObjectCollection orgDyColl = new DynamicObjectCollection();
            if (this.getModel().getValue(ADMIN_ORG) != null) {
                orgDyColl.add((Object)((DynamicObject)this.getModel().getValue(ADMIN_ORG)));
                this.addOrgEntry(ADMIN_ORG, orgDyColl);
            }
        }
    }

    private void updateVoCache() {
        MpRuleSetVO mpRuleSetVO = new MpRuleSetVO();
        ArrayList<MpRuleSetEntryVO> entryentities = new ArrayList<MpRuleSetEntryVO>(10);
        mpRuleSetVO.setEntryentities(entryentities);
        MpRuleUtils.buildMpRuleFromScheme(mpRuleSetVO, entryentities, (AbstractFormDataModel)this.getModel());
        this.getView().getPageCache().put("tempvo", JSON.toJSONString((Object)mpRuleSetVO));
        this.getModel().setValue("mpruleformula", null);
        this.getView().updateView("mpruleformula");
        CardEntry periodConfCard = (CardEntry)this.getView().getControl("periodconfentity");
        int endIndex = periodConfCard.getEntryData().getEndIndex();
        if (endIndex == 1) {
            this.getModel().setValue("isperiodassess", (Object)false);
        }
    }

    private void addOrgEntry(String adminOrg, DynamicObjectCollection orgDyColl) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("orgbasedata", new Object[0]);
        vs.addField("iscontainlower", new Object[0]);
        for (DynamicObject orgDy : orgDyColl) {
            if (HRStringUtils.equals((String)ORG_F_7, (String)adminOrg)) {
                vs.addRow(new Object[]{orgDy.getDynamicObject("fbasedataid").getPkValue(), Boolean.TRUE});
                continue;
            }
            vs.addRow(new Object[]{orgDy.getLong("id"), Boolean.TRUE});
        }
        model.batchCreateNewEntryRow("orgentryentity", vs);
        model.endInit();
        this.getView().updateView("orgentryentity");
    }

    private int getPeriodConfSelectRow() {
        CardEntry assGroupEntry = (CardEntry)this.getView().getControl("periodconfentity");
        int[] selectRows = assGroupEntry.getSelectRows();
        if (selectRows.length > 0) {
            return assGroupEntry.getSelectRows()[0];
        }
        return -1;
    }

    private void initTips() {
        this.setTips("startyear");
        this.setTips("endyear");
        this.setTips("orgap");
        this.setTips("ruleap");
    }

    private void setTips(String key) {
        DynamicObject dy = this.getModel().getDataEntity();
        String tipContent = SCHEME_APPLICATION_SERVICE.getTips(key, dy);
        if (StringUtils.isNotBlank((CharSequence)tipContent)) {
            HashMap<String, Tips> props = new HashMap<String, Tips>(16);
            Tips tips = new Tips();
            tips.setType("text");
            tips.setContent(new LocaleString(tipContent));
            props.put("tips", tips);
            this.getView().updateControlMetadata(key, props);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setSkipNoField(true);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returndata;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)CYCLE_TYPE_F_7, (String)actionId)) {
            returndata = closedCallBackEvent.getReturnData();
            if (returndata == null) {
                if (this.getModel().getEntryEntity("periodconfentity").size() == 1) {
                    this.getModel().setValue("isperiodassess", (Object)false);
                }
            } else if (((Boolean)this.getModel().getValue("isperiodassess")).booleanValue()) {
                int newRow = this.getModel().getEntryEntity("periodconfentity").size();
                this.getModel().createNewEntryRow("periodconfentity");
                if (newRow >= 0) {
                    this.getModel().setValue("pcycletype", ((ListSelectedRowCollection)returndata).get(0).getPrimaryKeyValue(), newRow);
                }
            }
            this.updateVoCache();
            this.setMpRuleVisible();
        }
        if (HRStringUtils.equals((String)"mpruleset", (String)actionId) && (returndata = (MpRuleSetVO)closedCallBackEvent.getReturnData()) != null) {
            this.getModel().setValue("mpruleformula", (Object)returndata.getMpformula());
            this.getView().updateView("mpruleformula");
            this.getView().getPageCache().put("tempvo", JSON.toJSONString((Object)returndata));
        }
    }

    private void lableSetText(String key, String text) {
        IFormView view = this.getView();
        Label label = (Label)view.getControl(key);
        if (ObjectUtils.isEmpty((Object)label)) {
            return;
        }
        label.setText(text == null ? "" : text);
    }

    static {
        SchemeBaseInfoEdit.CYCLE_INFO[0] = "cyclescheme";
        SchemeBaseInfoEdit.CYCLE_INFO[1] = "startyear";
        SchemeBaseInfoEdit.CYCLE_INFO[2] = "starttimetag";
        SchemeBaseInfoEdit.CYCLE_INFO[3] = "endyear";
        SchemeBaseInfoEdit.CYCLE_INFO[4] = "endtimetag";
    }
}

