/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.scheme;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.DynamicTextColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.MutexHelper;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.opmc.epa.business.application.service.scheme.AssessSchemeApplicationService;
import kd.opmc.epa.business.application.service.upgradeparam.UpgradeParamApplicationService;
import kd.opmc.epa.business.domain.indicator.imp.helper.DataValidateServiceHelper;

public class SchemeBaseInfoList
extends HRDataBaseList {
    private static final Log LOGGER = LogFactory.getLog(SchemeBaseInfoList.class);
    private static final String STOP = "stop";
    private static final String START = "start";
    private static final AssessSchemeApplicationService APP_SERVICE = AssessSchemeApplicationService.getInstance();
    private static final UpgradeParamApplicationService UPGRADE_PARAM_APPLICATION_SERVICE = UpgradeParamApplicationService.getInstance();
    private static Map<Object, String> PERIOD_CYCLE_MAP;

    public void preOpenForm(PreOpenFormEventArgs e) {
        DynamicObject flagLogObj;
        super.preOpenForm(e);
        DynamicObject upgradeParamObj = UPGRADE_PARAM_APPLICATION_SERVICE.getUpgradeParam();
        boolean isupgrade = upgradeParamObj.getBoolean("isupgrade");
        if (isupgrade && ((flagLogObj = BusinessDataServiceHelper.loadSingle((String)"epa_dynpermupdaterecord", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)1000000L)})) == null || "-1".equals(flagLogObj.getString("status")) || "".equals(flagLogObj.getString("status")))) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u529f\u80fd\u5b9e\u65bd\u90e8\u7f72\u4e2d\uff0c\u8bf7\u524d\u5f80\u201c\u76ee\u6807\u7ee9\u6548\u4e91>\u4e2a\u4eba\u7ee9\u6548\u8003\u6838>\u57fa\u7840\u914d\u7f6e>\u7cfb\u7edf\u5347\u7ea7\u7ba1\u7406\u201d\u5347\u7ea7\u529f\u80fd\uff0c\u6570\u636e\u5347\u7ea7\u5b8c\u6210\u540e\uff0c\u63d0\u793a\u5c06\u4e0d\u518d\u51fa\u73b0\u3002\u5982\u65e0\u201d\u5347\u7ea7\u529f\u80fd\u201c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"SchemeBaseInfoList_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        List<String> fixedColumnList = Arrays.asList("fseq", "number", "name");
        List listColumn = billList.getListFieldsControlColumns();
        ArrayList<Map> listFixedColumn = new ArrayList<Map>(10);
        for (Map map : listColumn) {
            String fieldKey = (String)map.get("listFieldKey");
            if (fixedColumnList.contains(fieldKey)) {
                map.replace("fixed", Boolean.TRUE);
            }
            listFixedColumn.add(map);
        }
        billList.setListFieldsControlColumns(listFixedColumn);
    }

    public void packageData(PackageDataEvent event) {
        DynamicTextColumnDesc columnDesc;
        DynamicObject rowData = event.getRowData();
        Object source = event.getSource();
        if (source instanceof DynamicTextColumnDesc && HRStringUtils.equals((String)(columnDesc = (DynamicTextColumnDesc)source).getKey(), (String)"periodcycletype")) {
            event.setFormatValue((Object)PERIOD_CYCLE_MAP.get(rowData.getPkValue()));
        }
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        DynamicObjectCollection pageData = e.getPageData();
        List idList = pageData.stream().map(data -> (Long)data.getPkValue()).collect(Collectors.toList());
        DynamicObject[] periodCycles = APP_SERVICE.querySchemePeriodCycle(idList);
        PERIOD_CYCLE_MAP = Arrays.stream(periodCycles).collect(Collectors.toMap(DataEntityBase::getPkValue, periodCycle -> {
            DynamicObjectCollection periodConfEntry = periodCycle.getDynamicObjectCollection("periodconfentity");
            StringBuilder periodCycleInfo = new StringBuilder();
            for (int i = 0; i < periodConfEntry.size(); ++i) {
                periodCycleInfo.append(((DynamicObject)periodConfEntry.get(i)).getString("pcycletype.name"));
                if (i == periodConfEntry.size() - 1) continue;
                periodCycleInfo.append('-');
            }
            return periodCycleInfo.toString();
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if (HRStringUtils.equals((String)fieldName, (String)"name")) {
            Long scheme = (Long)this.getFocusRowPkId();
            StringBuilder errMsg = new StringBuilder();
            DataMutex dataMutex = DataMutex.create();
            try {
                Map map = dataMutex.getLockInfo(String.valueOf(scheme), MutexHelper.getMutexGroupId((String)"epa_scheme", (String)"modify"), "epa_scheme");
                if (map != null && !RequestContext.get().getUserId().equals(map.get("userid"))) {
                    MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bos_user");
                    long userId = Long.parseLong((String)map.get("userid"));
                    Map cacheUserObjs = BusinessDataReader.loadFromCache((Object[])new Object[]{userId}, (DynamicObjectType)dt);
                    DynamicObject userObj = (DynamicObject)cacheUserObjs.get(userId);
                    if (userObj != null) {
                        errMsg.append(ResManager.loadKDString((String)"%1$s\u6b63\u5728PC\u7aef\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"SchemeBaseInfoList_1", (String)"opmc-epa-formplugin", (Object[])new Object[]{userObj.getString("name")}));
                    } else {
                        errMsg.append(ResManager.loadKDString((String)"\u6b63\u5728PC\u7aef\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"SchemeBaseInfoList_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                    }
                    this.getView().showErrorNotification(errMsg.toString());
                    args.setCancel(true);
                }
            }
            finally {
                try {
                    dataMutex.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    LOGGER.error(e.getMessage());
                }
            }
            super.billListHyperLinkClick(args);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if ((STOP.equals(operateKey) || START.equals(operateKey)) && operationResult.isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.getQFilters().add(DataValidateServiceHelper.getDataRule((String)"epa_scheme", (String)"47150e89000000ac", new HashMap()));
    }
}

