/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.scheme.assign;

import com.google.common.collect.ImmutableBiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.control.Control;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.opmc.epa.business.application.service.scheme.AssessGroupApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssessSchemeApplicationService;
import kd.opmc.epa.business.application.service.scheme.ObjectScopeApplicationService;

public class AssignManagerEditPlugin
extends HRDataBaseEdit
implements BeforeF7SelectListener,
AfterF7SelectListener {
    private static final ObjectScopeApplicationService OBJECT_SCOPE_APPLICATION_SERVICE = ObjectScopeApplicationService.getInstance();
    private static final AssessSchemeApplicationService ASSESS_SCHEME_APPLICATION_SERVICE = AssessSchemeApplicationService.getInstance();
    private static final AssessGroupApplicationService ASSESS_GROUP_APPLICATION_SERVICE = AssessGroupApplicationService.getInstance();
    private static List<String> PRO_KEYS = Stream.of("isorgcheck", "isscopecheck", "isgroupcheck").collect(Collectors.toList());
    private final Map<String, String> PROKEY_F7 = ImmutableBiMap.builder().put((Object)"isorgcheck", (Object)"org").put((Object)"isscopecheck", (Object)"objectscope").put((Object)"isgroupcheck", (Object)"assessgroup").build();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgEdit = (BasedataEdit)this.getView().getControl("org");
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit scopeEdit = (BasedataEdit)this.getView().getControl("objectscope");
        scopeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit groupEdit = (BasedataEdit)this.getView().getControl("assessgroup");
        groupEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit hrEdit = (BasedataEdit)this.getView().getControl("hrperson");
        hrEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit sysEdit = (BasedataEdit)this.getView().getControl("sysperson");
        sysEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs evt) {
        super.preOpenForm(evt);
        evt.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u6dfb\u52a0\u7ba1\u7406\u4eba\u5458", (String)"AssignManagerEditPlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object schemeId = this.getView().getParentView().getFormShowParameter().getCustomParam("schemeId");
        this.getModel().setValue("scheme", schemeId);
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        BasedataEdit orgEdit = (BasedataEdit)this.getView().getControl("org");
        BasedataEdit groupEdit = (BasedataEdit)this.getView().getControl("assessgroup");
        BasedataEdit scopeEdit = (BasedataEdit)this.getView().getControl("objectscope");
        orgEdit.setMustInput(true);
        groupEdit.setMustInput(true);
        scopeEdit.setMustInput(true);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey = args.getProperty().getName();
        if ("persontype".equals(fieldKey)) {
            this.getModel().setValue("hrperson", null);
            this.getModel().setValue("sysperson", null);
        } else if ("objectscope".equals(fieldKey)) {
            if (this.getModel().getValue("objectscope") == null) {
                this.getModel().setValue("assessgroup", null);
            } else {
                DynamicObjectCollection groups = (DynamicObjectCollection)this.getModel().getValue("assessgroup");
                if (groups.isEmpty()) {
                    return;
                }
                DynamicObjectCollection newgroups = new DynamicObjectCollection();
                DynamicObject[] scopesOfGroup = (DynamicObject[])((DynamicObjectCollection)this.getModel().getValue("objectscope")).toArray((Object[])new DynamicObject[0]);
                List scopeIdsOfgroup = null;
                if (scopesOfGroup != null && scopesOfGroup.length > 0) {
                    scopeIdsOfgroup = Arrays.stream(scopesOfGroup).map(obj -> obj.getLong(2)).collect(Collectors.toList());
                }
                if (scopeIdsOfgroup != null) {
                    for (DynamicObject group : groups) {
                        if (!scopeIdsOfgroup.contains(group.getDynamicObject("fbasedataid").getDynamicObject("objectscope").getPkValue())) continue;
                        newgroups.add((Object)group);
                    }
                }
                if (newgroups.size() > 0) {
                    this.getModel().setValue("assessgroup", (Object)newgroups);
                } else {
                    this.getModel().setValue("assessgroup", null);
                }
            }
        }
        this.setBizChanged(fieldKey, this.getModel().getDataEntity());
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = ((Control)beforeF7SelectEvent.getSource()).getKey();
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("scheme");
        Long schemeId = scheme.getLong("id");
        switch (fieldKey) {
            case "org": {
                Object[] baseInfo = ASSESS_SCHEME_APPLICATION_SERVICE.queryListBySchemeId(schemeId);
                ArrayList<Long> orgIds = new ArrayList<Long>(10);
                if (!ObjectUtils.isEmpty((Object[])baseInfo)) {
                    DynamicObjectCollection orgs = baseInfo[0].getDynamicObjectCollection("orgentryentity");
                    for (DynamicObject dy : orgs) {
                        long id = dy.getDynamicObject("orgbasedata").getLong("id");
                        if (dy.getBoolean("iscontainlower")) {
                            List ids = ASSESS_SCHEME_APPLICATION_SERVICE.getAllOrgIds(id);
                            orgIds.addAll(ids);
                            continue;
                        }
                        orgIds.add(id);
                    }
                }
                QFilter orgFilter = new QFilter("id", "in", orgIds);
                beforeF7SelectEvent.getCustomQFilters().add(orgFilter);
                break;
            }
            case "objectscope": {
                Object[] scopes = OBJECT_SCOPE_APPLICATION_SERVICE.queryListBySchemeId(schemeId);
                List scopeIds = null;
                if (!ObjectUtils.isEmpty((Object[])scopes)) {
                    scopeIds = Arrays.stream(scopes).map(obj -> obj.getLong("id")).collect(Collectors.toList());
                }
                QFilter ruleFilter = new QFilter("id", "in", scopeIds);
                beforeF7SelectEvent.getCustomQFilters().add(ruleFilter);
                break;
            }
            case "assessgroup": {
                Object[] groups = ASSESS_GROUP_APPLICATION_SERVICE.queryListBySchemeId(schemeId);
                List groupIds = null;
                if (!ObjectUtils.isEmpty((Object[])groups)) {
                    groupIds = Arrays.stream(groups).map(obj -> obj.getLong("id")).collect(Collectors.toList());
                }
                DynamicObject[] scopesOfGroup = (DynamicObject[])((DynamicObjectCollection)this.getModel().getValue("objectscope")).toArray((Object[])new DynamicObject[0]);
                List scopeIdsOfgroup = null;
                if (scopesOfGroup != null && scopesOfGroup.length > 0) {
                    scopeIdsOfgroup = Arrays.stream(scopesOfGroup).map(obj -> obj.getLong(2)).collect(Collectors.toList());
                }
                QFilter groupFilter = new QFilter("id", "in", groupIds);
                if (scopeIdsOfgroup != null) {
                    QFilter objectscopeFilter = new QFilter("objectscope", "in", scopeIdsOfgroup);
                    beforeF7SelectEvent.getCustomQFilters().add(objectscopeFilter);
                }
                beforeF7SelectEvent.getCustomQFilters().add(groupFilter);
                break;
            }
        }
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        DynamicObject person;
        DynamicObject hrPerson;
        String fieldKey = ((Control)afterF7SelectEvent.getSource()).getKey();
        if ("hrperson".equals(fieldKey) && (hrPerson = this.getModel().getDataEntity().getDynamicObject("hrperson")) != null && (person = hrPerson.getDynamicObject("person")) != null) {
            Long personId = person.getLong("id");
            Long sysId = ASSESS_SCHEME_APPLICATION_SERVICE.getUserIdByPersonInfo(personId);
            this.getModel().setValue("sysperson", (Object)sysId);
        }
    }

    public void setBizChanged(String fieldKey, DynamicObject dataEntity) {
        DataEntityState dataEntityState = dataEntity.getDataEntityState();
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        for (String propKey : PRO_KEYS) {
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)propKey);
            if (property == null) continue;
            dataEntityState.setBizChanged(property.getOrdinal(), false);
        }
        String propKey = this.PROKEY_F7.get(fieldKey);
        IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)propKey);
        if (property != null) {
            dataEntityState.setBizChanged(property.getOrdinal(), true);
            if (property instanceof BasedataProp) {
                property = (IDataEntityProperty)properties.get((Object)(propKey + "_id"));
                Optional.ofNullable(property).ifPresent(p -> dataEntityState.setBizChanged(p.getOrdinal(), true));
            }
        }
    }
}

