/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.upgrade;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.opmc.epa.business.domain.activity.entityservice.AssessActivityEntityService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.DynPermUpdateRecordEntityService;
import kd.opmc.epa.business.task.AtivityPermUpdateTask;
import kd.opmc.epa.business.task.DynPermMigrateTask;
import kd.opmc.epa.formplugin.web.utils.ActivityDispatchUtils;

public class UpgradePagePlugin
extends HRDynamicFormBasePlugin
implements TabSelectListener,
RowClickEventListener {
    private static final Log LOG = LogFactory.getLog(UpgradePagePlugin.class);
    private static final DynPermUpdateRecordEntityService DYN_PERM_UPDATE_RECORD_ENTITY_SERVICE = DynPermUpdateRecordEntityService.getInstance();
    private static final AssessActivityEntityService ACTIVITY_ENTITY = AssessActivityEntityService.getInstance();
    private static final String UPGRADE_SUCCESS_FLAG = "1";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        Tab tabAp = (Tab)this.getView().getControl("tabap");
        tabAp.addTabSelectListener((TabSelectListener)this);
        EntryGrid schemeEntryEntity = (EntryGrid)this.getControl("schemeentryentity");
        schemeEntryEntity.addRowClickListener((RowClickEventListener)this);
        EntryGrid activityEntryEntity = (EntryGrid)this.getControl("activityentryentity");
        activityEntryEntity.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initSchemeUpdateData();
    }

    public void tabSelected(TabSelectEvent event) {
        String tabKey = event.getTabKey();
        if ("schemetab".equals(tabKey)) {
            this.initSchemeUpdateData();
        } else if ("activitytab".equals(tabKey)) {
            this.initActivityUpdateData();
        }
    }

    private void initActivityUpdateData() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("activityentryentity");
        QFilter[] qFilters = new QFilter[]{new QFilter("scheme", "=", (Object)0L), new QFilter("activity", "!=", (Object)0L)};
        DynamicObject[] activityUpdateDynObjArr = DYN_PERM_UPDATE_RECORD_ENTITY_SERVICE.query("activity,status", qFilters, "status asc, modifytime desc");
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        tableValueSetter.addField("activity", new Object[0]);
        tableValueSetter.addField("activityupgraderesult", new Object[0]);
        tableValueSetter.addField("activityupdaterecord", new Object[0]);
        for (DynamicObject activityUpdateDynObj : activityUpdateDynObjArr) {
            tableValueSetter.addRow(new Object[]{activityUpdateDynObj.getLong("activity.id"), activityUpdateDynObj.getString("status"), activityUpdateDynObj.getLong("id")});
        }
        model.batchCreateNewEntryRow("activityentryentity", tableValueSetter);
    }

    private void initSchemeUpdateData() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("schemeentryentity");
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "!=", (Object)1000000L), new QFilter("activity", "=", (Object)0L)};
        DynamicObject[] schemeUpdateDynObjArr = DYN_PERM_UPDATE_RECORD_ENTITY_SERVICE.query("name,number,status", qFilters, "status asc, modifytime desc");
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        tableValueSetter.addField("schemenumber", new Object[0]);
        tableValueSetter.addField("schemename", new Object[0]);
        tableValueSetter.addField("schemeupgraderesult", new Object[0]);
        tableValueSetter.addField("schemeupdaterecord", new Object[0]);
        for (DynamicObject schemeUpdateDynObj : schemeUpdateDynObjArr) {
            tableValueSetter.addRow(new Object[]{schemeUpdateDynObj.getString("number"), schemeUpdateDynObj.getString("name"), schemeUpdateDynObj.getString("status"), schemeUpdateDynObj.getLong("id")});
        }
        model.batchCreateNewEntryRow("schemeentryentity", tableValueSetter);
    }

    public void entryRowClick(RowClickEvent evt) {
        long updateRecordId;
        DynamicObject updateDateDynObj;
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        String entryKey = entryGrid.getEntryKey();
        int rowIndex = evt.getRow();
        if (rowIndex == -1) {
            return;
        }
        if ("schemeentryentity".equals(entryKey)) {
            updateDateDynObj = this.getModel().getEntryRowEntity("schemeentryentity", rowIndex);
            if (UPGRADE_SUCCESS_FLAG.equals(updateDateDynObj.getString("schemeupgraderesult"))) {
                return;
            }
            updateRecordId = updateDateDynObj.getLong("schemeupdaterecord.id");
        } else {
            updateDateDynObj = this.getModel().getEntryRowEntity("activityentryentity", rowIndex);
            if (UPGRADE_SUCCESS_FLAG.equals(updateDateDynObj.getString("activityupgraderesult"))) {
                return;
            }
            updateRecordId = updateDateDynObj.getLong("activityupdaterecord.id");
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("epa_activityupdateinfo");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("recordId", (Object)updateRecordId);
        this.getView().showForm(formShowParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("activityupgrade".equals(operateKey)) {
            QFilter qFilter = new QFilter("status", "!=", (Object)UPGRADE_SUCCESS_FLAG);
            qFilter.and(new QFilter("id", "=", (Object)1000000L));
            if (DYN_PERM_UPDATE_RECORD_ENTITY_SERVICE.isExists(qFilter)) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5347\u7ea7\u8003\u6838\u6d3b\u52a8\u524d\uff0c\u8bf7\u5148\u5347\u7ea7\u8003\u6838\u8ba1\u5212\uff0c\u8c22\u8c22\u914d\u5408\u3002", (String)"UpgradePagePlugin_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                return;
            }
            QFilter activityFilter = new QFilter("dynamicpermission", "=", (Object)0L);
            if (!ACTIVITY_ENTITY.isExists(activityFilter)) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u5347\u7ea7\u5df2\u5b8c\u6210\uff0c\u4e0d\u652f\u6301\u91cd\u590d\u64cd\u4f5c\u3002", (String)"UpgradePagePlugin_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                return;
            }
            DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("customRegion");
            String key = "isUpdateActivity" + RequestContext.get().getTenantId();
            try {
                if (UPGRADE_SUCCESS_FLAG.equals(cache.get(key))) {
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u529f\u80fd\u5b9e\u65bd\u90e8\u7f72\u4e2d\uff0c\u8bf7\u524d\u5f80\u201c\u76ee\u6807\u7ee9\u6548\u4e91>\u4e2a\u4eba\u7ee9\u6548\u8003\u6838>\u57fa\u7840\u914d\u7f6e>\u7cfb\u7edf\u5347\u7ea7\u7ba1\u7406\u201d\u5347\u7ea7\u529f\u80fd\uff0c\u6570\u636e\u5347\u7ea7\u5b8c\u6210\u540e\uff0c\u63d0\u793a\u5c06\u4e0d\u518d\u51fa\u73b0\u3002\u5982\u65e0\u201d\u5347\u7ea7\u529f\u80fd\u201c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"UpgradePagePlugin_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                }
            }
            catch (Exception e) {
                String errorMsg = "cache error, read error: " + e.getMessage();
                LOG.error(errorMsg, (Throwable)e);
            }
        }
        if ("schemeupgrade".equals(operateKey)) {
            DynamicObject flagLogObj = BusinessDataServiceHelper.loadSingle((String)"epa_dynpermupdaterecord", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)1000000L)});
            if (flagLogObj == null) {
                flagLogObj = BusinessDataServiceHelper.newDynamicObject((String)"epa_dynpermupdaterecord");
                flagLogObj.set("id", (Object)1000000L);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{flagLogObj});
            } else if (UPGRADE_SUCCESS_FLAG.equals(flagLogObj.getString("status"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u5347\u7ea7\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01", (String)"UpgradePagePlugin_3", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else if (flagLogObj.getString("status") == null || "".equals(flagLogObj.getString("status"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5347\u7ea7\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01", (String)"UpgradePagePlugin_4", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else {
                flagLogObj.set("status", (Object)"");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{flagLogObj});
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        HashMap<String, Object> params;
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("activityupgrade".equals(operateKey)) {
            params = new HashMap<String, Object>(16);
            ActivityDispatchUtils.dispatch((AbstractFormPlugin)this, params, AtivityPermUpdateTask.class.getName(), ResManager.loadKDString((String)"\u5347\u7ea7\u6d3b\u52a8", (String)"UpgradePagePlugin_5", (String)"opmc-epa-formplugin", (Object[])new Object[0]), true, "activityupgrade");
        }
        if ("schemeupgrade".equals(operateKey)) {
            params = new HashMap(16);
            ActivityDispatchUtils.dispatch((AbstractFormPlugin)this, params, DynPermMigrateTask.class.getName(), ResManager.loadKDString((String)"\u6743\u9650\u8fc1\u79fb", (String)"UpgradePagePlugin_6", (String)"opmc-epa-formplugin", (Object[])new Object[0]), true, "schemeupgrade");
        }
        if ("refreshscheme".equals(operateKey)) {
            this.initSchemeUpdateData();
        }
        if ("refreshactivity".equals(operateKey)) {
            this.initActivityUpdateData();
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("activityupgrade".equals(actionId)) {
            this.getView().updateView("activityentryentity");
        }
        if ("schemeupgrade".equals(actionId)) {
            this.getView().updateView("schemeentryentity");
        }
    }
}

