/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.utils;

import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.container.TabPage;
import kd.opmc.epa.business.application.service.activitymanage.process.ProcessExecuteApplicationService;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.pbs.business.domain.assessnode.enums.NodeTabMapEnum;

public class ActManageUtils {
    private static final ProcessExecuteApplicationService PROCESS_EXECUTE_APPLICATION_SERVICE = ProcessExecuteApplicationService.getInstance();

    private ActManageUtils() {
    }

    public static void refreshFormulatedCount(IFormView iFormView, Long activityId) {
        IFormView parentView = iFormView.getParentView();
        if (!ObjectUtils.isEmpty((Object)parentView)) {
            Map<String, Integer> tabCountMap = ActManageUtils.getTabCountMap(iFormView, parentView, NodeTabMapEnum.TARGET_FORMU_LATE.getNodeId());
            Map joinInCountMap = PROCESS_EXECUTE_APPLICATION_SERVICE.queryJoinInCountByActId(activityId);
            int tobeFormulatedCount = (Integer)joinInCountMap.get("joined");
            int formulatingCount = tabCountMap.get(AssessNodeStatusEnum.TARGET_FORMULATING.getLabelName());
            int completedCount = tabCountMap.get(AssessNodeStatusEnum.TARGET_FORMULATED.getLabelName());
            TabPage tobeFormulatedAp = (TabPage)parentView.getControl("tobeformulatedap");
            TabPage formulatingAp = (TabPage)parentView.getControl("formulatingap");
            TabPage formulatedAp = (TabPage)parentView.getControl("formulatedap");
            tobeFormulatedAp.setText(new LocaleString(ResManager.loadKDString((String)"\u5f85\u5236\u5b9a\uff08%s\uff09", (String)"ActManageUtils_0", (String)"opmc-epa-formplugin", (Object[])new Object[]{tobeFormulatedCount})));
            formulatingAp.setText(new LocaleString(ResManager.loadKDString((String)"\u5236\u5b9a\u4e2d\uff08%s\uff09", (String)"ActManageUtils_1", (String)"opmc-epa-formplugin", (Object[])new Object[]{formulatingCount})));
            formulatedAp.setText(new LocaleString(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\uff08%s\uff09", (String)"ActManageUtils_2", (String)"opmc-epa-formplugin", (Object[])new Object[]{completedCount})));
            iFormView.sendFormAction(parentView);
        }
    }

    public static void refreshEvaluateCount(IFormView iFormView) {
        IFormView parentView = iFormView.getParentView();
        if (!ObjectUtils.isEmpty((Object)parentView)) {
            Map<String, Integer> tabCountMap = ActManageUtils.getTabCountMap(iFormView, parentView, NodeTabMapEnum.EVAL_PROCESS.getNodeId());
            int tobeevaluatedCount = tabCountMap.get(AssessNodeStatusEnum.TO_BE_EVALUATED.getLabelName());
            int evaluatingCount = tabCountMap.get(AssessNodeStatusEnum.EVALUATING.getLabelName());
            int completedCount = tabCountMap.get(AssessNodeStatusEnum.EVALUATED.getLabelName());
            TabPage tobeEvaluatedAp = (TabPage)parentView.getControl("tobeevaluatedap");
            TabPage evaluatingAp = (TabPage)parentView.getControl("evaluatingap");
            TabPage evaluatedAp = (TabPage)parentView.getControl("evaluatedap");
            tobeEvaluatedAp.setText(new LocaleString(ResManager.loadKDString((String)"\u5f85\u542f\u52a8\uff08%s\uff09", (String)"ActManageUtils_3", (String)"opmc-epa-formplugin", (Object[])new Object[]{tobeevaluatedCount})));
            evaluatingAp.setText(new LocaleString(ResManager.loadKDString((String)"\u8bc4\u4f30\u4e2d\uff08%s\uff09", (String)"ActManageUtils_4", (String)"opmc-epa-formplugin", (Object[])new Object[]{evaluatingCount})));
            evaluatedAp.setText(new LocaleString(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\uff08%s\uff09", (String)"ActManageUtils_2", (String)"opmc-epa-formplugin", (Object[])new Object[]{completedCount})));
            iFormView.sendFormAction(parentView);
        }
    }

    private static Map<String, Integer> getTabCountMap(IFormView iFormView, IFormView parentView, Long nodeId) {
        IDataModel parentModel = parentView.getModel();
        Long activityId = (Long)parentModel.getDataEntity().getPkValue();
        int nodeIndex = (Integer)iFormView.getFormShowParameter().getCustomParam("nodeindex");
        return PROCESS_EXECUTE_APPLICATION_SERVICE.queryNodeCountByActId(activityId, Integer.valueOf(nodeIndex), nodeId);
    }

    public static void refreshConfirmCount(IFormView iFormView) {
        IFormView parentView = iFormView.getParentView();
        if (!ObjectUtils.isEmpty((Object)parentView)) {
            Map<String, Integer> tabCountMap = ActManageUtils.getTabCountMap(iFormView, parentView, NodeTabMapEnum.RESULT_CONFIRM.getNodeId());
            int tobeConfirmedCount = tabCountMap.get(AssessNodeStatusEnum.TO_BE_CONFIRMED.getLabelName());
            int confirmingCount = tabCountMap.get(AssessNodeStatusEnum.CONFIRMING.getLabelName());
            int tobeAppealCount = tabCountMap.get(AssessNodeStatusEnum.TO_BE_APPEAL.getLabelName());
            int appealingCount = tabCountMap.get(AssessNodeStatusEnum.APPEALING.getLabelName());
            int terminateCount = tabCountMap.get(AssessNodeStatusEnum.TERMINATE.getLabelName());
            int confirmedCount = tabCountMap.get(AssessNodeStatusEnum.CONFIRMED.getLabelName());
            TabPage toConfirmedAp = (TabPage)parentView.getControl("tobeconfirmedap");
            TabPage confirmingAp = (TabPage)parentView.getControl("confirmingap");
            TabPage confirmedAp = (TabPage)parentView.getControl("confirmedap");
            toConfirmedAp.setText(new LocaleString(ResManager.loadKDString((String)"\u5f85\u786e\u8ba4\uff08%s\uff09", (String)"ActManageUtils_5", (String)"opmc-epa-formplugin", (Object[])new Object[]{tobeConfirmedCount})));
            confirmingAp.setText(new LocaleString(ResManager.loadKDString((String)"\u786e\u8ba4\u4e2d\uff08%s\uff09", (String)"ActManageUtils_6", (String)"opmc-epa-formplugin", (Object[])new Object[]{confirmingCount + tobeAppealCount + appealingCount + terminateCount})));
            confirmedAp.setText(new LocaleString(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\uff08%s\uff09", (String)"ActManageUtils_2", (String)"opmc-epa-formplugin", (Object[])new Object[]{confirmedCount})));
            iFormView.sendFormAction(parentView);
        }
    }

    public static void refreshPerformSummaryCount(IFormView view, IFormView parentView, Long preNode, Long activityId) {
        if (!ObjectUtils.isEmpty((Object)parentView)) {
            Map result = PROCESS_EXECUTE_APPLICATION_SERVICE.queryPerformSummaryCountByActId(activityId, preNode, Long.valueOf(5L));
            int toBePerformSummaryCount = (Integer)result.get("notcompletedCount");
            int performSummaryedCount = (Integer)result.get("completedCount");
            TabPage toperformsumAp = (TabPage)parentView.getControl("toperformsum");
            TabPage performsumedAp = (TabPage)parentView.getControl("performsumed");
            toperformsumAp.setText(new LocaleString(ResManager.loadKDString((String)"\u5f85\u6c47\u603b\uff08%s\uff09", (String)"ActManageUtils_7", (String)"opmc-epa-formplugin", (Object[])new Object[]{toBePerformSummaryCount})));
            performsumedAp.setText(new LocaleString(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\uff08%s\uff09", (String)"ActManageUtils_2", (String)"opmc-epa-formplugin", (Object[])new Object[]{performSummaryedCount})));
            view.sendFormAction(parentView);
        }
    }
}

