/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.utils;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.common.constants.AssessRuleConstants;
import kd.opmc.pbs.common.constants.NodeTypeConstants;

public class AssignIndicatorPageUtils {
    private static final String CHANGE_DATE = "changeDate";

    public static void showActivityCardInfo(IFormView view, Long activityId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("epa_activityabstract");
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setCustomParam("activityId", (Object)activityId);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("activityinfoflex");
        showParameter.setHasRight(true);
        view.showForm(showParameter);
    }

    public static String getIndicatorGroupMetaName() {
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)"epa_indicatorgroup_base", (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Entity);
        LocaleString name = entityMetadata.getName();
        return name.toString();
    }

    public static void validateAreaMustEnterField(IFormView view, AfterDoOperationEventArgs args) {
        String formId = view.getFormShowParameter().getFormId();
        ArrayList<OperateErrorInfo> errorInfoList = new ArrayList<OperateErrorInfo>();
        OperationResult operationResult = args.getOperationResult();
        DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("entryentity");
        String entityId = view.getEntityId();
        StringBuilder cacheKay = new StringBuilder("indicatorMustInput_");
        if ("epa_genareains_assign".equals(entityId)) {
            cacheKay.append(AssessRuleConstants.NORM_INDCTR_AREA_PK);
        } else if ("epa_addsubareains_assign".equals(entityId)) {
            cacheKay.append(AssessRuleConstants.PLUS_MINUS_AREA_PK);
        } else if ("epa_attachareains_assign".equals(entityId)) {
            cacheKay.append(AssessRuleConstants.ATTACH_AREA_PK);
        }
        cacheKay.append('_');
        Long confid = (Long)view.getFormShowParameter().getCustomParam("confid");
        cacheKay.append(confid);
        String cacheValue = view.getParentView().getPageCache().get(cacheKay.toString());
        if (!HRStringUtils.isEmpty((String)cacheValue)) {
            List mustInputFieldList = (List)JSON.parseObject((String)cacheValue, List.class);
            block0: for (DynamicObject insDy : entryEntity) {
                if (AssignIndicatorPageUtils.notValidate(view, insDy)) continue;
                boolean validate = true;
                for (String field : mustInputFieldList) {
                    Object value = insDy.get(field);
                    if (AssignIndicatorPageUtils.isEmpty(value)) {
                        validate = false;
                    }
                    if (validate) continue;
                    OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                    operateErrorInfo.setLevel(ErrorLevel.Warning);
                    String indctrName = HRStringUtils.equals((String)formId, (String)"epa_attachareains_assign") ? insDy.getString("keyactname") : insDy.getString("indctrname");
                    operateErrorInfo.setMessage(ResManager.loadKDString((String)"{0}. {1}\u6307\u6807\u5fc5\u586b\u9879\u5b58\u5728\u672a\u586b\u5199", (String)"AssignIndicatorPageUtils_2", (String)"opmc-epa-formplugin", (Object[])new Object[]{errorInfoList.size() + 1, indctrName}));
                    errorInfoList.add(operateErrorInfo);
                    continue block0;
                }
            }
            operationResult.setMessage(view.getPageCache().get("validate_areacustname"));
        }
        operationResult.setSuccess(HRCollUtil.isEmpty(errorInfoList));
        operationResult.setAllErrorInfo(errorInfoList);
    }

    private static boolean notValidate(IFormView view, DynamicObject instance) {
        String entityId = view.getEntityId();
        boolean isGen = "epa_addsubareains_assign".equals(entityId) || "epa_genareains_assign".equals(entityId);
        long flowRuNode = instance.getLong("flowrunode");
        long currentNodeId = Long.parseLong(view.getParentView().getPageCache().get("currentNodeId"));
        Long typeId = Long.valueOf(view.getParentView().getPageCache().get("nodeTypeId"));
        if (typeId.equals(NodeTypeConstants.INDICATOR_FORMULATE)) {
            if ("epa_attachareains_assign".equals(entityId) && instance.getBoolean("ispreinstall")) {
                return true;
            }
            if (isGen && instance.getBoolean("ispreinstall") && !instance.getBoolean("iseditable")) {
                return true;
            }
            if (flowRuNode != 0L && flowRuNode != currentNodeId) {
                return true;
            }
            if (isGen) {
                boolean isEdiTable = instance.getBoolean("iseditable");
                Long flowRuNodeId = instance.getLong("flowrunode");
                if (HRObjectUtils.equals((Object)0L, (Object)flowRuNodeId) && !isEdiTable) {
                    return true;
                }
            }
        }
        boolean canEdit = Boolean.parseBoolean(view.getParentView().getPageCache().get("reviewercanedit"));
        if (NodeTypeConstants.INDICATOR_AUDIT.equals(typeId) && !canEdit) {
            return true;
        }
        return NodeTypeConstants.INDICATOR_CONFIRM.equals(typeId);
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof DynamicObject) {
            return ((DynamicObject)obj).getLong("id") == 0L;
        }
        if (obj instanceof String) {
            return ((String)obj).trim().equals("");
        }
        if (obj instanceof OrmLocaleValue) {
            return obj.toString() == null || obj.toString().trim().equals("");
        }
        return false;
    }
}

