/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.utils;

import java.util.ArrayList;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class ChangeNodeNameUtils {
    private static final Pattern IS_NUMBER = Pattern.compile("-?\\d+(\\.\\d+)?");
    private static final String LEFT_BRACKET = "(";
    private static final String RIGHT_BRACKET = ")";

    public static boolean checkNodeName(String nodeName, String initName) {
        return HRStringUtils.equals((String)nodeName, (String)initName) || nodeName.startsWith(initName) && nodeName.endsWith(RIGHT_BRACKET) && nodeName.contains(LEFT_BRACKET) && IS_NUMBER.matcher(nodeName.substring(nodeName.lastIndexOf(LEFT_BRACKET) + 1, nodeName.length() - 1)).matches();
    }

    public static String changeNodeName(List<String> nodeNames, String nodeName, boolean type) {
        if (HRStringUtils.isEmpty((String)nodeName)) {
            return null;
        }
        if (nodeName.endsWith(RIGHT_BRACKET) && nodeName.contains(LEFT_BRACKET) && IS_NUMBER.matcher(nodeName.substring(nodeName.lastIndexOf(LEFT_BRACKET) + 1, nodeName.length() - 1)).matches()) {
            String substring = nodeName.substring(0, nodeName.lastIndexOf(LEFT_BRACKET));
            nodeName = StringUtils.isBlank((CharSequence)substring) ? nodeName : substring;
        }
        ArrayList<Integer> sum = new ArrayList<Integer>(16);
        int flag = 0;
        for (String name : nodeNames) {
            if (!HRStringUtils.equals((String)ChangeNodeNameUtils.removeNum(name), (String)nodeName)) continue;
            int index = name.lastIndexOf(nodeName);
            String seq = index == 0 ? name.replace(nodeName, "") : name.substring(index);
            String replace = seq.replace(RIGHT_BRACKET, "").replace(LEFT_BRACKET, "");
            if (type && HRStringUtils.isEmpty((String)replace)) {
                ++flag;
            }
            if (!name.endsWith(RIGHT_BRACKET) || !IS_NUMBER.matcher(replace).matches()) continue;
            sum.add(Integer.parseInt(replace));
        }
        IntSummaryStatistics collect = sum.stream().collect(Collectors.summarizingInt(x -> x));
        if (type && 1 == flag && 0 == sum.size()) {
            return nodeName + "(1)";
        }
        if (0 == sum.size()) {
            if (type) {
                return nodeName;
            }
            return nodeName + "(1)";
        }
        Integer max = collect.getMax() + 1;
        return nodeName + LEFT_BRACKET + max + RIGHT_BRACKET;
    }

    private static String removeNum(String name) {
        int index = name.lastIndexOf(LEFT_BRACKET);
        if (-1 == index) {
            return name;
        }
        return name.substring(0, name.lastIndexOf(LEFT_BRACKET));
    }
}

