/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.utils;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActivityEvaluationObjectApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssessObjectApplicationService;

public class EvalObjectVaildatorUtil {
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final ActivityEvaluationObjectApplicationService EVALUATION_OBJECT_APPLICATION_SERVICE = ActivityEvaluationObjectApplicationService.getInstance();
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final AssessObjectApplicationService ASSESS_OBJECT_APPLICATION_SERVICE = AssessObjectApplicationService.getInstance();

    private EvalObjectVaildatorUtil() {
    }

    private static void recordNotExistValidateMessage(DynamicObject object, StringBuilder message) {
        if (StringUtils.isNotBlank((CharSequence)message)) {
            message.append("\n");
        }
        message.append(ResManager.loadKDString((String)"{0}-{1}\uff1a\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u52a0\u5165\u8003\u6838\u6d3b\u52a8", (String)"EvalObjectVaildatorUtil_0", (String)"opmc-epa-formplugin", (Object[])new Object[]{object.getDynamicObject("person").getString("name"), object.getDynamicObject("person").getString("number")}));
    }

    private static void recordPerfTimeValidateMessage(DynamicObject object, StringBuilder message) {
        if (StringUtils.isNotBlank((CharSequence)message)) {
            message.append("\n");
        }
        message.append(ResManager.loadKDString((String)"{0}-{1}\uff1a\u6863\u6848\u6709\u6548\u671f\u95f4\u4e0d\u5728\u8003\u6838\u5468\u671f\u8d77\u6b62\u65e5\u671f\u5185", (String)"EvalObjectVaildatorUtil_1", (String)"opmc-epa-formplugin", (Object[])new Object[]{object.getDynamicObject("person").getString("name"), object.getDynamicObject("person").getString("number")}));
    }

    private static Set<Long> getJoinedObjIdsByAct(DynamicObject activity) {
        DynamicObject[] evaluationObject = EVALUATION_OBJECT_APPLICATION_SERVICE.queryEvaluationObjectByActId(Long.valueOf(activity.getLong("id")));
        return Arrays.stream(evaluationObject).map(obj -> obj.getLong("perffile.id")).collect(Collectors.toSet());
    }

    private static DynamicObject getCurActivity(Long activityId) {
        return ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne((Object)activityId);
    }

    public static boolean checkEvalObjectWithInput(IFormView view, DynamicObjectCollection col, Long activityId) {
        List perffileIds = col.stream().map(obj -> obj.getLong("perffile.id")).collect(Collectors.toList());
        DynamicObject curActivity = EvalObjectVaildatorUtil.getCurActivity(activityId);
        Set<Long> joinedObjIds = EvalObjectVaildatorUtil.getJoinedObjIdsByAct(curActivity);
        Date actStart = curActivity.getDate("periodstartdate");
        Date actEnd = curActivity.getDate("periodenddate");
        StringBuilder message = new StringBuilder();
        int fail = 0;
        DynamicObjectCollection successList = new DynamicObjectCollection();
        for (DynamicObject object : col) {
            if (object.getDynamicObject("group") == null) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u6709\u672a\u5206\u914d\u8003\u6838\u7ec4\u7684\u8bc4\u4f30\u5bf9\u8c61\uff0c\u8bf7\u68c0\u67e5\u8bbe\u7f6e\u8003\u6838\u7ec4\u3002", (String)"EvalObjectVaildatorUtil_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
                return false;
            }
            long perffileId = object.getLong("perffile.id");
            Date perfStartDate = object.getDate("perffile.startdate");
            Date perfEndDate = object.getDate("perffile.enddate");
            if (perfStartDate != null && perfEndDate != null && (perfEndDate.compareTo(actStart) < 0 || perfStartDate.compareTo(actEnd) > 0)) {
                EvalObjectVaildatorUtil.recordPerfTimeValidateMessage(object, message);
                ++fail;
                continue;
            }
            boolean joinedObj = joinedObjIds.contains(perffileId);
            if (joinedObj) {
                EvalObjectVaildatorUtil.recordNotExistValidateMessage(object, message);
                ++fail;
                continue;
            }
            successList.add((Object)object);
        }
        if (successList.size() != 0) {
            ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.saveAssessObjectWithInput(view, curActivity, successList);
            Long schemeId = curActivity.getLong("scheme.id");
            ASSESS_OBJECT_APPLICATION_SERVICE.saveAssessObjectWithInput(schemeId, successList, curActivity);
        }
        if (fail > 0) {
            view.close();
            IFormView parentView = view.getParentView();
            String title = ResManager.loadKDString((String)"\u5171{0}\u6761\u5355\u636e\uff0c\u6dfb\u52a0\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761\u3002", (String)"EvalObjectVaildatorUtil_3", (String)"opmc-epa-formplugin", (Object[])new Object[]{col.size(), successList.size(), fail});
            parentView.showMessage(title, message.toString(), MessageTypes.Default);
            parentView.invokeOperation("refresh");
            view.sendFormAction(parentView);
            return false;
        }
        return true;
    }
}

