/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.utils;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.field.ComboItem;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.hr.hbp.common.control.HRLabelAp;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.application.service.evaluating.ActEvalObjDetailApplicationService;
import kd.opmc.epa.business.domain.activitymanage.enums.ScalaTypeEnum;
import kd.opmc.epa.common.constants.AreaFieldConstants;
import kd.opmc.epa.common.enums.assessrule.ScoreCalcWayEnum;
import kd.opmc.epa.common.enums.per.NodeTypeEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.common.utils.EntityMetaDataUtils;

public class EvalResultViewUtils
implements AreaFieldConstants {
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final ActEvalObjDetailApplicationService ACT_EVAL_OBJ_DETAIL_APPLICATION_SERVICE = ActEvalObjDetailApplicationService.getInstance();

    public static void initIndicatorInfo(DynamicObject indicatorDy, DynamicObject conf, IFormView view) {
        DynamicObjectCollection confEntryEntity = conf.getDynamicObjectCollection("entryentity");
        FlexPanelAp indicatorListAp = ((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder("indicatorpanelap").setDirection("column").setJustifyContent("flex-start").setAlignItems("stretch").setWrap(false).setPaddingTop("12px")).setPaddingRight("20px")).setPaddingLeft("20px")).setPaddingTop("10px")).setGrow(0).setShrink(0).setBackColor("#ffffff").build();
        int numAccuracy = Integer.parseInt((String)view.getFormShowParameter().getCustomParam("numaccuracy"));
        int roundingMode = ScalaTypeEnum.get((String)((String)view.getFormShowParameter().getCustomParam("scaletype"))).getType();
        int index = 0;
        for (DynamicObject fieldInfo : confEntryEntity) {
            String fieldKey = fieldInfo.getString("areafield.number");
            String fieldCategory = fieldInfo.getString("areafield.category");
            if (!HRStringUtils.equals((String)fieldCategory, (String)"10") && !HRStringUtils.equals((String)fieldCategory, (String)"20") || ObjectUtils.isEmpty((Object)indicatorDy.getDataEntityType().getProperties().get((Object)fieldKey))) continue;
            String fieldName = fieldInfo.getString("fieldcustname");
            String value = EvalResultViewUtils.FormatFieldValue(indicatorDy, fieldKey, numAccuracy, roundingMode);
            FlexPanelAp indicatorAp = ((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder("indicatorap" + index).setDirection("row").setWrap(false).setMarginBottom("4px")).setBackColor("#ffffff").build();
            LabelAp nameLab = new HRLabelAp.Builder("indicatorkey" + index).setWidth(new LocaleString("60px")).setForeColor("#666666").setTextAlign("right").setGrow(0).setShrink(0).setName(fieldName + "\uff1a").build();
            indicatorAp.getItems().add(nameLab);
            FlexPanelAp valueAp = new HRFlexPanelAp.Builder("indicatorvalueap" + index).setDirection("row").setWrap(false).setBackColor("#ffffff").build();
            LabelAp valueLab = new HRLabelAp.Builder("indicatorvalue" + index).setAutoTextWrap(true).setGrow(0).setShrink(1).setName(value).build();
            valueAp.getItems().add(valueLab);
            indicatorAp.getItems().add(valueAp);
            indicatorListAp.getItems().add(indicatorAp);
        }
        view.updateControlMetadata(indicatorListAp.getKey(), indicatorListAp.createControl());
    }

    private static String FormatFieldValue(DynamicObject indicatorDy, String fieldKey, int numAccuracy, int roundingMode) {
        String value = "";
        if (ObjectUtils.isEmpty((Object)indicatorDy.get(fieldKey))) {
            return value;
        }
        value = indicatorDy.get(fieldKey) instanceof BigDecimal ? indicatorDy.getBigDecimal(fieldKey).setScale(numAccuracy, roundingMode).toPlainString() : (indicatorDy.get(fieldKey) instanceof Date ? (ObjectUtils.isEmpty((Object)indicatorDy.get(fieldKey)) ? "" : HRDateTimeUtils.formatDate((Date)indicatorDy.getDate(fieldKey))) : (indicatorDy.get(fieldKey) instanceof Boolean ? (indicatorDy.getBoolean(fieldKey) ? ResManager.loadKDString((String)"\u662f", (String)"EvalResultViewUtils_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"EvalResultViewUtils_1", (String)"opmc-epa-formplugin", (Object[])new Object[0])) : indicatorDy.getString(fieldKey)));
        if (HRStringUtils.equals((String)fieldKey, (String)"evaltype") || HRStringUtils.equals((String)fieldKey, (String)"evalmode")) {
            value = EntityMetaDataUtils.getEntityComboFieldItemName((String)indicatorDy.getDataEntityType().getName(), (String)fieldKey, (String)indicatorDy.getString(fieldKey));
        }
        return value;
    }

    public static void initEvalRecordInfo(DynamicObject[] evalRecords, DynamicObject conf, IFormView view) {
        AbstractFormDataModel model = (AbstractFormDataModel)view.getModel();
        model.beginInit();
        model.deleteEntryData("entryentity");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("handler", new Object[0]);
        vs.addField("indrecord", new Object[0]);
        vs.addField("flowrunode", new Object[0]);
        vs.addField("flowrurole", new Object[0]);
        for (DynamicObject recordDy : evalRecords) {
            vs.addRow(new Object[]{recordDy.get("flowrutask.handler.id"), recordDy.getPkValue(), recordDy.get("flowrunode.id"), recordDy.get("flowrurole.id")});
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        DynamicObjectCollection recordEntry = view.getModel().getEntryEntity("entryentity");
        for (DynamicObject record : recordEntry) {
            record.set("nodeweight", record.get("flowrunode.nodeweight"));
            record.set("roleweight", record.get("flowrurole.roleweight"));
            record.set("handlerhead", record.get("handler.picturefield"));
            record.set("ose", record.get("indrecord.soe"));
            record.set("evaldes", record.get("indrecord.evaldesc"));
        }
        model.endInit();
        view.updateView("entryentity");
        view.getModel().setDataChanged(false);
        String scoreCalcWay = (String)view.getFormShowParameter().getCustomParam("scorecalcway");
        if (!ScoreCalcWayEnum.SUM.getValue().equals(scoreCalcWay)) {
            view.setVisible(Boolean.FALSE, new String[]{"oseap"});
        }
        CardEntry sumRecordCard = (CardEntry)view.getControl("entryentity");
        Map<Long, Boolean> nodeIdMap = recordEntry.stream().collect(Collectors.toMap(filedInfo -> filedInfo.getLong("flowrunode.id"), filedInfo -> Boolean.TRUE, (v1, v2) -> v1));
        Map nodeTypeMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryNodeDefById(nodeIdMap.keySet());
        for (int i = 0; i < recordEntry.size(); ++i) {
            Long nodeId = ((DynamicObject)recordEntry.get(i)).getLong("flowrunode.id");
            if (nodeIdMap.get(nodeId).booleanValue()) {
                nodeIdMap.put(nodeId, Boolean.FALSE);
            } else {
                sumRecordCard.setChildVisible(false, i, new String[]{"nodeinfoap"});
            }
            if (!(conf == null || conf.getBoolean("isalloweval") && NodeTypeEnum.BATCH_ADJUST.getValue().longValue() != ((Long)nodeTypeMap.get(nodeId)).longValue())) {
                sumRecordCard.setChildVisible(false, i, new String[]{"oseap"});
            }
            if (conf == null || !StringUtils.isBlank((CharSequence)((DynamicObject)recordEntry.get(i)).getString("evaldes"))) continue;
            sumRecordCard.setChildVisible(false, i, new String[]{"evalap"});
        }
    }

    public static void showAreaInfoTips(IFormView view, String title, String content) {
        if (HRStringUtils.isEmpty((String)content)) {
            view.setVisible(Boolean.FALSE, new String[]{"tipsvector"});
            return;
        }
        HashMap<String, Tips> props = new HashMap<String, Tips>(16);
        Tips tips = new Tips();
        tips.setShowIcon(false);
        tips.setTitle(new LocaleString(title));
        tips.setTriggerType("hover");
        tips.setType("text");
        tips.setContent(new LocaleString(content));
        tips.setPlace("right");
        props.put("tips", tips);
        view.updateControlMetadata("tipsvector", props);
    }

    public static void hideFieldIfNull(CardEntry sumRecordCard, DynamicObjectCollection sumRecordEntry, int i, String ... fields) {
        for (String field : fields) {
            Object fieldVal = ((DynamicObject)sumRecordEntry.get(i)).get(field);
            if (HRObjectUtils.isEmpty((Object)fieldVal)) {
                sumRecordCard.setChildVisible(false, i, new String[]{field + "ap"});
                continue;
            }
            if (!(fieldVal instanceof BigDecimal) || ((BigDecimal)fieldVal).compareTo(BigDecimal.ZERO) > 0) continue;
            sumRecordCard.setChildVisible(false, i, new String[]{field + "ap"});
        }
    }

    public static DynamicObjectCollection initRecordEntryData(IFormView view, DynamicObject ruleDy, List<DynamicObject> recordList) {
        int numAccuracy = ruleDy.getInt("numaccuracy");
        int roundingMode = ScalaTypeEnum.get((String)ruleDy.getString("scaletype")).getType();
        AbstractFormDataModel model = (AbstractFormDataModel)view.getModel();
        model.beginInit();
        model.deleteEntryData("sumrecordentry");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("handler", new Object[0]);
        vs.addField("flowrunode", new Object[0]);
        vs.addField("flowrurole", new Object[0]);
        vs.addField("ose", new Object[0]);
        vs.addField("ole", new Object[0]);
        vs.addField("eval", new Object[0]);
        List perfLevelItems = ACT_EVAL_OBJ_DETAIL_APPLICATION_SERVICE.queryPerfLevelItemByRule(Long.valueOf(ruleDy.getLong("id")));
        for (DynamicObject recordDy : recordList) {
            BigDecimal ose = recordDy.getBigDecimal("ose");
            String oseStr = "";
            if (ose != null) {
                oseStr = ose.setScale(numAccuracy, roundingMode).toPlainString();
            }
            vs.addRow(new Object[]{recordDy.get("flowrutask.handler.id"), recordDy.get("flowrunode"), recordDy.get("flowrurole"), oseStr, EvalResultViewUtils.getOle(perfLevelItems, recordDy.getString("ole")), recordDy.get("eval")});
        }
        long objId = view.getModel().getDataEntity().getLong("id");
        DynamicObject[] adjRecords = ACT_EVAL_OBJ_DETAIL_APPLICATION_SERVICE.queryBatchAdjScoreRecord(objId);
        Arrays.stream(adjRecords).filter(record -> StringUtils.equals((CharSequence)record.getString("flowrutask.taskstatus"), (CharSequence)FlowRuTaskStatusEnum.PROCESSED.getCode())).forEach(record -> vs.addRow(new Object[]{record.get("flowrutask.handler.id"), record.get("flowrunode"), record.get("flowrurole"), EvalResultViewUtils.formatAdjOse(numAccuracy, roundingMode, record), EvalResultViewUtils.formatAdjOle(perfLevelItems, record), record.get("ins")}));
        long evalFlowInstId = view.getModel().getDataEntity().getLong("evalflowins.id");
        DynamicObject[] genAreaRecord = ACT_EVAL_OBJ_DETAIL_APPLICATION_SERVICE.queryGenRecordByActEvalObjId(Long.valueOf(objId), Long.valueOf(evalFlowInstId));
        List crossTaskIdList = Arrays.stream(genAreaRecord).filter(record -> record.getBoolean("flowrunode.iscrossnode")).map(record -> record.getLong("flowrutask")).collect(Collectors.toList());
        Arrays.stream(genAreaRecord).filter(record -> crossTaskIdList.contains(record.getLong("flowrutask"))).forEach(record -> vs.addRow(new Object[]{"", record.get("flowrunode.id"), record.get("flowrurole.id"), "", "", ""}));
        model.batchCreateNewEntryRow("sumrecordentry", vs);
        DynamicObjectCollection sumRecordEntry = view.getModel().getEntryEntity("sumrecordentry");
        for (DynamicObject sumRecord : sumRecordEntry) {
            sumRecord.set("nodeweight", sumRecord.get("flowrunode.nodeweight"));
            sumRecord.set("roleweight", sumRecord.get("flowrurole.roleweight"));
            sumRecord.set("handlerhead", sumRecord.get("handler.picturefield"));
        }
        List sortSumRecords = sumRecordEntry.stream().sorted(Comparator.comparingInt(dy -> dy.getInt("flowrunode.index"))).collect(Collectors.toList());
        TableValueSetter sortVs = new TableValueSetter(new String[0]);
        sortVs.addField("handler", new Object[0]);
        sortVs.addField("flowrunode", new Object[0]);
        sortVs.addField("flowrurole", new Object[0]);
        sortVs.addField("nodeweight", new Object[0]);
        sortVs.addField("roleweight", new Object[0]);
        sortVs.addField("handlerhead", new Object[0]);
        sortVs.addField("ose", new Object[0]);
        sortVs.addField("eval", new Object[0]);
        sortVs.addField("ole", new Object[0]);
        for (DynamicObject recordDy : sortSumRecords) {
            sortVs.addRow(new Object[]{recordDy.get("handler.id"), recordDy.get("flowrunode.id"), recordDy.get("flowrurole.id"), recordDy.get("nodeweight"), recordDy.get("roleweight"), recordDy.get("handlerhead"), recordDy.get("ose"), recordDy.get("eval"), recordDy.get("ole")});
        }
        model.deleteEntryData("sumrecordentry");
        model.batchCreateNewEntryRow("sumrecordentry", sortVs);
        model.endInit();
        view.updateView("sumrecordentry");
        view.getModel().setDataChanged(false);
        return sumRecordEntry;
    }

    private static String formatAdjOle(List<ComboItem> perfLevelItems, DynamicObject record) {
        String batcl = EvalResultViewUtils.getOle(perfLevelItems, record.getString("batcl"));
        String atcl = EvalResultViewUtils.getOle(perfLevelItems, record.getString("atcl"));
        if (HRStringUtils.isEmpty((String)batcl)) {
            return atcl;
        }
        if (HRStringUtils.isNotEmpty((String)atcl)) {
            return batcl + " \u2192 " + atcl;
        }
        return "";
    }

    private static String formatAdjOse(int numAccuracy, int roundingMode, DynamicObject record) {
        BigDecimal batcs = record.getBigDecimal("batcs");
        BigDecimal atcs = record.getBigDecimal("atcs");
        if (atcs == null) {
            return "";
        }
        String atcsStr = atcs.setScale(numAccuracy, roundingMode).toPlainString();
        if (batcs == null) {
            return atcsStr;
        }
        return batcs.setScale(numAccuracy, roundingMode).toPlainString() + " \u2192 " + atcsStr;
    }

    private static String getOle(List<ComboItem> perfLevelItems, String ole) {
        String oleStr = "";
        Optional<ComboItem> oleItem = perfLevelItems.stream().filter(perfLevelItem -> HRStringUtils.equals((String)perfLevelItem.getValue(), (String)ole)).findFirst();
        if (oleItem.isPresent()) {
            oleStr = oleItem.get().getCaption().getLocaleValue();
        }
        return oleStr;
    }
}

