/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.utils;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.field.ComboItem;
import kd.bos.portal.util.SerializationUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.evaluating.ActEvalObjDetailApplicationService;
import kd.opmc.epa.business.domain.evaluating.entity.ContentFieldEntryEvaDto;
import kd.opmc.epa.business.domain.evaluating.entityservice.ObjGenAreaIndAssignEntityService;
import kd.opmc.epa.common.constants.AssessRuleConstants;
import kd.opmc.epa.common.enums.activitymanage.AreaRegEnum;
import kd.opmc.epa.common.enums.assessrule.ScoreCalcWayEnum;
import kd.opmc.epa.formplugin.web.utils.ObjEvaluationUtils;
import kd.opmc.pbs.business.domain.workflow.model.FlowRuNodeBo;
import kd.opmc.pbs.business.domain.workflow.model.FlowRuRoleBo;
import kd.opmc.pbs.business.domain.workflow.model.WorkflowRuProcBo;
import kd.opmc.pbs.business.domain.workflow.service.FlowRunSupDomainService;

public class IndicatorDetailUtils {
    private static final ActEvalObjDetailApplicationService APP_SERVICE = ActEvalObjDetailApplicationService.getInstance();
    private static final AssessActivityApplicationService ACTIVITY_SERVICE = AssessActivityApplicationService.getInstance();
    private static final ObjGenAreaIndAssignEntityService OBJ_GEN_AREA_IND_ASSIGN_ENTITY_SERVICE = ObjGenAreaIndAssignEntityService.getInstance();
    private static final FlowRunSupDomainService FLOW_RUN_SUP_DOMAIN_SERVICE = FlowRunSupDomainService.getInstance();
    private static final String RAREAFIELDREG_CATEGORY_INDICATORDES = "10";
    private static final int MAXSEQ = 40;
    private static final int MAX_ROLE_COUNT = 2;
    private static final String COMMON_AREA_CLICKED = "2";
    private static final String ANONYMOUS_STR = "***";

    public static void showIndicatorDetail(EntryGrid entryGrid, IFormView view, AreaRegEnum indctrArea, String areaMarker) {
        EntryData entryData;
        DynamicObject[] dataEntitys;
        DynamicObject dataEntity;
        DynamicObject indicator;
        IFormView parentView = view.getParentView();
        parentView.getPageCache().put("isHideSoePanel", "false");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            return;
        }
        IndicatorDetailUtils.hideEmptyAp(parentView);
        String isCloseRight = parentView.getPageCache().get("isCloseRight");
        if (!HRStringUtils.equals((String)isCloseRight, (String)"true")) {
            IndicatorDetailUtils.showCloseVector(parentView);
            parentView.setVisible(Boolean.TRUE, new String[]{"actevaldetial"});
            parentView.setVisible(Boolean.TRUE, new String[]{"indicatorpanelap"});
        }
        if ((indicator = (DynamicObject)(dataEntity = (dataEntitys = (entryData = entryGrid.getEntryData()).getDataEntitys())[selectRows[0]]).get("indicator")) != null) {
            String clickedId;
            String curIndicatorId = indicator.getPkValue().toString();
            if (HRStringUtils.equals((String)curIndicatorId, (String)(clickedId = parentView.getPageCache().get("clickedId")))) {
                return;
            }
            String indctrname = indicator.getString("indctrname");
            IndicatorDetailUtils.setLabelText("indicatorlabel", indctrname, parentView);
            if (indctrArea.getAreaPkId().equals(AssessRuleConstants.NORM_INDCTR_AREA_PK)) {
                indicator = OBJ_GEN_AREA_IND_ASSIGN_ENTITY_SERVICE.queryOne(indicator.getPkValue());
                String scoreCalcWay = (String)view.getFormShowParameter().getCustomParam("scorecalcway");
                if (ScoreCalcWayEnum.SUM.getValue().equals(scoreCalcWay)) {
                    BigDecimal indctrscore = indicator.getBigDecimal("indctrscore");
                    String indctrscoreStr = " (" + indctrscore.stripTrailingZeros().toPlainString() + ")";
                    IndicatorDetailUtils.setLabelText("indicatorlabel", indctrname + indctrscoreStr, parentView);
                } else if (ScoreCalcWayEnum.WEIGHT.getValue().equals(scoreCalcWay)) {
                    BigDecimal indctrWeight = indicator.getBigDecimal("weight");
                    String indctrWeightStr = " (" + indctrWeight.stripTrailingZeros().toPlainString() + "%)";
                    IndicatorDetailUtils.setLabelText("indicatorlabel", indctrname + indctrWeightStr, parentView);
                }
            }
            IndicatorDetailUtils.setDetailInfo(dataEntity, parentView, indctrArea, areaMarker);
            IndicatorDetailUtils.setIndicatorDetail(view, indctrArea, indicator);
            parentView.updateView("actevaldetial");
            view.sendFormAction(parentView);
            parentView.getPageCache().put("clickedId", curIndicatorId);
        }
    }

    private static void setIndicatorDetail(IFormView view, AreaRegEnum indctrArea, DynamicObject indicator) {
        IFormView parentView = view.getParentView();
        String confId = parentView.getPageCache().get("confId");
        DynamicObject conf = null;
        if (indctrArea.name().equals("NORM_INDCTR_AREA")) {
            conf = ACTIVITY_SERVICE.queryNormalConfigByPk(Long.valueOf(confId));
            IndicatorDetailUtils.isHideSoePanel(conf, parentView);
        } else if (indctrArea.name().equals("PLUS_MINUS_AREA")) {
            conf = ACTIVITY_SERVICE.queryPlusMinusConfigByPk(Long.valueOf(confId));
        }
        if (conf == null) {
            return;
        }
        DynamicObjectCollection entryEntity = conf.getDynamicObjectCollection("entryentity");
        FormShowParameter formShowParameter = view.getFormShowParameter();
        List<ContentFieldEntryEvaDto> fieldEntryEvaDtos = ObjEvaluationUtils.getPermFieldSetting(formShowParameter);
        Map<Long, ContentFieldEntryEvaDto> filePermMap = IndicatorDetailUtils.change2PermMap(fieldEntryEvaDtos);
        List<String> blackList = Arrays.asList("indctrname", "weight", "indctrscore");
        int seq = 0;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        if (entryEntity != null) {
            for (DynamicObject configCol : entryEntity) {
                String fieldNumber = configCol.getString("areafield.number");
                if (!indicator.containsProperty(fieldNumber)) continue;
                String fieldCategory = configCol.getString("areafield.category");
                String fieldcustname = configCol.getString("fieldcustname");
                long areaFieldId = configCol.getLong("areafield.id");
                ContentFieldEntryEvaDto permFileDto = filePermMap.get(areaFieldId);
                Boolean displayItem = Boolean.FALSE;
                Boolean modifyItem = Boolean.FALSE;
                if (permFileDto != null) {
                    displayItem = permFileDto.getFieldDisplayItem() == null ? Boolean.FALSE : permFileDto.getFieldDisplayItem();
                    Boolean bl = modifyItem = permFileDto.getFieldModifyItem() == null ? Boolean.FALSE : permFileDto.getFieldModifyItem();
                }
                if (!fieldCategory.equals(RAREAFIELDREG_CATEGORY_INDICATORDES) || blackList.contains(fieldNumber) || !displayItem.booleanValue() || fieldNumber.startsWith("customfiled") && modifyItem.booleanValue()) continue;
                parentView.setVisible(Boolean.TRUE, new String[]{"indicatorap" + ++seq});
                Label keyLabel = (Label)parentView.getControl("indicatorkey" + seq);
                keyLabel.setText(fieldcustname + "\uff1a");
                Label valueLabel = (Label)parentView.getControl("indicatorval" + seq);
                String fieldValue = indicator.getString(fieldNumber);
                if (fieldValue == null || HRStringUtils.equals((String)fieldValue, (String)"")) {
                    fieldValue = "-";
                }
                if (fieldNumber.equals("evaltype")) {
                    String evaltype = IndicatorDetailUtils.getEnumName(indicator, "evaltype");
                    valueLabel.setText(evaltype);
                    continue;
                }
                Object value = indicator.get(fieldNumber);
                if (value instanceof Date) {
                    String dateFormate = format.format(value);
                    valueLabel.setText(dateFormate);
                    if (dateFormate != null && !HRStringUtils.equals((String)dateFormate, (String)"")) continue;
                    valueLabel.setText("-");
                    continue;
                }
                if (value instanceof BigDecimal) {
                    String numaccuracyStr = (String)view.getFormShowParameter().getCustomParam("numaccuracy");
                    if (numaccuracyStr == null) continue;
                    int numaccuracy = Integer.parseInt(numaccuracyStr);
                    BigDecimal bigDecimalVal = indicator.getBigDecimal(fieldNumber) == null ? BigDecimal.ZERO : indicator.getBigDecimal(fieldNumber);
                    valueLabel.setText(bigDecimalVal.setScale(numaccuracy).toPlainString());
                    continue;
                }
                valueLabel.setText(fieldValue);
            }
        }
        for (int i = seq + 1; i <= 40; ++i) {
            parentView.setVisible(Boolean.FALSE, new String[]{"indicatorap" + i});
        }
    }

    private static Map<Long, ContentFieldEntryEvaDto> change2PermMap(List<ContentFieldEntryEvaDto> fieldEntryEvaDtos) {
        HashMap<Long, ContentFieldEntryEvaDto> filePermMap = new HashMap<Long, ContentFieldEntryEvaDto>(16);
        if (fieldEntryEvaDtos != null) {
            for (ContentFieldEntryEvaDto fieldEntryEvaDto : fieldEntryEvaDtos) {
                if (fieldEntryEvaDto == null) continue;
                filePermMap.put(fieldEntryEvaDto.getAreaFieldId(), fieldEntryEvaDto);
            }
        }
        return filePermMap;
    }

    private static void isHideSoePanel(DynamicObject conf, IFormView parentView) {
        boolean isalloweval = conf.getBoolean("isalloweval");
        if (!isalloweval) {
            parentView.getPageCache().put("isHideSoePanel", "true");
        } else {
            parentView.getPageCache().put("isHideSoePanel", "false");
        }
    }

    private static String getEnumName(DynamicObject indicatorObj, String label) {
        String labelValue = indicatorObj.getString(label);
        DataEntityPropertyCollection properties = indicatorObj.getDataEntityType().getProperties();
        ComboProp comboUnitProp = (ComboProp)properties.get((Object)label);
        String labelName = comboUnitProp.getItemByName(labelValue);
        return labelName;
    }

    private static void hideEmptyAp(IFormView parentView) {
        parentView.setVisible(Boolean.FALSE, new String[]{"emptyap"});
        parentView.setVisible(Boolean.TRUE, new String[]{"otherevaltitle", "evaluationlist", "indicatorpanelap"});
    }

    private static void showCloseVector(IFormView parentView) {
        parentView.setVisible(Boolean.FALSE, new String[]{"openrightvectorap"});
        parentView.setVisible(Boolean.TRUE, new String[]{"closerightvectorap"});
    }

    private static void setDetailInfo(DynamicObject dataEntity, IFormView parentView, AreaRegEnum indctrArea, String areaMarker) {
        if (indctrArea.name().equals("NORM_INDCTR_AREA") || indctrArea.name().equals("PLUS_MINUS_AREA")) {
            IndicatorDetailUtils.setGrow(0, parentView);
        } else {
            IndicatorDetailUtils.setGrow(1, parentView);
        }
        long indicatorId = dataEntity.getLong("indicator.id");
        List<Long> indicatorIds = Collections.singletonList(indicatorId);
        parentView.getPageCache().put("indicatorIds", SerializationUtils.toJsonString(indicatorIds));
        parentView.getPageCache().put("indctrArea", SerializationUtils.toJsonString((Object)indctrArea));
        Map recordHisMap = APP_SERVICE.queryIndicatorEvalRecordHisDesc(indicatorIds, indctrArea);
        List hisList = (List)recordHisMap.get(indicatorId);
        if (hisList == null) {
            parentView.setVisible(Boolean.FALSE, new String[]{"otherevalap"});
        } else {
            parentView.setVisible(Boolean.TRUE, new String[]{"otherevalap"});
        }
        if (hisList != null && hisList.size() > 2) {
            parentView.setVisible(Boolean.TRUE, new String[]{"viewdetail"});
        } else {
            parentView.setVisible(Boolean.FALSE, new String[]{"viewdetail"});
        }
        IndicatorDetailUtils.showEvaluationList(hisList, parentView, "evaluationlist", 2, areaMarker);
    }

    private static void setGrow(int growVal, IFormView view) {
        HashMap<String, Integer> propsMap = new HashMap<String, Integer>(16);
        propsMap.put("gr", growVal);
        view.updateControlMetadata("otherevalap", propsMap);
    }

    public static void showEvaluationList(List<DynamicObject> hisList, IFormView view, String targetKey, int maxRoleCount, String areaMarker) {
        LinkedHashMap<Object, Object> nodeMap = new LinkedHashMap(16);
        if (hisList != null) {
            String taskIdStr = (String)view.getFormShowParameter().getCustomParam("taskId");
            Long taskId = null;
            if (!HRStringUtils.isEmpty((String)taskIdStr)) {
                taskId = Long.valueOf(taskIdStr);
            }
            Map permissionConfig = APP_SERVICE.queryPermissionConfig(taskId);
            List taskIdList = hisList.stream().map(obj -> obj.getLong("flowrutask.id")).collect(Collectors.toList());
            DynamicObject[] taskObjs = APP_SERVICE.queryTaskById(taskIdList);
            Map<Long, DynamicObject> taskMap = Arrays.asList(taskObjs).stream().collect(Collectors.toMap(x -> x.getLong("id"), Function.identity()));
            Map permCfgMap = APP_SERVICE.queryBatchProcessPermSettingScope(taskIdList);
            nodeMap = areaMarker.equals(COMMON_AREA_CLICKED) ? IndicatorDetailUtils.assembleCommonEvaluationData(hisList, view, permCfgMap, permissionConfig, taskMap, targetKey) : IndicatorDetailUtils.assembleSumEvaluationData(hisList, view, permCfgMap, permissionConfig, taskMap, targetKey);
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("epa_actevalind_flownode");
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(targetKey);
        showParameter.setCustomParam("flowNodeMap", (Object)JSON.toJSONString(nodeMap));
        showParameter.setCustomParam("maxRoleCount", (Object)maxRoleCount);
        showParameter.setHasRight(true);
        view.showForm(showParameter);
    }

    public static LinkedHashMap<String, Object> assembleCommonEvaluationData(List<DynamicObject> hisList, IFormView view, Map<Long, Object> permCfgMap, Map<String, Object> permissionConfig, Map<Long, DynamicObject> taskMap, String targetKey) {
        int currentTurnoversort = (Integer)permissionConfig.get("turnoversort");
        int currentNodeIndex = (Integer)permissionConfig.get("flowrunodeIndex");
        LinkedHashMap<String, Object> newHisMap = new LinkedHashMap<String, Object>(16);
        if (hisList != null && hisList.size() > 0) {
            for (DynamicObject his : hisList) {
                boolean isShowDescription;
                Long taskId = his.getLong("flowrutask.id");
                DynamicObject taskInfo = taskMap.get(taskId);
                int flowrunodeIndex = his.getInt("flowrunode.index");
                String flowrunodeName = his.getString("flowrunode.name");
                BigDecimal flowrunodeWeight = his.getBigDecimal("flowrunode.nodeweight");
                String flowrunodeId = his.getString("flowrunode.id");
                String flowruroleName = his.getString("flowrurole.name");
                Long flowruroleId = his.getLong("flowrurole.id");
                String modifierPicturefield = his.getString("modifier.picturefield");
                String modifierName = his.getString("modifier.name");
                long modifierId = his.getLong("modifier.id");
                BigDecimal soe = his.getBigDecimal("soe");
                String evaldesc = his.getString("evaldesc");
                Long flowDefNodeId = taskInfo.getLong("flowrunode.flownodedef.id");
                Map anonymousConfig = (Map)permCfgMap.get(flowDefNodeId);
                permissionConfig.put("histurnoversort", his.getInt("flowrurole.turnoversort"));
                permissionConfig.put("hisflowrurole", his.getLong("flowrurole.id"));
                ArrayList hisItemList = (ArrayList)newHisMap.get(flowrunodeId + "__SEPARATOR__" + flowrunodeName + "__SEPARATOR__" + flowrunodeWeight.stripTrailingZeros().toPlainString());
                if (hisItemList == null) {
                    hisItemList = new ArrayList(10);
                }
                HashMap<String, String> flowrunodeMap = new HashMap<String, String>(16);
                Long evalflowinsId = 0L;
                evalflowinsId = HRStringUtils.equals((String)targetKey, (String)"viewdetailap") ? Long.valueOf(view.getParentView().getModel().getDataEntity().getLong("evalflowins.id")) : Long.valueOf(view.getModel().getDataEntity().getLong("evalflowins.id"));
                boolean anonymous = IndicatorDetailUtils.isAnonymous(anonymousConfig, modifierId, evalflowinsId, flowrunodeIndex, flowruroleId, currentNodeIndex, currentTurnoversort, view);
                if (anonymous) {
                    flowruroleName = ANONYMOUS_STR;
                    modifierPicturefield = "";
                    modifierName = ANONYMOUS_STR;
                }
                flowrunodeMap.put("flowruroleName", flowruroleName);
                flowrunodeMap.put("modifierPicturefield", modifierPicturefield);
                flowrunodeMap.put("modifierName", modifierName);
                boolean isShowSoe = IndicatorDetailUtils.isShowFieldByPermission(permissionConfig, flowrunodeIndex, modifierId, "scope");
                if (isShowSoe && soe != null) {
                    flowrunodeMap.put("soe", soe.stripTrailingZeros().toPlainString());
                }
                if (isShowDescription = IndicatorDetailUtils.isShowFieldByPermission(permissionConfig, flowrunodeIndex, modifierId, "description")) {
                    flowrunodeMap.put("evaldesc", evaldesc);
                }
                hisItemList.add(flowrunodeMap);
                newHisMap.put(flowrunodeId + "__SEPARATOR__" + flowrunodeName + "__SEPARATOR__" + flowrunodeWeight.stripTrailingZeros().toPlainString(), hisItemList);
            }
        }
        return newHisMap;
    }

    private static boolean isAnonymous(Map<String, Object> anonymousConfig, Long modifierId, Long evalflowinsId, int flowrunodeIndex, Long flowruroleId, int currentNodeIndex, int currentTurnoversort, IFormView view) {
        WorkflowRuProcBo flowRuProcBo = FLOW_RUN_SUP_DOMAIN_SERVICE.getRuProcInstance(evalflowinsId);
        List flowRuNodeBoList = flowRuProcBo.getFlowRuNodeBoList();
        String anonymous = "not_anonymous";
        if (anonymousConfig == null) {
            return false;
        }
        if (anonymousConfig.get("anonymous") != null) {
            anonymous = anonymousConfig.get("anonymous").toString();
        }
        boolean flag = false;
        if (HRStringUtils.equals((String)anonymous, (String)"anonymous") && IndicatorDetailUtils.isBeforeRole(flowrunodeIndex, currentNodeIndex, flowruroleId, flowRuNodeBoList, currentTurnoversort, view)) {
            flag = true;
        }
        long currUserId = RequestContext.get().getCurrUserId();
        if (modifierId == currUserId) {
            flag = false;
        }
        return flag;
    }

    private static boolean isBeforeRole(int flowrunodeIndex, int currentNodeIndex, Long flowruroleId, List<FlowRuNodeBo> flowRuNodeBoList, int currentTurnoversort, IFormView view) {
        List flowRuRoleBoList;
        FlowRuNodeBo flowRuNodeBo;
        long currUserId;
        String actEvalObjUserId = view.getPageCache().get("actEvalObjUserId");
        if (HRStringUtils.equals((String)view.getEntityId(), (String)"epa_actevalobj_viewdetail")) {
            actEvalObjUserId = view.getParentView().getPageCache().get("actEvalObjUserId");
        }
        if (HRStringUtils.equals((String)String.valueOf(currUserId = RequestContext.get().getCurrUserId()), (String)actEvalObjUserId)) {
            return true;
        }
        if (flowrunodeIndex > currentNodeIndex) {
            return true;
        }
        if (flowrunodeIndex == currentNodeIndex && currentNodeIndex > 0 && flowRuNodeBoList != null && flowRuNodeBoList.size() >= currentNodeIndex && (flowRuNodeBo = flowRuNodeBoList.get(currentNodeIndex - 1)) != null && (flowRuRoleBoList = flowRuNodeBo.getFlowRuRoleBoList()) != null) {
            int turnoversort = 0;
            for (FlowRuRoleBo flowRuRoleBo : flowRuRoleBoList) {
                Long pkValue = (Long)flowRuRoleBo.getFlowRuRole().getPkValue();
                if (!HRObjectUtils.equals((Object)pkValue, (Object)flowruroleId)) continue;
                turnoversort = (Integer)flowRuRoleBo.getFlowRuRole().get("turnoversort");
            }
            if (turnoversort >= currentTurnoversort) {
                return true;
            }
        }
        return false;
    }

    private static boolean isShowFieldByPermission(Map<String, Object> permissionConfig, int flowrunodeIndex, long modifierId, String field) {
        boolean isShow = false;
        String scope = (String)permissionConfig.get(field);
        if (scope != null) {
            int currentNodeIndex = (Integer)permissionConfig.get("flowrunodeIndex");
            switch (scope) {
                case "show_self": {
                    long currUserId = RequestContext.get().getCurrUserId();
                    isShow = modifierId == currUserId;
                    break;
                }
                case "show_selfnode": {
                    isShow = flowrunodeIndex == currentNodeIndex;
                    break;
                }
                case "show_pre": {
                    isShow = flowrunodeIndex <= currentNodeIndex;
                    break;
                }
                case "show_all": {
                    isShow = true;
                    break;
                }
                case "show_selfandpre": {
                    long currUserId = RequestContext.get().getCurrUserId();
                    if (modifierId == currUserId) {
                        return true;
                    }
                    if (flowrunodeIndex < currentNodeIndex) {
                        isShow = true;
                        break;
                    }
                    if (flowrunodeIndex == currentNodeIndex) {
                        isShow = IndicatorDetailUtils.isShowBySelfAndPre(permissionConfig, modifierId, currUserId);
                        break;
                    }
                    isShow = false;
                    break;
                }
            }
        }
        return isShow;
    }

    public static String getOleShowText(Long ruleId, String ole) {
        if (ruleId == null) {
            return null;
        }
        List perfLevelItems = APP_SERVICE.queryPerfLevelItemByRule(ruleId);
        if (perfLevelItems != null) {
            for (ComboItem perfLevelItem : perfLevelItems) {
                LocaleString caption;
                if (perfLevelItem == null) continue;
                String perfLevelItemValue = perfLevelItem.getValue();
                if (ole == null || !ole.equals(perfLevelItemValue) || (caption = perfLevelItem.getCaption()) == null) continue;
                return caption.getLocaleValue();
            }
        }
        return null;
    }

    public static LinkedHashMap<String, Object> assembleSumEvaluationData(List<DynamicObject> hisList, IFormView view, Map<Long, Object> permCfgMap, Map<String, Object> permissionConfig, Map<Long, DynamicObject> taskMap, String targetKey) {
        int currentTurnoversort = (Integer)permissionConfig.get("turnoversort");
        int currentNodeIndex = (Integer)permissionConfig.get("flowrunodeIndex");
        LinkedHashMap<String, Object> newHisMap = new LinkedHashMap<String, Object>(16);
        String ruleIdStr = view.getPageCache().get("ruleId");
        view.getPageCache().put("iscrossnode", "false");
        for (DynamicObject his : hisList) {
            Long taskId = his.getLong("flowrutask.id");
            DynamicObject taskInfo = taskMap.get(taskId);
            int flowrunodeIndex = his.getInt("flowrunode.index");
            String flowrunodeName = his.getString("flowrunode.name");
            BigDecimal flowrunodeWeight = his.getBigDecimal("flowrunode.nodeweight");
            String flowruroleName = his.getString("flowrurole.name");
            Long flowruroleId = his.getLong("flowrurole.id");
            String flowrunodeId = his.getString("flowrunode.id");
            String modifierPicturefield = his.getString("handlerhead");
            String modifierName = his.getString("handler.name");
            long modifierId = his.getLong("handler.id");
            BigDecimal soe = his.getBigDecimal("sumrecord.ose");
            String evaldesc = his.getString("sumrecord.eval");
            String ole = his.getString("sumrecord.ole");
            Long flowDefNodeId = taskInfo.getLong("flowrunode.flownodedef.id");
            Map anonymousConfig = (Map)permCfgMap.get(flowDefNodeId);
            permissionConfig.put("histurnoversort", his.getInt("flowrurole.turnoversort"));
            permissionConfig.put("hisflowrurole", his.getLong("flowrurole.id"));
            Long ruleId = null;
            if (ruleIdStr != null) {
                ruleId = Long.valueOf(ruleIdStr);
            }
            String oleShowText = IndicatorDetailUtils.getOleShowText(ruleId, ole);
            ArrayList hisItemList = (ArrayList)newHisMap.get(flowrunodeId + "__SEPARATOR__" + flowrunodeName + "__SEPARATOR__" + flowrunodeWeight.stripTrailingZeros().toPlainString());
            if (hisItemList == null) {
                hisItemList = new ArrayList(10);
            }
            if (!his.getBoolean("flowrunode.iscrossnode")) {
                boolean isShowEvaldesc;
                boolean isShowOle;
                HashMap<String, String> flowrunodeMap = new HashMap<String, String>(16);
                Long evalflowinsId = 0L;
                evalflowinsId = HRStringUtils.equals((String)targetKey, (String)"viewdetailap") ? Long.valueOf(view.getParentView().getModel().getDataEntity().getLong("evalflowins.id")) : Long.valueOf(view.getModel().getDataEntity().getLong("evalflowins.id"));
                boolean anonymous = IndicatorDetailUtils.isAnonymous(anonymousConfig, modifierId, evalflowinsId, flowrunodeIndex, flowruroleId, currentNodeIndex, currentTurnoversort, view);
                if (anonymous) {
                    flowruroleName = ANONYMOUS_STR;
                    modifierPicturefield = "";
                    modifierName = ANONYMOUS_STR;
                }
                flowrunodeMap.put("flowruroleName", flowruroleName);
                flowrunodeMap.put("modifierPicturefield", modifierPicturefield);
                flowrunodeMap.put("modifierName", modifierName);
                boolean isShowSoe = IndicatorDetailUtils.isShowFieldByPermission(permissionConfig, flowrunodeIndex, modifierId, "sum");
                if (isShowSoe) {
                    flowrunodeMap.put("soe", soe.stripTrailingZeros().toPlainString());
                }
                if (isShowOle = IndicatorDetailUtils.isShowFieldByPermission(permissionConfig, flowrunodeIndex, modifierId, "level")) {
                    flowrunodeMap.put("ole", oleShowText);
                }
                if (isShowEvaldesc = IndicatorDetailUtils.isShowFieldByPermission(permissionConfig, flowrunodeIndex, modifierId, "comment")) {
                    flowrunodeMap.put("evaldesc", evaldesc);
                }
                hisItemList.add(flowrunodeMap);
            } else {
                view.getPageCache().put("iscrossnode", "true");
            }
            newHisMap.put(flowrunodeId + "__SEPARATOR__" + flowrunodeName + "__SEPARATOR__" + flowrunodeWeight.stripTrailingZeros().toPlainString(), hisItemList);
        }
        return newHisMap;
    }

    private static void setLabelText(String label, String text, IFormView parentView) {
        Label activityNameLab = (Label)parentView.getControl(label);
        if (activityNameLab != null) {
            activityNameLab.setText(text);
        }
    }

    public static void showEmptyap(IFormView view, String cacheKey) {
        IFormView parentView = view.getParentView();
        parentView.setVisible(Boolean.TRUE, new String[]{"otherevalap"});
        String areaTitle = view.getPageCache().get(cacheKey);
        Label indicatorlabel = (Label)parentView.getControl("indicatorlabel");
        if (indicatorlabel != null) {
            indicatorlabel.setText(areaTitle);
        }
        parentView.setVisible(Boolean.TRUE, new String[]{"emptyap"});
        parentView.setVisible(Boolean.FALSE, new String[]{"otherevaltitle", "evaluationlist", "indicatorpanelap"});
        IndicatorDetailUtils.setGrow(1, parentView);
        view.sendFormAction(parentView);
        parentView.getPageCache().put("clickedId", "emptyap");
    }

    public static boolean isShowBySelfAndPre(Map<String, Object> permissionConfig, long modifierId, long currUserId) {
        int turnOverSortInt;
        Integer curTurnOverSort = (Integer)permissionConfig.get("turnoversort");
        Integer turnOverSort = (Integer)permissionConfig.get("histurnoversort");
        Long hisFlowruRole = (Long)permissionConfig.get("hisflowrurole");
        Long flowRuRole = (Long)permissionConfig.get("flowruroleId");
        int curTurnOverSortInt = curTurnOverSort == null ? 0 : curTurnOverSort;
        int n = turnOverSortInt = turnOverSort == null ? 0 : turnOverSort;
        if (hisFlowruRole == null) {
            hisFlowruRole = 0L;
        }
        boolean isShow = hisFlowruRole.compareTo(flowRuRole) == 0 ? modifierId == currUserId : curTurnOverSortInt > turnOverSortInt;
        return isShow;
    }
}

