/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.interview.InterviewActivityConfApplication;
import kd.opmc.epa.business.domain.perfworkflow.service.PerfWorkFlowDomainService;
import kd.opmc.pbs.business.domain.workflow.service.WorkFlowDomainService;

public class InterviewSchemeSearchUtils {
    private static final InterviewActivityConfApplication INTERVIEW_ACTIVITY_CONF_APPLICATION = InterviewActivityConfApplication.getInstance();
    private static final WorkFlowDomainService WORK_FLOW_DOMAIN_SERVICE = WorkFlowDomainService.getInstance();
    private static final PerfWorkFlowDomainService PERF_WORK_FLOW_DOMAIN_SERVICE = PerfWorkFlowDomainService.getInstance();

    public static Long getPerfWorkFlowId(IFormView view) {
        String perfworkflow = view.getPageCache().get("perfworkflow");
        if (HRStringUtils.isNotEmpty((String)perfworkflow)) {
            return Long.valueOf(perfworkflow);
        }
        Long activityId = (Long)view.getFormShowParameter().getCustomParam("interact");
        DynamicObject interviewActivityDy = INTERVIEW_ACTIVITY_CONF_APPLICATION.queryInterviewProcessInfoById(activityId);
        if (interviewActivityDy != null) {
            long perfWorkFlowId = interviewActivityDy.getLong("perfworkflow.id");
            view.getPageCache().put("perfworkflow", String.valueOf(perfWorkFlowId));
            return perfWorkFlowId;
        }
        return 0L;
    }

    public static void assembleSchemeSearchFilter(List<QFilter> qFilters) {
        for (QFilter next : qFilters) {
            if (!HRStringUtils.equals((String)"interflow.id", (String)next.getProperty())) continue;
            Object qValue = next.getValue();
            List<Long> flowIdList = new ArrayList<Long>(10);
            if (qValue instanceof List) {
                flowIdList = (List)qValue;
            } else {
                flowIdList.add((Long)qValue);
            }
            DynamicObject[] flowvidArr = WORK_FLOW_DOMAIN_SERVICE.getAllHisWorkFlowByBoids(flowIdList);
            List flowvidList = Arrays.stream(flowvidArr).map(dy -> dy.getLong("id")).collect(Collectors.toList());
            next.__setValue(flowvidList);
        }
    }

    public static void filterF7Select(IFormView view, BeforeFilterF7SelectEvent args) {
        String fieldName;
        switch (fieldName = args.getFieldName()) {
            case "interflow.name": {
                Long perfWorkFlowId = InterviewSchemeSearchUtils.getPerfWorkFlowId(view);
                DynamicObjectCollection flowEntry = PERF_WORK_FLOW_DOMAIN_SERVICE.queryAssFlowById(perfWorkFlowId.longValue(), "3");
                List flowvidList = flowEntry.stream().map(dy -> dy.getLong("flowid")).collect(Collectors.toList());
                args.addCustomQFilter(new QFilter("id", "in", flowvidList));
                break;
            }
            case "evalobj.activity.name": 
            case "epa_interobj.evalobj.activity.name": {
                Long activityId = (Long)view.getFormShowParameter().getCustomParam("interact");
                DynamicObject interviewActivityDy = INTERVIEW_ACTIVITY_CONF_APPLICATION.queryInterviewProcessInfoById(activityId);
                if (interviewActivityDy == null) break;
                DynamicObjectCollection relActivityList = interviewActivityDy.getDynamicObjectCollection("activityids");
                List activityIdList = relActivityList.stream().map(dy -> dy.getLong("fbasedataid_id")).collect(Collectors.toList());
                args.addCustomQFilter(new QFilter("id", "in", activityIdList));
                break;
            }
            case "flowdefrole.rolename": 
            case "flowrurole.flowdefrole.rolename": {
                Long flowNodeId = (Long)view.getFormShowParameter().getCustomParam("flownode");
                if (flowNodeId == null) break;
                args.addCustomQFilter(new QFilter("defnode", "=", (Object)flowNodeId));
                break;
            }
        }
    }
}

