/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.utils;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.evaloverall.ActEvalObjOverallApplicationService;

public class LevelStatUtils {
    private static final Log LOGGER = LogFactory.getLog(LevelStatUtils.class);
    private static final ActEvalObjOverallApplicationService ACT_EVAL_OBJ_OVERALL_APPLICATION_SERVICE = ActEvalObjOverallApplicationService.getInstance();
    public static final String LEVELAP = "levelap";
    public static final String LEVELSTATLABPRE = "levelstatlab_";
    public static final String LEVELSTATNUMLABPRE = "levelstatnumlab_";
    public static final String LEVELSTATFLEXPRE = "levelstatflex_";
    public static final String LEVELPERLABPRE = "levelperlab_";

    public static void initLevelStatFlex(IFormView view, Long taskId) {
        List<String> showedLevelStatFlexList = LevelStatUtils.initLevelStat(view, taskId, null);
        Container levelap = (Container)view.getControl(LEVELAP);
        List levelapItems = levelap.getItems();
        ArrayList<String> allLevelStatFlexList = new ArrayList<String>(8);
        for (Control levelapItem : levelapItems) {
            allLevelStatFlexList.add(levelapItem.getKey());
        }
        allLevelStatFlexList.removeAll(showedLevelStatFlexList);
        if (allLevelStatFlexList.size() > 0) {
            view.setVisible(Boolean.FALSE, allLevelStatFlexList.toArray(new String[0]));
        }
    }

    public static List<String> initLevelStat(IFormView view, Long taskId, Map<String, Integer> levelStatMap) {
        ArrayList<String> showedLevelStatFlexList = new ArrayList<String>(8);
        boolean isShowLevel = (Boolean)view.getFormShowParameter().getCustomParam("isShowLevel");
        if (!isShowLevel) {
            return showedLevelStatFlexList;
        }
        if (levelStatMap == null) {
            levelStatMap = new HashMap<String, Integer>();
        } else {
            Integer total = levelStatMap.get("total");
            if (total == null) {
                total = 1;
            }
            view.getPageCache().put("levelstatnumlab_total", String.valueOf(total));
        }
        Long sumperflevel = 0L;
        if (taskId == null) {
            sumperflevel = Long.valueOf(view.getPageCache().get("sumperflevel"));
        } else {
            DynamicObject assessForm = ACT_EVAL_OBJ_OVERALL_APPLICATION_SERVICE.queryAssessFormByTaskId(taskId);
            DynamicObject sumperflevelObj = assessForm.getDynamicObject("sumperflevel");
            if (sumperflevelObj != null) {
                sumperflevel = sumperflevelObj.getLong("id");
            }
            view.getPageCache().put("sumperflevel", String.valueOf(sumperflevel));
        }
        if (sumperflevel != 0L) {
            List levelItems = ACT_EVAL_OBJ_OVERALL_APPLICATION_SERVICE.queryPerfLevelItemByRule(sumperflevel);
            for (ComboItem levelItem : levelItems) {
                String levelSeq = levelItem.getValue();
                LocaleString levelName = levelItem.getCaption();
                showedLevelStatFlexList.add(LEVELSTATFLEXPRE + levelSeq);
                Label levelStatLab = (Label)view.getControl(LEVELSTATLABPRE + levelSeq);
                if (levelStatLab == null) continue;
                levelStatLab.setText(levelName.getLocaleValue());
                Label levelStatNumLab = (Label)view.getControl(LEVELSTATNUMLABPRE + levelSeq);
                Integer levelStatNum = levelStatMap.get(levelSeq);
                if (levelStatNum == null) {
                    levelStatNum = 0;
                }
                String levelStatNumStr = String.valueOf(levelStatNum);
                levelStatNumLab.setText(levelStatNumStr);
                LevelStatUtils.setLevelStatPer(view, levelStatNumStr, levelSeq);
                view.getPageCache().put(LEVELSTATNUMLABPRE + levelSeq, levelStatNumStr);
            }
        }
        return showedLevelStatFlexList;
    }

    public static void setLevelStatPer(IFormView view, String levelNum, String levelSeq) {
        Label levelPerLab;
        String total = view.getPageCache().get("levelstatnumlab_total");
        String levelStatPerStr = "0%";
        if (HRStringUtils.isNotEmpty((String)levelNum) && HRStringUtils.isNotEmpty((String)total) && !"0".equals(total)) {
            DecimalFormat decimalFormat = new DecimalFormat("##.#");
            BigDecimal levelStatNumBig = new BigDecimal(levelNum);
            BigDecimal levelStatTotalBig = new BigDecimal(total);
            BigDecimal levelStatPer = levelStatNumBig.multiply(new BigDecimal("100")).divide(levelStatTotalBig, 1, 4);
            levelStatPerStr = decimalFormat.format(levelStatPer) + "%";
        }
        if ((levelPerLab = (Label)view.getControl(LEVELPERLABPRE + levelSeq)) != null) {
            levelPerLab.setText(levelStatPerStr);
        }
    }

    public static void refreshLevelStat(IFormView view, String newValue, String oldValue) {
        String oldLevelNum;
        if (!HRStringUtils.isEmpty((String)oldValue) && !HRStringUtils.isEmpty((String)(oldLevelNum = view.getPageCache().get(LEVELSTATNUMLABPRE + oldValue)))) {
            int oldLevelNumInt = Integer.parseInt(oldLevelNum) - 1;
            if (oldLevelNumInt < 0) {
                oldLevelNumInt = 0;
            }
            String oldLevelNumStr = String.valueOf(oldLevelNumInt);
            Label oldLevelStatLab = (Label)view.getControl(LEVELSTATNUMLABPRE + oldValue);
            oldLevelStatLab.setText(oldLevelNumStr);
            view.getPageCache().put(LEVELSTATNUMLABPRE + oldValue, oldLevelNumStr);
            LevelStatUtils.setLevelStatPer(view, oldLevelNumStr, oldValue);
        }
        if (!HRStringUtils.isEmpty((String)newValue)) {
            String newLevelNum = view.getPageCache().get(LEVELSTATNUMLABPRE + newValue);
            if (HRStringUtils.isEmpty((String)newLevelNum)) {
                newLevelNum = "0";
            }
            int newLevelNumInt = Integer.parseInt(newLevelNum) + 1;
            String newLevelNumStr = String.valueOf(newLevelNumInt);
            Label newLevelStatLab = (Label)view.getControl(LEVELSTATNUMLABPRE + newValue);
            if (newLevelStatLab != null) {
                newLevelStatLab.setText(newLevelNumStr);
            }
            view.getPageCache().put(LEVELSTATNUMLABPRE + newValue, newLevelNumStr);
            LevelStatUtils.setLevelStatPer(view, newLevelNumStr, newValue);
        }
    }
}

