/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.utils;

import com.google.common.collect.ImmutableBiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.opmc.epa.business.application.service.scheme.AssessSchemeApplicationService;
import kd.opmc.epa.business.domain.scheme.entity.MpRuleSetEntryVO;
import kd.opmc.epa.business.domain.scheme.entity.MpRuleSetVO;

public class MpRuleUtils {
    private static final AssessSchemeApplicationService ASSESS_SCHEME_APPLICATION_SERVICE = AssessSchemeApplicationService.getInstance();
    private static final Map<String, String> TAG_MAP = ImmutableBiMap.builder().put((Object)"1010_S", (Object)"Y").put((Object)"1020_S", (Object)"H").put((Object)"1030_S", (Object)"Q").put((Object)"1040_S", (Object)"M").build();
    private static final List<String> TIME_TAG_ALL = Arrays.asList("M1", "M2", "M3", "Q1", "M4", "M5", "M6", "Q2", "H1", "M7", "M8", "M9", "Q3", "M10", "M11", "M12", "Q4", "H2", "Y");
    private static final String PCYCLETYPE_NUMBER = "pcycletype.number";

    public static void buildVoByMpRule(DynamicObject mprule, MpRuleSetVO mpRuleSetVO, List<MpRuleSetEntryVO> entryentities) {
        if (mprule == null) {
            return;
        }
        mpRuleSetVO.setMpmode(mprule.getInt("mpmode"));
        mpRuleSetVO.setErdealrule(mprule.getInt("erdealrule") == 0 ? 1 : mprule.getInt("erdealrule"));
        DynamicObjectCollection entryEntity = mprule.getDynamicObjectCollection("entryentity");
        for (DynamicObject dyn : entryEntity) {
            MpRuleSetEntryVO vo = new MpRuleSetEntryVO();
            vo.setTimetag(dyn.getString("timetag"));
            vo.setWeight(dyn.getBigDecimal("weight"));
            vo.setCalcitem(dyn.getDynamicObject("calcitem"));
            entryentities.add(vo);
        }
    }

    public static void buildMpRuleFromScheme(MpRuleSetVO mpRuleSetVO, List<MpRuleSetEntryVO> entryentities, DynamicObject schemeDyn) {
        mpRuleSetVO.setMpmode(1);
        mpRuleSetVO.setErdealrule(1);
        DynamicObjectCollection periodconfentity = schemeDyn.getDynamicObjectCollection("periodconfentity");
        if (periodconfentity.size() == 0) {
            periodconfentity = new DynamicObjectCollection();
            DynamicObject periodconf = ASSESS_SCHEME_APPLICATION_SERVICE.generateEmptyEntryDynamicObject("periodconfentity");
            periodconf.set("pcycletype", schemeDyn.get("cycletype"));
            periodconfentity.add((Object)periodconf);
        }
        MpRuleUtils.buildEntryVO(entryentities, periodconfentity);
    }

    public static void buildMpRuleFromScheme(MpRuleSetVO mpRuleSetVO, List<MpRuleSetEntryVO> entryentities, AbstractFormDataModel schemeDyn) {
        mpRuleSetVO.setMpmode(1);
        mpRuleSetVO.setErdealrule(1);
        DynamicObjectCollection periodconfentity = schemeDyn.getEntityEntity("periodconfentity");
        if (periodconfentity.size() == 0) {
            periodconfentity = new DynamicObjectCollection();
            DynamicObject periodconf = ASSESS_SCHEME_APPLICATION_SERVICE.generateEmptyEntryDynamicObject("periodconfentity");
            periodconf.set("pcycletype", schemeDyn.getValue("cycletype"));
            periodconfentity.add((Object)periodconf);
        }
        MpRuleUtils.buildEntryVO(entryentities, periodconfentity);
    }

    public static void buildEntryVO(List<MpRuleSetEntryVO> entryentities, DynamicObjectCollection periodconfentity) {
        ArrayList existCycle = new ArrayList(10);
        for (DynamicObject entryentity : periodconfentity) {
            String tag = entryentity.getString(PCYCLETYPE_NUMBER);
            String timeTag = TAG_MAP.get(tag);
            if (StringUtils.isEmpty((CharSequence)timeTag)) continue;
            existCycle.addAll(TIME_TAG_ALL.stream().filter(v -> v.contains(timeTag)).collect(Collectors.toList()));
        }
        HashSet set2 = new HashSet(existCycle);
        ArrayList<String> intersection = new ArrayList<String>();
        for (String timeTag : TIME_TAG_ALL) {
            if (!set2.contains(timeTag)) continue;
            intersection.add(timeTag);
        }
        for (String timeTag : intersection) {
            MpRuleSetEntryVO vo = new MpRuleSetEntryVO();
            vo.setTimetag(timeTag);
            entryentities.add(vo);
        }
    }
}

