/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.utils;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.extplugin.PluginFilter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActivityEvaluationObjectApplicationService;
import kd.opmc.epa.business.application.service.evaluating.ActEvalObjDetailApplicationService;
import kd.opmc.epa.business.domain.activitymanage.enums.ScalaTypeEnum;
import kd.opmc.epa.business.domain.activitymanage.extpoint.IEvalScoreRange;
import kd.opmc.epa.business.domain.activitymanage.extpoint.impl.EvalScoreRange;
import kd.opmc.epa.business.domain.evaluating.entity.ContentFieldEntryEvaDto;
import kd.opmc.epa.business.domain.evaluating.entity.EvalFileMustInputBo;
import kd.opmc.epa.business.domain.evaluating.entity.IndicatorEvalRecordBo;
import kd.opmc.epa.common.enums.activitymanage.AreaRegEnum;
import kd.opmc.epa.common.enums.assessrule.ScoreCalcWayEnum;
import kd.opmc.epa.formplugin.web.activitymanage.evaluate.utils.EvaluteDrawEntryEntityUtils;

public class ObjEvaluationUtils {
    private static final Log LOGGER = LogFactory.getLog(ObjEvaluationUtils.class);
    private static final ActivityEvaluationObjectApplicationService EVAL_OBJECT_SERVICE = ActivityEvaluationObjectApplicationService.getInstance();
    private static final ActEvalObjDetailApplicationService APP_SERVICE = ActEvalObjDetailApplicationService.getInstance();
    public static final String NOT_CONSISTENT_WITH_AREA = "0";
    public static final String CACHE_CALCULATING_KEY = "calculating";
    public static final String CACHE_SUM_AREA_OSE_KEY = "SUM_AREA_OSE";
    public static final String CACHE_SUM_AREA_OLE_KEY = "SUM_AREA_OLE";
    private static final AssessActivityApplicationService ACTIVITY_SERVICE = AssessActivityApplicationService.getInstance();
    public static final String IS_BINDING_DATA = "isBindingData";
    public static final String RAREAFIELDREG_CATEGORY_INDICATORDES = "10";
    public static final String TASK_WEIGHT_PREFIX = "TASK_WEIGHT_";
    static final String[] NORMAL_CARRY_FIELDS = new String[]{"realfinishdate", "qualityres", "finishdesc", "customfiled1", "customfiled2", "customfiled3", "customfiled4", "customfiled5"};
    static final String[] ADDSUB_CARRY_FIELDS = new String[]{"realfinishdate", "qualityres", "finishdesc"};
    static final String[] ATTACH_CARRY_FIELDS = new String[]{"realfinishdate", "customfield"};
    private static final Map<String, String[]> EVAL_AREA_FIELDS = new HashMap<String, String[]>(16);

    private static BigDecimal getSSROfSumCalWay(DynamicObjectCollection indEvalRecordEntry, BigDecimal ssr) {
        if (indEvalRecordEntry != null) {
            for (DynamicObject indEvalRecord : indEvalRecordEntry) {
                if (indEvalRecord == null) continue;
                BigDecimal soe = indEvalRecord.getBigDecimal("soe") == null ? BigDecimal.ZERO : indEvalRecord.getBigDecimal("soe");
                ssr = ssr.add(soe);
            }
        }
        return ssr;
    }

    public static boolean isConsistentWithArea(IFormView view, long areaScoreSystemId) {
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Long formScoreSystemId = formShowParameter.getCustomParam("scoresystem") == null ? Long.valueOf(0L) : (Long)formShowParameter.getCustomParam("scoresystem");
        String consistentWithArea = (String)view.getFormShowParameter().getCustomParam("consistentwitharea");
        return !NOT_CONSISTENT_WITH_AREA.equals(consistentWithArea) || areaScoreSystemId == formScoreSystemId;
    }

    public static long getAreaScoreSystemId(DynamicObject conf) {
        DynamicObject dynamicObject = conf.getDynamicObject("scoresystem");
        long scoreSystemId = 0L;
        if (dynamicObject != null) {
            scoreSystemId = dynamicObject.getLong("id");
        }
        return scoreSystemId;
    }

    public static DynamicObject getObjGenAreaIns(IFormView view) {
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Long areaId = (Long)formShowParameter.getCustomParam("area");
        return EVAL_OBJECT_SERVICE.getObjGenAreaIns((Object)areaId);
    }

    public static int getScale(IFormView view) {
        String numAccuracy = (String)view.getFormShowParameter().getCustomParam("numaccuracy");
        if (HRStringUtils.isBlank((CharSequence)numAccuracy)) {
            numAccuracy = "2";
        }
        return Integer.parseInt(numAccuracy);
    }

    public static void calculateSSR(IFormView view, BigDecimal taskWeight, boolean isCalculateOse) {
        BigDecimal ssr = ObjEvaluationUtils.caluateSSR(view);
        if (ssr == null) {
            ssr = BigDecimal.ZERO;
        }
        String scaleTypeStr = (String)view.getFormShowParameter().getCustomParam("scaletype");
        int scale = ObjEvaluationUtils.getScale(view);
        int scaleType = ScalaTypeEnum.get((String)scaleTypeStr).getType();
        String isPartInStr = view.getPageCache().get("isPartInStr");
        LOGGER.info("caluate ssr isPartInStr:{}", (Object)isPartInStr);
        if (!HRStringUtils.equals((String)isPartInStr, (String)"true")) {
            ssr = ssr.setScale(scale, scaleType);
            view.getModel().setValue("ssr", (Object)ssr);
            view.updateView("ssr");
            view.getPageCache().put("ssrCacheValue", ssr.toPlainString());
            view.getPageCache().put("SSR_SCORE_AFTERBING", ssr.toPlainString());
            return;
        }
        BigDecimal nodeWeight = view.getModel().getDataEntity().getDynamicObject("flowrunode").getBigDecimal("nodeweight");
        BigDecimal roleWeight = view.getModel().getDataEntity().getDynamicObject("flowrurole").getBigDecimal("roleweight");
        BigDecimal ssrEc = taskWeight.multiply(nodeWeight.divide(new BigDecimal("100"), 10, 4)).multiply(roleWeight.divide(new BigDecimal("100"), 10, 4)).multiply(ssr);
        ssrEc = ssrEc.setScale(scale, scaleType);
        view.getModel().setValue("ssrec", (Object)ssrEc);
        ssr = ssr.setScale(scale, scaleType);
        view.getModel().setValue("ssr", (Object)ssr);
        view.updateView("ssr");
        view.getPageCache().put("ssrCacheValue", ssr.toPlainString());
        view.getPageCache().put("SSR_SCORE_AFTERBING", ssr.toPlainString());
        if (isCalculateOse) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            view.getParentView().invokeOperation("calculateose", option);
            view.sendFormAction(view.getParentView());
        }
    }

    public static BigDecimal caluateSSR(IFormView view) {
        BigDecimal ssr;
        DynamicObjectCollection indEvalRecordEntry = view.getModel().getEntryEntity("entryentity");
        if (HRStringUtils.equals((String)view.getFormShowParameter().getFormId(), (String)"epa_genarearecord")) {
            ssr = ObjEvaluationUtils.calculateGenSsrcal(view, indEvalRecordEntry);
            ssr = ObjEvaluationUtils.scoreSystemExchange(view, ssr);
        } else {
            ssr = indEvalRecordEntry.stream().map(indEvalRecord -> indEvalRecord.getBigDecimal("soe") == null ? BigDecimal.ZERO : indEvalRecord.getBigDecimal("soe")).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return ssr;
    }

    private static BigDecimal scoreSystemExchange(IFormView view, BigDecimal ssr) {
        FormShowParameter formShowParameter;
        Long formScoreSystemId;
        DynamicObject scoreSystem;
        long scoreSystemId;
        Long confId = (Long)view.getFormShowParameter().getCustomParam("confid");
        DynamicObject areaConf = ACTIVITY_SERVICE.queryNormalConfigByPk(confId);
        if (areaConf == null) {
            return ssr;
        }
        String scoreCalcWay = (String)view.getFormShowParameter().getCustomParam("scorecalcway");
        DynamicObject areaScoreSystem = areaConf.getDynamicObject("scoresystem");
        if (ScoreCalcWayEnum.WEIGHT.getValue().equals(scoreCalcWay) && !ObjEvaluationUtils.isConsistentWithArea(view, scoreSystemId = ObjEvaluationUtils.getAreaScoreSystemId(areaConf)) && (scoreSystem = ACTIVITY_SERVICE.queryScoreSystemById(formScoreSystemId = (formShowParameter = view.getFormShowParameter()).getCustomParam("scoresystem") == null ? Long.valueOf(0L) : (Long)formShowParameter.getCustomParam("scoresystem"))) != null && areaScoreSystem != null) {
            BigDecimal areaMaxScore = areaScoreSystem.getBigDecimal("maxscore");
            BigDecimal formMaxScore = scoreSystem.getBigDecimal("maxscore");
            if (areaMaxScore != null && formMaxScore != null) {
                String scaleTypeStr = (String)view.getFormShowParameter().getCustomParam("scaletype");
                int scaleType = ScalaTypeEnum.get((String)scaleTypeStr).getType();
                int scale = ObjEvaluationUtils.getScale(view);
                ssr = ssr.multiply(formMaxScore).divide(areaMaxScore, scale, scaleType);
            }
        }
        return ssr;
    }

    private static BigDecimal calculateGenSsrcal(IFormView view, DynamicObjectCollection indEvalRecordEntry) {
        BigDecimal ssr = BigDecimal.ZERO;
        String scoreCalcWay = (String)view.getFormShowParameter().getCustomParam("scorecalcway");
        if (ScoreCalcWayEnum.WEIGHT.getValue().equals(scoreCalcWay)) {
            String scaleTypeStr = (String)view.getFormShowParameter().getCustomParam("scaletype");
            if (indEvalRecordEntry != null) {
                for (DynamicObject indEvalRecord : indEvalRecordEntry) {
                    DynamicObject indicator;
                    if (indEvalRecord == null || (indicator = (DynamicObject)indEvalRecord.get("indicator")) == null) continue;
                    BigDecimal weight = indicator.getBigDecimal("weight") == null ? BigDecimal.ZERO : indicator.getBigDecimal("weight");
                    BigDecimal hundred = new BigDecimal("100");
                    BigDecimal percent = weight.divide(hundred, 10, 4);
                    BigDecimal soe = indEvalRecord.getBigDecimal("soe") == null ? BigDecimal.ZERO : indEvalRecord.getBigDecimal("soe");
                    BigDecimal soeRes = soe.multiply(percent);
                    ssr = ssr.add(soeRes);
                }
            }
        } else if (ScoreCalcWayEnum.SUM.getValue().equals(scoreCalcWay)) {
            ssr = ObjEvaluationUtils.getSSROfSumCalWay(indEvalRecordEntry, ssr);
        }
        return ssr;
    }

    public static void setCreateInfo(IFormView view, int i) {
        view.getModel().setValue("indcreator", (Object)RequestContext.get().getCurrUserId(), i);
        view.getModel().setValue("indmodifier", (Object)RequestContext.get().getCurrUserId(), i);
        view.getModel().setValue("indcreatetime", (Object)new Date(), i);
        view.getModel().setValue("indmodifytime", (Object)new Date(), i);
    }

    public static void setInitFields(IFormView view, String[] indicatorInitFields) {
        if (view.getFormShowParameter().getStatus() == OperationStatus.ADDNEW) {
            DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("entryentity");
            for (int i = 0; i < entryEntity.size(); ++i) {
                for (String initField : indicatorInitFields) {
                    Object fieldValue = view.getFormShowParameter().getCustomParam(initField);
                    if (fieldValue == null) continue;
                    view.getModel().setValue("ind" + initField, fieldValue, i);
                }
                ObjEvaluationUtils.setCreateInfo(view, i);
            }
        }
    }

    public static boolean validateSoe(IFormView view, ChangeData changeData, BigDecimal scoreMax, BigDecimal scoreMin) {
        int rowIndex = changeData.getRowIndex();
        BigDecimal newValue = (BigDecimal)changeData.getNewValue();
        if (newValue == null) {
            return false;
        }
        if (newValue.compareTo(scoreMax) > 0 || newValue.compareTo(scoreMin) < 0) {
            String showTipsTag = "";
            showTipsTag = newValue == null ? "soe" + rowIndex : "soe" + rowIndex + newValue.toString();
            String isShowTips = view.getPageCache().get(showTipsTag);
            LOGGER.info("before show tips oldValue:{}, newValue:{}", changeData.getOldValue(), (Object)newValue);
            if (HRStringUtils.equals((String)isShowTips, (String)"true")) {
                view.getPageCache().remove(showTipsTag);
                view.getModel().setValue("soe", null, rowIndex);
            }
            view.showTipNotification(ResManager.loadKDString((String)"\u8bc4\u5206\u5df2\u8d85\u51fa\u53ef\u8bc4\u5206\u8303\u56f4\uff0c\u8303\u56f4\uff1a{0}~{1}\u3002", (String)"ObjEvaluationUtils_0", (String)"opmc-epa-formplugin", (Object[])new Object[]{scoreMin, scoreMax}));
            view.getPageCache().put(showTipsTag, "true");
            LOGGER.info("after show tips oldValue:{}, newValue", changeData.getOldValue());
            view.getModel().setValue("soe", null, rowIndex);
        }
        return false;
    }

    public static boolean validateAreaMustEnterFieldOfGen(IFormView view, AfterDoOperationEventArgs args, List<Long> genImportIndicators) {
        return ObjEvaluationUtils.valiDateAndOperationRes(view, args, genImportIndicators);
    }

    public static boolean validateAreaMustEnterField(IFormView view, AfterDoOperationEventArgs args) {
        return ObjEvaluationUtils.valiDateAndOperationRes(view, args, null);
    }

    private static boolean valiDateAndOperationRes(IFormView view, AfterDoOperationEventArgs args, List<Long> genImportIndicators) {
        String formId = view.getFormShowParameter().getFormId();
        ArrayList<OperateErrorInfo> errorInfoList = new ArrayList<OperateErrorInfo>();
        OperationResult operationResult = args.getOperationResult();
        String evalFileMustInputBoStr = view.getPageCache().get("evalFileMustInputBo");
        if (!HRStringUtils.isBlank((CharSequence)evalFileMustInputBoStr)) {
            EvalFileMustInputBo evalFileMustInputBo = (EvalFileMustInputBo)JSON.parseObject((String)evalFileMustInputBoStr, EvalFileMustInputBo.class);
            DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("entryentity");
            List mustInputFieldList = evalFileMustInputBo.getMustInputFieldList();
            for (DynamicObject recordDy : entryEntity) {
                boolean validate = true;
                for (String fieldKey : mustInputFieldList) {
                    Object value = recordDy.get(fieldKey);
                    long indCatorId = recordDy.getLong("indicator.id");
                    if (genImportIndicators != null && genImportIndicators.contains(indCatorId) && indCatorId != 0L) {
                        validate = true;
                        continue;
                    }
                    if (!ObjEvaluationUtils.isEmpty(value)) continue;
                    validate = false;
                }
                if (validate) continue;
                OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                operateErrorInfo.setLevel(ErrorLevel.Warning);
                String indctrName = HRStringUtils.equals((String)formId, (String)"epa_attacharearecord") ? recordDy.getString("indicator.keyactname") : recordDy.getString("indicator.indctrname");
                operateErrorInfo.setMessage(ResManager.loadKDString((String)"{0}. {1}\u6307\u6807\u5b58\u5728\u8bc4\u4ef7\u9879\u672a\u586b\u5199", (String)"ObjEvaluationUtils_1", (String)"opmc-epa-formplugin", (Object[])new Object[]{errorInfoList.size() + 1, indctrName}));
                errorInfoList.add(operateErrorInfo);
            }
            operationResult.setMessage(evalFileMustInputBo.getAreaCustomerName());
        }
        if (ObjectUtils.isEmpty(errorInfoList)) {
            operationResult.setValidateResult(new ValidateResultCollection());
        }
        operationResult.setSuccess(ObjectUtils.isEmpty(errorInfoList));
        operationResult.setAllErrorInfo(errorInfoList);
        return ObjectUtils.isEmpty(errorInfoList);
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof DynamicObject) {
            return ((DynamicObject)obj).getLong("id") == 0L;
        }
        if (obj instanceof String) {
            return ((String)obj).trim().equals("");
        }
        if (obj instanceof OrmLocaleValue) {
            return obj.toString() == null || obj.toString().trim().equals("");
        }
        return false;
    }

    public static String getCalculateKey(String pageId) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(CACHE_CALCULATING_KEY).append('_').append(pageId);
        return stringBuilder.toString();
    }

    public static void cacheBindingData(IFormView view, boolean binding) {
        if (view != null) {
            if (binding) {
                view.getPageCache().put(IS_BINDING_DATA, "true");
            } else {
                view.getPageCache().put(IS_BINDING_DATA, "false");
            }
        }
    }

    public static boolean isOpenAdjustScore(DynamicObject normalConf) {
        if (normalConf == null) {
            return false;
        }
        return normalConf.getBoolean("reversepoints");
    }

    public static Map<String, List<Long>> getAreaRegIndicaMap(List<Map<String, Object>> batchTaskDetaiList, Long taskId) {
        HashMap<String, List<Long>> areaRegIndicaMap = new HashMap<String, List<Long>>(16);
        if (batchTaskDetaiList == null) {
            return areaRegIndicaMap;
        }
        if (taskId == null) {
            taskId = 0L;
        }
        for (Map<String, Object> batchTaskMap : batchTaskDetaiList) {
            DynamicObjectCollection coll;
            Long taskIdOfMap;
            if (batchTaskMap == null || !taskId.equals(taskIdOfMap = (Long)batchTaskMap.get("taskId")) || (coll = (DynamicObjectCollection)batchTaskMap.get("indicatorColl")) == null) continue;
            for (DynamicObject dynamicObject : coll) {
                long indicatorId = dynamicObject.getLong("indicatorid");
                long arearegId = dynamicObject.getLong("arearegid");
                String arearegIdStr = String.valueOf(arearegId);
                ArrayList<Long> indicatorIds = (ArrayList<Long>)areaRegIndicaMap.get(arearegIdStr);
                if (indicatorIds == null) {
                    indicatorIds = new ArrayList<Long>(10);
                }
                indicatorIds.add(indicatorId);
                areaRegIndicaMap.put(arearegIdStr, indicatorIds);
            }
        }
        return areaRegIndicaMap;
    }

    public static List<ContentFieldEntryEvaDto> getPermFieldSetting(FormShowParameter formShowParameter) {
        List<Object> fieldEntryEvaDtos = new ArrayList<ContentFieldEntryEvaDto>(10);
        String fieldPermSettingJsonStr = (String)formShowParameter.getCustomParam("fieldPermSettingJsonStr");
        if (!HRStringUtils.isBlank((CharSequence)fieldPermSettingJsonStr)) {
            fieldEntryEvaDtos = JSON.parseArray((String)fieldPermSettingJsonStr, ContentFieldEntryEvaDto.class);
        }
        return fieldEntryEvaDtos;
    }

    public static void cacheMustInputFieldInfo(IFormView view, DynamicObject conf, String areaName, AreaRegEnum areaRegEnum, boolean openReverse) {
        List mustInputFieldList;
        boolean isAllowEval;
        List<ContentFieldEntryEvaDto> fieldEntryEvaDtos = ObjEvaluationUtils.getPermFieldSetting(view.getFormShowParameter());
        Map<Long, ContentFieldEntryEvaDto> filePermMap = ObjEvaluationUtils.change2Map(fieldEntryEvaDtos);
        EvalFileMustInputBo evalFileMustInputBo = new EvalFileMustInputBo();
        evalFileMustInputBo.setAreaCustomerName(areaName);
        DynamicObjectCollection entryEntity = conf.getDynamicObjectCollection("entryentity");
        if (entryEntity != null) {
            for (DynamicObject fieldInfo : entryEntity) {
                Boolean fieldMustInputItem;
                ArrayList<String> mustInputFieldList2;
                DynamicObject areaField;
                long areaFieldId;
                ContentFieldEntryEvaDto permFileDto;
                if (fieldInfo == null || (permFileDto = filePermMap.get(areaFieldId = fieldInfo.getLong("areafield.id"))) == null || (areaField = fieldInfo.getDynamicObject("areafield")) == null) continue;
                String fieldKey = areaField.getString("number");
                if (EvaluteDrawEntryEntityUtils.ASSESS_FORM_FILED_MAP.containsKey(fieldKey)) {
                    fieldKey = EvaluteDrawEntryEntityUtils.ASSESS_FORM_FILED_MAP.get(fieldKey);
                }
                if (fieldKey != null && fieldKey.startsWith("customfiled") || fieldKey != null && fieldKey.equals("customfield")) {
                    Boolean modify;
                    Boolean bl = modify = permFileDto.getFieldModifyItem() == null ? Boolean.FALSE : permFileDto.getFieldModifyItem();
                    if (!modify.booleanValue()) {
                        continue;
                    }
                } else {
                    Boolean displayItem = permFileDto.getFieldDisplayItem() == null ? Boolean.FALSE : permFileDto.getFieldDisplayItem();
                    if (!displayItem.booleanValue()) continue;
                }
                if ((mustInputFieldList2 = evalFileMustInputBo.getMustInputFieldList()) == null) {
                    mustInputFieldList2 = new ArrayList<String>(10);
                }
                Boolean bl = fieldMustInputItem = permFileDto.getFieldMustInputItem() == null ? Boolean.FALSE : permFileDto.getFieldMustInputItem();
                if (fieldMustInputItem.booleanValue()) {
                    mustInputFieldList2.add(fieldKey);
                }
                evalFileMustInputBo.setMustInputFieldList(mustInputFieldList2);
            }
        }
        if (AreaRegEnum.NORM_INDCTR_AREA == areaRegEnum && !(isAllowEval = conf.getBoolean("isalloweval")) && (mustInputFieldList = evalFileMustInputBo.getMustInputFieldList()) != null) {
            mustInputFieldList.remove("soe");
            evalFileMustInputBo.setMustInputFieldList(mustInputFieldList);
        }
        ObjEvaluationUtils.dealAdjustEval(openReverse, evalFileMustInputBo);
        Map<String, List<String>> areaCateMap = ObjEvaluationUtils.getConfigColKeyMapByCategory(conf);
        List<String> indicatorDesList = areaCateMap.get(RAREAFIELDREG_CATEGORY_INDICATORDES);
        indicatorDesList.add("indctrname");
        indicatorDesList.add("weight");
        indicatorDesList.add("indctrscore");
        ObjEvaluationUtils.dealCustomerField(indicatorDesList);
        ArrayList<String> mustInputFieldList3 = evalFileMustInputBo.getMustInputFieldList();
        if (mustInputFieldList3 == null) {
            mustInputFieldList3 = new ArrayList<String>(10);
        }
        mustInputFieldList3.removeAll(indicatorDesList);
        evalFileMustInputBo.setMustInputFieldList(mustInputFieldList3);
        view.getPageCache().put("evalFileMustInputBo", JSON.toJSONString((Object)evalFileMustInputBo));
        ObjEvaluationUtils.cacheMustInputFields(view, areaRegEnum, mustInputFieldList3, conf);
    }

    private static void cacheMustInputFields(IFormView view, AreaRegEnum areaRegEnum, List<String> mustInputFieldList, DynamicObject conf) {
        String entityId;
        IFormView parentsView = view.getParentView().getParentView();
        if (parentsView != null && HRStringUtils.equals((String)(entityId = parentsView.getEntityId()), (String)"epa_actevalobj_eval_multi") && !HRObjectUtils.isEmpty(mustInputFieldList) && mustInputFieldList.size() > 0) {
            if (HRStringUtils.equals((String)areaRegEnum.name(), (String)"NORM_INDCTR_AREA")) {
                String confId = String.valueOf(conf.getPkValue());
                parentsView.getPageCache().put("NORMAREAMUST_" + confId, JSON.toJSONString(mustInputFieldList));
            } else {
                parentsView.getPageCache().put(areaRegEnum.name() + "_mustInputFields", JSON.toJSONString(mustInputFieldList));
            }
        }
    }

    private static void dealCustomerField(List<String> indicatorDesList) {
        Iterator<String> iterator = indicatorDesList.iterator();
        while (iterator.hasNext()) {
            String fieldNum = iterator.next();
            if (fieldNum == null || !fieldNum.startsWith("customfiled") && !fieldNum.equals("customfield")) continue;
            iterator.remove();
        }
    }

    private static void dealAdjustEval(boolean openReverse, EvalFileMustInputBo evalFileMustInputBo) {
        List mustInputFieldList;
        if (openReverse && (mustInputFieldList = evalFileMustInputBo.getMustInputFieldList()) != null) {
            mustInputFieldList.add("adjustval");
            evalFileMustInputBo.setMustInputFieldList(mustInputFieldList);
        }
    }

    private static Map<Long, ContentFieldEntryEvaDto> change2Map(List<ContentFieldEntryEvaDto> fieldEntryEvaDtos) {
        HashMap<Long, ContentFieldEntryEvaDto> filePermMap = new HashMap<Long, ContentFieldEntryEvaDto>(16);
        if (fieldEntryEvaDtos != null) {
            for (ContentFieldEntryEvaDto fieldEntryEvaDto : fieldEntryEvaDtos) {
                if (fieldEntryEvaDto == null) continue;
                filePermMap.put(fieldEntryEvaDto.getAreaFieldId(), fieldEntryEvaDto);
            }
        }
        return filePermMap;
    }

    public static Map<String, List<String>> getConfigColKeyMapByCategory(DynamicObject conf) {
        HashMap<String, List<String>> areaCateMap = new HashMap<String, List<String>>(16);
        DynamicObjectCollection entryEntity = conf.getDynamicObjectCollection("entryentity");
        if (entryEntity != null) {
            for (DynamicObject configCol : entryEntity) {
                String fieldNumber = configCol.getString("areafield.number");
                String fieldCategory = configCol.getString("areafield.category");
                ArrayList<String> fieldList = (ArrayList<String>)areaCateMap.get(fieldCategory);
                if (fieldList == null) {
                    fieldList = new ArrayList<String>(10);
                }
                fieldList.add(fieldNumber);
                areaCateMap.put(fieldCategory, fieldList);
            }
        }
        return areaCateMap;
    }

    public static boolean isPreRoleNodeIsCross(IFormView view, Long taskId) {
        Boolean isCrossEvaluate = null;
        if (view != null) {
            String isCrossEvaluateStr = (String)view.getFormShowParameter().getCustomParam("preRoleIsCrossNode");
            if ("true".equals(isCrossEvaluateStr)) {
                isCrossEvaluate = Boolean.TRUE;
            } else if ("false".equals(isCrossEvaluateStr)) {
                isCrossEvaluate = Boolean.FALSE;
            }
        }
        if (isCrossEvaluate == null) {
            boolean crossNodeOfPreRule = APP_SERVICE.isCrossNodeOfPreRole(taskId);
            isCrossEvaluate = crossNodeOfPreRule;
        }
        return isCrossEvaluate;
    }

    public static void calculateScoreFirst(IFormView view) {
        if (view != null) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            view.getParentView().invokeOperation("caltotalscorefirst", option);
            view.sendFormAction(view.getParentView());
        }
    }

    public static BigDecimal setScaleTypeOfFormSetting(IFormView view, BigDecimal val) {
        if (val == null) {
            return val;
        }
        if (view != null) {
            String scaleTypeStr = (String)view.getFormShowParameter().getCustomParam("scaletype");
            String numAccuracy = (String)view.getFormShowParameter().getCustomParam("numaccuracy");
            int scaleType = ScalaTypeEnum.get((String)scaleTypeStr).getType();
            if (HRStringUtils.isBlank((CharSequence)numAccuracy)) {
                numAccuracy = "2";
            }
            int scale = Integer.parseInt(numAccuracy);
            return val.setScale(scale, scaleType);
        }
        return val;
    }

    public static Map<String, List<Long>> getAreaRegIndicaMap(List<Map<String, Object>> batchTaskDetaiList, List<Long> taskList) {
        HashMap<String, List<Long>> areaRegIndicaMap = new HashMap<String, List<Long>>(16);
        if (batchTaskDetaiList == null) {
            return areaRegIndicaMap;
        }
        if (taskList == null || taskList.size() < 1) {
            return areaRegIndicaMap;
        }
        for (Map<String, Object> batchTaskMap : batchTaskDetaiList) {
            DynamicObjectCollection coll;
            Long taskIdOfMap;
            if (batchTaskMap == null || !taskList.contains(taskIdOfMap = (Long)batchTaskMap.get("taskId")) || (coll = (DynamicObjectCollection)batchTaskMap.get("indicatorColl")) == null) continue;
            for (DynamicObject dynamicObject : coll) {
                long indicatorId = dynamicObject.getLong("indicatorid");
                long arearegId = dynamicObject.getLong("arearegid");
                String arearegIdStr = String.valueOf(arearegId);
                ArrayList<Long> indicatorIds = (ArrayList<Long>)areaRegIndicaMap.get(arearegIdStr);
                if (indicatorIds == null) {
                    indicatorIds = new ArrayList<Long>(10);
                }
                if (!indicatorIds.contains(indicatorId)) {
                    indicatorIds.add(indicatorId);
                }
                areaRegIndicaMap.put(arearegIdStr, indicatorIds);
                String taskIdStr = String.valueOf(taskIdOfMap);
                ArrayList<Long> taskIndList = (ArrayList<Long>)areaRegIndicaMap.get(taskIdStr);
                if (taskIndList == null) {
                    taskIndList = new ArrayList<Long>(10);
                }
                taskIndList.add(indicatorId);
                areaRegIndicaMap.put(taskIdStr, taskIndList);
                ArrayList<Long> mergeTaskIds = (ArrayList<Long>)areaRegIndicaMap.get(arearegIdStr + "mergeTaskIds");
                if (mergeTaskIds == null) {
                    mergeTaskIds = new ArrayList<Long>(10);
                }
                if (!mergeTaskIds.contains(taskIdOfMap)) {
                    mergeTaskIds.add(taskIdOfMap);
                }
                areaRegIndicaMap.put(arearegIdStr + "mergeTaskIds", mergeTaskIds);
            }
        }
        return areaRegIndicaMap;
    }

    public static void repeatCaluateSsr(IFormView view, BigDecimal taskWeight) {
        BigDecimal modelSsr;
        BigDecimal entrySsr = ObjEvaluationUtils.caluateSSR(view) == null ? BigDecimal.ZERO : ObjEvaluationUtils.caluateSSR(view);
        BigDecimal bigDecimal = modelSsr = view.getModel().getDataEntity(true).getBigDecimal("ssr") == null ? BigDecimal.ZERO : view.getModel().getDataEntity(true).getBigDecimal("ssr");
        if (modelSsr != null && entrySsr != null && modelSsr.compareTo(entrySsr) != 0) {
            ObjEvaluationUtils.calculateSSR(view, taskWeight, true);
        }
    }

    public static BigDecimal queryTaskWeight(IPageCache pageCache, Long taskId) {
        LOGGER.info("caluate ssr taskid:{}", (Object)taskId);
        LOGGER.info("caluate ssr taskid:{}", (Object)taskId);
        String taskWeightStr = pageCache.get(TASK_WEIGHT_PREFIX + taskId);
        LOGGER.info("caluate ssr taskWeightStr:{}", (Object)taskWeightStr);
        LOGGER.error("caluate ssr taskWeightStr:{}", (Object)taskWeightStr);
        if (!HRStringUtils.isBlank((CharSequence)taskWeightStr)) {
            BigDecimal taskWeight = new BigDecimal(taskWeightStr);
            return taskWeight;
        }
        BigDecimal taskWeight = APP_SERVICE.queryTaskWeight(taskId);
        if (taskWeight != null) {
            LOGGER.error("caluate ssr taskWeightStr:{}", (Object)taskWeight.toPlainString());
            pageCache.put(TASK_WEIGHT_PREFIX + taskId, taskWeight.toPlainString());
        }
        return taskWeight;
    }

    public static Map<Long, List<Long>> getTaskIndsOfMerge(List<Long> taskIds) {
        Map<Long, List<Long>> map = new HashMap<Long, List<Long>>(16);
        if (taskIds != null && !taskIds.isEmpty()) {
            map = APP_SERVICE.queryTaskIndicators(taskIds);
        }
        return map;
    }

    private static Map<String, Integer> change2TaskIndCountMap(Map<Long, List<Long>> indsMap) {
        HashMap<String, Integer> taskIndCountMap = new HashMap<String, Integer>(16);
        if (indsMap != null) {
            for (Map.Entry<Long, List<Long>> entry : indsMap.entrySet()) {
                if (entry == null) continue;
                Long taskIdTmp = entry.getKey();
                List<Long> indList = entry.getValue();
                if (taskIdTmp == null || indList == null || indList.isEmpty()) continue;
                for (Long indicatorId : indList) {
                    Integer count;
                    if (indicatorId == null) continue;
                    String key = taskIdTmp + "#" + indicatorId;
                    Integer n = count = taskIndCountMap.get(key) == null ? Integer.valueOf(0) : (Integer)taskIndCountMap.get(key);
                    Integer n2 = count = Integer.valueOf(count + 1);
                    taskIndCountMap.put(key, count);
                }
            }
        }
        return taskIndCountMap;
    }

    public static boolean isIndicatorChangeOfCross(String oldTaskIndCountMapStr, List<Long> crossTaskIds) {
        if (!HRStringUtils.isBlank((CharSequence)oldTaskIndCountMapStr)) {
            Map oldTaskIndCountMap = (Map)JSON.parseObject((String)oldTaskIndCountMapStr, Map.class);
            Map<Long, List<Long>> indsMap = ObjEvaluationUtils.getTaskIndsOfMerge(crossTaskIds);
            Map<String, Integer> newTaskIndCountMap = ObjEvaluationUtils.change2TaskIndCountMap(indsMap);
            if (oldTaskIndCountMap != null && !oldTaskIndCountMap.isEmpty()) {
                if (newTaskIndCountMap == null || newTaskIndCountMap.isEmpty()) {
                    return true;
                }
                for (Map.Entry entry : oldTaskIndCountMap.entrySet()) {
                    Integer newCount;
                    Integer oldCount;
                    String key;
                    if (entry == null || (key = (String)entry.getKey()) == null) continue;
                    Integer n = oldCount = entry.getValue() == null ? Integer.valueOf(0) : (Integer)entry.getValue();
                    if (newTaskIndCountMap == null) continue;
                    Integer n2 = newCount = newTaskIndCountMap.get(key) == null ? Integer.valueOf(0) : newTaskIndCountMap.get(key);
                    if (oldCount.intValue() == newCount.intValue()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void dealPreNodeCarryInfo(IFormView view, OperationStatus status, Long taskId, AreaRegEnum areaRegEnum, DynamicObject conf) {
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Map<Long, Boolean> taskRollbackMap = new HashMap<Long, Boolean>(16);
        DynamicObject taskObj = APP_SERVICE.queryTaskInfo(taskId);
        boolean isrollbacked = taskObj.getBoolean("isrollbacked");
        taskRollbackMap.put(taskId, isrollbacked);
        Boolean isCrossEvaluate = (Boolean)formShowParameter.getCustomParam("isCrossEvaluate");
        String isDealCarryInfo = (String)formShowParameter.getCustomParam("isDealCarryInfo");
        if (APP_SERVICE.isFirstNodeAndRole(taskId)) {
            return;
        }
        DynamicObjectCollection evaRecordColl = (DynamicObjectCollection)view.getModel().getValue("entryentity");
        String[] carryFieldArr = null;
        boolean openAdjustScore = false;
        if (evaRecordColl != null && evaRecordColl.size() > 0) {
            IndicatorEvalRecordBo evalRecordBo;
            Long pkValue;
            DynamicObject indicatorObj;
            ArrayList<Long> entryIndicatorList;
            List areaIndItemList;
            Map areaRegIndicaItemMap;
            Long taskItemId;
            DynamicObject[] taskObjs;
            Map mergeTaskInds;
            List mergeTaskIds;
            HashMap<Long, List> taskMap;
            Long areaId;
            String mergeTaskIndsStr;
            String mergeTaskIdsStr;
            boolean isDealCarrySoe = false;
            boolean isHaveSoe = true;
            Map indEvalRecordMap = new HashMap(16);
            Map indEvalScoreRecordMap = new HashMap(16);
            if (AreaRegEnum.NORM_INDCTR_AREA.compareTo((Enum)areaRegEnum) == 0) {
                openAdjustScore = ObjEvaluationUtils.isOpenAdjustScore(conf);
                carryFieldArr = NORMAL_CARRY_FIELDS;
                if (!isCrossEvaluate.booleanValue() && !ObjEvaluationUtils.isPreRoleNodeIsCross(view, taskId)) {
                    indEvalRecordMap = APP_SERVICE.queryIndicatorEvalRecordOfPreRoleLastTask(taskId, areaRegEnum);
                    indEvalScoreRecordMap = APP_SERVICE.queryIndicatorEvalScoreRecordOfPreRoleLastTask(taskId, areaRegEnum);
                } else {
                    mergeTaskIdsStr = (String)formShowParameter.getCustomParam("mergeTaskIds");
                    mergeTaskIndsStr = (String)formShowParameter.getCustomParam("mergeTaskInds");
                    areaId = (Long)formShowParameter.getCustomParam("area");
                    taskMap = new HashMap<Long, List>(16);
                    if (HRStringUtils.isNotEmpty((String)mergeTaskIdsStr) && HRStringUtils.isNotEmpty((String)mergeTaskIndsStr)) {
                        mergeTaskIds = (List)JSON.parseObject((String)mergeTaskIdsStr, List.class);
                        mergeTaskInds = (Map)JSON.parseObject((String)mergeTaskIndsStr, Map.class);
                        if (mergeTaskInds.size() > 1) {
                            taskObjs = APP_SERVICE.queryTaskInfos(mergeTaskIds);
                            taskRollbackMap.clear();
                            taskRollbackMap = Arrays.stream(taskObjs).collect(Collectors.toMap(x -> x.getLong("id"), y -> y.getBoolean("isrollbacked"), (v1, v2) -> v2));
                            for (int j = 0; j < mergeTaskIds.size(); ++j) {
                                taskItemId = (Long)mergeTaskIds.get(j);
                                areaRegIndicaItemMap = (Map)mergeTaskInds.get(taskItemId);
                                if (!areaRegIndicaItemMap.containsKey(areaId)) continue;
                                areaIndItemList = (List)areaRegIndicaItemMap.get(areaId);
                                taskMap.put(taskItemId, areaIndItemList);
                            }
                        } else {
                            entryIndicatorList = new ArrayList<Long>(10);
                            for (DynamicObject evaRecord : evaRecordColl) {
                                indicatorObj = evaRecord.getDynamicObject("indicator");
                                pkValue = (Long)indicatorObj.getPkValue();
                                entryIndicatorList.add(pkValue);
                            }
                            taskMap.put(taskId, entryIndicatorList);
                        }
                    }
                    if ((evalRecordBo = APP_SERVICE.queryPreTaskCrossEvalRecord(taskMap, AreaRegEnum.NORM_INDCTR_AREA)) != null) {
                        indEvalRecordMap = evalRecordBo.getFinishEvalRecordMap();
                        indEvalScoreRecordMap = evalRecordBo.getScoreEvalRecordMap();
                    }
                }
            } else if (AreaRegEnum.PLUS_MINUS_AREA.compareTo((Enum)areaRegEnum) == 0) {
                carryFieldArr = ADDSUB_CARRY_FIELDS;
                if (!isCrossEvaluate.booleanValue() && !ObjEvaluationUtils.isPreRoleNodeIsCross(view, taskId)) {
                    indEvalRecordMap = APP_SERVICE.queryIndEvalRecordOfPreRoleLastTaskNotCross(taskId, areaRegEnum);
                    indEvalScoreRecordMap = APP_SERVICE.queryIndEvalScoreRecordOfPreRoleLastTaskNotCross(taskId, areaRegEnum);
                } else {
                    mergeTaskIdsStr = (String)formShowParameter.getCustomParam("mergeTaskIds");
                    mergeTaskIndsStr = (String)formShowParameter.getCustomParam("mergeTaskInds");
                    areaId = (Long)formShowParameter.getCustomParam("area");
                    taskMap = new HashMap(16);
                    if (HRStringUtils.isNotEmpty((String)mergeTaskIdsStr) && HRStringUtils.isNotEmpty((String)mergeTaskIndsStr)) {
                        mergeTaskIds = (List)JSON.parseObject((String)mergeTaskIdsStr, List.class);
                        mergeTaskInds = (Map)JSON.parseObject((String)mergeTaskIndsStr, Map.class);
                        if (mergeTaskInds.size() > 1) {
                            taskObjs = APP_SERVICE.queryTaskInfos(mergeTaskIds);
                            taskRollbackMap.clear();
                            taskRollbackMap = Arrays.stream(taskObjs).collect(Collectors.toMap(x -> x.getLong("id"), y -> y.getBoolean("isrollbacked"), (v1, v2) -> v2));
                            for (int j = 0; j < mergeTaskIds.size(); ++j) {
                                taskItemId = (Long)mergeTaskIds.get(j);
                                areaRegIndicaItemMap = (Map)mergeTaskInds.get(taskItemId);
                                if (!areaRegIndicaItemMap.containsKey(areaId)) continue;
                                areaIndItemList = (List)areaRegIndicaItemMap.get(areaId);
                                taskMap.put(taskItemId, areaIndItemList);
                            }
                        } else {
                            entryIndicatorList = new ArrayList(10);
                            for (DynamicObject evaRecord : evaRecordColl) {
                                indicatorObj = evaRecord.getDynamicObject("indicator");
                                pkValue = (Long)indicatorObj.getPkValue();
                                entryIndicatorList.add(pkValue);
                            }
                            taskMap.put(taskId, entryIndicatorList);
                        }
                    }
                    if ((evalRecordBo = APP_SERVICE.queryPreTaskCrossEvalRecord(taskMap, areaRegEnum)) != null) {
                        indEvalRecordMap = evalRecordBo.getFinishEvalRecordMap();
                        indEvalScoreRecordMap = evalRecordBo.getScoreEvalRecordMap();
                    }
                }
            } else if (AreaRegEnum.ATTACH_AREA.compareTo((Enum)areaRegEnum) == 0) {
                isHaveSoe = false;
                carryFieldArr = ATTACH_CARRY_FIELDS;
                indEvalRecordMap = APP_SERVICE.queryIndEvalRecordOfPreRoleLastTaskNotCross(taskId, areaRegEnum);
            } else {
                return;
            }
            if (carryFieldArr == null) {
                return;
            }
            for (DynamicObject evaRecord : evaRecordColl) {
                DynamicObject soeRecord;
                Long flowrutaskId;
                DynamicObject indicatorObj2 = evaRecord.getDynamicObject("indicator");
                boolean iscanedit = evaRecord.getBoolean("iscanedit");
                Long pkValue2 = (Long)indicatorObj2.getPkValue();
                DynamicObject finishRecord = (DynamicObject)indEvalRecordMap.get(pkValue2);
                if (finishRecord == null || (isrollbacked = ((Boolean)taskRollbackMap.get(flowrutaskId = Long.valueOf(evaRecord.getLong("indflowrutask")))).booleanValue()) || !iscanedit) continue;
                for (String carryField : carryFieldArr) {
                    evaRecord.set(carryField, finishRecord.get(carryField) == null ? "" : finishRecord.get(carryField));
                }
                if (!isHaveSoe || (soeRecord = (DynamicObject)indEvalScoreRecordMap.get(pkValue2)) == null) continue;
                isDealCarrySoe = true;
                if (!openAdjustScore) {
                    evaRecord.set("soe", soeRecord.get("soe") == null ? BigDecimal.ZERO : soeRecord.get("soe"));
                    continue;
                }
                evaRecord.set("adjustval", soeRecord.get("adjustval") == null ? BigDecimal.ZERO : soeRecord.get("adjustval"));
            }
            if (isDealCarrySoe) {
                ObjEvaluationUtils.calculateSSR(view, APP_SERVICE.queryTaskWeight(taskId), false);
            }
            view.updateView("entryentity");
        }
    }

    public static void dealSumAreaPreCarry(IFormView view) {
        DynamicObject preSumAreaObj;
        Long taskId;
        DynamicObject taskObj;
        boolean isrollbacked;
        OperationStatus status = view.getFormShowParameter().getStatus();
        if (status == OperationStatus.EDIT && !(isrollbacked = (taskObj = APP_SERVICE.queryTaskInfo(taskId = (Long)view.getFormShowParameter().getCustomParam("flowrutask"))).getBoolean("isrollbacked")) && (preSumAreaObj = APP_SERVICE.querySumAreaEvalRecordOfPreRoleLastTask(taskId)) != null) {
            String carryOle = preSumAreaObj.getString("ole");
            String carryEval = preSumAreaObj.getString("eval");
            if (carryOle != null && !HRStringUtils.equals((String)"$$NOTNEEDCARRY$$", (String)carryOle)) {
                if (HRStringUtils.isEmpty((String)carryOle)) {
                    carryOle = null;
                }
                view.getModel().setValue("ole", (Object)carryOle);
            }
            if (carryEval != null && !HRStringUtils.equals((String)"$$NOTNEEDCARRY$$", (String)carryEval)) {
                if (HRStringUtils.isEmpty((String)carryEval)) {
                    carryEval = null;
                }
                view.getModel().setValue("eval", (Object)carryEval);
            }
        }
    }

    public static void ExtPointSetScope(DynamicObject assessForm, IFormView view) {
        IPageCache pageCache = view.getPageCache();
        Long activityId = (Long)view.getFormShowParameter().getCustomParam("activity");
        EvalScoreRange evalScoreRange = new EvalScoreRange();
        HRPluginProxy proxy = HRPlugInProxyFactory.create((Object)evalScoreRange, IEvalScoreRange.class, (String)"kd.opmc.epa.business.domain.activitymanage.extpoint.IEvalScoreRange#getEvalScoreRange", (PluginFilter)null);
        List tuples = proxy.callReplaceIfPresent(range -> range.getEvalScoreRange(activityId, assessForm));
        if (tuples != null && tuples.size() > 0 && tuples.get(0) != null) {
            pageCache.put("minscore", ((Tuple)tuples.get((int)0)).item1 == null ? NOT_CONSISTENT_WITH_AREA : ((BigDecimal)((Tuple)tuples.get((int)0)).item1).toString());
            pageCache.put("maxscore", ((Tuple)tuples.get((int)0)).item2 == null ? NOT_CONSISTENT_WITH_AREA : ((BigDecimal)((Tuple)tuples.get((int)0)).item2).toString());
        }
    }

    static {
        EVAL_AREA_FIELDS.put("epa_genarearecord", new String[]{"realfinishdate", "qualityres", "finishdesc", "soe", "evaldesc"});
        EVAL_AREA_FIELDS.put("epa_addsubarearecord", new String[]{"realfinishdate", "qualityres", "finishdesc", "soe", "evaldesc"});
        EVAL_AREA_FIELDS.put("epa_attacharearecord", new String[]{"realfinishdate"});
    }
}

