/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.IFormView;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.activitymanage.ActivityEvaluationObjectApplicationService;
import kd.opmc.pbs.business.external.hrpi.IHRPIWorkRoleService;

public class PersonInfoUtils {
    private static final String SUPERIOR_PANEL = "superiorpanelap";
    private static final String SUPERIOR_NAME_LAB = "superiornamelab";
    private static final String SUPERIOR_IMAGE = "superiorimage";
    private static final String CHARGE_PANEL = "chargepanelap";
    private static final String CHARGE_NAME_LAB = "chargenamelab";
    private static final String CHARGE_IMAGE = "chargeimage";
    private static final String HEAD_SCULPTURE_CARD = "headsculpturecard";
    private static final String LABEL_NAME = "label_name";
    private static final String LABEL_NUMBER = "label_number";
    private static final String LABEL_POSITION = "label_position";
    private static final String LABEL_AFFILIATEORG = "label_affiliateorg";
    private static final String LABEL_PERFORG = "label_perforg";
    private static final String LABEL_PMDPERSON = "label_pmdperson";
    private static final String COMSUFFIX = "_com";
    private static final String CUSSUFFIX = "_cus";

    public static void setPersonCardInfoOfIndicatorAssign(IFormView view, DynamicObject evalObj) {
        Image image = (Image)view.getControl(HEAD_SCULPTURE_CARD);
        image.setUrl(HRImageUrlUtil.getImageFullUrl((String)evalObj.getString("person.headsculpture")));
        PersonInfoUtils.setPersonCardInfo(view, evalObj, "");
        PersonInfoUtils.setSuperiorInfo(view, evalObj.getLong("perffile.depemp.id"));
        PersonInfoUtils.setChargeInfo(view, evalObj.getLong("empposrel.adminorg.id"));
    }

    private static void setChargeInfo(IFormView view, long adminorg) {
        List mainChargeInfoByOrg = ActivityEvaluationObjectApplicationService.getInstance().getMainChargeInfoByOrg(Long.valueOf(adminorg));
        view.setVisible(Boolean.FALSE, new String[]{CHARGE_PANEL});
        if (!ObjectUtils.isEmpty((Object)mainChargeInfoByOrg)) {
            Map chargeInfo = (Map)mainChargeInfoByOrg.get(0);
            Label nameLab = (Label)view.getControl(CHARGE_NAME_LAB);
            if (!ObjectUtils.isEmpty((Object)nameLab)) {
                nameLab.setText(String.valueOf(chargeInfo.get("name")));
            }
            if (!ObjectUtils.isEmpty(chargeInfo.get("headsculpture"))) {
                Image image = (Image)view.getControl(CHARGE_IMAGE);
                image.setUrl(PersonInfoUtils.getImageUrl(String.valueOf(chargeInfo.get("headsculpture"))));
            }
            view.setVisible(Boolean.TRUE, new String[]{CHARGE_PANEL});
        }
    }

    private static String getImageUrl(String imageUrl) {
        return HRStringUtils.equals((String)"/images/pc/emotion/default_person_82_82.png", (String)imageUrl) ? imageUrl : HRImageUrlUtil.getImageFullUrl((String)imageUrl);
    }

    private static void setText(IFormView view, String labelName, String text) {
        Label label = (Label)view.getControl(labelName);
        if (ObjectUtils.isEmpty((Object)label)) {
            return;
        }
        String flexName = labelName.replaceAll("label", "flex");
        if (text == null) {
            view.setVisible(Boolean.FALSE, new String[]{flexName});
        } else {
            view.setVisible(Boolean.TRUE, new String[]{flexName});
            label.setText(text);
        }
    }

    public static void setSuperiorInfo(IFormView view, Long depEmpId) {
        List list;
        ArrayList<Long> depEmpIds = new ArrayList<Long>();
        depEmpIds.add(depEmpId);
        Map resultMap = IHRPIWorkRoleService.getInstance().getDirectSuperiorByDepempId(depEmpIds);
        view.setVisible(Boolean.FALSE, new String[]{SUPERIOR_PANEL});
        if (!ObjectUtils.isEmpty((Object)resultMap) && !ObjectUtils.isEmpty((Object)(list = (List)resultMap.get(depEmpId)))) {
            Map superiorMap = (Map)list.get(0);
            Label nameLab = (Label)view.getControl(SUPERIOR_NAME_LAB);
            if (!ObjectUtils.isEmpty((Object)nameLab)) {
                nameLab.setText(String.valueOf(superiorMap.get("superior.name")));
            }
            if (!ObjectUtils.isEmpty(superiorMap.get("superior.headsculpture"))) {
                Image image = (Image)view.getControl(SUPERIOR_IMAGE);
                image.setUrl(PersonInfoUtils.getImageUrl(String.valueOf(superiorMap.get("superior.headsculpture"))));
            }
            view.setVisible(Boolean.TRUE, new String[]{SUPERIOR_PANEL});
        }
    }

    public static void setCommonPersonCardInfoOfBatchAssign(IFormView view, DynamicObject evalObj) {
        view.setVisible(Boolean.TRUE, new String[]{"commonselectobjap"});
        PersonInfoUtils.setPersonCardInfo(view, evalObj, COMSUFFIX);
    }

    private static void setPersonCardInfo(IFormView view, DynamicObject evalObj, String suffix) {
        PersonInfoUtils.setText(view, LABEL_NAME + suffix, evalObj.getString("person.name"));
        PersonInfoUtils.setText(view, LABEL_NUMBER + suffix, evalObj.getString("person.number"));
        PersonInfoUtils.setText(view, LABEL_POSITION + suffix, evalObj.getString("empposrel.position.name"));
        PersonInfoUtils.setText(view, LABEL_AFFILIATEORG + suffix, evalObj.getString("affiliateadminorg.name"));
        PersonInfoUtils.setText(view, LABEL_PERFORG + suffix, evalObj.getString("perforg.name"));
        PersonInfoUtils.setText(view, LABEL_PMDPERSON + suffix, evalObj.getString("perffile.pmdperson.name"));
    }

    public static void setCustomPersonCardInfoOfBatchAssign(IFormView view, DynamicObject evalObj) {
        PersonInfoUtils.setPersonCardInfo(view, evalObj, CUSSUFFIX);
    }
}

