/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.opmc.epa.business.application.service.scheme.AssessSchemeApplicationService;
import kd.opmc.pbs.business.application.service.timetag.TimeTagApplicationService;

public class TimeTagUtil {
    private static final TimeTagApplicationService TIME_TAG = TimeTagApplicationService.getInstance();
    private static final AssessSchemeApplicationService ASSESS_SCHEME_APPLICATION_SERVICE = AssessSchemeApplicationService.getInstance();

    private TimeTagUtil() {
    }

    public static DynamicObject getCurTimeTag(Long id, String name) {
        if (HRObjectUtils.isEmpty((Object)id)) {
            return null;
        }
        int month = HRDateTimeUtils.getMonth((Date)new Date());
        StringBuilder sb = new StringBuilder();
        if ("Y".equals(name)) {
            sb.append('Y');
        } else if ("H".equals(name)) {
            sb.append('H').append((month - 1) / 6 + 1);
        } else if ("Q".equals(name)) {
            sb.append('Q').append((month - 1) / 3 + 1);
        } else {
            sb.append('M').append(month);
        }
        return TIME_TAG.queryListByCycleTypeNName(id, sb.toString());
    }

    public static List<Long> getTimeTagRangeByYear(int curYear, Long schemeId) {
        int i;
        ArrayList<Long> res = new ArrayList<Long>(10);
        DynamicObject scheme = ASSESS_SCHEME_APPLICATION_SERVICE.queryCycleInfoById(schemeId);
        long cycleType = scheme.getDynamicObject("cycletype").getLong("id");
        DynamicObject[] cycleTags = TIME_TAG.queryListByCycleType(Long.valueOf(cycleType));
        List allTagIds = Arrays.stream(cycleTags).map(tag -> tag.getLong("id")).sorted().collect(Collectors.toList());
        Date startYear = scheme.getDate("startyear");
        Date endYear = scheme.getDate("endyear");
        long startTag = scheme.getDynamicObject("starttimetag").getLong("id");
        long endTag = scheme.getDynamicObject("endtimetag").getLong("id");
        int startYearInt = HRDateTimeUtils.getYear((Date)startYear);
        int endYearInt = 2199;
        if (endYear != null) {
            endYearInt = HRDateTimeUtils.getYear((Date)endYear);
        }
        int starIdx = -1;
        int endIdx = -1;
        for (i = 0; i < allTagIds.size(); ++i) {
            if (startTag == (Long)allTagIds.get(i)) {
                starIdx = i;
            }
            if (endTag != (Long)allTagIds.get(i)) continue;
            endIdx = i;
        }
        for (i = 0; i < allTagIds.size(); ++i) {
            if (i == 0 && curYear == startYearInt) {
                i = starIdx;
            }
            res.add((Long)allTagIds.get(i));
            if (curYear == endYearInt && i == endIdx) break;
        }
        return res;
    }

    public static List<DynamicObject> getTimeTagRange(Long schemeId, Long cycleType) {
        DynamicObject[] dys = TIME_TAG.queryListByCycleType(cycleType);
        List<DynamicObject> list = Arrays.stream(dys).collect(Collectors.toList());
        DynamicObject[] baseInfo = ASSESS_SCHEME_APPLICATION_SERVICE.queryListBySchemeId(schemeId);
        boolean allTag = TimeTagUtil.compareYearAndTimeTag(baseInfo[0]);
        if (allTag) {
            return list;
        }
        Long startTag = baseInfo[0].getDynamicObject("starttimetag").getLong("id");
        Long endTag = baseInfo[0].getDynamicObject("endtimetag").getLong("id");
        List doubleList = Stream.of(list, list).flatMap(Collection::stream).collect(Collectors.toList());
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>(10);
        boolean ref = false;
        for (DynamicObject obj2 : doubleList) {
            if (startTag.equals(obj2.getLong("id"))) {
                ref = true;
            }
            if (ref) {
                resultList.add(obj2);
            }
            if (!ref || !endTag.equals(obj2.getLong("id"))) continue;
            break;
        }
        resultList.sort(Comparator.comparing(obj -> obj.getString("number")));
        return resultList;
    }

    private static boolean compareYearAndTimeTag(DynamicObject dy) {
        Date startYear = dy.getDate("startyear");
        Date endYear = dy.getDate("endyear");
        int startYearInt = Integer.parseInt(HRDateTimeUtils.format((Date)startYear, (String)"yyyy"));
        int endYearInt = endYear == null ? 2199 : Integer.parseInt(HRDateTimeUtils.format((Date)endYear, (String)"yyyy"));
        int yearDiff = endYearInt - startYearInt;
        String tagNum = dy.getDynamicObject("starttimetag").getString("number");
        if ("101010_S".equals(tagNum)) {
            return true;
        }
        String startTag = dy.getDynamicObject("starttimetag").getString("name").substring(1);
        String endTag = dy.getDynamicObject("endtimetag").getString("name").substring(1);
        int tagDiff = Integer.parseInt(startTag) - Integer.parseInt(endTag);
        boolean b1 = tagDiff < 0 && yearDiff == 0;
        boolean b2 = tagDiff > 0 && yearDiff == 1;
        boolean b3 = tagDiff == 0 && yearDiff == 0;
        return !b1 && !b2 && !b3;
    }
}

