/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.utils.permission;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;

public class HisPerResultUtils {
    public static Date getClosestDateFromMap(int year, String monthString, Map<Date, DynamicObject> map) {
        switch (monthString) {
            case "M1": 
            case "Q1": 
            case "H1": 
            case "Y": {
                return HisPerResultUtils.getClosestDate(LocalDate.of(year, 1, 1), map);
            }
            case "M2": {
                return HisPerResultUtils.getClosestDate(LocalDate.of(year, 2, 1), map);
            }
            case "M3": {
                return HisPerResultUtils.getClosestDate(LocalDate.of(year, 3, 1), map);
            }
            case "M4": 
            case "Q2": {
                return HisPerResultUtils.getClosestDate(LocalDate.of(year, 4, 1), map);
            }
            case "M5": {
                return HisPerResultUtils.getClosestDate(LocalDate.of(year, 5, 1), map);
            }
            case "M6": {
                return HisPerResultUtils.getClosestDate(LocalDate.of(year, 6, 1), map);
            }
            case "M7": 
            case "Q3": 
            case "H2": {
                return HisPerResultUtils.getClosestDate(LocalDate.of(year, 7, 1), map);
            }
            case "M8": {
                return HisPerResultUtils.getClosestDate(LocalDate.of(year, 8, 1), map);
            }
            case "M9": {
                return HisPerResultUtils.getClosestDate(LocalDate.of(year, 9, 1), map);
            }
            case "M10": 
            case "Q4": {
                return HisPerResultUtils.getClosestDate(LocalDate.of(year, 10, 1), map);
            }
            case "M11": {
                return HisPerResultUtils.getClosestDate(LocalDate.of(year, 11, 1), map);
            }
            case "M12": {
                return HisPerResultUtils.getClosestDate(LocalDate.of(year, 12, 1), map);
            }
        }
        throw new IllegalArgumentException("Invalid month: " + monthString);
    }

    private static Date getClosestDate(LocalDate localDate, Map<Date, DynamicObject> map) {
        ArrayList<Date> dateList = new ArrayList<Date>(map.keySet());
        Instant instant = localDate.atStartOfDay(ZoneId.systemDefault()).toInstant();
        long timestamp = instant.toEpochMilli();
        int closestIndex = 0;
        for (int i = 0; i < dateList.size(); ++i) {
            if (Math.abs(((Date)dateList.get(i)).getTime() - timestamp) >= Math.abs(((Date)dateList.get(closestIndex)).getTime() - timestamp)) continue;
            closestIndex = i;
        }
        return (Date)dateList.get(closestIndex);
    }
}

