/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.utils.permission;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.opmc.epa.business.domain.assessform.service.AssessFormDomainService;
import kd.opmc.epa.business.domain.assessrule.entityservice.AreaRegEntityService;
import kd.opmc.epa.common.enums.per.AllFieldEnum;
import kd.opmc.epa.common.enums.per.AreaEnum;
import kd.opmc.epa.common.enums.per.FieldEnum;
import kd.opmc.epa.common.enums.per.NodeTypeEnum;
import kd.opmc.epa.common.enums.per.PassessNodeEnum;
import kd.opmc.epa.common.enums.per.ScoreContentEnum;
import kd.opmc.epa.common.utils.per.PerformanceAreaMap;
import kd.opmc.epa.common.utils.per.PerformanceFieldAttachMap;
import kd.opmc.epa.common.utils.per.PerformanceFieldCustomMap;
import kd.opmc.epa.common.utils.per.PerformanceFieldEmpMap;
import kd.opmc.epa.common.utils.per.PerformanceFieldNormalMap;
import kd.opmc.epa.common.utils.per.PerformanceFieldPlusMap;
import kd.opmc.epa.common.utils.per.PerformanceFieldSumMap;
import kd.opmc.epa.common.utils.per.PerformanceShowAreaMap;
import kd.opmc.epa.common.vo.AreaCollBO;
import kd.opmc.epa.common.vo.AssessNodeEntryBO;
import kd.opmc.epa.common.vo.EmpSumBO;
import kd.opmc.pbs.business.application.service.workflow.WorkFlowApplicationService;
import kd.opmc.pbs.business.domain.workflow.entityservice.FlowDefRoleEntityService;
import kd.opmc.pbs.business.domain.workflow.service.FlowDefProcDomainService;
import kd.opmc.pbs.common.utils.OpmcDateUtils;

public class PermissionSettingsUtils {
    private static final WorkFlowApplicationService WORK_FLOW_APPLICATION_SERVICE = WorkFlowApplicationService.getInstance();
    private static final AssessFormDomainService ASSESS_FORM_DOMAIN_SERVICE = AssessFormDomainService.getInstance();
    private static final FlowDefProcDomainService FLOWDEFPROC_DOMAIN_SERVICE = FlowDefProcDomainService.getInstance();
    private static final FlowDefRoleEntityService FLOWDEFROLE_ENTITY_SERVICE = FlowDefRoleEntityService.getInstance();
    private static final AreaRegEntityService AREA_REGENTITY_SERVICE = AreaRegEntityService.getInstance();
    private static final int SUM_SEQ = 100;

    private PermissionSettingsUtils() {
    }

    public static DynamicObject setPermissionSettings(DynamicObject executeScheme) {
        DynamicObject processSetDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"epa_processpermsetting");
        DynamicObjectCollection assessNodeEntry = processSetDynamicObject.getDynamicObjectCollection("assessnodeentry");
        DynamicObjectCollection workFlowEntries = processSetDynamicObject.getDynamicObjectCollection("workflowentry");
        DynamicObjectCollection flowDefnodeEntries = processSetDynamicObject.getDynamicObjectCollection("flowdefnodeentry");
        AssessNodeEntryBO assessNodeEntryBo = new AssessNodeEntryBO(executeScheme, assessNodeEntry, workFlowEntries, flowDefnodeEntries, processSetDynamicObject);
        PermissionSettingsUtils.setEpaProcesspermsettingEntry(assessNodeEntryBo);
        return PermissionSettingsUtils.saveSettings(processSetDynamicObject, executeScheme);
    }

    private static void setEpaProcesspermsettingEntry(AssessNodeEntryBO assessNodeEntryBo) {
        DynamicObject executeScheme = assessNodeEntryBo.getExecuteScheme();
        Long perfWorkFlowId = executeScheme.get("perfworkflow") instanceof Long ? executeScheme.getLong("perfworkflow") : executeScheme.getLong("perfworkflow.id");
        DynamicObject perfworkflow = BusinessDataServiceHelper.loadSingle((Object)perfWorkFlowId, (String)"epa_perfworkflow");
        DynamicObjectCollection flowEntries = perfworkflow.getDynamicObjectCollection("flowentry");
        Long assessFormId = executeScheme.get("assessform") instanceof Long ? executeScheme.getLong("assessform") : executeScheme.getLong("assessform.id");
        DynamicObject areaForm = ASSESS_FORM_DOMAIN_SERVICE.queryScoreSystemByAssessForm(assessFormId);
        DynamicObjectCollection areColls = areaForm.getDynamicObjectCollection("areaconfentry");
        AreaCollBO areaCollBO = PermissionSettingsUtils.getAreaCollBo(areColls);
        DynamicObject empAndSumForm = ASSESS_FORM_DOMAIN_SERVICE.queryAssessForm(assessFormId.longValue());
        EmpSumBO empSumBO = PermissionSettingsUtils.setEmpAndSum(empAndSumForm);
        Set<Long> areaFieldNameSet = PermissionSettingsUtils.getAreaFieldNameSet(areColls, empSumBO, areaCollBO);
        HashSet<Long> nodeSet = new HashSet<Long>();
        int seq = 0;
        for (DynamicObject entry : flowEntries) {
            Long assessnodeId = entry.getLong("passnode");
            Long workflowId = entry.getLong("flowvid");
            PermissionSettingsUtils.setAssessNodeEntry(assessNodeEntryBo.getAssessNodeEntries(), nodeSet, assessnodeId, seq);
            PermissionSettingsUtils.setFlowEntry(assessNodeEntryBo.getWorkflowEntries(), assessnodeId, seq, entry);
            DynamicObjectCollection allNodeDefByWorkflowIds = FLOWDEFPROC_DOMAIN_SERVICE.getAllNodeDefByWorkflowId(workflowId);
            PermissionSettingsUtils.setFlowdefNodeEntry(assessNodeEntryBo.getFlowdefNodeEntries(), workflowId, seq, allNodeDefByWorkflowIds);
            PermissionSettingsUtils.processAreaEntry(areaFieldNameSet, assessNodeEntryBo.getProcessSetDynamicObject(), assessnodeId, allNodeDefByWorkflowIds);
            PermissionSettingsUtils.processContentAreaEntryWithAss(areColls, empSumBO, assessNodeEntryBo.getProcessSetDynamicObject(), assessnodeId, allNodeDefByWorkflowIds, areaCollBO);
            ++seq;
        }
        DynamicObjectCollection entryEntity = perfworkflow.getDynamicObjectCollection("entryentity");
        Long resultConfirmationCount = entryEntity.stream().filter(dynamicObject -> PassessNodeEnum.RESULT_CONFIRMATION.getValue().equals(dynamicObject.getLong("node.id"))).filter(dynamicObject -> dynamicObject.getBoolean("isshow")).count();
        PermissionSettingsUtils.prepareCompleteAndResult(assessNodeEntryBo.getAssessNodeEntries(), seq, resultConfirmationCount);
        if (resultConfirmationCount > 0L) {
            PermissionSettingsUtils.processAreaEntry(areaFieldNameSet, assessNodeEntryBo.getProcessSetDynamicObject(), PassessNodeEnum.RESULT_CONFIRMATION.getValue(), null);
        }
        PermissionSettingsUtils.processAreaEntry(areaFieldNameSet, assessNodeEntryBo.getProcessSetDynamicObject(), PassessNodeEnum.COMPLETE_CHECK.getValue(), null);
        PermissionSettingsUtils.processContentAreaEntry(areColls, empSumBO, assessNodeEntryBo.getProcessSetDynamicObject(), PassessNodeEnum.RESULT_CONFIRMATION.getValue(), areaCollBO);
        PermissionSettingsUtils.processContentAreaEntry(areColls, empSumBO, assessNodeEntryBo.getProcessSetDynamicObject(), PassessNodeEnum.COMPLETE_CHECK.getValue(), areaCollBO);
        PermissionSettingsUtils.setEntry(assessNodeEntryBo.getAssessNodeEntries(), assessNodeEntryBo.getWorkflowEntries(), assessNodeEntryBo.getFlowdefNodeEntries(), resultConfirmationCount);
    }

    private static AreaCollBO getAreaCollBo(DynamicObjectCollection areColls) {
        List normalIdList = areColls.stream().filter(dynamicObject -> dynamicObject.getLong("areareg_id") == AreaEnum.NORMINDCTR.getValue().longValue()).map(dynamicObject -> dynamicObject.getLong("areaconf")).collect(Collectors.toList());
        MainEntityType normalType = EntityMetadataCache.getDataEntityType((String)"epa_normalconf");
        DynamicObject[] norConfArray = BusinessDataServiceHelper.load((Object[])normalIdList.toArray(), (DynamicObjectType)normalType);
        List plusIdList = areColls.stream().filter(dynamicObject -> dynamicObject.getLong("areareg_id") == AreaEnum.PLUSMINUS.getValue().longValue()).map(dynamicObject -> dynamicObject.getLong("areaconf")).collect(Collectors.toList());
        MainEntityType plusType = EntityMetadataCache.getDataEntityType((String)"epa_plusminusconf");
        DynamicObject[] plusConfArray = BusinessDataServiceHelper.load((Object[])plusIdList.toArray(), (DynamicObjectType)plusType);
        List customIdList = areColls.stream().filter(dynamicObject -> dynamicObject.getLong("areareg_id") == AreaEnum.CUSTOM.getValue().longValue()).map(dynamicObject -> dynamicObject.getLong("areaconf")).collect(Collectors.toList());
        MainEntityType customType = EntityMetadataCache.getDataEntityType((String)"epa_customareaconf");
        DynamicObject[] customConfArray = BusinessDataServiceHelper.load((Object[])customIdList.toArray(), (DynamicObjectType)customType);
        List attachIdList = areColls.stream().filter(dynamicObject -> dynamicObject.getLong("areareg_id") == AreaEnum.ATTACH.getValue().longValue()).map(dynamicObject -> dynamicObject.getLong("areaconf")).collect(Collectors.toList());
        MainEntityType attachType = EntityMetadataCache.getDataEntityType((String)"epa_attachconf");
        DynamicObject[] attachArray = BusinessDataServiceHelper.load((Object[])attachIdList.toArray(), (DynamicObjectType)attachType);
        return new AreaCollBO(norConfArray, attachArray, plusConfArray, customConfArray);
    }

    private static EmpSumBO setEmpAndSum(DynamicObject empAndSumForm) {
        DynamicObject empInfConf = BusinessDataServiceHelper.loadSingle((Object)empAndSumForm.getLong("empinfoconf"), (String)"epa_empinfoconf");
        DynamicObject areaPage = AREA_REGENTITY_SERVICE.queryOne((Object)AreaEnum.EMPINFO.getValue());
        DynamicObject sumConf = BusinessDataServiceHelper.loadSingle((Object)empAndSumForm.getLong("sumconf"), (String)"epa_sumconf");
        return new EmpSumBO(empInfConf, areaPage, sumConf);
    }

    private static void setEntry(DynamicObjectCollection assessNodeEntries, DynamicObjectCollection workflowEntries, DynamicObjectCollection flowdefNodeEntries, Long resultConfirmationCount) {
        int i;
        long[] newAssessnodeEntryIds = null;
        newAssessnodeEntryIds = resultConfirmationCount > 0L ? DBServiceHelper.genLongIds((String)"t_epa_assessnodeentry", (int)(assessNodeEntries.size() + 2)) : DBServiceHelper.genLongIds((String)"t_epa_assessnodeentry", (int)(assessNodeEntries.size() + 1));
        long[] newFlowEntryIds = DBServiceHelper.genLongIds((String)"t_epa_workflowentry", (int)workflowEntries.size());
        long[] newFlowdefnodeEntryIds = DBServiceHelper.genLongIds((String)"t_epa_flowdefnodeentry", (int)flowdefNodeEntries.size());
        for (i = 0; i < assessNodeEntries.size(); ++i) {
            ((DynamicObject)assessNodeEntries.get(i)).set("entryboid", (Object)newAssessnodeEntryIds[i]);
            ((DynamicObject)assessNodeEntries.get(i)).set("id", (Object)newAssessnodeEntryIds[i]);
        }
        for (i = 0; i < workflowEntries.size(); ++i) {
            ((DynamicObject)workflowEntries.get(i)).set("entryboidflow", (Object)newFlowEntryIds[i]);
            ((DynamicObject)workflowEntries.get(i)).set("id", (Object)newFlowEntryIds[i]);
        }
        for (i = 0; i < flowdefNodeEntries.size(); ++i) {
            ((DynamicObject)flowdefNodeEntries.get(i)).set("entryboidnode", (Object)newFlowdefnodeEntryIds[i]);
            ((DynamicObject)flowdefNodeEntries.get(i)).set("id", (Object)newFlowdefnodeEntryIds[i]);
        }
    }

    private static void prepareCompleteAndResult(DynamicObjectCollection assessNodeEntries, int count, Long resultConfirmationCount) {
        if (resultConfirmationCount > 0L) {
            DynamicObject resultConfirmEntry = assessNodeEntries.addNew();
            resultConfirmEntry.set("assessnode", (Object)PassessNodeEnum.RESULT_CONFIRMATION.getValue());
            resultConfirmEntry.set("seq", (Object)(++count));
        }
        DynamicObject completeCheckEntry = assessNodeEntries.addNew();
        completeCheckEntry.set("assessnode", (Object)PassessNodeEnum.COMPLETE_CHECK.getValue());
        completeCheckEntry.set("seq", (Object)(++count));
    }

    private static void setFlowdefNodeEntry(DynamicObjectCollection flowdefNodeEntries, Long workflowId, int count, DynamicObjectCollection allNodeDefByWorkflowIds) {
        for (DynamicObject obj : allNodeDefByWorkflowIds) {
            DynamicObject newFlowdefnodeEntry = flowdefNodeEntries.addNew();
            newFlowdefnodeEntry.set("flowdefnode", obj.getPkValue());
            newFlowdefnodeEntry.set("pworkflow", (Object)workflowId);
            newFlowdefnodeEntry.set("seq", (Object)count);
        }
    }

    private static void setFlowEntry(DynamicObjectCollection workflowEntries, Long assessnodeId, int seq, DynamicObject entry) {
        DynamicObject newFlowEntry = workflowEntries.addNew();
        DynamicObject workflow = WORK_FLOW_APPLICATION_SERVICE.getWorkflowById(entry.getLong("flowvid"));
        newFlowEntry.set("workflow", (Object)workflow);
        newFlowEntry.set("passessnode", (Object)assessnodeId);
        newFlowEntry.set("isdefault", (Object)entry.getBoolean("isdefaultflow"));
        newFlowEntry.set("seq", (Object)seq);
    }

    private static void setAssessNodeEntry(DynamicObjectCollection assessNodeEntries, Set<Long> nodeSet, Long assessnodeId, int seq) {
        if (nodeSet.add(assessnodeId)) {
            DynamicObject newAssessnodeEntry = assessNodeEntries.addNew();
            newAssessnodeEntry.set("assessnode", (Object)assessnodeId);
            newAssessnodeEntry.set("seq", (Object)seq);
        }
    }

    private static DynamicObject saveSettings(DynamicObject dynamicObject, DynamicObject executeScheme) {
        Long currentFid = DBServiceHelper.genGlobalLongId();
        Long oldId = DBServiceHelper.genGlobalLongId();
        dynamicObject.set("excutescheme", (Object)executeScheme.getLong("id"));
        dynamicObject.set("name", executeScheme.get("name"));
        dynamicObject.set("number", executeScheme.get("number"));
        dynamicObject.set("status", (Object)"C");
        dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("enable", (Object)"1");
        dynamicObject.set("id", (Object)currentFid);
        dynamicObject.set("masterid", (Object)currentFid);
        dynamicObject.set("boid", (Object)currentFid);
        dynamicObject.set("iscurrentversion", (Object)Boolean.TRUE);
        dynamicObject.set("datastatus", (Object)"1");
        dynamicObject.set("firstbsed", (Object)OpmcDateUtils.getMidnight());
        Long assessFormId = executeScheme.get("assessform") instanceof Long ? executeScheme.getLong("assessform") : executeScheme.getLong("assessform.id");
        dynamicObject.set("assessform", (Object)assessFormId);
        dynamicObject.set("bred", (Object)new Date());
        dynamicObject.set("bsed", (Object)OpmcDateUtils.getMidnight());
        dynamicObject.set("bsled", (Object)OpmcDateUtils.getDefaultBsled());
        dynamicObject.set("sourcevid", (Object)oldId);
        Long perfWorkFlowId = executeScheme.get("perfworkflow") instanceof Long ? executeScheme.getLong("perfworkflow") : executeScheme.getLong("perfworkflow.id");
        dynamicObject.set("perfworkflow", (Object)perfWorkFlowId);
        return dynamicObject;
    }

    private static void processAreaEntry(Set<Long> areaFieldNameSet, DynamicObject dataEntity, Long assessnodeId, DynamicObjectCollection flownodeIds) {
        DynamicObjectCollection areaentryEntities = dataEntity.getDynamicObjectCollection("scopeareaentry");
        if (PassessNodeEnum.RESULT_CONFIRMATION.getValue().equals(assessnodeId) || PassessNodeEnum.COMPLETE_CHECK.getValue().equals(assessnodeId)) {
            PermissionSettingsUtils.setCompleteAndConfirm(areaentryEntities, areaFieldNameSet, assessnodeId);
            return;
        }
        if (flownodeIds == null) {
            return;
        }
        for (int i = 0; i < flownodeIds.size(); ++i) {
            Long nodeTypeId = ((DynamicObject)flownodeIds.get(i)).getLong("nodetype.id");
            for (Long areaNameId : areaFieldNameSet) {
                String key = assessnodeId + "-" + nodeTypeId + "-" + areaNameId;
                if (PerformanceShowAreaMap.getAreaDisplayMapValue((String)key) == null) continue;
                DynamicObject areaentry = areaentryEntities.addNew();
                areaentry.set("scorecontent", (Object)areaNameId);
                areaentry.set("scoreshowarea", (Object)PerformanceShowAreaMap.getAreaDisplayMapValue((String)key));
                areaentry.set("aflowdefnode", ((DynamicObject)flownodeIds.get(i)).getPkValue());
                areaentry.set("seq", (Object)PerformanceShowAreaMap.getAreaSeqMapValue((Long)areaNameId));
                areaentry.set("entryboidarea", (Object)DBServiceHelper.genGlobalLongId());
            }
        }
    }

    private static void setCompleteAndConfirm(DynamicObjectCollection areaentryentities, Set<Long> areaFieldNameSet, Long assessnodeId) {
        for (Long areaId : areaFieldNameSet) {
            String key = assessnodeId + "--" + areaId;
            if (PerformanceShowAreaMap.getAreaDisplayMapValue((String)key) == null) continue;
            DynamicObject areaentry = areaentryentities.addNew();
            areaentry.set("scorecontent", (Object)areaId);
            areaentry.set("scoreshowarea", (Object)PerformanceShowAreaMap.getAreaDisplayMapValue((String)key));
            areaentry.set("aflowdefnode", (Object)(assessnodeId.equals(PassessNodeEnum.RESULT_CONFIRMATION.getValue()) ? PassessNodeEnum.RESULT_CONFIRMATION.getValue() : PassessNodeEnum.COMPLETE_CHECK.getValue()));
            areaentry.set("entryboidarea", (Object)DBServiceHelper.genGlobalLongId());
            areaentry.set("seq", (Object)PerformanceShowAreaMap.getAreaSeqMapValue((Long)areaId));
        }
    }

    private static Set<Long> getAreaFieldNameSet(DynamicObjectCollection areColls, EmpSumBO empSumBO, AreaCollBO areaCollBO) {
        HashSet<Long> areaSet = new HashSet<Long>();
        areaSet.add(ScoreContentEnum.OTHER_EVA.getValue());
        DynamicObject[] normalCollection = areaCollBO.getNormalCollection();
        DynamicObject[] plusCollection = areaCollBO.getPlusCollection();
        for (DynamicObject coll : areColls) {
            long areaConf;
            Long areaId = coll.getLong("areareg.id");
            if (AreaEnum.NORMINDCTR.getValue().equals(areaId)) {
                areaConf = coll.getLong("areaconf");
                DynamicObject normalConf = Arrays.stream(normalCollection).filter(obj -> obj.getLong("id") == areaConf).findFirst().orElse(null);
                if (normalConf == null) continue;
                for (DynamicObject entity : normalConf.getDynamicObjectCollection("entryentity")) {
                    if (FieldEnum.EVALSCORE.getValue().equals(entity.getLong("areafield.id"))) {
                        areaSet.add(ScoreContentEnum.EVALSCORE.getValue());
                        continue;
                    }
                    if (FieldEnum.EVALDESC.getValue().equals(entity.getLong("areafield.id"))) {
                        areaSet.add(ScoreContentEnum.EVALDESC.getValue());
                        continue;
                    }
                    if (!FieldEnum.WEIGHT.getValue().equals(entity.getLong("areafield.id"))) continue;
                    areaSet.add(ScoreContentEnum.WEIGHT.getValue());
                }
            }
            if (!AreaEnum.PLUSMINUS.getValue().equals(areaId)) continue;
            areaConf = coll.getLong("areaconf");
            DynamicObject plusConf = Arrays.stream(plusCollection).filter(obj -> obj.getLong("id") == areaConf).findFirst().orElse(null);
            if (plusConf == null) continue;
            for (DynamicObject entity : plusConf.getDynamicObjectCollection("entryentity")) {
                if (FieldEnum.PLUSEVALSCORE.getValue().equals(entity.getLong("areafield.id"))) {
                    areaSet.add(ScoreContentEnum.EVALSCORE.getValue());
                    continue;
                }
                if (!FieldEnum.PLUSEVALDESC.getValue().equals(entity.getLong("areafield.id"))) continue;
                areaSet.add(ScoreContentEnum.EVALDESC.getValue());
            }
        }
        for (DynamicObject entity : empSumBO.getSumConfDynamicObject().getDynamicObjectCollection("entryentity")) {
            if (!entity.getBoolean("isshow")) continue;
            if (FieldEnum.OLE.getValue().equals(entity.getLong("areafield.id"))) {
                areaSet.add(ScoreContentEnum.OLE.getValue());
                continue;
            }
            if (FieldEnum.OSE.getValue().equals(entity.getLong("areafield.id"))) {
                areaSet.add(ScoreContentEnum.OSE.getValue());
                continue;
            }
            if (!FieldEnum.EVAL.getValue().equals(entity.getLong("areafield.id"))) continue;
            areaSet.add(ScoreContentEnum.EVAL.getValue());
        }
        return areaSet;
    }

    private static void processContentAreaEntryWithAss(DynamicObjectCollection areColls, EmpSumBO empSumBO, DynamicObject dataEntity, Long assessnodeId, DynamicObjectCollection flownodeIds, AreaCollBO areaCollBO) {
        DynamicObjectCollection contentAreaentryEntities = dataEntity.getDynamicObjectCollection("contentareaentry");
        for (int i = 0; i < flownodeIds.size(); ++i) {
            Long nodeTypeId = ((DynamicObject)flownodeIds.get(i)).getLong("nodetype.id");
            PermissionSettingsUtils.handleSumAndEmpWithAss(flownodeIds, empSumBO, i, contentAreaentryEntities, assessnodeId, nodeTypeId);
            DynamicObject[] defRoleByDefNodeId = FLOWDEFROLE_ENTITY_SERVICE.getDefRoleByDefNodeId(Long.valueOf(((DynamicObject)flownodeIds.get(i)).getLong("id")));
            long[] newContentAreaEntryIds = DBServiceHelper.genLongIds((String)"t_epa_contentareaentry", (int)areColls.size());
            for (int j = 0; j < areColls.size(); ++j) {
                String key = PermissionSettingsUtils.getAreaKey(areColls, assessnodeId, nodeTypeId, defRoleByDefNodeId, j);
                if (PerformanceAreaMap.getAreaDisplayMapValue((String)key) == null) continue;
                DynamicObject contentareaentry = PermissionSettingsUtils.setAreaEntry(areColls, contentAreaentryEntities, j, key, newContentAreaEntryIds[j]);
                contentareaentry.set("pflowdefnode", ((DynamicObject)flownodeIds.get(i)).getPkValue());
                DynamicObjectCollection contentfieldentryentities = contentareaentry.getDynamicObjectCollection("contentfieldentry");
                Long arearegId = ((DynamicObject)areColls.get(j)).getLong("areareg_id");
                if (AreaEnum.NORMINDCTR.getValue().equals(arearegId)) {
                    PermissionSettingsUtils.setNormalFieldArea(areColls, assessnodeId, nodeTypeId, defRoleByDefNodeId, j, contentareaentry, contentfieldentryentities, areaCollBO.getNormalCollection());
                    continue;
                }
                if (AreaEnum.PLUSMINUS.getValue().equals(arearegId)) {
                    PermissionSettingsUtils.setPlusFieldArea(areColls, assessnodeId, nodeTypeId, defRoleByDefNodeId, j, contentareaentry, contentfieldentryentities, areaCollBO.getPlusCollection());
                    continue;
                }
                if (AreaEnum.ATTACH.getValue().equals(arearegId)) {
                    PermissionSettingsUtils.setAttachFieldArea(areColls, assessnodeId, nodeTypeId, defRoleByDefNodeId, j, contentareaentry, contentfieldentryentities, areaCollBO.getAttachCollection());
                    continue;
                }
                if (!AreaEnum.CUSTOM.getValue().equals(arearegId)) continue;
                PermissionSettingsUtils.setCustomFieldArea(areColls, assessnodeId, nodeTypeId, j, contentareaentry, contentfieldentryentities, areaCollBO.getCustomCollection());
            }
        }
    }

    private static DynamicObject setAreaEntry(DynamicObjectCollection areColls, DynamicObjectCollection contentAreaentryEntities, int j, String key, long newContentAreaEntryId) {
        DynamicObject contentareaentry = contentAreaentryEntities.addNew();
        contentareaentry.set("areapage", (Object)((DynamicObject)areColls.get(j)).getLong("areareg_id"));
        contentareaentry.set("displaysettings", (Object)PerformanceAreaMap.getAreaDisplayMapValue((String)key));
        contentareaentry.set("areadisplayitem", (Object)PerformanceAreaMap.getAreaDisplay((String)key));
        contentareaentry.set("updatesettings", (Object)PerformanceAreaMap.getAreaUpdateMapValue((String)key));
        contentareaentry.set("areamodifyitem", (Object)PerformanceAreaMap.getAreaUpdate((String)key));
        contentareaentry.set("entryboidfield", (Object)newContentAreaEntryId);
        contentareaentry.set("id", (Object)newContentAreaEntryId);
        contentareaentry.set("seq", (Object)(j + 1));
        return contentareaentry;
    }

    private static void setAttachFieldArea(DynamicObjectCollection areColls, Long assessnodeId, Long nodeTypeId, DynamicObject[] defRoleByDefNodeId, int j, DynamicObject contentareaentry, DynamicObjectCollection contentfieldentryentities, DynamicObject[] dynamicObjectCollection) {
        long areaConf = ((DynamicObject)areColls.get(j)).getLong("areaconf");
        DynamicObject attachConf = Arrays.stream(dynamicObjectCollection).filter(obj -> obj.getLong("id") == areaConf).findFirst().orElse(null);
        if (attachConf == null) {
            return;
        }
        contentareaentry.set("areapageinsname", (Object)attachConf.getString("areacustname"));
        contentareaentry.set("areapageinsid", (Object)attachConf.getLong("id"));
        DynamicObjectCollection attachconfColls = attachConf.getDynamicObjectCollection("entryentity");
        long[] newContentFieldEntryIds = DBServiceHelper.genLongIds((String)"t_epa_contentfieldentry", (int)attachconfColls.size());
        for (int k = 0; k < attachconfColls.size(); ++k) {
            Long areaField = ((DynamicObject)attachconfColls.get(k)).getLong("areafield.id");
            String fieldKey = PermissionSettingsUtils.getFieldKey(assessnodeId, nodeTypeId, defRoleByDefNodeId, areaField);
            if (PerformanceFieldAttachMap.getAreaDisplayMapValue((String)fieldKey) == null) continue;
            DynamicObject contentfieldentry = contentfieldentryentities.addNew();
            contentfieldentry.set("areafield", (Object)areaField);
            contentfieldentry.set("fielddissettings", (Object)PerformanceFieldAttachMap.getAreaDisplayMapValue((String)fieldKey));
            contentfieldentry.set("fielddisplayitem", (Object)PerformanceFieldAttachMap.getAreaDisplay((String)fieldKey));
            contentfieldentry.set("fieldupsettings", (Object)PerformanceFieldAttachMap.getAreaUpdateMapValue((String)fieldKey));
            contentfieldentry.set("fieldmodifyitem", (Object)PerformanceFieldAttachMap.getAreaUpdate((String)fieldKey));
            contentfieldentry.set("requiredsettings", (Object)PerformanceFieldAttachMap.getAreaRequiredMapValue((String)fieldKey));
            contentfieldentry.set("fieldmustinputitem", (Object)PerformanceFieldAttachMap.getAreaRequired((String)fieldKey));
            contentfieldentry.set("areafieldname", (Object)((DynamicObject)attachconfColls.get(k)).getString("fieldcustname"));
            contentfieldentry.set("entryboidsubfield", (Object)newContentFieldEntryIds[k]);
            contentfieldentry.set("id", (Object)newContentFieldEntryIds[k]);
            contentfieldentry.set("seq", (Object)k);
        }
    }

    private static void setPlusFieldArea(DynamicObjectCollection areColls, Long assessnodeId, Long nodeTypeId, DynamicObject[] defRoleByDefNodeId, int j, DynamicObject contentareaentry, DynamicObjectCollection contentfieldentryentities, DynamicObject[] dynamicObjectCollection) {
        long areaConf = ((DynamicObject)areColls.get(j)).getLong("areaconf");
        DynamicObject plusminusConf = Arrays.stream(dynamicObjectCollection).filter(obj -> obj.getLong("id") == areaConf).findFirst().orElse(null);
        if (plusminusConf == null) {
            return;
        }
        contentareaentry.set("areapageinsname", (Object)plusminusConf.getString("areacustname"));
        contentareaentry.set("areapageinsid", (Object)plusminusConf.getLong("id"));
        DynamicObjectCollection plusminusColls = plusminusConf.getDynamicObjectCollection("entryentity");
        long[] newContentFieldEntryIds = DBServiceHelper.genLongIds((String)"t_epa_contentfieldentry", (int)plusminusColls.size());
        for (int k = 0; k < plusminusColls.size(); ++k) {
            Long areaField = ((DynamicObject)plusminusColls.get(k)).getLong("areafield.id");
            String fieldKey = PermissionSettingsUtils.getFieldKey(assessnodeId, nodeTypeId, defRoleByDefNodeId, areaField);
            if (PerformanceFieldPlusMap.getAreaDisplayMapValue((String)fieldKey) == null) continue;
            DynamicObject contentfieldentry = contentfieldentryentities.addNew();
            contentfieldentry.set("areafield", (Object)areaField);
            contentfieldentry.set("fielddissettings", (Object)PerformanceFieldPlusMap.getAreaDisplayMapValue((String)fieldKey));
            contentfieldentry.set("fielddisplayitem", (Object)PerformanceFieldPlusMap.getAreaDisplay((String)fieldKey));
            contentfieldentry.set("fieldupsettings", (Object)PerformanceFieldPlusMap.getAreaUpdateMapValue((String)fieldKey));
            contentfieldentry.set("fieldmodifyitem", (Object)PerformanceFieldPlusMap.getAreaUpdate((String)fieldKey));
            contentfieldentry.set("requiredsettings", (Object)PerformanceFieldPlusMap.getAreaRequiredMapValue((String)fieldKey));
            contentfieldentry.set("fieldmustinputitem", (Object)PerformanceFieldPlusMap.getAreaRequired((String)fieldKey));
            contentfieldentry.set("entryboidsubfield", (Object)newContentFieldEntryIds[k]);
            contentfieldentry.set("areafieldname", (Object)((DynamicObject)plusminusColls.get(k)).getString("fieldcustname"));
            contentfieldentry.set("id", (Object)newContentFieldEntryIds[k]);
            contentfieldentry.set("seq", (Object)k);
        }
    }

    private static String getFieldKey(Long assessnodeId, Long nodeTypeId, DynamicObject[] defRoleByDefNodeId, Long areaField) {
        String fieldKey = null;
        if (nodeTypeId == 0L) {
            fieldKey = String.valueOf(assessnodeId) + "-" + "-" + areaField;
            return fieldKey;
        }
        if (NodeTypeEnum.AUDIT_FORMULATE.getValue().equals(nodeTypeId) && defRoleByDefNodeId != null && defRoleByDefNodeId.length > 0 && !defRoleByDefNodeId[0].getBoolean("reviewercanedit")) {
            fieldKey = String.valueOf(assessnodeId) + "-" + nodeTypeId + areaField;
            return fieldKey;
        }
        fieldKey = String.valueOf(assessnodeId) + "-" + nodeTypeId + "-" + areaField;
        return fieldKey;
    }

    private static void setNormalFieldArea(DynamicObjectCollection areColls, Long assessnodeId, Long nodeTypeId, DynamicObject[] defRoleByDefNodeId, int j, DynamicObject contentareaentry, DynamicObjectCollection contentfieldentryentities, DynamicObject[] dynamicObjectCollection) {
        long areaConf = ((DynamicObject)areColls.get(j)).getLong("areaconf");
        DynamicObject normalConf = Arrays.stream(dynamicObjectCollection).filter(obj -> obj.getLong("id") == areaConf).findFirst().orElse(null);
        if (normalConf == null) {
            return;
        }
        contentareaentry.set("areapageinsname", (Object)normalConf.getString("areacustname"));
        contentareaentry.set("areapageinsid", (Object)normalConf.getLong("id"));
        DynamicObjectCollection normalColls = normalConf.getDynamicObjectCollection("entryentity");
        long[] newContentFieldEntryIds = DBServiceHelper.genLongIds((String)"t_epa_contentfieldentry", (int)normalColls.size());
        for (int k = 0; k < normalColls.size(); ++k) {
            Long areaField = ((DynamicObject)normalColls.get(k)).getLong("areafield.id");
            String fieldKey = PermissionSettingsUtils.getFieldKey(assessnodeId, nodeTypeId, defRoleByDefNodeId, areaField);
            if (PerformanceFieldNormalMap.getAreaDisplayMapValue((String)fieldKey) == null) continue;
            DynamicObject contentfieldentry = contentfieldentryentities.addNew();
            contentfieldentry.set("areafield", (Object)areaField);
            contentfieldentry.set("fielddissettings", (Object)PerformanceFieldNormalMap.getAreaDisplayMapValue((String)fieldKey));
            contentfieldentry.set("fielddisplayitem", (Object)PerformanceFieldNormalMap.getAreaDisplay((String)fieldKey));
            contentfieldentry.set("fieldupsettings", (Object)PerformanceFieldNormalMap.getAreaUpdateMapValue((String)fieldKey));
            contentfieldentry.set("fieldmodifyitem", (Object)PerformanceFieldNormalMap.getAreaUpdate((String)fieldKey));
            contentfieldentry.set("requiredsettings", (Object)PerformanceFieldNormalMap.getAreaRequiredMapValue((String)fieldKey));
            contentfieldentry.set("fieldmustinputitem", (Object)PerformanceFieldNormalMap.getAreaRequired((String)fieldKey));
            contentfieldentry.set("areafieldname", (Object)((DynamicObject)normalColls.get(k)).getString("fieldcustname"));
            contentfieldentry.set("entryboidsubfield", (Object)newContentFieldEntryIds[k]);
            contentfieldentry.set("id", (Object)newContentFieldEntryIds[k]);
            contentfieldentry.set("seq", (Object)k);
        }
    }

    private static String getAreaKey(DynamicObjectCollection areColls, Long assessnodeId, Long nodeTypeId, DynamicObject[] defRoleByDefNodeId, int j) {
        String key = null;
        if (NodeTypeEnum.AUDIT_FORMULATE.getValue().equals(nodeTypeId) && defRoleByDefNodeId != null && defRoleByDefNodeId.length > 0 && !defRoleByDefNodeId[0].getBoolean("reviewercanedit")) {
            key = String.valueOf(assessnodeId) + "-" + nodeTypeId + ((DynamicObject)areColls.get(j)).getLong("areareg_id");
            return key;
        }
        key = String.valueOf(assessnodeId) + "-" + nodeTypeId + "-" + ((DynamicObject)areColls.get(j)).getLong("areareg_id");
        return key;
    }

    private static void handleSumAndEmpWithAss(DynamicObjectCollection flownodeIds, EmpSumBO empSumBO, int i, DynamicObjectCollection contentAreaentryEntities, Long assessnodeId, Long nodeTypeId) {
        String sumKey;
        long[] newContentAreaEntryIds = DBServiceHelper.genLongIds((String)"t_epa_contentareaentry", (int)2);
        String empKey = String.valueOf(assessnodeId) + "-" + nodeTypeId + "-" + AreaEnum.EMPINFO.getValue();
        if (PerformanceAreaMap.getAreaDisplayMapValue((String)empKey) != null) {
            DynamicObject contentareaentry = PermissionSettingsUtils.setEmpAreaEntry(empSumBO, contentAreaentryEntities, empKey);
            contentareaentry.set("entryboidfield", (Object)newContentAreaEntryIds[0]);
            contentareaentry.set("id", (Object)newContentAreaEntryIds[0]);
            contentareaentry.set("pflowdefnode", ((DynamicObject)flownodeIds.get(i)).getPkValue());
            DynamicObjectCollection contentfieldentryentities = contentareaentry.getDynamicObjectCollection("contentfieldentry");
            DynamicObjectCollection empinfColls = empSumBO.getEmpConfDynamicObject().getDynamicObjectCollection("entryentity");
            long[] newContentFieldEntryIds = DBServiceHelper.genLongIds((String)"t_epa_contentfieldentry", (int)empinfColls.size());
            PermissionSettingsUtils.setEmpFieldEntry(contentfieldentryentities, empinfColls, newContentFieldEntryIds);
        }
        if (PerformanceAreaMap.getAreaDisplayMapValue((String)(sumKey = String.valueOf(assessnodeId) + "-" + nodeTypeId + "-" + AreaEnum.SUM.getValue())) != null) {
            DynamicObject contentareaentry = PermissionSettingsUtils.setSumAreaEntry(empSumBO, contentAreaentryEntities, sumKey);
            contentareaentry.set("entryboidfield", (Object)newContentAreaEntryIds[1]);
            contentareaentry.set("id", (Object)newContentAreaEntryIds[1]);
            contentareaentry.set("pflowdefnode", ((DynamicObject)flownodeIds.get(i)).getPkValue());
            DynamicObjectCollection contentfieldentryentities = contentareaentry.getDynamicObjectCollection("contentfieldentry");
            DynamicObjectCollection sumconfColls = empSumBO.getSumConfDynamicObject().getDynamicObjectCollection("entryentity");
            long[] newContentFieldEntryIds = DBServiceHelper.genLongIds((String)"t_epa_contentfieldentry", (int)sumconfColls.size());
            if (nodeTypeId.equals(NodeTypeEnum.BATCH_ADJUST.getValue())) {
                PermissionSettingsUtils.setSumFieldEntry(assessnodeId, contentfieldentryentities, sumconfColls, nodeTypeId);
            } else {
                PermissionSettingsUtils.setSumFieldEntry(assessnodeId, contentfieldentryentities, sumconfColls, newContentFieldEntryIds, nodeTypeId);
            }
        }
    }

    private static DynamicObject setEmpAreaEntry(EmpSumBO empSumBO, DynamicObjectCollection contentAreaentryEntities, String empKey) {
        DynamicObject contentareaentry = contentAreaentryEntities.addNew();
        contentareaentry.set("areapage", (Object)AreaEnum.EMPINFO.getValue());
        contentareaentry.set("displaysettings", (Object)PerformanceAreaMap.getAreaDisplayMapValue((String)empKey));
        contentareaentry.set("areadisplayitem", (Object)PerformanceAreaMap.getAreaDisplay((String)empKey));
        contentareaentry.set("updatesettings", (Object)PerformanceAreaMap.getAreaUpdateMapValue((String)empKey));
        contentareaentry.set("areamodifyitem", (Object)PerformanceAreaMap.getAreaUpdate((String)empKey));
        contentareaentry.set("areapageinsid", (Object)empSumBO.getEmpConfDynamicObject().getLong("id"));
        contentareaentry.set("areapageinsname", (Object)empSumBO.getEmpDynamicObject().getString("name"));
        return contentareaentry;
    }

    private static DynamicObject setSumAreaEntry(EmpSumBO empSumBO, DynamicObjectCollection contentAreaentryEntities, String sumKey) {
        DynamicObject contentareaentry = contentAreaentryEntities.addNew();
        contentareaentry.set("areapage", (Object)AreaEnum.SUM.getValue());
        contentareaentry.set("displaysettings", (Object)PerformanceAreaMap.getAreaDisplayMapValue((String)sumKey));
        contentareaentry.set("areadisplayitem", (Object)PerformanceAreaMap.getAreaDisplay((String)sumKey));
        contentareaentry.set("updatesettings", (Object)PerformanceAreaMap.getAreaUpdateMapValue((String)sumKey));
        contentareaentry.set("areamodifyitem", (Object)PerformanceAreaMap.getAreaUpdate((String)sumKey));
        contentareaentry.set("areapageinsid", (Object)empSumBO.getSumConfDynamicObject().getLong("id"));
        contentareaentry.set("areapageinsname", (Object)empSumBO.getSumConfDynamicObject().getString("areacustname"));
        contentareaentry.set("seq", (Object)100);
        return contentareaentry;
    }

    private static void processContentAreaEntry(DynamicObjectCollection areColls, EmpSumBO empSumBO, DynamicObject dataEntity, Long assessnodeId, AreaCollBO areaCollBO) {
        DynamicObjectCollection contentAreaentryEntities = dataEntity.getDynamicObjectCollection("contentareaentry");
        long[] newContentAreaEntryIds = DBServiceHelper.genLongIds((String)"t_epa_contentareaentry", (int)areColls.size());
        PermissionSettingsUtils.handleSumAndEmp(assessnodeId, empSumBO, contentAreaentryEntities);
        for (int j = 0; j < areColls.size(); ++j) {
            String key = String.valueOf(assessnodeId) + "-" + "-" + ((DynamicObject)areColls.get(j)).getLong("areareg_id");
            if (PerformanceAreaMap.getAreaDisplayMapValue((String)key) == null) continue;
            DynamicObject contentareaentry = PermissionSettingsUtils.setAreaEntry(areColls, contentAreaentryEntities, j, key, newContentAreaEntryIds[j]);
            contentareaentry.set("pflowdefnode", (Object)assessnodeId);
            DynamicObjectCollection contentfieldentryentities = contentareaentry.getDynamicObjectCollection("contentfieldentry");
            Long arearegId = ((DynamicObject)areColls.get(j)).getLong("areareg_id");
            if (AreaEnum.NORMINDCTR.getValue().equals(arearegId)) {
                PermissionSettingsUtils.setNormalFieldArea(areColls, assessnodeId, 0L, null, j, contentareaentry, contentfieldentryentities, areaCollBO.getNormalCollection());
                continue;
            }
            if (AreaEnum.PLUSMINUS.getValue().equals(arearegId)) {
                PermissionSettingsUtils.setPlusFieldArea(areColls, assessnodeId, 0L, null, j, contentareaentry, contentfieldentryentities, areaCollBO.getPlusCollection());
                continue;
            }
            if (AreaEnum.ATTACH.getValue().equals(arearegId)) {
                PermissionSettingsUtils.setAttachFieldArea(areColls, assessnodeId, 0L, null, j, contentareaentry, contentfieldentryentities, areaCollBO.getAttachCollection());
                continue;
            }
            if (!AreaEnum.CUSTOM.getValue().equals(arearegId)) continue;
            PermissionSettingsUtils.setCustomFieldArea(areColls, assessnodeId, 0L, j, contentareaentry, contentfieldentryentities, areaCollBO.getCustomCollection());
        }
    }

    private static void setCustomFieldArea(DynamicObjectCollection areColls, Long assessnodeId, Long nodeTypeId, int j, DynamicObject contentareaentry, DynamicObjectCollection contentfieldentryentities, DynamicObject[] dynamicObjectCollection) {
        long areaConf = ((DynamicObject)areColls.get(j)).getLong("areaconf");
        DynamicObject customareaConf = Arrays.stream(dynamicObjectCollection).filter(obj -> obj.getLong("id") == areaConf).findFirst().orElse(null);
        if (customareaConf == null) {
            return;
        }
        contentareaentry.set("areapageinsname", (Object)customareaConf.getString("areacustname"));
        contentareaentry.set("areapageinsid", (Object)customareaConf.getLong("id"));
        DynamicObjectCollection customareaconfColls = customareaConf.getDynamicObjectCollection("entryentity");
        long[] newContentFieldEntryIds = DBServiceHelper.genLongIds((String)"t_epa_contentfieldentry", (int)customareaconfColls.size());
        for (int k = 0; k < customareaconfColls.size(); ++k) {
            Long areaField = ((DynamicObject)customareaconfColls.get(k)).getLong("areafield.id");
            String fieldKey = null;
            fieldKey = nodeTypeId != 0L ? String.valueOf(assessnodeId) + "-" + nodeTypeId + "-" + areaField : String.valueOf(assessnodeId) + "-" + "-" + areaField;
            if (PerformanceFieldCustomMap.getAreaDisplayMapValue((String)fieldKey) == null) continue;
            DynamicObject contentfieldentry = contentfieldentryentities.addNew();
            contentfieldentry.set("areafield", (Object)areaField);
            contentfieldentry.set("fielddissettings", (Object)PerformanceFieldCustomMap.getAreaDisplayMapValue((String)fieldKey));
            contentfieldentry.set("fielddisplayitem", (Object)PerformanceFieldCustomMap.getAreaDisplay((String)fieldKey));
            contentfieldentry.set("fieldupsettings", (Object)PerformanceFieldCustomMap.getAreaUpdateMapValue((String)fieldKey));
            contentfieldentry.set("fieldmodifyitem", (Object)PerformanceFieldCustomMap.getAreaUpdate((String)fieldKey));
            contentfieldentry.set("requiredsettings", (Object)PerformanceFieldCustomMap.getAreaRequiredMapValue((String)fieldKey));
            contentfieldentry.set("fieldmustinputitem", (Object)PerformanceFieldCustomMap.getAreaRequired((String)fieldKey));
            contentfieldentry.set("entryboidsubfield", (Object)newContentFieldEntryIds[k]);
            contentfieldentry.set("areafieldname", (Object)((DynamicObject)customareaconfColls.get(k)).getString("fieldcustname"));
            contentfieldentry.set("id", (Object)newContentFieldEntryIds[k]);
            contentfieldentry.set("seq", (Object)k);
        }
    }

    private static void handleSumAndEmp(Long assessnodeId, EmpSumBO empSumBO, DynamicObjectCollection contentAreaentryEntities) {
        String sumKey;
        long[] newContentAreaEntryIds = DBServiceHelper.genLongIds((String)"t_epa_contentareaentry", (int)2);
        String empKey = String.valueOf(assessnodeId) + "-" + "-" + AreaEnum.EMPINFO.getValue();
        if (PerformanceAreaMap.getAreaDisplayMapValue((String)empKey) != null) {
            DynamicObject contentareaentry = PermissionSettingsUtils.setEmpAreaEntry(empSumBO, contentAreaentryEntities, empKey);
            contentareaentry.set("pflowdefnode", (Object)assessnodeId);
            contentareaentry.set("entryboidfield", (Object)newContentAreaEntryIds[0]);
            contentareaentry.set("id", (Object)newContentAreaEntryIds[0]);
            DynamicObjectCollection contentfieldentryentities = contentareaentry.getDynamicObjectCollection("contentfieldentry");
            DynamicObjectCollection empinfColls = empSumBO.getEmpConfDynamicObject().getDynamicObjectCollection("entryentity");
            long[] newContentFieldEntryIds = DBServiceHelper.genLongIds((String)"t_epa_contentfieldentry", (int)empinfColls.size());
            PermissionSettingsUtils.setEmpFieldEntry(contentfieldentryentities, empinfColls, newContentFieldEntryIds);
        }
        if (PerformanceAreaMap.getAreaDisplayMapValue((String)(sumKey = String.valueOf(assessnodeId) + "-" + "-" + AreaEnum.SUM.getValue())) != null) {
            DynamicObject contentareaentry = PermissionSettingsUtils.setSumAreaEntry(empSumBO, contentAreaentryEntities, sumKey);
            contentareaentry.set("entryboidfield", (Object)newContentAreaEntryIds[1]);
            contentareaentry.set("id", (Object)newContentAreaEntryIds[1]);
            contentareaentry.set("pflowdefnode", (Object)assessnodeId);
            DynamicObjectCollection contentfieldentryentities = contentareaentry.getDynamicObjectCollection("contentfieldentry");
            DynamicObjectCollection sumconfColls = empSumBO.getSumConfDynamicObject().getDynamicObjectCollection("entryentity");
            long[] newContentFieldEntryIds = DBServiceHelper.genLongIds((String)"t_epa_contentfieldentry", (int)sumconfColls.size());
            PermissionSettingsUtils.setSumFieldEntry(assessnodeId, contentfieldentryentities, sumconfColls, newContentFieldEntryIds, 0L);
        }
    }

    private static void setEmpFieldEntry(DynamicObjectCollection contentfieldentryentities, DynamicObjectCollection empEntryEntities, long[] newContentFieldEntryIds) {
        for (int k = 0; k < empEntryEntities.size(); ++k) {
            Long areaField;
            if (!((DynamicObject)empEntryEntities.get(k)).getBoolean("isshow") || PerformanceFieldEmpMap.getAreaDisplayMapValue((String)String.valueOf(areaField = Long.valueOf(((DynamicObject)empEntryEntities.get(k)).getLong("areafield.id")))) == null) continue;
            DynamicObject contentfieldentry = contentfieldentryentities.addNew();
            contentfieldentry.set("areafield", (Object)areaField);
            contentfieldentry.set("fielddissettings", (Object)PerformanceFieldEmpMap.getAreaDisplayMapValue((String)String.valueOf(areaField)));
            contentfieldentry.set("fielddisplayitem", (Object)PerformanceFieldEmpMap.getAreaDisplay((String)String.valueOf(areaField)));
            contentfieldentry.set("fieldupsettings", (Object)PerformanceFieldEmpMap.getAreaUpdateMapValue((String)String.valueOf(areaField)));
            contentfieldentry.set("fieldmodifyitem", (Object)PerformanceFieldEmpMap.getAreaUpdate((String)String.valueOf(areaField)));
            contentfieldentry.set("requiredsettings", (Object)PerformanceFieldEmpMap.getAreaRequiredMapValue((String)String.valueOf(areaField)));
            contentfieldentry.set("fieldmustinputitem", (Object)PerformanceFieldEmpMap.getAreaRequired((String)String.valueOf(areaField)));
            contentfieldentry.set("entryboidsubfield", (Object)newContentFieldEntryIds[k]);
            contentfieldentry.set("areafieldname", (Object)((DynamicObject)empEntryEntities.get(k)).getString("areafield.name"));
            contentfieldentry.set("id", (Object)newContentFieldEntryIds[k]);
            contentfieldentry.set("seq", (Object)k);
        }
    }

    private static void setSumFieldEntry(Long assessnodeId, DynamicObjectCollection contentfieldentryentities, DynamicObjectCollection sumConfDynamicObjectCollection, long[] newContentFieldEntryIds, Long nodeTypeId) {
        for (int k = 0; k < sumConfDynamicObjectCollection.size(); ++k) {
            Long areaField = ((DynamicObject)sumConfDynamicObjectCollection.get(k)).getLong("areafield.id");
            if (!((DynamicObject)sumConfDynamicObjectCollection.get(k)).getBoolean("isshow")) continue;
            String fieldKey = null;
            fieldKey = assessnodeId.equals(PassessNodeEnum.RESULT_CONFIRMATION.getValue()) || assessnodeId.equals(PassessNodeEnum.COMPLETE_CHECK.getValue()) ? String.valueOf(assessnodeId) + "-" + "-" + areaField : String.valueOf(assessnodeId) + "-" + nodeTypeId + "-" + areaField;
            String displayMapValue = PerformanceFieldSumMap.getAreaDisplayMapValue((String)fieldKey);
            if (displayMapValue == null) continue;
            DynamicObject contentfieldentry = contentfieldentryentities.addNew();
            contentfieldentry.set("areafield", (Object)areaField);
            contentfieldentry.set("fielddissettings", (Object)displayMapValue);
            contentfieldentry.set("fielddisplayitem", (Object)PerformanceFieldSumMap.getAreaDisplay((String)fieldKey));
            contentfieldentry.set("fieldupsettings", (Object)PerformanceFieldSumMap.getAreaUpdateMapValue((String)fieldKey));
            contentfieldentry.set("fieldmodifyitem", (Object)PerformanceFieldSumMap.getAreaUpdate((String)fieldKey));
            contentfieldentry.set("requiredsettings", (Object)PerformanceFieldSumMap.getAreaRequiredMapValue((String)fieldKey));
            contentfieldentry.set("fieldmustinputitem", (Object)PerformanceFieldSumMap.getAreaRequired((String)fieldKey));
            contentfieldentry.set("entryboidsubfield", (Object)newContentFieldEntryIds[k]);
            contentfieldentry.set("areafieldname", (Object)((DynamicObject)sumConfDynamicObjectCollection.get(k)).getString("fieldcustname"));
            contentfieldentry.set("id", (Object)newContentFieldEntryIds[k]);
            contentfieldentry.set("seq", (Object)k);
        }
    }

    private static void setSumFieldEntry(Long assessnodeId, DynamicObjectCollection contentfieldentryentities, DynamicObjectCollection sumconfColls, Long nodeTypeId) {
        if (assessnodeId.equals(PassessNodeEnum.PERFORMANCE_EVALUATION.getValue()) && nodeTypeId.equals(NodeTypeEnum.BATCH_ADJUST.getValue())) {
            long[] longIds = DBServiceHelper.genLongIds((String)"t_epa_contentfieldentry", (int)3);
            String fieldKey = String.valueOf(assessnodeId) + "-" + nodeTypeId + "-" + AllFieldEnum.SUM_ADJUSTSCORE.getValue();
            PermissionSettingsUtils.setAdjustSumContentFieldEntry(contentfieldentryentities, AllFieldEnum.SUM_ADJUSTSCORE.getValue(), fieldKey, longIds, 0, ResManager.loadKDString((String)"\u8c03\u6574\u5206", (String)"PermissionSettingsUtils_0", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            fieldKey = String.valueOf(assessnodeId) + "-" + nodeTypeId + "-" + AllFieldEnum.SUM_ADJUSTSDESC.getValue();
            PermissionSettingsUtils.setAdjustSumContentFieldEntry(contentfieldentryentities, AllFieldEnum.SUM_ADJUSTSDESC.getValue(), fieldKey, longIds, 1, ResManager.loadKDString((String)"\u8c03\u6574\u8bf4\u660e", (String)"PermissionSettingsUtils_1", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            long count = sumconfColls.stream().filter(dynamicObject -> AllFieldEnum.SUM_OLE.getValue().equals(dynamicObject.getLong("areafield.id"))).filter(dynamicObject -> dynamicObject.getBoolean("isshow")).count();
            if (count > 0L) {
                fieldKey = String.valueOf(assessnodeId) + "-" + nodeTypeId + "-" + AllFieldEnum.SUM_ADJUSTRANK.getValue();
                PermissionSettingsUtils.setAdjustSumContentFieldEntry(contentfieldentryentities, AllFieldEnum.SUM_ADJUSTRANK.getValue(), fieldKey, longIds, 2, ResManager.loadKDString((String)"\u603b\u7b49\u7ea7", (String)"PermissionSettingsUtils_2", (String)"opmc-epa-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private static void setAdjustSumContentFieldEntry(DynamicObjectCollection contentfieldentryentities, Long areaField, String fieldKey, long[] newContentFieldEntryIds, int k, String customName) {
        String displayMapValue = PerformanceFieldSumMap.getAreaDisplayMapValue((String)fieldKey);
        DynamicObject contentfieldentry = contentfieldentryentities.addNew();
        contentfieldentry.set("areafield", (Object)areaField);
        contentfieldentry.set("fielddissettings", (Object)displayMapValue);
        contentfieldentry.set("fielddisplayitem", (Object)PerformanceFieldSumMap.getAreaDisplay((String)fieldKey));
        contentfieldentry.set("fieldupsettings", (Object)PerformanceFieldSumMap.getAreaUpdateMapValue((String)fieldKey));
        contentfieldentry.set("fieldmodifyitem", (Object)PerformanceFieldSumMap.getAreaUpdate((String)fieldKey));
        contentfieldentry.set("requiredsettings", (Object)PerformanceFieldSumMap.getAreaRequiredMapValue((String)fieldKey));
        contentfieldentry.set("fieldmustinputitem", (Object)PerformanceFieldSumMap.getAreaRequired((String)fieldKey));
        contentfieldentry.set("entryboidsubfield", (Object)newContentFieldEntryIds[k]);
        contentfieldentry.set("areafieldname", (Object)customName);
        contentfieldentry.set("id", (Object)newContentFieldEntryIds[k]);
        contentfieldentry.set("seq", (Object)k);
    }
}

