/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.formplugin.web.workflow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.engine.extitf.IWorkflowPlugin;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityEvaluationObjectEntityService;
import kd.opmc.epa.formplugin.web.activitymanage.confirm.ListUtils;
import org.apache.commons.lang3.ObjectUtils;

public class ConfirmWorkflowPlugin
implements IWorkflowPlugin {
    private static final Log LOGGER = LogFactory.getLog(ConfirmWorkflowPlugin.class);
    private static final ActivityEvaluationObjectEntityService ACTIVITY_EVALUATION_OBJECT_ENTITY = ActivityEvaluationObjectEntityService.getInstance();

    public List<Long> calcUserIds(AgentExecution execution) {
        String businessKey = execution.getBusinessKey();
        LOGGER.info("get businessKey:", (Object)businessKey);
        if (StringUtils.isEmpty((String)businessKey)) {
            return new ArrayList<Long>();
        }
        DynamicObject evaluationObject = ACTIVITY_EVALUATION_OBJECT_ENTITY.queryOne("person", (Object)Long.parseLong(businessKey));
        if (Objects.isNull(evaluationObject)) {
            LOGGER.error("get businessKey is error,query nothing: {0}", (Object)businessKey);
            return new ArrayList<Long>();
        }
        long personId = evaluationObject.getLong("person.id");
        List<Long> bosUserIdList = this.getBosUserIdsByPersonIds(Collections.singletonList(personId));
        if (ObjectUtils.isEmpty(bosUserIdList)) {
            LOGGER.error("get sysUser is exception,param is", (Object)personId);
            return new ArrayList<Long>();
        }
        Map<Long, Boolean> userIsEnableMap = ListUtils.batchQueryUserIsEnable(bosUserIdList);
        boolean flag = false;
        for (Map.Entry<Long, Boolean> userIsEnableEntry : userIsEnableMap.entrySet()) {
            Boolean userIsEnable = userIsEnableEntry.getValue();
            if (!Boolean.TRUE.equals(userIsEnable)) continue;
            flag = true;
        }
        if (!flag) {
            return new ArrayList<Long>();
        }
        return bosUserIdList;
    }

    private List<Long> getBosUserIdsByPersonIds(List<Long> personIds) {
        HashMap<String, List<Long>> idMaps = new HashMap<String, List<Long>>(1);
        idMaps.put("person", personIds);
        Map userIdMaps = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getUserIdByPersonInfo", (Object[])new Object[]{idMaps});
        if (Boolean.FALSE.equals(userIdMaps.get("success"))) {
            return new ArrayList<Long>();
        }
        Map data = (Map)userIdMaps.get("data");
        if (data == null) {
            return new ArrayList<Long>();
        }
        return data.entrySet().stream().map(entry -> (Long)((Map)entry.getValue()).get("user")).collect(Collectors.toList());
    }
}

