/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.mservice;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.interview.InterviewObjApplication;
import kd.opmc.epa.business.domain.activitymanage.service.ActEvalObjManageDomainService;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import kd.opmc.epa.business.domain.activitymanage.service.AssessEvaluatedDomainService;
import kd.opmc.epa.business.domain.indicator.service.IndicatorGroupDomainService;
import kd.opmc.epa.business.domain.intactivity.service.IntActivityDomainService;
import kd.opmc.epa.business.domain.interview.entityservice.InterviewObjEntityService;
import kd.opmc.epa.business.domain.interview.service.InterviewObjDomainService;
import kd.opmc.epa.business.utils.EvalObjUtils;
import kd.opmc.epa.business.utils.InterViewObjUtils;
import kd.opmc.epa.common.vo.ResponseResult;
import kd.opmc.epa.mservice.api.IEPAActevalobjService;
import kd.opmc.pbs.business.domain.workflow.entity.FlowRuProcBo;

public class EPAActevalobjService
implements IEPAActevalobjService {
    private static final ActEvalObjManageDomainService ACT_EVAL_OBJ_MANAGE_DOMAIN_SERVICE = ActEvalObjManageDomainService.getInstance();
    private static final InterviewObjDomainService INTERVIEW_OBJ_DOMAIN_SERVICE = InterviewObjDomainService.getInstance();
    private static final IndicatorGroupDomainService INDICATOR_GROUP_DOMAIN_SERVICE = IndicatorGroupDomainService.getInstance();
    private static final AssessEvaluatedDomainService ASSESS_EVALUATED_DOMAIN_SERVICE = AssessEvaluatedDomainService.getInstance();
    private static final ActivityEvaluationObjectDomainService ACTIVITY_EVALUATION_OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();
    private static final IntActivityDomainService INT_ACTIVITY_DOMAIN_SERVICE = IntActivityDomainService.getInstance();
    private static final InterviewObjEntityService INTERVIEW_OBJ_ENTITY_SERVICE = InterviewObjEntityService.getInstance();
    private static final InterviewObjApplication INTERVIEW_OBJ_APPLICATION = InterviewObjApplication.getInstance();
    private static final ActivityEvaluationObjectDomainService OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();

    public DynamicObject getActevalobjById(Long actevalobjId) {
        return ACT_EVAL_OBJ_MANAGE_DOMAIN_SERVICE.queryActivityEvaluationObjectById(actevalobjId);
    }

    public DynamicObject getInterViewobjById(Long interviewobjId) {
        return INTERVIEW_OBJ_DOMAIN_SERVICE.queryInterViewObjectById(interviewobjId);
    }

    public Map<Long, List<Long>> getPerffilevOrgIdById(List<Long> actevalobjIdList) {
        return ACT_EVAL_OBJ_MANAGE_DOMAIN_SERVICE.getPerffilevOrgIdById(actevalobjIdList);
    }

    public Map<Long, List<Long>> queryActivityRespersonIdByIds(List<Long> actevalobjIdList) {
        return ACT_EVAL_OBJ_MANAGE_DOMAIN_SERVICE.queryActivityRespersonIdByIds(actevalobjIdList);
    }

    public Map<Long, List<Long>> queryActivityCreateSchemeIdByIds(List<Long> actevalobjIdList) {
        return ACT_EVAL_OBJ_MANAGE_DOMAIN_SERVICE.queryActivityCreateSchemeIdByIds(actevalobjIdList);
    }

    public Map<Long, List<Long>> queryActivityCreateIdByIds(List<Long> actevalobjIdList) {
        return ACT_EVAL_OBJ_MANAGE_DOMAIN_SERVICE.queryActivityCreateIdByIds(actevalobjIdList);
    }

    public DynamicObject[] getActevalobjArrayById(List<Long> actevalobjIds) {
        return ACT_EVAL_OBJ_MANAGE_DOMAIN_SERVICE.queryActivityEvaluationObjectArrayById((Long[])actevalobjIds.stream().toArray(Long[]::new));
    }

    public DynamicObject[] getInterviewobjArrayById(List<Long> interobjIds) {
        return INTERVIEW_OBJ_DOMAIN_SERVICE.queryInterViewObjectArrayById((Long[])interobjIds.stream().toArray(Long[]::new));
    }

    public Map<Long, Map<Long, Long>> queryIndicatorByObjIds(List<Long> evalObjIds) {
        return ACT_EVAL_OBJ_MANAGE_DOMAIN_SERVICE.queryIndicatorByObjIds(evalObjIds);
    }

    public List<Object> buildFlowRuProcBosByObjIds(List<Long> evalObjIds, String workflowType) {
        ArrayList<Object> flowRuProcBos = new ArrayList<Object>(10);
        DynamicObject[] actEvalObjs = null;
        if (HRStringUtils.equals((String)"3", (String)workflowType)) {
            String selectFile = "interact, perffile, interflow, interflowins, person, perforg, adminorg, perfworkflow, interact.adminorg, interact.perfworkflow, empposrel";
            actEvalObjs = INTERVIEW_OBJ_ENTITY_SERVICE.queryInterviewobjsById(selectFile, evalObjIds);
        } else {
            actEvalObjs = ACT_EVAL_OBJ_MANAGE_DOMAIN_SERVICE.queryActEvalObjByIds(evalObjIds);
        }
        for (DynamicObject actEvalObj : actEvalObjs) {
            long flowVid;
            FlowRuProcBo flowRuProcBo = null;
            if (HRStringUtils.equals((String)"2", (String)workflowType)) {
                flowVid = actEvalObj.getLong("evalflow.id");
                flowRuProcBo = EvalObjUtils.buildEvaluationProcBo((DynamicObject)actEvalObj, (Long)flowVid, (String)workflowType);
            } else if (HRStringUtils.equals((String)"3", (String)workflowType)) {
                flowVid = actEvalObj.getLong("interflow.id");
                flowRuProcBo = InterViewObjUtils.buildIntProcBo((DynamicObject)actEvalObj, (Long)flowVid);
            } else {
                flowVid = actEvalObj.getLong("formulateflow.id");
                flowRuProcBo = EvalObjUtils.buildEvaluationProcBo((DynamicObject)actEvalObj, (Long)flowVid, (String)workflowType);
            }
            flowRuProcBos.add(flowRuProcBo);
        }
        return flowRuProcBos;
    }

    public Map<Long, DynamicObject> queryObjIndicatorAreaEntry(List<Long> objGenIndicatorIds, List<Long> objAddsubIndicatorIds) {
        return INDICATOR_GROUP_DOMAIN_SERVICE.queryObjIndicatorAreaEntry(objGenIndicatorIds, objAddsubIndicatorIds);
    }

    public void completeEvaluate(Long actEvalObjId) {
        ASSESS_EVALUATED_DOMAIN_SERVICE.completeEvaluate(actEvalObjId);
    }

    public void finishIndicator(List<Long> objIds) {
        ACTIVITY_EVALUATION_OBJECT_DOMAIN_SERVICE.finishIndicator(objIds);
    }

    public boolean updateActEvaObjFlowInstance(Map<Long, Long> fomulateInsMap, Map<Long, Long> evalInsMap) {
        return ACT_EVAL_OBJ_MANAGE_DOMAIN_SERVICE.updateActEvaObjFlowInstance(fomulateInsMap, evalInsMap);
    }

    public boolean updateIntObjFlowInstance(Map<Long, Long> intInsMap) {
        return ACT_EVAL_OBJ_MANAGE_DOMAIN_SERVICE.updateIntObjFlowInstance(intInsMap);
    }

    public Map<Long, String> queryActEvalObjPerffileNamesByObjIds(List<Long> evalObjIds) {
        return ACT_EVAL_OBJ_MANAGE_DOMAIN_SERVICE.getActEvalObjPerffileNamesByObjIds(evalObjIds);
    }

    public Map<Long, String> queryInterViewObjPerffileNamesByObjIds(List<Long> interObjIds) {
        return INTERVIEW_OBJ_DOMAIN_SERVICE.getInterViewObjPerffileNamesByObjIds(interObjIds);
    }

    public Map<Long, Map<String, String>> queryActEvalObjPerffilePersonInfo(List<Long> evalObjIds) {
        return ACT_EVAL_OBJ_MANAGE_DOMAIN_SERVICE.getActEvalObjPerffilePersonInfoByObjIds(evalObjIds);
    }

    public Map<Long, Map<String, String>> queryInterViewObjPerffilePersonInfo(List<Long> interObjIds) {
        return INTERVIEW_OBJ_DOMAIN_SERVICE.getInterViewObjPerffilePersonInfoByObjIds(interObjIds);
    }

    public DynamicObject[] getIntObjArrayById(List<Long> intObjIds) {
        return INT_ACTIVITY_DOMAIN_SERVICE.queryIntObjectArrayById((Long[])intObjIds.stream().toArray(Long[]::new));
    }

    public void finishIntview(List<Long> intObjIds) {
        INTERVIEW_OBJ_APPLICATION.finishIntview(intObjIds);
    }

    public void setFormulateGroup(Long indicatorGroupId, List<Long> evalObjectIdList) {
        OBJECT_DOMAIN_SERVICE.setFormulateGroup(indicatorGroupId, evalObjectIdList);
    }

    public ResponseResult startFormulateFlow(List<Long> evalObjectIds, int nodeIndex) {
        return OBJECT_DOMAIN_SERVICE.startFormulateFlow(evalObjectIds, nodeIndex);
    }

    public ResponseResult startEvaluate(List<Long> objIds, int nodeIdx) {
        return ASSESS_EVALUATED_DOMAIN_SERVICE.startEvaluate(objIds, nodeIdx);
    }

    public ResponseResult copyIndicatorToEvalObj(Long sourceActivityId, Long targetActivityId) {
        return OBJECT_DOMAIN_SERVICE.copyIndicatorToEvalObj(sourceActivityId, targetActivityId);
    }

    public ResponseResult unifiedDistTask(List<Long> evalObjectIds, int nodeIndex) {
        return OBJECT_DOMAIN_SERVICE.unifiedDistTask(evalObjectIds, nodeIndex);
    }

    public Map<Long, List<Long>> getCooperator(Long activityId, List<Long> authorizedIdList, String businessType) {
        return ACT_EVAL_OBJ_MANAGE_DOMAIN_SERVICE.getCooperator(activityId, authorizedIdList, businessType);
    }

    public Map<Long, Map<String, Object>> getActevaobjPerfFileInfo(List<Long> evalObjIdList) {
        return ACT_EVAL_OBJ_MANAGE_DOMAIN_SERVICE.getActevaobjPerfFileInfo(evalObjIdList);
    }
}

