/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.mservice;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.extplugin.PluginFilter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.mutex.DataMutex;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActivityEvaluationObjectApplicationService;
import kd.opmc.epa.business.application.service.evaluating.ActEvalObjDetailApplicationService;
import kd.opmc.epa.business.domain.evaluating.entity.ContentAreaEntryEvaDto;
import kd.opmc.epa.business.domain.evaluating.entity.ContentFieldEntryEvaDto;
import kd.opmc.epa.business.task.extpoint.IndicatorBatchSubmitCheckService;
import kd.opmc.epa.business.task.extpoint.impl.IndicatorBatchSubmitCheckServiceImpl;
import kd.opmc.epa.business.task.extpoint.vo.IndicateSubmitParam;
import kd.opmc.epa.common.constants.AssessRuleConstants;
import kd.opmc.epa.common.enums.activitymanage.AreaRegEnum;
import kd.opmc.epa.mservice.api.IEPAIndicatorVerificationService;
import kd.opmc.pbs.business.application.service.workflow.FlowRuProcApplicationService;
import kd.opmc.pbs.business.application.service.workflow.WorkFlowApplicationService;
import kd.opmc.pbs.business.domain.workflow.model.FlowRuNodeBo;
import kd.opmc.pbs.business.domain.workflow.vo.NodeIdAndTaskIdMapVO;

public class EPAIndicatorVerificationService
implements IEPAIndicatorVerificationService {
    private static final Log LOG = LogFactory.getLog(EPAIndicatorVerificationService.class);
    private static final ActivityEvaluationObjectApplicationService APP_SERVICE = ActivityEvaluationObjectApplicationService.getInstance();
    private static final FlowRuProcApplicationService FLOW_RU_PROC_APPLICATION_SERVICE = FlowRuProcApplicationService.getInstance();
    private final WorkFlowApplicationService WORK_FLOW_APPLICATION_SERVICE = WorkFlowApplicationService.getInstance();
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final ActEvalObjDetailApplicationService ACT_EVAL_OBJ_DETAIL_APPLICATION_SERVICE = ActEvalObjDetailApplicationService.getInstance();

    public Map<String, Object> indicatorVerification(Map<Long, Long> taskMap) {
        HashMap indicatorMustInputMap;
        List<ContentAreaEntryEvaDto> processPermSetting;
        Map<Long, ContentAreaEntryEvaDto> areaEntryEvaDtoMap;
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        ArrayList<Long> taskIdsList = new ArrayList<Long>(taskMap.values());
        ArrayList<Long> objIds = new ArrayList<Long>(taskMap.keySet());
        ArrayList msgList = new ArrayList(16);
        ArrayList successObj = new ArrayList(16);
        ArrayList canSubmitTask = new ArrayList(16);
        Object[] dynamicObjects = FLOW_RU_PROC_APPLICATION_SERVICE.queryProcByEvaObjIds(objIds);
        DynamicObject[] taskDys = FLOW_RU_PROC_APPLICATION_SERVICE.queryNoOperateTasksById(taskIdsList);
        NodeIdAndTaskIdMapVO nodeIdAndTaskIdMapVO = FLOW_RU_PROC_APPLICATION_SERVICE.getNodeIdAndTaskIdMapVO(taskIdsList);
        List nodeIds = nodeIdAndTaskIdMapVO.getNodeId();
        Map taskNodeIdMap = nodeIdAndTaskIdMapVO.getTaskNodeIdMap();
        HashMap<Long, DynamicObject> nodeIdUserDyMap = new HashMap<Long, DynamicObject>(16);
        HashMap taskIdUserDyMap = new HashMap(16);
        HashMap<Long, Boolean> isLastNodeMap = new HashMap<Long, Boolean>(16);
        List<Long> lockedNodeList = this.getLockedNode(nodeIds, nodeIdUserDyMap);
        ArrayList lockedTaskList = new ArrayList(10);
        for (Long lockedNodeId : lockedNodeList) {
            taskNodeIdMap.forEach((taskId, nodeId) -> {
                if (lockedNodeId.equals(nodeId)) {
                    lockedTaskList.add(taskId);
                    taskIdUserDyMap.put(taskId, nodeIdUserDyMap.get(nodeId));
                }
            });
        }
        resultMap.put("successObj", successObj);
        resultMap.put("canSubmitTask", canSubmitTask);
        Object[] evalDynamicObject = APP_SERVICE.loadDynamicObjectArray(objIds);
        if (ObjectUtils.isEmpty(objIds) || ObjectUtils.isEmpty((Object[])dynamicObjects) || HRArrayUtils.isEmpty((Object[])evalDynamicObject)) {
            return resultMap;
        }
        Object billObj = evalDynamicObject[0];
        DynamicObject actObj = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne((Object)billObj.getLong("activity.id"));
        long ruleId = actObj.getLong("assessform.id");
        DynamicObject assessformDy = APP_SERVICE.queryAssessForm(ruleId);
        ArrayList<DynamicObject> areaList = new ArrayList<DynamicObject>((Collection<DynamicObject>)assessformDy.getDynamicObjectCollection("areaconfentry"));
        DynamicObjectCollection areaEntry = billObj.getDynamicObjectCollection("areaentry");
        HashMap<String, Object> resultMapInput = this.getIndicatorMustInputMap(resultMap, areaEntry, areaEntryEvaDtoMap = this.convert2MapByAreaConf(processPermSetting = this.getProcessPermSetting(areaList, areaEntry, (DynamicObject)billObj, taskMap.get(billObj.getLong("id")))), indicatorMustInputMap = Maps.newHashMapWithExpectedSize((int)10));
        if (resultMapInput != null) {
            return resultMapInput;
        }
        Map personNameAndNumberMap = APP_SERVICE.getPersonNameAndNumberByIds(objIds);
        List<Long> flowVid = this.getFlowVid(objIds);
        List flowsDys = Arrays.stream(dynamicObjects).filter(dynamicObject -> flowVid.contains(dynamicObject.getLong("flowv.id"))).collect(Collectors.toList());
        if (HRArrayUtils.isEmpty((Object[])evalDynamicObject)) {
            LOG.error("evalDynamicObject is empty");
            return resultMap;
        }
        DynamicObject executeScheme = ASSESS_ACTIVITY_APPLICATION_SERVICE.getExecuteSchemeById(Long.valueOf(evalDynamicObject[0].getLong("activity.id")));
        if (HRObjectUtils.isEmpty((Object)executeScheme)) {
            LOG.error("executeScheme is empty");
            return resultMap;
        }
        DynamicObject ruleDy = APP_SERVICE.queryAssessForm(ruleId);
        if (HRObjectUtils.isEmpty((Object)ruleDy)) {
            LOG.error("ruleDy is empty");
            return resultMap;
        }
        for (DynamicObject dynamicObject2 : flowsDys) {
            long id = dynamicObject2.getLong("actevalobj");
            boolean isLastNode = this.currentIsLastNode(id);
            isLastNodeMap.put(id, isLastNode);
        }
        IndicateSubmitParam indicateSubmitParam = new IndicateSubmitParam();
        indicateSubmitParam.setEvalObjTaskMap(taskMap);
        indicateSubmitParam.setTaskDynamicObjects(taskDys);
        indicateSubmitParam.setTaskIdUserDynamicObjectMap(taskIdUserDyMap);
        indicateSubmitParam.setIsLastNodeMap(isLastNodeMap);
        indicateSubmitParam.setLockedTaskList(lockedTaskList);
        indicateSubmitParam.setPersonNameAndNumberMap(personNameAndNumberMap);
        indicateSubmitParam.setFlowDynamicObject(flowsDys);
        indicateSubmitParam.setEvalDynamicObject((DynamicObject[])evalDynamicObject);
        indicateSubmitParam.setAssessFormDynamicObject(ruleDy);
        indicateSubmitParam.setIndicatorMustInputMap((Map)indicatorMustInputMap);
        IndicatorBatchSubmitCheckServiceImpl indicatorBatchSubmitCheckService = new IndicatorBatchSubmitCheckServiceImpl();
        HRPluginProxy proxy = HRPlugInProxyFactory.create((Object)indicatorBatchSubmitCheckService, IndicatorBatchSubmitCheckService.class, (String)"kd.opmc.epa.business.task.extpoint.IndicatorBatchSubmitCheckService#batchSubmitCheck", (PluginFilter)null);
        proxy.callReplaceIfPresent(validate -> validate.batchSubmitCheck(msgList, successObj, canSubmitTask, indicateSubmitParam));
        resultMap.put("msgList", !ObjectUtils.isEmpty(msgList) && msgList.size() > 1 ? msgList.stream().distinct().collect(Collectors.toList()) : msgList);
        resultMap.put("successObj", successObj);
        resultMap.put("canSubmitTask", canSubmitTask);
        return resultMap;
    }

    private HashMap<String, Object> getIndicatorMustInputMap(HashMap<String, Object> resultMap, DynamicObjectCollection areaEntry, Map<Long, ContentAreaEntryEvaDto> areaEntryEvaDtoMap, Map<String, List<String>> indicatorMustInputMap) {
        for (DynamicObject dynamicObject : areaEntry) {
            DynamicObject areaReg = dynamicObject.getDynamicObject("areareg");
            long areaRegId = areaReg.getLong("id");
            Long confId = dynamicObject.getLong("areaconf");
            ContentAreaEntryEvaDto areaEntryEvaDto = areaEntryEvaDtoMap.get(confId);
            String formId = AreaRegEnum.get((Long)areaRegId).getEvalObjAreaPageIdOfAssign();
            DynamicObject conf = null;
            switch (formId) {
                case "epa_genareains_assign": {
                    conf = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryNormalConfigByPk(confId);
                    break;
                }
                case "epa_addsubareains_assign": {
                    conf = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryPlusMinusConfigByPk(confId);
                    break;
                }
                case "epa_attachareains_assign": {
                    conf = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryAttachConfigByPk(confId);
                    break;
                }
            }
            if (conf == null || HRObjectUtils.isEmpty((Object)conf)) {
                return resultMap;
            }
            DynamicObjectCollection entryEntity = conf.getDynamicObjectCollection("entryentity");
            ArrayList<String> mustInputFieldList = new ArrayList<String>(16);
            Map<Long, ContentFieldEntryEvaDto> filePermMap = null;
            if (areaEntryEvaDto != null) {
                filePermMap = this.change2PermMap(areaEntryEvaDto.getContentfieldentry());
            }
            for (DynamicObject fieldInfo : entryEntity) {
                ContentFieldEntryEvaDto permFileDto;
                EntryFieldAp entryFieldAp = new EntryFieldAp();
                String fieldKey = fieldInfo.getString("areafield.number");
                long areaFieldId = fieldInfo.getLong("areafield.id");
                if (filePermMap == null || (permFileDto = filePermMap.get(areaFieldId)) == null || !permFileDto.getFieldDisplayItem().booleanValue()) continue;
                entryFieldAp.setId(fieldKey);
                entryFieldAp.setKey(fieldKey);
                if (HRStringUtils.equals((String)fieldKey, (String)"indctrname") || HRStringUtils.equals((String)fieldKey, (String)"keyactname")) {
                    entryFieldAp.setHyperlink(true);
                }
                if (!permFileDto.getFieldMustInputItem().booleanValue()) continue;
                mustInputFieldList.add(fieldKey);
            }
            String cacheKey = "indicatorMustInput_" + areaRegId + "_" + conf.getLong("id");
            indicatorMustInputMap.put(cacheKey, mustInputFieldList);
        }
        return null;
    }

    private Map<Long, ContentFieldEntryEvaDto> change2PermMap(List<ContentFieldEntryEvaDto> fieldEntryEvaDtos) {
        HashMap<Long, ContentFieldEntryEvaDto> filePermMap = new HashMap<Long, ContentFieldEntryEvaDto>(16);
        if (fieldEntryEvaDtos != null) {
            for (ContentFieldEntryEvaDto fieldEntryEvaDto : fieldEntryEvaDtos) {
                if (fieldEntryEvaDto == null) continue;
                filePermMap.put(fieldEntryEvaDto.getAreaFieldId(), fieldEntryEvaDto);
            }
        }
        return filePermMap;
    }

    private Map<Long, ContentAreaEntryEvaDto> convert2MapByAreaConf(List<ContentAreaEntryEvaDto> contentAreaEntryEvaDtos) {
        HashMap<Long, ContentAreaEntryEvaDto> returnMap = new HashMap<Long, ContentAreaEntryEvaDto>(16);
        if (contentAreaEntryEvaDtos != null) {
            for (ContentAreaEntryEvaDto areaEntryEvaDto : contentAreaEntryEvaDtos) {
                if (areaEntryEvaDto == null) continue;
                Long areaPageInsId = areaEntryEvaDto.getAreaPageInsId();
                returnMap.put(areaPageInsId, areaEntryEvaDto);
            }
        }
        return returnMap;
    }

    private List<ContentAreaEntryEvaDto> getProcessPermSetting(List<DynamicObject> areaList, DynamicObjectCollection areaEntry, DynamicObject dynamicObject, Long taskId) {
        if (ObjectUtils.isEmpty((Object)taskId) || taskId == 0L) {
            return null;
        }
        ArrayList<Long> areaConfigIds = new ArrayList<Long>();
        int commonAreaSeq = 0;
        for (DynamicObject areaDy : areaList) {
            Long areaRegId = areaDy.getLong("areareg.id");
            if (AssessRuleConstants.CUSTOM_AREA_PK.equals(areaRegId)) continue;
            DynamicObject areaInsDy = (DynamicObject)areaEntry.get(commonAreaSeq);
            Long areaConfId = areaInsDy.getLong("areaconf");
            areaConfigIds.add(areaConfId);
            ++commonAreaSeq;
        }
        DynamicObject activityDy = dynamicObject.getDynamicObject("activity");
        Long permissionId = activityDy.getLong("processpermsetting.id");
        DynamicObject ruNodeDy = ACT_EVAL_OBJ_DETAIL_APPLICATION_SERVICE.queryFlowDefNodeIdByruNodeId(this.getFlowRuNodeId(taskId));
        return ACT_EVAL_OBJ_DETAIL_APPLICATION_SERVICE.queryProcessPermSettingByKeyField(permissionId, Long.valueOf(ruNodeDy.getLong("flownodedef.id")), areaConfigIds);
    }

    private List<Long> getLockedNode(List<Long> nodeIds, Map<Long, DynamicObject> nodeIdUserDyMap) {
        ArrayList<Long> lockedNodeList = new ArrayList<Long>(10);
        HashMap<Long, Long> nodeIdUserIdMap = new HashMap<Long, Long>(16);
        ArrayList<Long> lockUserList = new ArrayList<Long>(10);
        for (Long nodeId2 : nodeIds) {
            Long userId2;
            DataMutex dataMutex = DataMutex.create();
            Map lockInfoMap = dataMutex.getLockInfo(nodeId2.toString(), "default_netctrl", "epa_actevalobj");
            if (lockInfoMap == null) continue;
            Long currentUserId = UserServiceHelper.getCurrentUserId();
            if (lockInfoMap.get("userid") == null || (userId2 = Long.valueOf((String)lockInfoMap.get("userid"))) != 0L && currentUserId.equals(userId2)) continue;
            lockedNodeList.add(nodeId2);
            lockUserList.add(userId2);
            nodeIdUserIdMap.put(nodeId2, userId2);
        }
        Map idUserMap = BusinessDataServiceHelper.loadFromCache((Object[])lockUserList.toArray(), (String)"bos_user");
        nodeIdUserIdMap.forEach((nodeId, userId) -> nodeIdUserDyMap.put((Long)nodeId, (DynamicObject)idUserMap.get(userId)));
        return lockedNodeList;
    }

    private Long getFlowRuNodeId(Long taskId) {
        long flowRuNodeId = 0L;
        if (taskId != null && taskId != 0L) {
            DynamicObject taskDy = FLOW_RU_PROC_APPLICATION_SERVICE.getTaskById(taskId);
            flowRuNodeId = taskDy.getLong("flowrunode.id");
        }
        return flowRuNodeId;
    }

    private List<Long> getFlowVid(List<Long> ids) {
        DynamicObject[] dynamicObjects = APP_SERVICE.queryById("formulateflow", ids);
        return Arrays.stream(dynamicObjects).map(dynamicObject -> dynamicObject.getLong("formulateflow.id")).collect(Collectors.toList());
    }

    private boolean currentIsLastNode(Long objId) {
        DynamicObject dynamicObject = APP_SERVICE.queryEvaluatedObj(objId);
        long flowId = dynamicObject.getLong("formulateflow.id");
        ArrayList<Long> flowIds = new ArrayList<Long>(16);
        flowIds.add(flowId);
        ArrayList<Long> objIds = new ArrayList<Long>(16);
        objIds.add(objId);
        DynamicObject[] dynamicObjects = FLOW_RU_PROC_APPLICATION_SERVICE.queryProcByEvaObjIds(objIds);
        List objects = Arrays.stream(dynamicObjects).filter(dyc -> HRObjectUtils.equals((Object)dyc.getLong("flowv.id"), (Object)flowId)).collect(Collectors.toList());
        LOG.info("objects size {}", (Object)objects.size());
        if (!ObjectUtils.isEmpty(objects)) {
            Object[] workFlows = this.WORK_FLOW_APPLICATION_SERVICE.getWorkflowsByVid(flowIds);
            long currentNode = ((DynamicObject)objects.get(0)).getLong("currentnode.id");
            if (currentNode != 0L) {
                FlowRuNodeBo ruNodeInstance = FLOW_RU_PROC_APPLICATION_SERVICE.getRuNodeInstance(Long.valueOf(currentNode));
                DynamicObject flowDefNode = ruNodeInstance.getFlowDefNode();
                String entrySeq = flowDefNode.getString("entryseq");
                LOG.info("entrySeq {}", (Object)entrySeq);
                if (HRArrayUtils.isNotEmpty((Object[])workFlows)) {
                    LOG.info("--------------currentIsLastNode entrySeq:{};nodenum:{};-----------------------", (Object)entrySeq, (Object)workFlows[0].getString("nodenum"));
                    return HRStringUtils.equals((String)entrySeq, (String)workFlows[0].getString("nodenum"));
                }
            }
        }
        LOG.info("currentIsLastNode false");
        return false;
    }
}

