/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.common.enums.activitymanage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;

public enum AssessNodeStatusEnum {
    TO_BE_FORMULATED(1L, "5", "tobeformulated"),
    TARGET_FORMULATING(1L, "10", "targetformulating"),
    TARGET_CHANGING(1L, "20", "targetchanging"),
    TARGET_FORMULATED(1L, "30", "targetformulated"),
    TO_BE_EVALUATED(4L, "10", "tobeevaluated"),
    EVALUATING(4L, "20", "evaluating"),
    EVALUATED(4L, "30", "evaluated"),
    TO_BE_MP(5L, "10", "tobemp"),
    MPING(5L, "20", "mping"),
    MPED(5L, "30", "mped"),
    TO_BE_CALIBRATED(6L, "10", "tobecalibrated"),
    CALIBRATING(6L, "20", "calibrating"),
    CALIBRATED(6L, "30", "calibrated"),
    TO_BE_CONFIRMED(8L, "10", "tobeconfirmed"),
    CONFIRMING(8L, "20", "confirming"),
    CONFIRMED(8L, "30", "confirmed"),
    TO_BE_APPEAL(8L, "40", "tobeappeal"),
    APPEALING(8L, "50", "appealing"),
    TERMINATE(8L, "60", "terminate"),
    END_CONFIRM(8L, "70", "end_confirm");

    private final Long nodeId;
    private final String status;
    private final String labelName;

    private AssessNodeStatusEnum(Long nodeId, String status, String labelName) {
        this.nodeId = nodeId;
        this.status = status;
        this.labelName = labelName;
    }

    public Long getNodeId() {
        return this.nodeId;
    }

    public String getStatus() {
        return this.status;
    }

    public String getLabelName() {
        return this.labelName;
    }

    public static List<AssessNodeStatusEnum> getNodeStatusList(Long nodeId) {
        return Arrays.stream(AssessNodeStatusEnum.values()).filter(nodeStatusEnum -> nodeId.equals(nodeStatusEnum.getNodeId())).collect(Collectors.toList());
    }

    public static AssessNodeStatusEnum getLastNodeStatus(Long nodeId) {
        return Arrays.stream(AssessNodeStatusEnum.values()).filter(nodeStatusEnum -> nodeId.equals(nodeStatusEnum.getNodeId()) && "30".equals(nodeStatusEnum.getStatus())).findFirst().orElse(null);
    }

    public boolean isLastStatus() {
        return "30".equals(this.status);
    }

    public boolean isFirstStatus() {
        return "10".equals(this.status);
    }

    public static AssessNodeStatusEnum getEnumByIdAndStatus(Long nodeId, String status) {
        return Arrays.stream(AssessNodeStatusEnum.values()).filter(statusEnum -> statusEnum.getNodeId().equals(nodeId) && statusEnum.getStatus().equals(status)).findFirst().orElse(null);
    }

    public String getText() {
        String res = "";
        switch (this) {
            case TARGET_FORMULATING: {
                res = ResManager.loadKDString((String)"\u5236\u5b9a\u4e2d", (String)"AssessNodeStatusEnum_0", (String)"opmc-epa-common", (Object[])new Object[0]);
                break;
            }
            case TARGET_CHANGING: {
                res = ResManager.loadKDString((String)"\u53d8\u66f4\u4e2d", (String)"AssessNodeStatusEnum_1", (String)"opmc-epa-common", (Object[])new Object[0]);
                break;
            }
            case TARGET_FORMULATED: {
                res = ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"AssessNodeStatusEnum_2", (String)"opmc-epa-common", (Object[])new Object[0]);
                break;
            }
            case TO_BE_EVALUATED: {
                res = ResManager.loadKDString((String)"\u5f85\u8bc4\u4f30", (String)"AssessNodeStatusEnum_3", (String)"opmc-epa-common", (Object[])new Object[0]);
                break;
            }
            case EVALUATING: {
                res = ResManager.loadKDString((String)"\u8bc4\u4f30\u4e2d", (String)"AssessNodeStatusEnum_4", (String)"opmc-epa-common", (Object[])new Object[0]);
                break;
            }
            case EVALUATED: {
                res = ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"AssessNodeStatusEnum_2", (String)"opmc-epa-common", (Object[])new Object[0]);
                break;
            }
            case TO_BE_CALIBRATED: {
                res = ResManager.loadKDString((String)"\u5f85\u6821\u51c6", (String)"AssessNodeStatusEnum_5", (String)"opmc-epa-common", (Object[])new Object[0]);
                break;
            }
            case CALIBRATING: {
                res = ResManager.loadKDString((String)"\u6821\u51c6\u4e2d", (String)"AssessNodeStatusEnum_6", (String)"opmc-epa-common", (Object[])new Object[0]);
                break;
            }
            case CALIBRATED: {
                res = ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"AssessNodeStatusEnum_2", (String)"opmc-epa-common", (Object[])new Object[0]);
                break;
            }
            case TO_BE_CONFIRMED: {
                res = ResManager.loadKDString((String)"\u5f85\u786e\u8ba4", (String)"AssessNodeStatusEnum_7", (String)"opmc-epa-common", (Object[])new Object[0]);
                break;
            }
            case CONFIRMING: {
                res = ResManager.loadKDString((String)"\u786e\u8ba4\u4e2d", (String)"AssessNodeStatusEnum_8", (String)"opmc-epa-common", (Object[])new Object[0]);
                break;
            }
            case CONFIRMED: {
                res = ResManager.loadKDString((String)"\u5df2\u786e\u8ba4", (String)"AssessNodeStatusEnum_9", (String)"opmc-epa-common", (Object[])new Object[0]);
                break;
            }
            case TO_BE_APPEAL: {
                res = ResManager.loadKDString((String)"\u4e0d\u8ba4\u540c", (String)"AssessNodeStatusEnum_10", (String)"opmc-epa-common", (Object[])new Object[0]);
                break;
            }
            case APPEALING: {
                res = ResManager.loadKDString((String)"\u7533\u8bc9\u4e2d", (String)"AssessNodeStatusEnum_11", (String)"opmc-epa-common", (Object[])new Object[0]);
                break;
            }
            case TERMINATE: {
                res = ResManager.loadKDString((String)"\u5df2\u7ec8\u6b62", (String)"AssessNodeStatusEnum_12", (String)"opmc-epa-common", (Object[])new Object[0]);
                break;
            }
            case END_CONFIRM: {
                res = ResManager.loadKDString((String)"\u7ed3\u675f\u786e\u8ba4", (String)"AssessNodeStatusEnum_13", (String)"opmc-epa-common", (Object[])new Object[0]);
                break;
            }
            case TO_BE_MP: {
                res = ResManager.loadKDString((String)"\u5f85\u6c47\u603b", (String)"AssessNodeStatusEnum_14", (String)"opmc-epa-common", (Object[])new Object[0]);
                break;
            }
            case MPING: {
                res = ResManager.loadKDString((String)"\u6c47\u603b\u4e2d", (String)"AssessNodeStatusEnum_15", (String)"opmc-epa-common", (Object[])new Object[0]);
                break;
            }
            case MPED: {
                res = ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"AssessNodeStatusEnum_2", (String)"opmc-epa-common", (Object[])new Object[0]);
                break;
            }
        }
        return res;
    }

    public static List<String> getNodeIdByName(String nodeName, QFilter qFilter) {
        String cp = qFilter.getCP();
        String value = qFilter.getValue() != null ? qFilter.getValue().toString() : "";
        HashSet<String> nodeStatus = new HashSet<String>();
        long count = value.chars().mapToObj(c -> Character.valueOf((char)c)).filter(c -> c.charValue() == '%').count();
        AssessNodeStatusEnum[] datas = AssessNodeStatusEnum.values();
        for (int i = 0; i < datas.length; ++i) {
            AssessNodeStatusEnum assessNodeStatusEnum = datas[i];
            if (!assessNodeStatusEnum.getText().contains(nodeName)) continue;
            nodeStatus.add(assessNodeStatusEnum.getStatus());
        }
        ArrayList<String> matcherNodes = new ArrayList<String>();
        block17: for (int i = 0; i < datas.length; ++i) {
            AssessNodeStatusEnum data = datas[i];
            String status = data.getStatus();
            String text = data.getText();
            switch (cp) {
                case "like": {
                    if (count == 1L) {
                        if (value.indexOf("%") == 0) {
                            matcherNodes.add(text.endsWith(nodeName) ? status : "0");
                            continue block17;
                        }
                        if (value.indexOf("%") > 0) {
                            matcherNodes.add(text.startsWith(nodeName) ? status : "0");
                            continue block17;
                        }
                    }
                    matcherNodes.add(text.contains(nodeName) ? status : "0");
                    continue block17;
                }
                case "not like": {
                    matcherNodes.add(!text.contains(nodeName) && !nodeStatus.contains(status) ? status : "0");
                    if (HRStringUtils.isEmpty((String)nodeName)) continue block17;
                    matcherNodes.add(" ");
                    continue block17;
                }
                case "=": {
                    matcherNodes.add(nodeName.equals(text) ? status : "0");
                    continue block17;
                }
                case "!=": {
                    matcherNodes.add(!nodeName.equals(text) && !nodeStatus.contains(status) ? status : "0");
                    if (HRStringUtils.isEmpty((String)nodeName)) continue block17;
                    matcherNodes.add(" ");
                    continue block17;
                }
                case "is not null": {
                    matcherNodes.add(status);
                    continue block17;
                }
                case "is null": {
                    matcherNodes.add(" ");
                    continue block17;
                }
                default: {
                    matcherNodes.add("0");
                }
            }
        }
        return matcherNodes;
    }
}

