/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.common.enums.activitymanage;

import java.util.Arrays;

public enum NodeIdScoreEnum {
    EVALUATED(4L, "sop", "lop", "sopsource"),
    SUM(5L, "mpsop", "mplop", "mpsopsource"),
    CALIBRATE(6L, "csop", "clop", "csopsource"),
    INTERVIEW(7L, "", "", ""),
    CONFIRM(8L, "cfsop", "cflop", "cfsopsource");

    private final Long nodeId;
    private final String scoreFieldName;
    private final String levelFieldName;
    private final String sourceFieldName;

    private NodeIdScoreEnum(Long nodeId, String scoreFieldName, String levelFieldName, String sourceFieldName) {
        this.nodeId = nodeId;
        this.scoreFieldName = scoreFieldName;
        this.levelFieldName = levelFieldName;
        this.sourceFieldName = sourceFieldName;
    }

    public static NodeIdScoreEnum getEnumByNodeId(Long nodeId) {
        return Arrays.stream(NodeIdScoreEnum.values()).filter(statusEnum -> statusEnum.getNodeId().equals(nodeId)).findFirst().orElse(null);
    }

    public Long getNodeId() {
        return this.nodeId;
    }

    public String getScoreFieldName() {
        return this.scoreFieldName;
    }

    public String getLevelFieldName() {
        return this.levelFieldName;
    }

    public String getSourceFieldName() {
        return this.sourceFieldName;
    }
}

