/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.common.enums.assessrule;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.opmc.epa.common.vo.PerfworkflowBO;

public enum EvalProcessOperationEnum {
    EDIT("edit", 4),
    VIEW("view", 5),
    PUBLISH("publish", 7),
    START("start", 10),
    BAN("ban", 20),
    DEFAULT("default", 30),
    COPY("copy", 34),
    PERM_CONFIG("perm_config", 37),
    DELETE("delete", 40);

    private String opKey;
    private int sort;

    private EvalProcessOperationEnum(String opKey, int sort) {
        this.opKey = opKey;
        this.sort = sort;
    }

    public int getSort() {
        return this.sort;
    }

    public String getOpKey() {
        return this.opKey;
    }

    public static EvalProcessOperationEnum getOperation(String opKey) {
        return Arrays.stream(EvalProcessOperationEnum.values()).filter(operation -> StringUtils.equals((CharSequence)opKey, (CharSequence)operation.getOpKey())).findFirst().orElse(null);
    }

    public String getOpName() {
        String opName;
        switch (this) {
            case EDIT: {
                opName = ResManager.loadKDString((String)"\u7f16\u8f91", (String)"EvalProcessOperationEnum_0", (String)"opmc-epa-common", (Object[])new Object[0]);
                break;
            }
            case VIEW: {
                opName = ResManager.loadKDString((String)"\u67e5\u770b", (String)"EvalProcessOperationEnum_1", (String)"opmc-epa-common", (Object[])new Object[0]);
                break;
            }
            case PUBLISH: {
                opName = ResManager.loadKDString((String)"\u53d1\u5e03", (String)"EvalProcessOperationEnum_2", (String)"opmc-epa-common", (Object[])new Object[0]);
                break;
            }
            case START: {
                opName = ResManager.loadKDString((String)"\u542f\u7528", (String)"EvalProcessOperationEnum_3", (String)"opmc-epa-common", (Object[])new Object[0]);
                break;
            }
            case BAN: {
                opName = ResManager.loadKDString((String)"\u7981\u7528", (String)"EvalProcessOperationEnum_4", (String)"opmc-epa-common", (Object[])new Object[0]);
                break;
            }
            case DEFAULT: {
                opName = ResManager.loadKDString((String)"\u8bbe\u4e3a\u9ed8\u8ba4", (String)"EvalProcessOperationEnum_5", (String)"opmc-epa-common", (Object[])new Object[0]);
                break;
            }
            case COPY: {
                opName = ResManager.loadKDString((String)"\u590d\u5236", (String)"EvalProcessOperationEnum_6", (String)"opmc-epa-common", (Object[])new Object[0]);
                break;
            }
            case PERM_CONFIG: {
                opName = ResManager.loadKDString((String)"\u6743\u9650\u8bbe\u7f6e", (String)"EvalProcessOperationEnum_7", (String)"opmc-epa-common", (Object[])new Object[0]);
                break;
            }
            case DELETE: {
                opName = ResManager.loadKDString((String)"\u5220\u9664", (String)"EvalProcessOperationEnum_8", (String)"opmc-epa-common", (Object[])new Object[0]);
                break;
            }
            default: {
                opName = "";
            }
        }
        return opName;
    }

    public static List<EvalProcessOperationEnum> getList() {
        EvalProcessOperationEnum[] values = EvalProcessOperationEnum.values();
        return Arrays.asList(values);
    }

    public static List<EvalProcessOperationEnum> getListByOldPerf() {
        return Arrays.asList(START, BAN, DEFAULT, DELETE);
    }

    public static List<EvalProcessOperationEnum> getListByBo(PerfworkflowBO bo) {
        if (bo.isUsed()) {
            return Arrays.asList(VIEW, DEFAULT, COPY, PERM_CONFIG);
        }
        if (!bo.isAvailable()) {
            return Arrays.asList(VIEW, START, COPY);
        }
        if (bo.isPublish()) {
            return Arrays.asList(EDIT, BAN, DEFAULT, COPY, PERM_CONFIG, DELETE);
        }
        if (!bo.isPublish()) {
            return Arrays.asList(EDIT, PUBLISH, COPY, DELETE);
        }
        return Collections.emptyList();
    }
}

