/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.common.utils;

import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobFormInfo;

public class DispatchUtil {
    public static void dispatch(AbstractFormPlugin plugin, Map<String, Object> params, String taskClassname, String caption) {
        DispatchUtil.dispatch(plugin, params, taskClassname, caption, false, "unifieddist");
    }

    public static void dispatch(AbstractFormPlugin plugin, Map<String, Object> params, String taskClassname, String caption, boolean canBackground, String actionId) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("epa");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setParams(params);
        jobInfo.setTaskClassname(taskClassname);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)plugin, actionId);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(ResManager.loadKDString((String)caption, (String)"DispatchUtil_1", (String)"opmc-epa-common", (Object[])new Object[0]));
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(canBackground);
        jobFormInfo.setCanStop(false);
        DispatchUtil.dispatch(jobFormInfo, plugin.getView());
    }

    public static void dispatch(JobFormInfo jobFormInfo, IFormView view) {
        jobFormInfo.setRootPageId(view.getFormShowParameter().getRootPageId());
        jobFormInfo.setParentPageId(view.getPageId());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("epa_taskprogress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (StringUtils.isNotBlank((CharSequence)jobFormInfo.getCaption())) {
            showParameter.setCaption(jobFormInfo.getCaption());
        } else if (StringUtils.isNotBlank((CharSequence)jobFormInfo.getJobInfo().getName())) {
            showParameter.setCaption(jobFormInfo.getJobInfo().getName());
        }
        showParameter.setShowTitle(false);
        showParameter.getCustomParams().put("ServiceAppId", view.getFormShowParameter().getServiceAppId());
        String jobInfoStr = SerializationUtils.toJsonString((Object)jobFormInfo);
        showParameter.getCustomParams().put("sch_clientjobinfo", jobInfoStr);
        showParameter.setCloseCallBack(jobFormInfo.getCloseCallBack());
        view.showForm(showParameter);
    }
}

