/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.common.vo;

import kd.bos.dataentity.resource.ResManager;

public class ResponseResult<T> {
    private Integer code;
    private Boolean status;
    private String message;
    private T data;

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public Boolean getStatus() {
        return this.status;
    }

    public void setStatus(Boolean status) {
        this.status = status;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    private static <T> ResponseResult<T> response(Integer code, Boolean status, String message, T data) {
        ResponseResult<T> responseResult = new ResponseResult<T>();
        responseResult.setCode(code);
        responseResult.setStatus(status);
        String msg = ResManager.loadKDString((String)message, (String)"ResponseResult_0", (String)"opmc-epa-common", (Object[])new Object[0]);
        responseResult.setMessage(msg);
        responseResult.setData(data);
        return responseResult;
    }

    private static <T> ResponseResult<T> response(Integer code, Boolean status, String message) {
        ResponseResult<T> responseResult = new ResponseResult<T>();
        responseResult.setCode(code);
        responseResult.setStatus(status);
        responseResult.setMessage(message);
        return responseResult;
    }

    public static <T> ResponseResult<T> success(Integer code, String message) {
        return ResponseResult.response(code, true, message);
    }

    public static <T> ResponseResult<T> success(String message, T data) {
        return ResponseResult.response(200, true, message, data);
    }

    public static <T> ResponseResult<T> success(Integer code, String message, T data) {
        return ResponseResult.response(code, true, message, data);
    }

    public static <T> ResponseResult<T> success(String message) {
        return ResponseResult.response(200, true, message, null);
    }

    public static <T> ResponseResult<T> success(T data) {
        return ResponseResult.response(200, true, "", data);
    }

    public static <T> ResponseResult<T> fail(Integer code, String message) {
        return ResponseResult.response(code, false, message);
    }

    public static <T> ResponseResult<T> fail(Integer code, String message, T data) {
        return ResponseResult.response(code, false, message, data);
    }

    public static <T> ResponseResult<T> fail(Integer code, T data) {
        return ResponseResult.response(code, false, "", data);
    }
}

