/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.common.vo.dynpermission;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.util.CollectionUtils;
import kd.opmc.epa.common.bo.ContentAreaBo;
import kd.opmc.epa.common.bo.ContentFieldBo;
import kd.opmc.epa.common.vo.dynpermission.ContentAreaEntry;
import kd.opmc.epa.common.vo.dynpermission.ContentFieldEntry;
import kd.opmc.epa.common.vo.dynpermission.ScopeAreaEntry;

public class DynamicPermissionConfigVO {
    private Long PermissionId;
    private String PermissionName;
    private String PermissionNumber;
    private DynamicObject assessForm;
    private DynamicObject perfWorkflow;
    private DynamicObject excuteScheme;
    private Map<Long, Set<Long>> workflowIdDefNodeIdsMap;
    private Map<Long, List<ScopeAreaEntry>> scopeAreaEntriesMap;
    private Map<Long, List<ContentAreaEntry>> contentAreaEntriesMap;
    private Map<Long, Long> flowNodeWithAssnodeMap = new HashMap<Long, Long>(16);

    public DynamicPermissionConfigVO() {
    }

    public DynamicPermissionConfigVO(DynamicPermissionConfigVO configVO) {
        this.setAssessForm(configVO.getAssessForm());
        this.setPerfWorkflow(configVO.getPerfWorkflow());
        this.setContentAreaEntriesMap(configVO.getContentAreaEntriesMap());
        this.setScopeAreaEntriesMap(configVO.getScopeAreaEntriesMap());
    }

    public Long getPermissionId() {
        return this.PermissionId;
    }

    public void setWorkflowIdDefNodeIdsMap(Map<Long, Set<Long>> workflowIdDefNodeIdsMap) {
        this.workflowIdDefNodeIdsMap = workflowIdDefNodeIdsMap;
    }

    public void setPermissionId(Long permissionId) {
        this.PermissionId = permissionId;
    }

    public String getPermissionName() {
        return this.PermissionName;
    }

    public void setPermissionName(String permissionName) {
        this.PermissionName = permissionName;
    }

    public String getPermissionNumber() {
        return this.PermissionNumber;
    }

    public void setPermissionNumber(String permissionNumber) {
        this.PermissionNumber = permissionNumber;
    }

    public DynamicObject getAssessForm() {
        return this.assessForm;
    }

    public void setAssessForm(DynamicObject assessForm) {
        this.assessForm = assessForm;
    }

    public DynamicObject getPerfWorkflow() {
        return this.perfWorkflow;
    }

    public void setPerfWorkflow(DynamicObject perfWorkflow) {
        this.perfWorkflow = perfWorkflow;
    }

    public DynamicObject getExcuteScheme() {
        return this.excuteScheme;
    }

    public void setExcuteScheme(DynamicObject excuteScheme) {
        this.excuteScheme = excuteScheme;
    }

    public Map<Long, List<ContentAreaEntry>> getContentAreaEntriesMap() {
        return this.contentAreaEntriesMap;
    }

    public Map<Long, List<ScopeAreaEntry>> getScopeAreaEntriesMap() {
        return this.scopeAreaEntriesMap;
    }

    public void setScopeAreaEntriesMap(Map<Long, List<ScopeAreaEntry>> scopeAreaEntriesMap) {
        this.scopeAreaEntriesMap = scopeAreaEntriesMap;
    }

    public void setContentAreaEntriesMap(Map<Long, List<ContentAreaEntry>> contentAreaEntriesMap) {
        this.contentAreaEntriesMap = contentAreaEntriesMap;
    }

    public Map<Long, Set<Long>> getWorkflowIdDefNodeIdsMap() {
        return this.workflowIdDefNodeIdsMap;
    }

    public Map<Long, Long> getFlowNodeWithAssnodeMap() {
        return this.flowNodeWithAssnodeMap;
    }

    public void setFlowNodeWithAssnodeMap(Map<Long, Long> flowNodeWithAssnodeMap) {
        this.flowNodeWithAssnodeMap = flowNodeWithAssnodeMap;
    }

    public void setEntriesGroupByNode(DynamicObjectCollection collection) {
        if (collection == null || collection.size() < 1) {
            return;
        }
        this.scopeAreaEntriesMap = new HashMap<Long, List<ScopeAreaEntry>>(16);
        this.contentAreaEntriesMap = new HashMap<Long, List<ContentAreaEntry>>(16);
        this.workflowIdDefNodeIdsMap = new HashMap<Long, Set<Long>>(16);
        for (DynamicObject obj : collection) {
            String configJson = obj.getString("mainconfiguration");
            if ("1".equals(obj.get("configtype"))) {
                if (this.scopeAreaEntriesMap.get(obj.getLong("flowdefnodeid")) == null) {
                    this.scopeAreaEntriesMap.put(obj.getLong("flowdefnodeid"), new ArrayList(10));
                }
                this.scopeAreaEntriesMap.get(obj.getLong("flowdefnodeid")).add((ScopeAreaEntry)JSON.parseObject((String)configJson, ScopeAreaEntry.class));
            } else if ("2".equals(obj.getString("configtype"))) {
                if (this.contentAreaEntriesMap.get(obj.getLong("flowdefnodeid")) == null) {
                    this.contentAreaEntriesMap.put(obj.getLong("flowdefnodeid"), new ArrayList(10));
                }
                this.setContenetAreaList(configJson, obj.getString("fieldconfiguration_tag"), this.contentAreaEntriesMap.get(obj.getLong("flowdefnodeid")));
            }
            this.setWorkflowIdDefNodeIdsMap(obj);
        }
    }

    private void setWorkflowIdDefNodeIdsMap(DynamicObject perConfigEntry) {
        Set<Long> defNodeIdSet = this.workflowIdDefNodeIdsMap.get(perConfigEntry.getLong("flowvid"));
        if (CollectionUtils.isNotEmpty(defNodeIdSet)) {
            defNodeIdSet.add(perConfigEntry.getLong("flowdefnodeid"));
        } else {
            defNodeIdSet = new HashSet<Long>(16);
            this.workflowIdDefNodeIdsMap.put(perConfigEntry.getLong("flowvid"), defNodeIdSet);
            defNodeIdSet.add(perConfigEntry.getLong("flowdefnodeid"));
        }
    }

    private void setContenetAreaList(String mainConfigJson, String fieldConfigJson, List<ContentAreaEntry> list) {
        ContentAreaBo contentAreaBo = (ContentAreaBo)JSON.parseObject((String)mainConfigJson, ContentAreaBo.class);
        ContentAreaEntry contentAreaEntry = this.transferToContentAreaEntry(contentAreaBo);
        List contentFieldBos = JSON.parseArray((String)fieldConfigJson, ContentFieldBo.class);
        List<ContentFieldEntry> contentFieldEntries = this.transferToContentFieldEntries(contentFieldBos);
        contentAreaEntry.setFieldEntries(contentFieldEntries);
        list.add(contentAreaEntry);
    }

    private ContentAreaEntry transferToContentAreaEntry(ContentAreaBo contentAreaBo) {
        ContentAreaEntry contentAreaEntry = new ContentAreaEntry();
        contentAreaEntry.setAreapageId(contentAreaBo.getAreapageId());
        contentAreaEntry.setAreapageInsId(contentAreaBo.getAreapageInsId());
        contentAreaEntry.setAreapageInsname(contentAreaBo.getAreapageInsname());
        contentAreaEntry.setAreaDisplay(contentAreaBo.getAreaDisplay());
        contentAreaEntry.setAreaDisplaySetting(contentAreaBo.getAreaDisplaySetting());
        contentAreaEntry.setAreaModify(contentAreaBo.getAreaModify());
        contentAreaEntry.setAreaUpdateSetting(contentAreaBo.getAreaUpdateSetting());
        contentAreaEntry.setSeq(contentAreaBo.getSeq());
        return contentAreaEntry;
    }

    private List<ContentFieldEntry> transferToContentFieldEntries(List<ContentFieldBo> contentFieldBos) {
        ArrayList<ContentFieldEntry> fieldEntries = new ArrayList<ContentFieldEntry>(contentFieldBos.size());
        ContentFieldEntry fieldEntry = null;
        ContentFieldBo contentFieldBo = null;
        String viewSets = "";
        Integer buttonSets = 0;
        for (int i = 0; i < contentFieldBos.size(); ++i) {
            fieldEntry = new ContentFieldEntry();
            contentFieldBo = contentFieldBos.get(i);
            buttonSets = contentFieldBo.getButtonSets();
            viewSets = contentFieldBo.getViewSets();
            fieldEntry.setAreaFieldId(contentFieldBo.getAreaFieldId());
            fieldEntry.setAreaFieldName(contentFieldBo.getAreaFieldName());
            fieldEntry.setEntityName(contentFieldBo.getEntityName());
            fieldEntry.setSeq(contentFieldBo.getSeq());
            fieldEntry.setAreaFieldInsId(contentFieldBo.getAreaFieldInsId());
            fieldEntry.transferSets(viewSets, buttonSets);
            fieldEntries.add(fieldEntry);
        }
        return fieldEntries;
    }
}

