/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.opplugin.web.activity;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.domain.activity.entityservice.AssessActivityEntityService;
import kd.opmc.epa.business.domain.activity.enums.ActivityStatusEnum;
import kd.opmc.epa.business.utils.ActivityPermissionUtils;
import kd.opmc.epa.opplugin.web.activity.validator.EvaluationActivitySaveValidator;

public class EvaluationActivitySaveOp
extends HRDataBaseOp {
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final AssessActivityEntityService ASSESS_ACTIVITY_ENTITY_SERVICE = AssessActivityEntityService.getInstance();

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new EvaluationActivitySaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.beginOperationTransaction(e);
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            DynamicObjectCollection assessGroupEntry;
            if (dataEntity.get("activitystatus") == null) {
                dataEntity.set("activitystatus", (Object)ActivityStatusEnum.TO_BE_EXECUTE.getValue());
            }
            long workFlowId = dataEntity.getLong("executescheme.perfworkflow.id");
            DynamicObject workFlowDynObj = ASSESS_ACTIVITY_APPLICATION_SERVICE.loadSingleWorkFlow(workFlowId);
            DynamicObjectCollection nodeSettingColl = workFlowDynObj.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection timePlanEntry = dataEntity.getDynamicObjectCollection("timeplanentry");
            if (timePlanEntry == null || timePlanEntry.size() == 0) {
                for (int i = 0; i < nodeSettingColl.size(); ++i) {
                    DynamicObject nodeSetting = (DynamicObject)nodeSettingColl.get(i);
                    if (!nodeSetting.getBoolean("isshow") || timePlanEntry == null) continue;
                    DynamicObject timePlan = timePlanEntry.addNew();
                    timePlan.set("activity", (Object)nodeSetting.getLong("node.id"));
                    timePlan.set("seq", (Object)i);
                }
            }
            if ((assessGroupEntry = dataEntity.getDynamicObjectCollection("assgroupentry")) != null && assessGroupEntry.size() != 0) continue;
            long assessScopeId = dataEntity.getLong("executescheme.assessscope.id");
            List assessGroupIdList = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryAssessGroupId(assessScopeId);
            for (int i = 0; i < assessGroupIdList.size(); ++i) {
                Long assessGroupId = (Long)assessGroupIdList.get(i);
                if (assessGroupEntry == null) continue;
                DynamicObject assessGroup = assessGroupEntry.addNew();
                assessGroup.set("assgroup", (Object)assessGroupId);
                assessGroup.set("seq", (Object)i);
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dynamicObjects;
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        ActivityPermissionUtils.setActivityAndCopyFlow((DynamicObject[])dataEntities);
        Map<Long, DynamicObject> activityMap = Arrays.stream(dataEntities).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        List ids = Arrays.stream(dataEntities).map(data -> data.getLong("id")).collect(Collectors.toList());
        String selectFields = "adminorg,org,perfworkflow,assessform,dynamicpermission,scheme.org,scheme.adminorg";
        for (DynamicObject data2 : dynamicObjects = ASSESS_ACTIVITY_ENTITY_SERVICE.query(selectFields, new QFilter[]{new QFilter("id", "in", ids)})) {
            if (data2.getDynamicObject("dynamicpermission") == null || data2.getDynamicObject("dynamicpermission").getLong("id") == 0L) {
                Long activityId = data2.getLong("id");
                data2.set("perfworkflow", (Object)activityMap.get(activityId).getLong("perfworkflow"));
                data2.set("assessform", (Object)activityMap.get(activityId).getLong("assessform"));
                data2.set("dynamicpermission", (Object)activityMap.get(activityId).getLong("dynamicpermission"));
            }
            data2.set("org", (Object)data2.getDynamicObject("scheme").getLong("org.id"));
            data2.set("adminorg", (Object)data2.getDynamicObject("scheme").getLong("adminorg.id"));
        }
        ASSESS_ACTIVITY_ENTITY_SERVICE.save(dynamicObjects);
    }
}

