/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.opplugin.web.activitymanage.confirm;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityObjRecordEntityService;
import kd.opmc.epa.business.domain.activitymanage.enums.AssessStausEnum;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessScoreAbbrEnum;

public class ConfirmCompleteOp
extends HRDataBaseOp {
    private static final Log log = LogFactory.getLog(ConfirmCompleteOp.class);
    private static final ActivityObjRecordEntityService ACTIVITY_RECORD_ENTITY = ActivityObjRecordEntityService.getInstance();
    private static final ActivityEvaluationObjectDomainService EVALUATION_OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("nodeindex");
        e.getFieldKeys().add("assessnode");
        e.getFieldKeys().add("assessstaus");
        e.getFieldKeys().add("nodestatus");
        e.getFieldKeys().add("assessperiod");
        e.getFieldKeys().add("assessyear");
        e.getFieldKeys().add("activity.id");
        e.getFieldKeys().add("perforg.id");
        e.getFieldKeys().add("activity.timeplanentry");
        e.getFieldKeys().add("completetime");
        e.getFieldKeys().add("fsop");
        e.getFieldKeys().add("flop");
        e.getFieldKeys().add("fsopsource");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject evalObj = e.getDataEntities()[0];
        int nodeIndex = evalObj.getInt("nodeindex");
        long userId = UserServiceHelper.getCurrentUserId();
        Date now = new Date();
        this.updateEvalObj(nodeIndex, now, userId, evalObj);
        this.addActivityRecord(nodeIndex, evalObj, now, userId);
        EVALUATION_OBJECT_DOMAIN_SERVICE.saveEvaluationObject(new DynamicObject[]{evalObj});
    }

    private void updateEvalObj(int nodeIndex, Date date, long userId, DynamicObject evaluationObj) {
        boolean isLastNode;
        log.info(" ----------\u3010\u53d8\u66f4\u8bc4\u4f30\u5bf9\u8c61\u3011ASSESSNODE:{},NODEINDEX:{},NODESTATUS:{}----------", new Object[]{AssessNodeStatusEnum.CONFIRMED.getNodeId(), nodeIndex, AssessNodeStatusEnum.CONFIRMED.getStatus()});
        evaluationObj.set("modifier", (Object)userId);
        evaluationObj.set("modifytime", (Object)date);
        evaluationObj.set("assessnode", (Object)AssessNodeStatusEnum.CONFIRMED.getNodeId());
        evaluationObj.set("nodeindex", (Object)nodeIndex);
        evaluationObj.set("nodestatus", (Object)AssessNodeStatusEnum.CONFIRMED.getStatus());
        evaluationObj.set("fsopsource", (Object)AssessScoreAbbrEnum.CFSOP.getCode());
        DynamicObjectCollection timeplanEntry = evaluationObj.getDynamicObjectCollection("activity.timeplanentry");
        boolean bl = isLastNode = timeplanEntry.size() == nodeIndex;
        if (isLastNode) {
            evaluationObj.set("nodestatus", null);
            evaluationObj.set("assessstaus", (Object)AssessStausEnum.COMPLETED.getStatus());
            evaluationObj.set("assessnode", null);
            evaluationObj.set("nodeindex", null);
            evaluationObj.set("completetime", (Object)date);
        }
    }

    private void addActivityRecord(int nodeIndex, DynamicObject evaluationObj, Date date, long userId) {
        log.info(" ----------\u3010\u6dfb\u52a0\u8bc4\u4f30\u5bf9\u8c61\u7684\u7ee9\u6548\u6d3b\u52a8\u8bb0\u5f55\u3011\u5f00\u59cb----------");
        DynamicObject activityRecord = ACTIVITY_RECORD_ENTITY.generateEmptyDynamicObject();
        activityRecord.set("actevalobj", (Object)evaluationObj.getLong("id"));
        activityRecord.set("assessnode", (Object)AssessNodeStatusEnum.CONFIRMED.getNodeId());
        activityRecord.set("nodestatus", (Object)AssessNodeStatusEnum.CONFIRMED.getStatus());
        activityRecord.set("nodeindex", (Object)nodeIndex);
        activityRecord.set("endtime", (Object)date);
        activityRecord.set("starttype", (Object)"20");
        activityRecord.set("assessperiod", (Object)evaluationObj.getString("assessperiod"));
        activityRecord.set("assessyear", (Object)evaluationObj.getInt("assessyear"));
        activityRecord.set("activity", (Object)evaluationObj.getLong("activity.id"));
        activityRecord.set("perforg", (Object)evaluationObj.getLong("perforg.id"));
        activityRecord.set("ose", evaluationObj.get("fsop"));
        activityRecord.set("ole", evaluationObj.get("flop"));
        activityRecord.set("creator", (Object)userId);
        activityRecord.set("createtime", (Object)date);
        activityRecord.set("modifier", (Object)userId);
        activityRecord.set("modifytime", (Object)date);
        ACTIVITY_RECORD_ENTITY.saveOne(activityRecord);
        log.info(" ----------\u3010\u6dfb\u52a0\u8bc4\u4f30\u5bf9\u8c61\u7684\u7ee9\u6548\u6d3b\u52a8\u8bb0\u5f55\u3011\u5b8c\u6210----------");
    }
}

