/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.opplugin.web.activitymanage.confirm;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityObjRecordEntityService;
import kd.opmc.epa.business.domain.activitymanage.service.ActivityEvaluationObjectDomainService;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.opplugin.web.activitymanage.confirm.ConfirmCompleteOp;
import kd.opmc.pbs.business.domain.msg.service.MsgSendDomainService;

public class ConfirmTerminateOp
extends HRDataBaseOp {
    private static final Log log = LogFactory.getLog(ConfirmCompleteOp.class);
    private static final ActivityObjRecordEntityService ACTIVITY_RECORD_ENTITY = ActivityObjRecordEntityService.getInstance();
    private static final ActivityEvaluationObjectDomainService EVALUATION_OBJECT_DOMAIN_SERVICE = ActivityEvaluationObjectDomainService.getInstance();
    private static final MsgSendDomainService MSG_SEND_DOMAIN_SERVICE = MsgSendDomainService.getInstance();
    private static final Long EPA_CONFIRM_TERMINATE = 1904457236181311488L;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("nodeindex");
        e.getFieldKeys().add("assessnode");
        e.getFieldKeys().add("assessstaus");
        e.getFieldKeys().add("nodestatus");
        e.getFieldKeys().add("assessperiod");
        e.getFieldKeys().add("assessyear");
        e.getFieldKeys().add("activity.id");
        e.getFieldKeys().add("activity.name");
        e.getFieldKeys().add("perforg.id");
        e.getFieldKeys().add("person.id");
        e.getFieldKeys().add("person.number");
        e.getFieldKeys().add("person.name");
        e.getFieldKeys().add("description");
        e.getFieldKeys().add("fsop");
        e.getFieldKeys().add("flop");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject evalObj = e.getDataEntities()[0];
        String nodeStatus = evalObj.getString("nodestatus");
        DynamicObject node = evalObj.getDynamicObject("assessnode");
        if (StringUtils.equals((CharSequence)nodeStatus, (CharSequence)AssessNodeStatusEnum.CONFIRMING.getStatus()) && node != null && node.getLong("id") == AssessNodeStatusEnum.CONFIRMING.getNodeId().longValue()) {
            int nodeIndex = evalObj.getInt("nodeindex");
            long userId = UserServiceHelper.getCurrentUserId();
            Date now = new Date();
            this.updateEvalObj(nodeIndex, now, userId, evalObj);
            this.addActivityRecord(nodeIndex, evalObj, now, userId);
            EVALUATION_OBJECT_DOMAIN_SERVICE.saveEvaluationObject(new DynamicObject[]{evalObj});
            this.sendMessage(evalObj);
        }
    }

    private void updateEvalObj(int nodeIndex, Date date, long userId, DynamicObject evaluationObj) {
        log.info(" ----------\u3010\u53d8\u66f4\u8bc4\u4f30\u5bf9\u8c61\u3011NODESTATUS:{}----------", (Object)AssessNodeStatusEnum.TERMINATE.getStatus());
        evaluationObj.set("modifier", (Object)userId);
        evaluationObj.set("modifytime", (Object)date);
        evaluationObj.set("nodestatus", (Object)AssessNodeStatusEnum.TERMINATE.getStatus());
    }

    private void addActivityRecord(int nodeIndex, DynamicObject evaluationObj, Date date, long userId) {
        log.info(" ----------\u3010\u6dfb\u52a0\u8bc4\u4f30\u5bf9\u8c61\u7684\u7ee9\u6548\u6d3b\u52a8\u8bb0\u5f55\u3011\u5f00\u59cb----------");
        DynamicObject activityRecord = ACTIVITY_RECORD_ENTITY.generateEmptyDynamicObject();
        activityRecord.set("actevalobj", (Object)evaluationObj.getLong("id"));
        activityRecord.set("assessnode", (Object)AssessNodeStatusEnum.TERMINATE.getNodeId());
        activityRecord.set("nodestatus", (Object)AssessNodeStatusEnum.TERMINATE.getStatus());
        activityRecord.set("nodeindex", (Object)nodeIndex);
        activityRecord.set("endtime", (Object)date);
        activityRecord.set("starttype", (Object)"20");
        activityRecord.set("assessperiod", (Object)evaluationObj.getString("assessperiod"));
        activityRecord.set("assessyear", (Object)evaluationObj.getInt("assessyear"));
        activityRecord.set("activity", (Object)evaluationObj.getLong("activity.id"));
        activityRecord.set("perforg", (Object)evaluationObj.getLong("perforg.id"));
        activityRecord.set("description", evaluationObj.get("description"));
        activityRecord.set("ose", evaluationObj.get("fsop"));
        activityRecord.set("ole", evaluationObj.get("flop"));
        activityRecord.set("creator", (Object)userId);
        activityRecord.set("createtime", (Object)date);
        activityRecord.set("modifier", (Object)userId);
        activityRecord.set("modifytime", (Object)date);
        ACTIVITY_RECORD_ENTITY.saveOne(activityRecord);
        log.info(" ----------\u3010\u6dfb\u52a0\u8bc4\u4f30\u5bf9\u8c61\u7684\u7ee9\u6548\u6d3b\u52a8\u8bb0\u5f55\u3011\u5b8c\u6210----------");
    }

    private void sendMessage(DynamicObject evalObj) {
        DynamicObject activityRecord = ACTIVITY_RECORD_ENTITY.queryLastestRecord("creator", Long.valueOf(evalObj.getLong("id")), AssessNodeStatusEnum.CONFIRMING);
        long userId = activityRecord.getDynamicObject("creator").getLong("id");
        HashMap urlParams = Maps.newHashMapWithExpectedSize((int)3);
        MSG_SEND_DOMAIN_SERVICE.sendMessageWithUrl(EPA_CONFIRM_TERMINATE, Collections.singletonList(userId), evalObj, (Map)urlParams, ResManager.loadKDString((String)"\u7ed3\u679c\u786e\u8ba4-\u5df2\u7ec8\u6b62", (String)"ConfirmTerminateOp_0", (String)"opmc-epa-opplugin", (Object[])new Object[0]));
    }
}

