/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.opplugin.web.activitymanage.evalschedule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.pbs.business.domain.assessnode.enums.NodeTabMapEnum;
import kd.opmc.pbs.business.domain.workflow.vo.AssignHandlerVO;

public class DeleteEvalCrossOp
extends HRDataBaseOp {
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("rutask");
        e.getFieldKeys().add("indicator");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                List ruRoleIds = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getDataEntity().getLong("rutask.flowrurole.id")).collect(Collectors.toList());
                Map roleToObjMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.getEvalObjMap(ruRoleIds);
                Map objMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryEvalObjById(new ArrayList(roleToObjMap.values()));
                ArrayList<DynamicObject> delList = new ArrayList<DynamicObject>(10);
                for (ExtendedDataEntity dataEntity2 : dataEntities) {
                    boolean isEval;
                    long ruRoleId = dataEntity2.getDataEntity().getLong("rutask.flowrurole.id");
                    Long objId = (Long)roleToObjMap.get(ruRoleId);
                    DynamicObject objDy = (DynamicObject)objMap.get(objId);
                    boolean bl = isEval = NodeTabMapEnum.EVAL_PROCESS.getNodeId().equals(objDy.getLong("assessnode.id")) && AssessNodeStatusEnum.EVALUATING.getStatus().equals(objDy.getString("nodestatus"));
                    if (isEval) {
                        delList.add(dataEntity2.getDataEntity());
                        continue;
                    }
                    this.addErrorMessage(dataEntity2, ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61-{0}\uff08{1}\uff09\uff1a\u5df2\u4e0d\u5728\u8bc4\u4f30\u4e2d\uff0c\u4e0d\u53ef\u5220\u9664\u8bc4\u4f30\u4eba", (String)"DeleteEvalCrossOp_0", (String)"opmc-epa-opplugin", (Object[])new Object[]{objDy.getString("person.name"), objDy.getString("person.number")}));
                }
                Map resultMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.deleteEvalPersonCross(delList, roleToObjMap);
                for (ExtendedDataEntity dataEntity3 : dataEntities) {
                    AssignHandlerVO result = (AssignHandlerVO)resultMap.get((Long)dataEntity3.getBillPkId());
                    if (result == null || result.isSucess()) continue;
                    this.addErrorMessage(dataEntity3, result.getErrorMessage());
                }
            }
        });
    }
}

