/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.opplugin.web.activitymanage.evalschedule;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.domain.activitymanage.enums.ProcessManageApEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.pbs.business.domain.common.service.CustomTerminologyDomainService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowCooperatorEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.common.utils.CommonResultBo;

public class EvalCrossDelCooperatorOp
extends HRDataBaseOp {
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final Log LOG = LogFactory.getLog(EvalCrossDelCooperatorOp.class);
    private static final CustomTerminologyDomainService CUSTOM_TERMINOLOGY_DOMAIN_SERVICE = CustomTerminologyDomainService.getInstance();

    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        evt.getFieldKeys().add("flowruproc");
        evt.getFieldKeys().add("taskstatus");
        evt.getFieldKeys().add("handler");
        evt.getFieldKeys().add("flowrunode");
        evt.getFieldKeys().add("flowrurole");
    }

    public void onAddValidators(AddValidatorsEventArgs evt) {
        evt.addValidator(new AbstractValidator(){

            public void validate() {
                CommonResultBo commonResultBo;
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                Long[] taskEntryIdArrs = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getDataEntity().getLong("id")).collect(Collectors.toList()).toArray(new Long[0]);
                DynamicObject[] taskEntryDys = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.loadTaskEntryDy(taskEntryIdArrs);
                List taskIds = Arrays.stream(taskEntryDys).map(dataEntity -> dataEntity.getLong("rutask.id")).collect(Collectors.toList());
                Map<Long, Long> entryIdIdMap = Arrays.stream(taskEntryDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("rutask.id")));
                DynamicObject[] ruTaskDys = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryTaskByIds(taskIds);
                Map idTaskDyMap = Arrays.stream(ruTaskDys).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity()));
                Map<Long, Long> taskIdObjIdMap = Arrays.stream(ruTaskDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("flowruproc.actevalobj")));
                HashMap entryIdObjIdMap = new HashMap(16);
                HashMap entryIdTaskDyMap = new HashMap(16);
                entryIdIdMap.forEach((entryId, id) -> {
                    entryIdObjIdMap.put(entryId, taskIdObjIdMap.get(id));
                    entryIdTaskDyMap.put(entryId, idTaskDyMap.get(id));
                });
                List objIds = Arrays.stream(ruTaskDys).map(dy -> dy.getLong("flowruproc.actevalobj")).collect(Collectors.toList());
                Map objMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryEvalObjById(objIds);
                Map<Long, Long> taskRoleMap = Arrays.stream(ruTaskDys).collect(Collectors.toMap(task -> task.getLong("id"), task -> task.getLong("flowrurole.id")));
                if (ObjectUtils.isEmpty(taskRoleMap)) {
                    return;
                }
                HashSet<Long> passIds = new HashSet<Long>();
                for (ExtendedDataEntity task2 : dataEntities) {
                    String errorMsg;
                    String errorMsgTxt;
                    Long objId = (Long)entryIdObjIdMap.get(task2.getDataEntity().getLong("id"));
                    DynamicObject objDy = (DynamicObject)objMap.get(objId);
                    DynamicObject taskDy = (DynamicObject)entryIdTaskDyMap.get(task2.getDataEntity().getLong("id"));
                    String taskStatus = taskDy.getString("taskstatus");
                    String handlerNameStr = taskDy.getString("handler.name");
                    String handlerName = HRStringUtils.isEmpty((String)handlerNameStr) ? "" : handlerNameStr;
                    String desc = objDy.getString("person.name") + " " + objDy.getString("person.number");
                    if (!HRStringUtils.equals((String)objDy.getString("nodestatus"), (String)AssessNodeStatusEnum.EVALUATING.getStatus()) || !HRStringUtils.equals((String)objDy.getString("assessnode.id"), (String)ProcessManageApEnum.EVALUATING.getLabId())) {
                        errorMsgTxt = ResManager.loadKDString((String)"{0} {1}\uff1a\u8bc4\u4f30\u5bf9\u8c61\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u5df2\u4e0d\u5728\u201c\u8bc4\u4f30\u4e2d\u201d\uff0c\u4e0d\u80fd\u5220\u9664\u534f\u529e\u4eba\u3002", (String)"EvalCrossDelCooperatorOp_0", (String)"opmc-epa-opplugin", (Object[])new Object[]{objDy.getString("person.name"), objDy.getString("person.number")});
                        errorMsg = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(errorMsgTxt);
                        this.addErrorMessage(task2, errorMsg);
                        continue;
                    }
                    if (FlowRuTaskStatusEnum.PROCESSED.getCode().equals(taskStatus)) {
                        errorMsgTxt = ResManager.loadKDString((String)"{0}\uff1a{1}\u4efb\u52a1\u72b6\u6001\u5904\u4e8e\u201c\u5df2\u5904\u7406\u201d\u4e0d\u80fd\u5220\u9664\u534f\u529e\u4eba\u3002", (String)"EvalCrossDelCooperatorOp_1", (String)"opmc-epa-opplugin", (Object[])new Object[]{desc, handlerName});
                        errorMsg = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(errorMsgTxt);
                        this.addErrorMessage(task2, errorMsg);
                        continue;
                    }
                    if (FlowRuTaskStatusEnum.EXPIRED.getCode().equals(taskStatus)) {
                        errorMsgTxt = ResManager.loadKDString((String)"{0}\uff1a{1}\u4efb\u52a1\u72b6\u6001\u5904\u4e8e\u201c\u5df2\u5931\u6548\u201d\u4e0d\u80fd\u5220\u9664\u534f\u529e\u4eba\u3002", (String)"EvalCrossDelCooperatorOp_2", (String)"opmc-epa-opplugin", (Object[])new Object[]{desc, handlerName});
                        errorMsg = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(errorMsgTxt);
                        this.addErrorMessage(task2, errorMsg);
                        continue;
                    }
                    if (FlowRuTaskStatusEnum.RETURNED.getCode().equals(taskStatus)) {
                        errorMsgTxt = ResManager.loadKDString((String)"{0}\uff1a{1}\u4efb\u52a1\u72b6\u6001\u5904\u4e8e\u201c\u5df2\u9000\u56de\u201d\u4e0d\u80fd\u5220\u9664\u534f\u529e\u4eba\u3002", (String)"EvalCrossDelCooperatorOp_3", (String)"opmc-epa-opplugin", (Object[])new Object[]{desc, handlerName});
                        errorMsg = CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(errorMsgTxt);
                        this.addErrorMessage(task2, errorMsg);
                        continue;
                    }
                    passIds.add(taskDy.getLong("id"));
                }
                List taskEntities = Arrays.stream(dataEntities).filter(task -> passIds.contains(entryIdIdMap.get(task.getDataEntity().getLong("id")))).collect(Collectors.toList());
                if (ObjectUtils.isEmpty(taskEntities)) {
                    return;
                }
                try {
                    HashMap<Long, Object> cooperatorMap = new HashMap<Long, Object>(16);
                    for (Long mainTaskId : passIds) {
                        cooperatorMap.put(mainTaskId, null);
                    }
                    commonResultBo = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.setCooperator(cooperatorMap, FlowCooperatorEnum.DEL_COOPERATOR);
                }
                catch (Exception e) {
                    try {
                        for (ExtendedDataEntity dataEntity2 : taskEntities) {
                            Long objId = (Long)entryIdObjIdMap.get(dataEntity2.getDataEntity().getLong("id"));
                            DynamicObject objDy = (DynamicObject)objMap.get(objId);
                            this.addErrorMessage(dataEntity2, ResManager.loadKDString((String)"{0} {1}:\u8c03\u7528\u7ee9\u6548\u5de5\u4f5c\u6d41\u5931\u8d25\uff0c\u8bf7\u8054\u7cfbIT\u7ba1\u7406\u5458\uff1b", (String)"EvalCrossDelCooperatorOp_4", (String)"opmc-epa-opplugin", (Object[])new Object[]{objDy.getString("person.name"), objDy.getString("person.number")}));
                        }
                    }
                    catch (Exception exception) {
                        this.addErrorMessage((ExtendedDataEntity)taskEntities.get(0), ResManager.loadKDString((String)"\u8c03\u7528\u7ee9\u6548\u5de5\u4f5c\u6d41\u5931\u8d25\uff0c\u8bf7\u8054\u7cfbIT\u7ba1\u7406\u5458\uff1b", (String)"EvalCrossDelCooperatorOp_5", (String)"opmc-epa-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    return;
                }
                LOG.info("commonResultBo: {}", (Object)commonResultBo);
            }
        });
    }
}

