/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.opplugin.web.activitymanage.evalschedule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.business.domain.workflow.vo.ReminderVO;
import kd.opmc.pbs.common.utils.EntityMetaDataUtils;

public class EvalIndicatorTaskPushOp
extends HRDataBaseOp {
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("indicator");
        e.getFieldKeys().add("rutask");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                List taskIdObjs = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getDataEntity().get("rutask.id")).distinct().collect(Collectors.toList());
                DynamicObject[] taskDys = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryTaskById(taskIdObjs);
                Map<Long, Long> taskMap = Arrays.stream(taskDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("flowruproc.actevalobj"), (k1, k2) -> k1));
                Map objMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryEvalObjById(new ArrayList<Long>(taskMap.values()));
                List taskIds = Arrays.stream(dataEntities).filter(dataEntity -> HRStringUtils.equals((String)dataEntity.getDataEntity().getString("rutask.taskstatus"), (String)FlowRuTaskStatusEnum.PROCESSING.getCode()) || HRStringUtils.equals((String)dataEntity.getDataEntity().getString("rutask.taskstatus"), (String)FlowRuTaskStatusEnum.WAITING.getCode())).map(dataEntity -> dataEntity.getDataEntity().getLong("rutask.id")).distinct().collect(Collectors.toList());
                Map resultMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.pushTask(taskIds);
                for (ExtendedDataEntity dataEntity2 : dataEntities) {
                    Long taskId = dataEntity2.getDataEntity().getLong("rutask.id");
                    Long objId = taskMap.get(taskId);
                    DynamicObject objDy = (DynamicObject)objMap.get(objId);
                    ReminderVO reminderVO = (ReminderVO)resultMap.get(taskId);
                    if (reminderVO != null && reminderVO.isSucess()) continue;
                    String taskStatus = dataEntity2.getDataEntity().getString("rutask.taskstatus");
                    String taskStatusStr = EntityMetaDataUtils.getEntityComboFieldItemName((String)"epa_evalflowrutask", (String)"taskstatus", (String)taskStatus);
                    if (reminderVO != null && reminderVO.getErrorType() == 2) {
                        this.addErrorMessage(dataEntity2, ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61-{0} {1}\uff1a\u8bc4\u4f30\u4eba-{2}\u5df2\u7ecf\u88ab\u7981\u7528\uff0c\u4efb\u52a1\u72b6\u6001\u53d8\u66f4\u4e3a\u201c\u5df2\u6302\u8d77\u201d\uff0c\u4e0d\u80fd\u50ac\u529e\u3002", (String)"EvalIndicatorTaskPushOp_0", (String)"opmc-epa-opplugin", (Object[])new Object[]{objDy.getString("person.name"), objDy.getString("person.number"), dataEntity2.getDataEntity().getString("rutask.handler.name")}));
                        continue;
                    }
                    this.addErrorMessage(dataEntity2, ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61-{0} {1}\uff1a\u8bc4\u4f30\u4eba-{2}\u5728\u5f53\u524d\u8282\u70b9\u7684\u8bc4\u4f30\u4efb\u52a1\u5904\u5728\u201c{3}\u201d\uff0c\u65e0\u9700\u50ac\u529e", (String)"EvalIndicatorTaskPushOp_1", (String)"opmc-epa-opplugin", (Object[])new Object[]{objDy.getString("person.name"), objDy.getString("person.number"), dataEntity2.getDataEntity().getString("rutask.handler.name"), taskStatusStr}));
                }
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
    }
}

