/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.opplugin.web.activitymanage.evalschedule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.domain.activitymanage.enums.ProcessManageApEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.pbs.business.domain.common.service.CustomTerminologyDomainService;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.business.domain.workflow.vo.ReminderVO;
import kd.opmc.pbs.common.utils.EntityMetaDataUtils;

public class EvalTaskPushOp
extends HRDataBaseOp {
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final CustomTerminologyDomainService CUSTOM_TERMINOLOGY_DOMAIN_SERVICE = CustomTerminologyDomainService.getInstance();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("flowruproc");
        e.getFieldKeys().add("taskstatus");
        e.getFieldKeys().add("handler");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                List objIds = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getDataEntity().getLong("flowruproc.actevalobj")).collect(Collectors.toList());
                Map objMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryEvalObjById(objIds);
                OperateOption option = this.getOption();
                List<Object> taskIds = new ArrayList(10);
                if ("formulate".equals(option.getVariableValue("OP_SOURCE", "eval"))) {
                    for (ExtendedDataEntity dataEntity2 : dataEntities) {
                        long objId = dataEntity2.getDataEntity().getLong("flowruproc.actevalobj");
                        DynamicObject objDy = (DynamicObject)objMap.get(objId);
                        if (!HRStringUtils.equals((String)objDy.getString("nodestatus"), (String)AssessNodeStatusEnum.TARGET_FORMULATING.getStatus()) || !HRStringUtils.equals((String)objDy.getString("assessnode.id"), (String)ProcessManageApEnum.TARGET_FORMULATING.getLabId()) || objDy.getLong("nodeindex") != AssessNodeStatusEnum.TARGET_FORMULATING.getNodeId().longValue()) {
                            this.addErrorMessage(dataEntity2, CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"{0} {1}\uff1a\u5236\u5b9a\u5bf9\u8c61\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u5df2\u4e0d\u5728\u201c\u5236\u5b9a\u4e2d\u201d\uff0c\u4e0d\u80fd\u50ac\u529e\u3002", (String)"EvalTaskPushOp_0", (String)"opmc-epa-opplugin", (Object[])new Object[]{objDy.getString("person.name"), objDy.getString("person.number")})));
                            continue;
                        }
                        long taskId = (Long)dataEntity2.getDataEntity().getPkValue();
                        taskIds.add(taskId);
                    }
                } else {
                    taskIds = Arrays.stream(dataEntities).filter(dataEntity -> StringUtils.equals((CharSequence)dataEntity.getDataEntity().getString("taskstatus"), (CharSequence)FlowRuTaskStatusEnum.PROCESSING.getCode()) || StringUtils.equals((CharSequence)dataEntity.getDataEntity().getString("taskstatus"), (CharSequence)FlowRuTaskStatusEnum.WAITING.getCode())).map(dataEntity -> (Long)dataEntity.getDataEntity().getPkValue()).collect(Collectors.toList());
                }
                Map resultMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.pushTask(taskIds);
                for (ExtendedDataEntity dataEntity3 : dataEntities) {
                    String taskStatusStr;
                    String taskStatus;
                    long objId = dataEntity3.getDataEntity().getLong("flowruproc.actevalobj");
                    DynamicObject objDy = (DynamicObject)objMap.get(objId);
                    ReminderVO reminderVO = (ReminderVO)resultMap.get((Long)dataEntity3.getBillPkId());
                    if (reminderVO != null && reminderVO.isSucess()) continue;
                    if ("formulate".equals(option.getVariableValue("OP_SOURCE", "eval"))) {
                        taskStatus = dataEntity3.getDataEntity().getString("taskstatus");
                        taskStatusStr = EntityMetaDataUtils.getEntityComboFieldItemName((String)"epa_formulateflowrutask", (String)"taskstatus", (String)taskStatus);
                        if (reminderVO != null && reminderVO.getErrorType() == 2) {
                            this.addErrorMessage(dataEntity3, CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"\u5236\u5b9a\u5bf9\u8c61-{0} {1}\uff1a\u5236\u5b9a\u4eba-{2}\u5df2\u7ecf\u88ab\u7981\u7528\uff0c\u4efb\u52a1\u72b6\u6001\u53d8\u66f4\u4e3a\u201c\u5df2\u6302\u8d77\u201d\uff0c\u4e0d\u80fd\u50ac\u529e\u3002", (String)"EvalTaskPushOp_1", (String)"opmc-epa-opplugin", (Object[])new Object[]{objDy.getString("person.name"), objDy.getString("person.number"), dataEntity3.getDataEntity().getString("handler.name")})));
                            continue;
                        }
                        long taskId = (Long)dataEntity3.getDataEntity().getPkValue();
                        if (!taskIds.contains(taskId)) continue;
                        this.addErrorMessage(dataEntity3, CUSTOM_TERMINOLOGY_DOMAIN_SERVICE.getCusTerminology(ResManager.loadKDString((String)"\u5236\u5b9a\u5bf9\u8c61-{0} {1}\uff1a\u5236\u5b9a\u4eba-{2}\u5728\u5f53\u524d\u8282\u70b9\u7684\u5236\u5b9a\u4efb\u52a1\u5904\u5728\u201c{3}\u201d\uff0c\u4e0d\u80fd\u50ac\u529e\u3002", (String)"EvalTaskPushOp_2", (String)"opmc-epa-opplugin", (Object[])new Object[]{objDy.getString("person.name"), objDy.getString("person.number"), dataEntity3.getDataEntity().getString("handler.name"), taskStatusStr})));
                        continue;
                    }
                    taskStatus = dataEntity3.getDataEntity().getString("taskstatus");
                    taskStatusStr = EntityMetaDataUtils.getEntityComboFieldItemName((String)"epa_evalflowrutask", (String)"taskstatus", (String)taskStatus);
                    if (reminderVO != null && reminderVO.getErrorType() == 2) {
                        this.addErrorMessage(dataEntity3, ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61-{0} {1}\uff1a\u8bc4\u4f30\u4eba-{2}\u5df2\u7ecf\u88ab\u7981\u7528\uff0c\u4efb\u52a1\u72b6\u6001\u53d8\u66f4\u4e3a\u201c\u5df2\u6302\u8d77\u201d\uff0c\u4e0d\u80fd\u50ac\u529e\u3002", (String)"EvalTaskPushOp_3", (String)"opmc-epa-opplugin", (Object[])new Object[]{objDy.getString("person.name"), objDy.getString("person.number"), dataEntity3.getDataEntity().getString("handler.name")}));
                        continue;
                    }
                    this.addErrorMessage(dataEntity3, ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61-{0} {1}\uff1a\u8bc4\u4f30\u4eba-{2}\u5728\u5f53\u524d\u8282\u70b9\u7684\u8bc4\u4f30\u4efb\u52a1\u5904\u5728\u201c{3}\u201d\uff0c\u65e0\u9700\u50ac\u529e", (String)"EvalTaskPushOp_4", (String)"opmc-epa-opplugin", (Object[])new Object[]{objDy.getString("person.name"), objDy.getString("person.number"), dataEntity3.getDataEntity().getString("handler.name"), taskStatusStr}));
                }
            }
        });
    }
}

