/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.opplugin.web.activitymanage.evalschedule;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.pbs.business.domain.assessnode.enums.NodeTabMapEnum;
import kd.opmc.pbs.business.domain.workflow.enums.FlowRuTaskStatusEnum;
import kd.opmc.pbs.business.domain.workflow.vo.AssignHandlerVO;
import kd.opmc.pbs.common.utils.EntityMetaDataUtils;

public class ModifyEvalPersonOp
extends HRDataBaseOp {
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("flowruproc");
        e.getFieldKeys().add("taskstatus");
        e.getFieldKeys().add("handler");
        e.getFieldKeys().add("flowrurole");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        final String evaluator = this.getOption().getVariableValue("evaluaties", "");
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                List objIds = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getDataEntity().getLong("flowruproc.actevalobj")).collect(Collectors.toList());
                Map objMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryEvalObjById(objIds);
                List taskDys = Arrays.stream(dataEntities).filter(dataEntity -> {
                    String taskStatus = dataEntity.getDataEntity().getString("taskstatus");
                    long objId = dataEntity.getDataEntity().getLong("flowruproc.actevalobj");
                    DynamicObject objDy = (DynamicObject)objMap.get(objId);
                    boolean inEval = NodeTabMapEnum.EVAL_PROCESS.getNodeId().equals(objDy.getLong("assessnode.id")) && AssessNodeStatusEnum.EVALUATING.getStatus().equals(objDy.getString("nodestatus"));
                    return (HRStringUtils.equals((String)taskStatus, (String)FlowRuTaskStatusEnum.NOT_ACTIVE.getCode()) || HRStringUtils.equals((String)taskStatus, (String)FlowRuTaskStatusEnum.BE_WAITTING.getCode()) || HRStringUtils.equals((String)taskStatus, (String)FlowRuTaskStatusEnum.WAITING.getCode()) || HRStringUtils.equals((String)taskStatus, (String)FlowRuTaskStatusEnum.PROCESSING.getCode()) || HRStringUtils.equals((String)taskStatus, (String)FlowRuTaskStatusEnum.PENDING.getCode())) && inEval;
                }).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
                Map resultMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.modifyEvalPerson(taskDys, evaluator);
                for (ExtendedDataEntity dataEntity2 : dataEntities) {
                    AssignHandlerVO result = (AssignHandlerVO)resultMap.get((Long)dataEntity2.getBillPkId());
                    if (result == null) {
                        long objId = dataEntity2.getDataEntity().getLong("flowruproc.actevalobj");
                        DynamicObject objDy = (DynamicObject)objMap.get(objId);
                        String taskStatus = dataEntity2.getDataEntity().getString("taskstatus");
                        if (!NodeTabMapEnum.EVAL_PROCESS.getNodeId().equals(objDy.getLong("assessnode.id")) || !AssessNodeStatusEnum.EVALUATING.getStatus().equals(objDy.getString("nodestatus"))) {
                            this.addErrorMessage(dataEntity2, ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61-{0}\uff08{1}\uff09\uff1a\u5df2\u4e0d\u5728\u8bc4\u4f30\u4e2d\uff0c\u4e0d\u53ef\u8c03\u6574\u8bc4\u4f30\u4eba", (String)"ModifyEvalPersonOp_0", (String)"opmc-epa-opplugin", (Object[])new Object[]{objDy.getString("person.name"), objDy.getString("person.number")}));
                            continue;
                        }
                        if (HRStringUtils.equals((String)taskStatus, (String)FlowRuTaskStatusEnum.NOT_ACTIVE.getCode()) || HRStringUtils.equals((String)taskStatus, (String)FlowRuTaskStatusEnum.BE_WAITTING.getCode()) || HRStringUtils.equals((String)taskStatus, (String)FlowRuTaskStatusEnum.WAITING.getCode()) || HRStringUtils.equals((String)taskStatus, (String)FlowRuTaskStatusEnum.PROCESSING.getCode()) || HRStringUtils.equals((String)taskStatus, (String)FlowRuTaskStatusEnum.PENDING.getCode())) continue;
                        String taskStatusStr = EntityMetaDataUtils.getEntityComboFieldItemName((String)"epa_evalflowrutask", (String)"taskstatus", (String)taskStatus);
                        this.addErrorMessage(dataEntity2, ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61-{0}\uff08{1}\uff09\uff1a\u8bc4\u4f30\u4eba-{2}\u5728\u5f53\u524d\u8282\u70b9\u7684\u8bc4\u4f30\u4efb\u52a1\u201c{3}\u201d\uff0c\u4e0d\u53ef\u8c03\u6574", (String)"ModifyEvalPersonOp_1", (String)"opmc-epa-opplugin", (Object[])new Object[]{objDy.getString("person.name"), objDy.getString("person.number"), dataEntity2.getDataEntity().getString("handler.name"), taskStatusStr}));
                        continue;
                    }
                    if (result.isSucess()) continue;
                    this.addErrorMessage(dataEntity2, result.getErrorMessage());
                }
            }
        });
    }
}

