/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.opplugin.web.activitymanage.evalschedule;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.domain.activity.entityservice.AssessActivityEntityService;
import kd.opmc.epa.business.domain.activitymanage.enums.AssessStausEnum;
import kd.opmc.epa.business.utils.ResetEvalUtil;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;

public class ResetEvalCompleteOp
extends HRDataBaseOp {
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final AssessActivityEntityService ACTIVITY_ENTITY_SERVICE = AssessActivityEntityService.getInstance();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("person");
        e.getFieldKeys().add("assessnode");
        e.getFieldKeys().add("nodestatus");
        e.getFieldKeys().add("assessstaus");
        e.getFieldKeys().add("nodeindex");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        String activityId = this.getOption().getVariableValue("activity", "0");
        final int nodeIndex = Integer.parseInt(this.getOption().getVariableValue("nodeindex", "0"));
        DynamicObject activity = ACTIVITY_ENTITY_SERVICE.queryActivityPAssessNode(Long.valueOf(Long.parseLong(activityId)));
        final DynamicObjectCollection timePlanEntry = activity.getDynamicObjectCollection("timeplanentry");
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                List objIds = Arrays.stream(dataEntities).filter(dataEntity -> {
                    DynamicObject objDy = dataEntity.getDataEntity();
                    boolean evaled = AssessNodeStatusEnum.EVALUATED.getStatus().equals(objDy.getString("nodestatus")) && nodeIndex == objDy.getInt("nodeindex") && AssessNodeStatusEnum.EVALUATED.getNodeId().equals(objDy.getLong("assessnode.id"));
                    boolean complete = nodeIndex == timePlanEntry.size() && AssessStausEnum.COMPLETED.getStatus().equals(objDy.getString("assessstaus"));
                    return evaled || complete;
                }).map(dataEntity -> dataEntity.getDataEntity().getLong("id")).collect(Collectors.toList());
                Map checkResult = ResetEvalUtil.checkEvalCompletedReset(objIds, (boolean)false);
                objIds.removeIf(checkResult::containsKey);
                Map resultMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.resetEval(objIds);
                for (ExtendedDataEntity dataEntity2 : dataEntities) {
                    String message;
                    Long billPkId = (Long)dataEntity2.getBillPkId();
                    DynamicObject obj = dataEntity2.getDataEntity();
                    if (resultMap.containsKey(billPkId)) {
                        message = (String)resultMap.get(billPkId);
                        this.addErrorMessage(dataEntity2, message);
                        continue;
                    }
                    if (checkResult.containsKey(billPkId)) {
                        message = (String)checkResult.get(billPkId);
                        this.addErrorMessage(dataEntity2, ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61-{0}\uff08{1}\uff09\uff1a{2}", (String)"ResetEvalCompleteOp_0", (String)"opmc-epa-opplugin", (Object[])new Object[]{obj.getString("person.name"), obj.getString("person.number"), message}));
                        continue;
                    }
                    if (objIds.contains(billPkId)) continue;
                    this.addErrorMessage(dataEntity2, ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61-{0}\uff08{1}\uff09\uff1a\u5df2\u4e0d\u5728\u7ee9\u6548\u8bc4\u4f30-\u5df2\u5b8c\u6210\u3002", (String)"ResetEvalCompleteOp_1", (String)"opmc-epa-opplugin", (Object[])new Object[]{obj.getString("person.name"), obj.getString("person.number")}));
                }
            }
        });
    }
}

