/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.opplugin.web.activitymanage.evalschedule;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.pbs.business.domain.assessnode.enums.NodeTabMapEnum;

public class ResetEvalOp
extends HRDataBaseOp {
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("person");
        e.getFieldKeys().add("assessnode");
        e.getFieldKeys().add("nodestatus");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                List objIds = Arrays.stream(dataEntities).filter(dataEntity -> {
                    DynamicObject objDy = dataEntity.getDataEntity();
                    return NodeTabMapEnum.EVAL_PROCESS.getNodeId().equals(objDy.getLong("assessnode.id")) && AssessNodeStatusEnum.EVALUATING.getStatus().equals(objDy.getString("nodestatus"));
                }).map(dataEntity -> dataEntity.getDataEntity().getLong("id")).collect(Collectors.toList());
                Map resultMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.resetEval(objIds);
                for (ExtendedDataEntity dataEntity2 : dataEntities) {
                    String message;
                    boolean inEval;
                    DynamicObject objDy = dataEntity2.getDataEntity();
                    boolean bl = inEval = NodeTabMapEnum.EVAL_PROCESS.getNodeId().equals(objDy.getLong("assessnode.id")) && AssessNodeStatusEnum.EVALUATING.getStatus().equals(objDy.getString("nodestatus"));
                    if (!inEval) {
                        this.addErrorMessage(dataEntity2, ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61-{0}\uff08{1}\uff09\uff1a\u5df2\u4e0d\u5728\u7ee9\u6548\u8bc4\u4f30\u4e2d\uff0c\u4e0d\u53ef\u91cd\u7f6e\u3002", (String)"ResetEvalOp_0", (String)"opmc-epa-opplugin", (Object[])new Object[]{dataEntity2.getDataEntity().getString("person.name"), dataEntity2.getDataEntity().getString("person.number")}));
                        continue;
                    }
                    if (resultMap.isEmpty() || !StringUtils.isNotBlank((CharSequence)(message = (String)resultMap.get((Long)dataEntity2.getBillPkId())))) continue;
                    this.addErrorMessage(dataEntity2, message);
                }
            }
        });
    }
}

