/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.opplugin.web.activitymanage.evalschedule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.pbs.business.domain.assessnode.enums.NodeTabMapEnum;

public class ReturnEvalCrossOp
extends HRDataBaseOp {
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("rutask");
        e.getFieldKeys().add("indicator");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                List ruRoleIds = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getDataEntity().getLong("rutask.flowrurole.id")).collect(Collectors.toList());
                Map roleToObjMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.getEvalObjMap(ruRoleIds);
                Map objMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.queryEvalObjById(new ArrayList(roleToObjMap.values()));
                ArrayList<DynamicObject> returnList = new ArrayList<DynamicObject>(10);
                for (ExtendedDataEntity dataEntity2 : dataEntities) {
                    boolean isEval;
                    long ruRoleId = dataEntity2.getDataEntity().getLong("rutask.flowrurole.id");
                    Long objId = (Long)roleToObjMap.get(ruRoleId);
                    DynamicObject objDy = (DynamicObject)objMap.get(objId);
                    boolean bl = isEval = NodeTabMapEnum.EVAL_PROCESS.getNodeId().equals(objDy.getLong("assessnode.id")) && AssessNodeStatusEnum.EVALUATING.getStatus().equals(objDy.getString("nodestatus"));
                    if (isEval) {
                        returnList.add(dataEntity2.getDataEntity());
                        continue;
                    }
                    this.addErrorMessage(dataEntity2, ResManager.loadKDString((String)"\u8bc4\u4f30\u5bf9\u8c61-{0}\uff08{1}\uff09\uff1a\u5df2\u4e0d\u5728\u8bc4\u4f30\u4e2d", (String)"ReturnEvalCrossOp_0", (String)"opmc-epa-opplugin", (Object[])new Object[]{objDy.getString("person.name"), objDy.getString("person.number")}));
                }
                Map taskToIndicatorMap = returnList.stream().collect(Collectors.groupingBy(dy -> dy.getLong("rutask.id"), Collectors.mapping(dy -> dy.getLong("indicator"), Collectors.toList())));
                String reason = this.getOption().getVariableValue("reason", "");
                Map resultMap = ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.returnEvalPersonCross(taskToIndicatorMap, reason);
                if (resultMap.size() != 0) {
                    for (ExtendedDataEntity dataEntity3 : dataEntities) {
                        String message = (String)resultMap.get(dataEntity3.getDataEntity().getLong("rutask.id"));
                        if (!StringUtils.isNotBlank((CharSequence)message)) continue;
                        this.addErrorMessage(dataEntity3, message);
                    }
                }
            }
        });
    }
}

