/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.opplugin.web.activitymanage.evaluaobject;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssessObjectApplicationService;
import kd.opmc.pmd.business.application.service.PerffileApplicationService;

public class EvalObjExitedReAddOp
extends HRDataBaseOp {
    private static final AssessObjectApplicationService ASSESS_OBJECT_APPLICATION_SERVICE = AssessObjectApplicationService.getInstance();
    private static final PerffileApplicationService PERF_FILE_APPLICATION_SERVICE = PerffileApplicationService.getInstance();
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("epa_actevalobj");
    private static final String PMDORG = "pmdorg";
    private static final String EMPPOSREL = "empposrel";

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        args.getFieldKeys().add("person");
        args.getFieldKeys().add("perffile.id");
        args.getFieldKeys().add("activity.id");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        DynamicObject[] dataEntities = args.getDataEntities();
        if (dataEntities.length == 0) {
            return;
        }
        Long assessActivityPkId = dataEntities[0].getLong("activity.id");
        DynamicObject activityDynObj = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne((Object)assessActivityPkId);
        List<Long> perfileIds = Arrays.stream(dataEntities).map(data -> data.getLong("perffile.id")).collect(Collectors.toList());
        List<Long> ids = Arrays.stream(dataEntities).map(data -> data.getLong("id")).collect(Collectors.toList());
        long schemeId = activityDynObj.getLong("scheme.id");
        ASSESS_OBJECT_APPLICATION_SERVICE.deleteAssessObjectByPerfFileIdList(schemeId, perfileIds);
        HELPER.delete((Object[])ids.toArray(new Long[0]));
        this.saveEvaluationObject(perfileIds, activityDynObj);
    }

    private void saveEvaluationObject(List<Long> perfileIds, DynamicObject activityDynObj) {
        String selectors = "person,empposrel,employee,affiliateadminorg,startdate,enddate,pmdorg,bsed,bsled";
        DynamicObject[] assessObjectJoinInCol = PERF_FILE_APPLICATION_SERVICE.getPerffileListByIds(selectors, perfileIds);
        DynamicObjectCollection assessObjectJoinInList = new DynamicObjectCollection();
        Arrays.stream(assessObjectJoinInCol).forEach(data -> assessObjectJoinInList.add(data));
        this.saveAssessObjectAndEvaluationObject(activityDynObj, assessObjectJoinInList);
    }

    private void saveAssessObjectAndEvaluationObject(DynamicObject curActivityDynObj, DynamicObjectCollection assessObjectJoinInList) {
        long schemeId = curActivityDynObj.getLong("scheme.id");
        long executeSchemeAssessScopeId = curActivityDynObj.getLong("executescheme.assessscope.id");
        DynamicObjectCollection assessObjectEntryEntity = this.genAssessObjectEntryEntity(assessObjectJoinInList, schemeId, executeSchemeAssessScopeId);
        DynamicObject[] assessObjectArr = ASSESS_OBJECT_APPLICATION_SERVICE.saveAssessObject(Long.valueOf(schemeId), assessObjectEntryEntity, curActivityDynObj);
        ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.saveAssessObject(curActivityDynObj, assessObjectArr);
    }

    private DynamicObjectCollection genAssessObjectEntryEntity(DynamicObjectCollection assessObjectJoinInList, long schemeId, long executeSchemeAssessScopeId) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"epa_assessobject_joinin");
        DynamicObject emptyJonInDynObj = new DynamicObject((DynamicObjectType)dataEntityType);
        Object[] assessGroupArr = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryAssessGroupArr(schemeId, executeSchemeAssessScopeId);
        Object assessGroup = null;
        for (DynamicObject dynamicObject : assessGroupArr) {
            if (!dynamicObject.getBoolean("isdefault")) continue;
            assessGroup = dynamicObject;
            break;
        }
        if (assessGroup == null && !HRArrayUtils.isEmpty((Object[])assessGroupArr) && assessGroupArr.length > 0) {
            assessGroup = assessGroupArr[0];
        }
        DynamicObjectCollection assessObjectEntryEntity = emptyJonInDynObj.getDynamicObjectCollection("assessobjectentryentity");
        for (DynamicObject perfFileDynObj : assessObjectJoinInList) {
            DynamicObject dynamicObject = assessObjectEntryEntity.addNew();
            dynamicObject.set("perffile", (Object)perfFileDynObj);
            dynamicObject.set("group", (Object)(assessGroup == null ? 0L : assessGroup.getLong("id")));
            dynamicObject.set("assessscope", (Object)(assessGroup == null ? 0L : assessGroup.getLong("objectscope.id")));
            dynamicObject.set("person", (Object)perfFileDynObj.getDynamicObject("person"));
            dynamicObject.set("empposorgrel", (Object)perfFileDynObj.getDynamicObject(EMPPOSREL));
            dynamicObject.set("employee", (Object)perfFileDynObj.getDynamicObject("employee"));
        }
        return assessObjectEntryEntity;
    }
}

