/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.opplugin.web.activitymanage.evaluaobject;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.domain.activitymanage.entityservice.ActivityEvaluationObjectEntityService;
import kd.opmc.epa.business.domain.scheme.entityservice.AssessObjectEntityService;

public class EvalObjResPersonOp
extends HRDataBaseOp {
    private static final AssessObjectEntityService ASSESS_OBJECT_ENTITY_SERVICE = AssessObjectEntityService.getInstance();
    private static final ActivityEvaluationObjectEntityService ACTIVITY_EVALUATION_OBJECT_ENTITY = ActivityEvaluationObjectEntityService.getInstance();
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        List<Long> idList = Arrays.stream(e.getDataEntities()).map(dataDy -> dataDy.getLong("id")).collect(Collectors.toList());
        switch (e.getOperationKey()) {
            case "save": {
                this.saveResPerson(e.getDataEntities());
                break;
            }
            case "removeresperson": {
                this.removeResPerson(idList);
                break;
            }
        }
    }

    void saveResPerson(DynamicObject[] evaluationObjects) {
        DynamicObject curActivity = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne((Object)evaluationObjects[0].getLong("activity.id"));
        DynamicObject[] assessObjects = ASSESS_OBJECT_ENTITY_SERVICE.queryListBySchemeId("id,person.id,resperson,perfile.id", Long.valueOf(curActivity.getLong("scheme.id")));
        List idList = Arrays.stream(evaluationObjects).map(dataDy -> dataDy.getLong("id")).collect(Collectors.toList());
        evaluationObjects = ACTIVITY_EVALUATION_OBJECT_ENTITY.queryActEvalObjByIds(idList);
        HashMap<Long, DynamicObject> assessObjMap = new HashMap<Long, DynamicObject>(assessObjects.length);
        ArrayList<DynamicObject> assessObjsToSave = new ArrayList<DynamicObject>();
        for (DynamicObject obj : assessObjects) {
            assessObjMap.put(obj.getLong("perfile.id"), obj);
        }
        for (DynamicObject evaluationObject : evaluationObjects) {
            Long perfileId = evaluationObject.getLong("perffile.id");
            DynamicObject assessObj = (DynamicObject)assessObjMap.get(perfileId);
            if (assessObj == null) continue;
            DynamicObjectCollection personCollOfAssessobj = this.getResPersonColl(evaluationObject.getDynamicObjectCollection("resperson"), assessObj);
            assessObj.set("resperson", (Object)personCollOfAssessobj);
            assessObjsToSave.add(assessObj);
        }
        if (assessObjsToSave.size() > 0) {
            ASSESS_OBJECT_ENTITY_SERVICE.save(assessObjsToSave.toArray(new DynamicObject[0]));
        }
    }

    void removeResPerson(List<Long> idList) {
        DynamicObject[] evaluationObjects = ACTIVITY_EVALUATION_OBJECT_ENTITY.queryActivityEvaluationObjectById("id,person.id,activity.id, resperson", idList);
        DynamicObject curActivity = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne((Object)evaluationObjects[0].getLong("activity.id"));
        DynamicObject[] assessObjects = ASSESS_OBJECT_ENTITY_SERVICE.queryListBySchemeId("id,person.id,resperson", Long.valueOf(curActivity.getLong("scheme.id")));
        HashMap<Long, DynamicObject> assessObjMap = new HashMap<Long, DynamicObject>(assessObjects.length);
        ArrayList<DynamicObject> assessObjsToSave = new ArrayList<DynamicObject>();
        for (DynamicObject obj : assessObjects) {
            assessObjMap.put(obj.getLong("person.id"), obj);
        }
        for (DynamicObject evaluationObject : evaluationObjects) {
            evaluationObject.set("resperson", null);
            Long personId = evaluationObject.getLong("person.id");
            DynamicObject assessObj = (DynamicObject)assessObjMap.get(personId);
            if (assessObj == null) continue;
            assessObj.set("resperson", null);
            assessObjsToSave.add(assessObj);
        }
        ACTIVITY_EVALUATION_OBJECT_ENTITY.save(evaluationObjects);
        if (assessObjsToSave.size() > 0) {
            ASSESS_OBJECT_ENTITY_SERVICE.save(assessObjsToSave.toArray(new DynamicObject[0]));
        }
    }

    private DynamicObjectCollection getResPersonColl(DynamicObjectCollection personCollection, DynamicObject evaluationObject) {
        if (personCollection.size() == 0) {
            return null;
        }
        DynamicObjectCollection personColl = evaluationObject.getDynamicObjectCollection("resperson");
        personColl.clear();
        for (DynamicObject person : personCollection) {
            DynamicObject newCurrency = new DynamicObject(personColl.getDynamicObjectType());
            newCurrency.set("fbasedataid", person.get("fbasedataid"));
            personColl.add((Object)newCurrency);
        }
        return personColl;
    }
}

