/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.opplugin.web.activitymanage.evaluaobject;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.opmc.epa.business.application.service.activity.AssessActivityApplicationService;
import kd.opmc.epa.business.application.service.activitymanage.ActEvalObjManageApplicationService;
import kd.opmc.epa.business.application.service.scheme.AssessObjectApplicationService;
import kd.opmc.epa.business.application.service.scheme.ExecuteSchemeApplicationService;
import kd.opmc.epa.business.domain.activitymanage.enums.AssessStausEnum;
import kd.opmc.epa.business.domain.scheme.entityservice.AssessObjectEntityService;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;
import kd.opmc.epa.opplugin.web.activitymanage.evaluaobject.validate.EvalObjectInHandValidator;

public class EvalObjecInHandOp
extends HRDataBaseOp {
    private static final Log log = LogFactory.getLog(EvalObjecInHandOp.class);
    private static final ActEvalObjManageApplicationService ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE = ActEvalObjManageApplicationService.getInstance();
    private static final AssessObjectEntityService ASSESS_OBJECT = AssessObjectEntityService.getInstance();
    private static final AssessActivityApplicationService ASSESS_ACTIVITY_APPLICATION_SERVICE = AssessActivityApplicationService.getInstance();
    private static final ExecuteSchemeApplicationService EXECUTE_SCHEME_APPLICATION_SERVICE = ExecuteSchemeApplicationService.getInstance();
    private static final AssessObjectApplicationService ASSESS_OBJECT_APPLICATION_SERVICE = AssessObjectApplicationService.getInstance();

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        args.getFieldKeys().add("person");
        args.getFieldKeys().add("assessstaus");
        args.getFieldKeys().add("assessnode");
        args.getFieldKeys().add("nodestatus");
        args.getFieldKeys().add("nodeindex");
        args.getFieldKeys().add("evalflow");
        args.getFieldKeys().add("quittime");
        args.getFieldKeys().add("evalflowru");
        args.getFieldKeys().add("perffile.id");
        args.getFieldKeys().add("activity.id");
        args.getFieldKeys().add("evalflowentry");
        args.getFieldKeys().add("formulateflowins");
        args.getFieldKeys().add("evalflowins.id");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new EvalObjectInHandValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        super.endOperationTransaction(args);
        DynamicObject[] dataEntities = args.getDataEntities();
        ArrayList<Long> perfiles = new ArrayList<Long>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            long flowId;
            perfiles.add(dataEntity.getLong("perffile.id"));
            Long nodeId = dataEntity.getLong("assessnode.id");
            dataEntity.set("assessstaus", (Object)AssessStausEnum.Exited.getStatus());
            dataEntity.set("quittime", (Object)new Date());
            dataEntity.set("nodeindex", null);
            dataEntity.set("nodestatus", null);
            dataEntity.set("assessnode", null);
            if (AssessNodeStatusEnum.EVALUATING.getNodeId().equals(nodeId)) {
                long flowRuId = dataEntity.getLong("evalflowins_id");
                if (flowRuId == 0L) continue;
                ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.endProcess(flowRuId);
                continue;
            }
            if (!AssessNodeStatusEnum.TARGET_FORMULATING.getNodeId().equals(nodeId) || (flowId = dataEntity.getLong("formulateflowins.id")) == 0L) continue;
            ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.endProcess(flowId);
        }
        ACT_EVAL_OBJ_MANAGE_APPLICATION_SERVICE.exitObject(dataEntities);
        if (dataEntities.length > 0) {
            this.setCycle(dataEntities[0].getLong("activity.id"), perfiles);
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities;
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            Long nodeId = dataEntity.getLong("assessnode.id");
            if (!AssessNodeStatusEnum.CONFIRMING.getNodeId().equals(nodeId)) continue;
            String businessKey = String.valueOf(dataEntity.getLong("id"));
            try {
                if (!WorkflowServiceHelper.inProcess((String)businessKey)) continue;
                WorkflowServiceHelper.abandonByBusienssKey((String)businessKey);
            }
            catch (Exception ex) {
                log.error((Throwable)ex);
                throw new KDBizException(ex.getMessage());
            }
        }
    }

    void setCycle(long activityId, List<Long> perfiles) {
        long executeSchemeId;
        if (activityId == 0L) {
            return;
        }
        DynamicObject curActivity = ASSESS_ACTIVITY_APPLICATION_SERVICE.queryOne((Object)activityId);
        long schemeId = curActivity.getLong("scheme.id");
        boolean sameTopCycleType = EXECUTE_SCHEME_APPLICATION_SERVICE.isSameTopCycleType(schemeId, executeSchemeId = curActivity.getLong("executescheme.id"));
        if (!sameTopCycleType) {
            return;
        }
        DynamicObject[] assessObjects = ASSESS_OBJECT.queryListBySchemeIdAndPerfiles(schemeId, perfiles);
        if (assessObjects != null && assessObjects.length > 0) {
            for (DynamicObject assessObject : assessObjects) {
                assessObject.set("startcycle", (Object)"");
                assessObject.set("endcycle", (Object)"");
            }
            ASSESS_OBJECT_APPLICATION_SERVICE.save(assessObjects);
        }
    }
}

