/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.opplugin.web.activitymanage.evaluaobject;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.opmc.epa.business.application.service.scheme.AssessObjectApplicationService;
import kd.opmc.epa.business.application.service.scheme.ExecuteSchemeApplicationService;
import kd.opmc.epa.business.domain.scheme.entityservice.AssessObjectEntityService;
import kd.opmc.epa.opplugin.web.activitymanage.evaluaobject.validate.EvalObjectJoinedValidator;

public class EvalObjectJoinedOp
extends HRDataBaseOp {
    private static final AssessObjectApplicationService ASSESS_OBJECT_APPLICATION_SERVICE = AssessObjectApplicationService.getInstance();
    private static final AssessObjectEntityService ASSESS_OBJECT = AssessObjectEntityService.getInstance();
    private static final ExecuteSchemeApplicationService EXECUTE_SCHEME_APPLICATION_SERVICE = ExecuteSchemeApplicationService.getInstance();

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        args.getFieldKeys().add("person");
        args.getFieldKeys().add("perffile");
        args.getFieldKeys().add("activity");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new EvalObjectJoinedValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        long schemeId = dataEntities[0].getLong("activity.scheme.id");
        long executeSchemeId = dataEntities[0].getLong("activity.executescheme.id");
        boolean sameTopCycleType = EXECUTE_SCHEME_APPLICATION_SERVICE.isSameTopCycleType(schemeId, executeSchemeId);
        if (!sameTopCycleType) {
            return;
        }
        List perfFileList = Arrays.stream(dataEntities).map(dynObj -> dynObj.getLong("perffile.id")).collect(Collectors.toList());
        DynamicObject[] assessObjects = ASSESS_OBJECT.queryListBySchemeIdAndPerfiles(schemeId, perfFileList);
        if (assessObjects != null && assessObjects.length > 0) {
            for (DynamicObject assessObject : assessObjects) {
                assessObject.set("startcycle", (Object)"");
                assessObject.set("endcycle", (Object)"");
            }
            ASSESS_OBJECT_APPLICATION_SERVICE.save(assessObjects);
        }
    }
}

