/*
 * Decompiled with CFR 0.152.
 */
package kd.opmc.epa.opplugin.web.activitymanage.evaluaobject.validate;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.opmc.epa.business.domain.activitymanage.enums.AssessStausEnum;
import kd.opmc.epa.common.enums.activitymanage.AssessNodeStatusEnum;

public class EvalObjectInHandValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            Long nodeId = dataEntity.getDataEntity().getLong("assessnode.id");
            String nodeStatus = dataEntity.getDataEntity().getString("nodestatus");
            String assessStatus = dataEntity.getDataEntity().getString("assessstaus");
            if (AssessNodeStatusEnum.CONFIRMED.getNodeId().equals(nodeId) && AssessNodeStatusEnum.CONFIRMED.getStatus().equals(nodeStatus)) {
                this.checkConfirmValidateMessage(dataEntity);
                continue;
            }
            if (AssessStausEnum.COMPLETED.getStatus().equals(assessStatus)) {
                this.checkCompleteValidateMessage(dataEntity);
                continue;
            }
            if (!AssessStausEnum.JOINED.getStatus().equals(assessStatus)) continue;
            this.checkJoinedValidateMessage(dataEntity);
        }
    }

    private void checkConfirmValidateMessage(ExtendedDataEntity dataEntity) {
        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"{0}-{1}\uff1a\u7ee9\u6548\u7ed3\u679c\u5df2\u786e\u8ba4\uff0c\u4e0d\u53ef\u9000\u51fa\u8003\u6838", (String)"EvalObjectInHandValidator_0", (String)"opmc-epa-opplugin", (Object[])new Object[]{dataEntity.getDataEntity().getDynamicObject("person").getString("name"), dataEntity.getDataEntity().getDynamicObject("person").getString("number")}));
    }

    private void checkCompleteValidateMessage(ExtendedDataEntity dataEntity) {
        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"{0}-{1}\uff1a\u8003\u6838\u5df2\u5b8c\u6210\uff0c\u4e0d\u53ef\u9000\u51fa\u8003\u6838", (String)"EvalObjectInHandValidator_1", (String)"opmc-epa-opplugin", (Object[])new Object[]{dataEntity.getDataEntity().getDynamicObject("person").getString("name"), dataEntity.getDataEntity().getDynamicObject("person").getString("number")}));
    }

    private void checkJoinedValidateMessage(ExtendedDataEntity dataEntity) {
        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"{0}-{1}\uff1a\u672a\u5f00\u59cb\u8003\u6838\uff0c\u65e0\u9700\u9000\u51fa\u8003\u6838", (String)"EvalObjectInHandValidator_2", (String)"opmc-epa-opplugin", (Object[])new Object[]{dataEntity.getDataEntity().getDynamicObject("person").getString("name"), dataEntity.getDataEntity().getDynamicObject("person").getString("number")}));
    }
}

